/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.runtime.onpremise;

import com.sap.core.connectivity.cloud.destinations.tunnel.TunnelIdFactory;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.RuntimeUtil;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.AuthenticationCredentials;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.ConnectivityContextInformationProvider;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.PrincipalInformationProvider;
import com.sap.core.tenant.api.Tenant;
import com.sap.core.tenant.common.TenantData;
import java.security.Principal;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class DefaultConnectivityContextInformationProvider
implements ConnectivityContextInformationProvider {
    private static final Logger log = Logger.getLogger(DefaultConnectivityContextInformationProvider.class.getName());
    private static final String HELIUM_DESTINATION_PROVIDER_ACCOUNT = "helium.html5db.destination.provideraccount";
    private static final String DISABLED = "disabled";
    private static final boolean IS_PROVIDER_ACCOUNT_DISABLED = "disabled".equalsIgnoreCase(System.getProperty("helium.html5db.destination.provideraccount"));
    private final HttpDestinationInfo httpDestinationInfo;
    private final Properties connectionInfo;
    private final PrincipalInformationProvider principalInformationProvider;
    private String onPremiseDestinationAccount;
    private final RuntimeUtil runtimeUtil = new RuntimeUtil();

    DefaultConnectivityContextInformationProvider(HttpDestinationInfo httpDestinationInfo, PrincipalInformationProvider principalInformationProvider, String onPremiseDestinationAccount) {
        this.httpDestinationInfo = httpDestinationInfo;
        this.connectionInfo = new Properties();
        this.onPremiseDestinationAccount = onPremiseDestinationAccount;
        this.principalInformationProvider = principalInformationProvider;
    }

    @Override
    public String getTunnelId() {
        if (this.onPremiseDestinationAccount == null || IS_PROVIDER_ACCOUNT_DISABLED) {
            this.onPremiseDestinationAccount = this.runtimeUtil.isOsgiRuntime() ? Tenant.getData().getAccountName() : this.getTenantData().getAccountName();
        }
        String location = this.extractCloudConnectorLocation(this.httpDestinationInfo);
        String tunnelId = TunnelIdFactory.createIdForAccount(this.onPremiseDestinationAccount, location);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("Tunnel id for on-premise destination %s is %s", this.httpDestinationInfo.getName(), tunnelId));
        }
        return tunnelId;
    }

    private TenantData getTenantData() {
        Class<Tenant> tenantClass = this.runtimeUtil.loadTenantClassWithImplClassLoader();
        try {
            return (TenantData)tenantClass.getMethod("getData", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Principal getPrincipal() {
        return this.principalInformationProvider != null ? this.principalInformationProvider.getPrincipal() : null;
    }

    @Override
    public AuthenticationCredentials getSingleSignOnCredentials() {
        return this.principalInformationProvider != null ? this.principalInformationProvider.getSingleSignOnCredentials() : null;
    }

    @Override
    public Properties getConnectionInfo() {
        return this.connectionInfo;
    }

    private String extractCloudConnectorLocation(HttpDestinationInfo destinationInfo) {
        return destinationInfo.getProperty("CloudConnectorLocationId");
    }
}

