/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.runtime.onpremise;

import com.sap.core.connectivity.api.DestinationNotFoundException;
import com.sap.core.connectivity.api.authentication.AuthenticationHeaderProvider;
import com.sap.core.connectivity.cloud.destinations.tunnel.ConnectivityProxyAddressReader;
import com.sap.core.connectivity.cloud.destinations.tunnel.ConnectivityProxyAddressReaderFactory;
import com.sap.core.connectivity.httpdestination.common.HttpClientBuilderWrapper;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.common.HttpRequestExecutionCustomizer;
import com.sap.core.connectivity.httpdestination.common.onpremise.OnPremiseConfigurator;
import com.sap.core.connectivity.httpdestination.impl.DestinationClientConnectionManager;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationInfoDelegate;
import com.sap.core.connectivity.httpdestination.impl.utils.HttpDestinationInfoUtils;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.ConnectivityClientConnectionOperatorFactory;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.ConnectivityContextInformationProvider;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.ConnectivityHttpRequestExecutionCustomizer;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.DefaultConnectivityContextInformationProvider;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.OnPremiseHttpRoutePlanner;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.PrincipalPropagationHttpRequestExecutionCustomizer;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.PrincipalPropagationHttpRequestExecutorExtender;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.PrincipalPropagationInformationProvider;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;

public class OnPremiseConfiguratorImpl
implements OnPremiseConfigurator {
    static final String HTTP_PARAM_CONNECTION_POOLING_SUPPORTED = "CONNECTION_POOLING_SUPPORTED";
    private final HttpDestinationInfoDelegate destinationInfoDelegate;
    private final AuthenticationHeaderProvider authenticationHeaderProvider;
    private ConnectivityContextInformationProvider contextInformationProvider;

    public OnPremiseConfiguratorImpl(HttpDestinationInfoDelegate destinationInfoDelegate, AuthenticationHeaderProvider authenticationHeaderProvider) {
        this.destinationInfoDelegate = destinationInfoDelegate;
        this.authenticationHeaderProvider = authenticationHeaderProvider;
        this.contextInformationProvider = this.getContextInformationProvider();
    }

    @Override
    public void configure(HttpClientBuilderWrapper builder, HttpDestinationInfo destinationInfo) {
        if (HttpDestinationInfoUtils.isOnPremiseDestination(destinationInfo)) {
            builder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
            builder.setRoutePlanner(new OnPremiseHttpRoutePlanner());
            builder.setConnectionManager(this.createConnectionManager(destinationInfo));
            this.configureRequestExecutor(builder, destinationInfo);
        }
    }

    @Override
    public HttpRequestExecutionCustomizer createRequestExecutionCustomizer(HttpDestinationInfo destinationInfo) {
        if (!"PrincipalPropagation".equals(destinationInfo.getAuthenticator().getType())) {
            return new ConnectivityHttpRequestExecutionCustomizer(this.contextInformationProvider);
        }
        return new PrincipalPropagationHttpRequestExecutionCustomizer(this.contextInformationProvider);
    }

    private void configureRequestExecutor(HttpClientBuilderWrapper builder, HttpDestinationInfo info) {
        if ("PrincipalPropagation".equals(info.getAuthenticator().getType())) {
            builder.setRequestExecutor(new PrincipalPropagationHttpRequestExecutorExtender(this.contextInformationProvider));
        }
    }

    private HttpClientConnectionManager createConnectionManager(HttpDestinationInfo info) {
        HttpClientConnectionOperator connectionOperator = ConnectivityClientConnectionOperatorFactory.createConnectivityClientConnectionOperator(this.contextInformationProvider, this.getConnectivityProxyAddressReader());
        DestinationClientConnectionManager poolingClientConnectionManager = new DestinationClientConnectionManager(connectionOperator, (HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection>)new ManagedHttpClientConnectionFactory(), 0L, TimeUnit.MILLISECONDS, info);
        return poolingClientConnectionManager;
    }

    protected ConnectivityContextInformationProvider getContextInformationProvider() {
        HttpDestinationInfo httpDestinationInfo;
        try {
            httpDestinationInfo = this.destinationInfoDelegate.getHttpDestinationInfo();
        }
        catch (DestinationNotFoundException e) {
            throw new IllegalStateException(e);
        }
        PrincipalPropagationInformationProvider principalInformationProvider = null;
        if (httpDestinationInfo.getAuthenticator() != null && "PrincipalPropagation".equals(httpDestinationInfo.getAuthenticator().getType())) {
            principalInformationProvider = new PrincipalPropagationInformationProvider(this.authenticationHeaderProvider);
        }
        return new DefaultConnectivityContextInformationProvider(httpDestinationInfo, principalInformationProvider, this.destinationInfoDelegate.getDestinationAccount());
    }

    protected ConnectivityProxyAddressReader getConnectivityProxyAddressReader() {
        return new ConnectivityProxyAddressReaderFactory().getConnectivityProxyAddressReader();
    }

    @Override
    public boolean isConnectionPoolingSupported() {
        return Boolean.parseBoolean(this.contextInformationProvider.getConnectionInfo().getProperty(HTTP_PARAM_CONNECTION_POOLING_SUPPORTED));
    }
}

