/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.runtime.onpremise;

import java.net.InetAddress;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.protocol.HttpContext;

class OnPremiseHttpRoutePlanner
implements HttpRoutePlanner {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    OnPremiseHttpRoutePlanner() {
    }

    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        if (request == null) {
            throw new IllegalStateException("Request must not be null.");
        }
        if (target == null) {
            throw new IllegalStateException("Target host must not be null.");
        }
        this.checkTargetHostScheme(target);
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        InetAddress local = clientContext.getRequestConfig().getLocalAddress();
        boolean secure = false;
        return new HttpRoute(target, local, false);
    }

    private void checkTargetHostScheme(HttpHost target) throws HttpException {
        if (!this.hasSupportedScheme(target)) {
            throw new HttpException("The target scheme is not supported: " + target.getSchemeName());
        }
    }

    private boolean hasSupportedScheme(HttpHost target) {
        String schemeName = target.getSchemeName();
        return HTTP.equals(schemeName) || HTTPS.equals(schemeName);
    }
}

