/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.runtime.onpremise;

import com.sap.core.connectivity.httpdestination.runtime.onpremise.AuthenticationCredentials;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.ConnectivityContextInformationProvider;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.SCCUtil;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.SCCVersion;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

public class PrincipalPropagationHttpRequestExecutorExtender
extends HttpRequestExecutor {
    private static final String CONN_ATTR_PRINCIPAL = "principal";
    private static final String CONN_ATTR_CONN_UNRELIABLE = "connUnreliable";
    private static final Logger log = Logger.getLogger(PrincipalPropagationHttpRequestExecutorExtender.class.getName());
    private static final String SSO_TOKEN_HEADER = "SAP-Connectivity-SSOToken";
    private static final String SSO_TOKEN_BASE64_HEADER = "SAP-Connectivity-SSOToken-Base64";
    private static final String SSO_TOKEN_TYPE_HEADER = "SAP-Connectivity-SSOTokenType";
    private static final String SSO_TOKEN_ENCODING = "UTF-8";
    private ConnectivityContextInformationProvider contextInformationProvider;
    private SCCUtil sccUtil = new SCCUtil();

    public PrincipalPropagationHttpRequestExecutorExtender(ConnectivityContextInformationProvider contextInformationProvider) {
        this.contextInformationProvider = contextInformationProvider;
    }

    public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        boolean isConnectionPoolingUnreliable;
        Principal currentPrincipal = this.contextInformationProvider.getPrincipal();
        if (currentPrincipal == null) {
            throw new IllegalArgumentException("No logged-in user");
        }
        Properties connectionInfo = this.contextInformationProvider.getConnectionInfo();
        SCCVersion masterVersion = this.sccUtil.getSccVersion("masterVersion", connectionInfo);
        SCCVersion shadowVersion = this.sccUtil.getSccVersion("shadowVersion", connectionInfo);
        boolean isConnectionPoolingSupported = this.sccUtil.isConnectionPoolingSupported(masterVersion, shadowVersion);
        connectionInfo.setProperty("CONNECTION_POOLING_SUPPORTED", String.valueOf(isConnectionPoolingSupported));
        Principal connectionPrincipal = (Principal)this.getAttribute(conn, CONN_ATTR_PRINCIPAL);
        if (connectionPrincipal == null) {
            this.setAttribute(conn, CONN_ATTR_PRINCIPAL, currentPrincipal);
            return super.execute(request, conn, context);
        }
        boolean bl = isConnectionPoolingUnreliable = isConnectionPoolingSupported && !this.sccUtil.isConnectionPoolingReliable(masterVersion, shadowVersion);
        if (!connectionPrincipal.equals(currentPrincipal)) {
            if (!isConnectionPoolingSupported) {
                log.log(Level.SEVERE, String.format("Same instance of HttpClient for OnPremise destinations cannot be used by different users. If you want to cache the HttpClient instance, use the user session. User when instance was created: %s, user which triggered current request %s", connectionPrincipal.getName(), currentPrincipal.getName()));
                throw new IllegalArgumentException("Same instance of HttpClient for OnPremise destinations cannot be used by different users. If you want to cache the HttpClient instance, use the user session.");
            }
            this.addSSOCredentialsToRequest(request, currentPrincipal, masterVersion, shadowVersion);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Updating principal from " + connectionPrincipal + " to " + currentPrincipal);
            }
            this.setAttribute(conn, CONN_ATTR_PRINCIPAL, currentPrincipal);
            if (isConnectionPoolingUnreliable) {
                log.log(Level.WARNING, String.format("Performance might be affected due to old SAP Cloud Connector version '%s' used for the connection over connectivity tunnel with ID '%s'. For better performance, upgrade to version '%s'", masterVersion, this.contextInformationProvider.getTunnelId(), SCCUtil.RELIABLE_SCC_VERSION_CONNECTION_POOLING));
                return this.executeUnreliableRequest(request, conn, context);
            }
        } else if (isConnectionPoolingUnreliable && Boolean.TRUE.equals(this.getAttribute(conn, CONN_ATTR_CONN_UNRELIABLE))) {
            this.addSSOCredentialsToRequest(request, currentPrincipal, masterVersion, shadowVersion);
            return this.executeUnreliableRequest(request, conn, context);
        }
        return super.execute(request, conn, context);
    }

    private void setAttribute(HttpClientConnection conn, String key, Object value) {
        if (conn instanceof HttpContext) {
            ((HttpContext)conn).setAttribute(key, value);
        }
    }

    private Object getAttribute(HttpClientConnection conn, String key) {
        if (conn instanceof HttpContext) {
            return ((HttpContext)conn).getAttribute(key);
        }
        return null;
    }

    private void removeAttribute(HttpClientConnection conn, String key) {
        if (conn instanceof HttpContext) {
            ((HttpContext)conn).removeAttribute(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeUnreliableRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        boolean isConnectionReliable = false;
        try {
            HttpResponse response = super.execute(request, conn, context);
            isConnectionReliable = this.isResponseReliable(response);
            if (isConnectionReliable) {
                this.removeAttribute(conn, CONN_ATTR_CONN_UNRELIABLE);
            }
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (!isConnectionReliable) {
                this.setAttribute(conn, CONN_ATTR_CONN_UNRELIABLE, Boolean.TRUE);
            }
        }
    }

    private boolean isResponseReliable(HttpResponse response) {
        return response.getStatusLine().getStatusCode() < 400;
    }

    private void addSSOCredentialsToRequest(HttpRequest request, Principal principal, SCCVersion masterVersion, SCCVersion shadowVersion) {
        AuthenticationCredentials singleSignOnCredentials = this.contextInformationProvider.getSingleSignOnCredentials();
        if (singleSignOnCredentials != null) {
            String ssoToken = singleSignOnCredentials.getToken();
            if (this.sccUtil.isBase64SSOTokenSupported(masterVersion, shadowVersion)) {
                String ssoTokenBase64 = DatatypeConverter.printBase64Binary((byte[])ssoToken.getBytes(Charset.forName(SSO_TOKEN_ENCODING)));
                request.addHeader(SSO_TOKEN_BASE64_HEADER, ssoTokenBase64);
            } else {
                request.addHeader(SSO_TOKEN_HEADER, ssoToken);
            }
        } else {
            log.log(Level.SEVERE, String.format("Missing SSO creadentials for the user '%s', which triggered current request", principal.getName()));
            throw new IllegalStateException("Missing SSO creadentials for the user triggered the request");
        }
        request.addHeader(SSO_TOKEN_TYPE_HEADER, singleSignOnCredentials.getType());
    }
}

