/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.runtime.onpremise;

import com.sap.core.connectivity.api.authentication.AuthenticationHeader;
import com.sap.core.connectivity.api.authentication.AuthenticationHeaderProvider;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.AuthenticationCredentials;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.CurrentPrincipal;
import com.sap.core.connectivity.httpdestination.runtime.onpremise.PrincipalInformationProvider;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import java.nio.charset.Charset;
import java.security.Principal;
import javax.xml.bind.DatatypeConverter;

class PrincipalPropagationInformationProvider
implements PrincipalInformationProvider {
    private final AuthenticationHeaderProvider authenticationHeaderProvider;

    PrincipalPropagationInformationProvider(AuthenticationHeaderProvider authenticationHeaderProvider) {
        this.authenticationHeaderProvider = authenticationHeaderProvider;
    }

    @Override
    public Principal getPrincipal() {
        User currentUser;
        try {
            UserProvider userProvider = UserManagementAccessor.getUserProvider();
            if (userProvider == null) {
                return null;
            }
            currentUser = userProvider.getCurrentUser();
            if (currentUser == null) {
                return null;
            }
        }
        catch (PersistenceException e) {
            throw new IllegalStateException(e);
        }
        return new CurrentPrincipal(currentUser.getName());
    }

    @Override
    public AuthenticationCredentials getSingleSignOnCredentials() {
        AuthenticationHeader principalPropagationHeader = this.authenticationHeaderProvider.getPrincipalPropagationHeader();
        return this.parsePrincipalPropagationHeader(principalPropagationHeader);
    }

    private AuthenticationCredentials parsePrincipalPropagationHeader(AuthenticationHeader principalPropagationHeader) {
        AuthenticationCredentials authenticationCredentials = null;
        if (principalPropagationHeader != null) {
            String headerValue = principalPropagationHeader.getValue();
            String[] tokens = headerValue.trim().split("\\s+");
            if (tokens.length != 2) {
                throw new IllegalStateException("Invalid principal propagation header value: " + headerValue);
            }
            try {
                String authenticationType = tokens[0];
                String authenticationToken = new String(DatatypeConverter.parseBase64Binary((String)tokens[1]), Charset.forName("UTF-8"));
                authenticationCredentials = new AuthenticationCredentials(authenticationType, authenticationToken);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalStateException("Invalid principal propagation token: " + tokens[1], ex);
            }
        }
        return authenticationCredentials;
    }
}

