/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.runtime.onpremise;

import com.sap.core.connectivity.httpdestination.runtime.onpremise.SCCVersion;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SCCUtil {
    static final SCCVersion RELIABLE_SCC_VERSION_CONNECTION_POOLING = new SCCVersion("2.11.0");
    static final SCCVersion REQUIRED_SCC_VERSION_CONNECTION_POOLING = new SCCVersion("2.8.0");
    static final SCCVersion REQUIRED_SCC_VERSION_SSO_TOKEN_BASE64 = new SCCVersion("2.8.0");
    private static final Logger log = Logger.getLogger(SCCUtil.class.getName());

    boolean isConnectionPoolingSupported(SCCVersion masterVersion, SCCVersion shadowVersion) {
        return SCCVersion.isMatchingRequiredVersion(masterVersion, shadowVersion, REQUIRED_SCC_VERSION_CONNECTION_POOLING);
    }

    boolean isConnectionPoolingReliable(SCCVersion masterVersion, SCCVersion shadowVersion) {
        return SCCVersion.isMatchingRequiredVersion(masterVersion, shadowVersion, RELIABLE_SCC_VERSION_CONNECTION_POOLING);
    }

    boolean isBase64SSOTokenSupported(SCCVersion masterVersion, SCCVersion shadowVersion) {
        return SCCVersion.isMatchingRequiredVersion(masterVersion, shadowVersion, REQUIRED_SCC_VERSION_SSO_TOKEN_BASE64);
    }

    SCCVersion getSccVersion(String name, Properties connectionInfo) {
        String version = connectionInfo.getProperty(name);
        try {
            return new SCCVersion(version);
        }
        catch (IllegalArgumentException ex) {
            log.log(Level.WARNING, String.format("Invalid SCC version: %s", name), ex);
            return null;
        }
    }
}

