/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.runtime.system;

import com.sap.core.connectivity.api.DestinationException;
import com.sap.core.connectivity.api.DestinationNotFoundException;
import com.sap.core.connectivity.api.http.HttpDestination;
import com.sap.core.connectivity.api.http.HttpDestinationClient;
import com.sap.core.connectivity.httpdestination.common.HttpClientBuilderWrapper;
import com.sap.core.connectivity.httpdestination.common.HttpClientConfigurator;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.impl.AbstractHttpDestinationService;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationAuthenticatorProvider;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationHeadersProvider;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationImpl;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationInfoDelegate;
import com.sap.core.connectivity.httpdestination.internal.api.ISystemDestinationsService;
import com.sap.core.connectivity.httpdestination.runtime.system.InternalSystemAuthenticator;
import com.sap.core.connectivity.httpdestination.runtime.system.SystemHttpDestinationInfoProvider;
import org.apache.http.client.config.RequestConfig;

public final class SystemDestinationsService
extends AbstractHttpDestinationService
implements ISystemDestinationsService {
    protected static final int SYSTEM_DESTINATION_CONNECT_TIMEOUT = 30000;
    protected static final int SYSTEM_DESTINATION_READ_TIMEOUT = 60000;

    @Override
    public HttpDestination getDestination(String destinationName) throws DestinationNotFoundException {
        return this.getDestination(destinationName, this.getConfigurationProvider(), true);
    }

    @Override
    protected HttpDestination createHttpDestination(HttpDestinationInfoDelegate httpDestinationInfoDelegate) {
        return new HttpDestinationImpl(httpDestinationInfoDelegate){

            @Override
            public HttpDestinationClient createHttpClient() throws DestinationException {
                return super.createHttpClient(new SystemHttpClientConfigurator());
            }
        };
    }

    @Override
    protected void activate() {
        HttpDestinationAuthenticatorProvider authenticatorProvider = new HttpDestinationAuthenticatorProvider(new InternalSystemAuthenticator());
        HttpDestinationHeadersProvider headersProvider = new HttpDestinationHeadersProvider(this.getAuthenticationHeaderProvider(), this.getSapPassportHeaderProvider());
        SystemHttpDestinationInfoProvider destinationInfoProvider = new SystemHttpDestinationInfoProvider(authenticatorProvider, headersProvider);
        this.setDestinationInfoProvider(destinationInfoProvider);
    }

    private static class SystemHttpClientConfigurator
    implements HttpClientConfigurator {
        private SystemHttpClientConfigurator() {
        }

        @Override
        public void configure(HttpClientBuilderWrapper builder, HttpDestinationInfo destinationInfo) throws DestinationException {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(60000).build();
            builder.setDefaultRequestConfig(requestConfig);
        }
    }
}

