/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.httpdestination.runtime.system;

import com.sap.core.connectivity.api.DestinationNotFoundException;
import com.sap.core.connectivity.destinations.internal.api.ConfigurationProvider;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationAuthenticatorProvider;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationHeadersProvider;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationInfoProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SystemHttpDestinationInfoProvider
extends HttpDestinationInfoProvider {
    private final Map<String, HttpDestinationInfo> httpDestinationInfoCache = new ConcurrentHashMap<String, HttpDestinationInfo>();

    public SystemHttpDestinationInfoProvider(HttpDestinationAuthenticatorProvider authenticatorProvider, HttpDestinationHeadersProvider headersProvider) {
        super(authenticatorProvider, headersProvider);
    }

    @Override
    public HttpDestinationInfo getHttpDestinationInfo(String name, ConfigurationProvider configurationProvider) throws DestinationNotFoundException {
        HttpDestinationInfo httpDestinationInfo = this.httpDestinationInfoCache.get(name);
        if (httpDestinationInfo == null) {
            httpDestinationInfo = super.getHttpDestinationInfo(name, configurationProvider);
            this.httpDestinationInfoCache.put(name, httpDestinationInfo);
        }
        return httpDestinationInfo;
    }
}

