/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import java.util.Arrays;

@Immutable
final class SecureStoreRecord {
    private final String _preamble;
    private final byte[] _timestamp;
    private final String _username;
    private final String _hostname;
    private final int _recordType;
    private final int _recordLength;
    private final String _recordIdentifier;
    private final int _isDeleted;
    private final int _isPlainText;
    private final int _isBinary;
    private final byte[] _hmac;
    private final int _payloadLength;
    private final char[] _data;

    SecureStoreRecord(String preamble, byte[] timestamp, String username, String hostname, int recordType, int recordLength, String recordIdentifier, int isDeleted, int isPlainText, int isBinary, byte[] hmac, int payloadLength, char[] data) {
        this._preamble = preamble;
        this._timestamp = Arrays.copyOf(timestamp, timestamp.length);
        this._username = username;
        this._hostname = hostname;
        this._recordType = recordType;
        this._recordLength = recordLength;
        this._recordIdentifier = recordIdentifier;
        this._isDeleted = isDeleted;
        this._isPlainText = isPlainText;
        this._isBinary = isBinary;
        this._hmac = Arrays.copyOf(hmac, hmac.length);
        this._payloadLength = payloadLength;
        this._data = Arrays.copyOf(data, data.length);
    }

    String getPreamble() {
        return this._preamble;
    }

    byte[] getTimestamp() {
        return this._timestamp;
    }

    String getUsername() {
        return this._username;
    }

    String getHostname() {
        return this._hostname;
    }

    int getRecordType() {
        return this._recordType;
    }

    int getRecordLength() {
        return this._recordLength;
    }

    String getRecordIdentifier() {
        return this._recordIdentifier;
    }

    int isDeleted() {
        return this._isDeleted;
    }

    int isPlainText() {
        return this._isPlainText;
    }

    int isBinary() {
        return this._isBinary;
    }

    byte[] getHmac() {
        return this._hmac;
    }

    int getPayloadLength() {
        return this._payloadLength;
    }

    char[] getData() {
        return this._data;
    }
}

