/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.packet.ActiveActiveProtocolVersion;
import com.sap.db.jdbc.packet.ClientSideEncryptionVersion;
import com.sap.db.jdbc.packet.DataFormatVersion;
import com.sap.db.util.Dbg;
import com.sap.db.util.security.AuthenticationMethodType;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Immutable
public enum ConnectionProperty {
    USER("user"),
    PASSWD(true, "password"),
    INSTANCE_NUMBER("instanceNumber"),
    KEY(true, "key"),
    VIRTUAL_HOST_NAME("virtualHostName"),
    DATABASE_NAME("databaseName"),
    ENCRYPT("encrypt", false),
    LOCALE("locale"),
    RECONNECT("reconnect", true),
    PACKET_SIZE("packetSize", 0x100000),
    CLOSE_HANDLES_ON_FINALIZE("closeHandlesOnFinalize", true),
    SPLIT_BATCH_COMMANDS("splitBatchCommands", false),
    EMPTY_TIMESTAMP_IS_NULL("emptyTimestampIsNull", true),
    VALIDATE_CERTIFICATE("validateCertificate", true),
    HOST_NAME_IN_CERTIFICATE("hostNameInCertificate"),
    KEY_STORE("keyStore"),
    KEY_STORE_TYPE("keyStoreType"),
    KEY_STORE_PASSWD(true, "keyStorePassword"),
    TRUST_STORE("trustStore"),
    TRUST_STORE_TYPE("trustStoreType"),
    TRUST_STORE_PASSWD(true, "trustStorePassword"),
    SNI_HOSTNAME("sniHostname"),
    PREFETCH("prefetch", true),
    CSE_KEY_STORE_PASSWD(true, "cseKeyStorePassword"),
    COMPRESS("compress", false),
    PROXY_HOST_NAME("proxyHostName", ""),
    PROXY_PORT("proxyPort", 1080),
    PROXY_USER_NAME("proxyUserName", ""),
    PROXY_PASSWD(true, "proxyPassword", ""),
    PROXY_SCP_ACCOUNT("proxyScpAccount", ""),
    WEB_SOCKET_URL("webSocketUrl", ""),
    STATEMENT_CACHE_SIZE("statementCacheSize", 0),
    CONNECT_TIMEOUT("connectTimeout", 60000),
    CLOSE_HANDLES_BY_CLEANER("closeHandlesByCleaner", true),
    INEXACT_DOUBLE_TO_DECIMAL_CONVERSION("inexactDoubleToDecimalConversion", true),
    TRANSACTIONAL_LOBS("transactionalLobs", true),
    SSL_KEY_STORE(true, "sslKeyStore"),
    SSL_TRUST_STORE("sslTrustStore"),
    WEB_SOCKET_PING_TIMEOUT("webSocketPingTimeout", 30),
    SITE_TYPE("siteType", "ANY"),
    MAX_LAZY_DROPPED_STATEMENTS("maxLazyDroppedStatements", 50),
    CURSOR_HOLDABILITY_TYPE("cursorHoldabilityType"),
    ROUTE_DIRECT_EXECUTE("routeDirectExecute", false),
    DEFERRED_PREPARE("deferredPrepare", false),
    NETWORK_GROUP("networkGroup", System.getenv("HDB_NETWORK_GROUP")),
    TRACE_FILE("traceFile"),
    TRACE_OPTIONS("traceOptions"),
    PROXY_HTTP("proxyHttp", false),
    TCP_KEEP_ALIVE_IDLE("tcpKeepAliveIdle", 200),
    TCP_KEEP_ALIVE_INTERVAL("tcpKeepAliveInterval", 4),
    TCP_KEEP_ALIVE_COUNT("tcpKeepAliveCount", 5),
    SSL_SNI_REQUEST("sslSniRequest", true),
    NON_BLOCKING_IO("nonBlockingIO", true),
    HEARTBEAT_TIME("heartbeatTime"),
    BIND_ADDRESS("bindAddress"),
    AUTHENTICATION_METHODS("authenticationMethods", AuthenticationMethodType.DEFAULT_METHOD_NAMES),
    TRACE_DISABLED("traceDisabled", false),
    AUTHENTICATION_X509("authenticationX509"),
    STATEMENT_ROUTING_FAILURE_BACKOFF("statementRoutingFailureBackoff", true),
    RESPECT_AUTO_COMMIT_ON_PREPARE("respectAutoCommitOnPrepare", false),
    AUTO_COMMIT("autoCommit", true),
    READ_ONLY("readOnly", false),
    ISOLATION("isolation", "TRANSACTION_READ_COMMITTED"),
    CURRENT_SCHEMA("currentSchema"),
    COMMUNICATION_TIMEOUT("communicationTimeout", 0),
    IGNORE_TOPOLOGY("ignoreTopology", false),
    DISTRIBUTION("distribution", "STATEMENT"),
    DBURL("dburl"),
    HOSTLIST("hostlist"),
    APPLICATION("application", ConnectionProperty._getApplicationDefault()),
    APPLICATIONUSER("applicationUser", System.getProperty("user.name")),
    NATIVE_AUTHENTICATION("nativeAuthentication", false),
    TRANSPORT("transport", "socket"),
    ASSOCIATED_CONNECTION_ID("associatedConnectionID"),
    CONNECTION_TRACE("connectionTrace"),
    TRACE("trace"),
    TRACE_SIZE("traceSize"),
    DATA_FORMAT_SUPPORT("dataFormatSupport", DataFormatVersion.Level8.getValue()),
    SYSTEM_REPLICATION_PROTOCOL_VERSION("systemReplicationProtocolVersion", ActiveActiveProtocolVersion.Level2.getValue()),
    HINT_ROUTING_BACKOFF_MIN("hintRoutingBackoffMin", 5),
    HINT_ROUTING_BACKOFF_MAX("hintRoutingBackoffMax", 300),
    STATEMENT_ROUTING_BACKOFF_MIN("statementRoutingBackoffMin", 60),
    STATEMENT_ROUTING_BACKOFF_MAX("statementRoutingBackoffMax", 3600),
    COMPRESS_LOCAL("compressLocal", false),
    DYNAMIC_FETCH_SIZE("dynamicFetchSize", true),
    PORT_OVERRIDE("portOverride"),
    STATEMENT_CACHE_TRACK_SIZE("statementCacheTrackSize"),
    STATEMENT_CACHE_MAINTENANCE_FREQUENCY("statementCacheMaintenanceFrequency"),
    STATEMENT_CACHE_COLD_INTERVAL("statementCacheColdInterval"),
    STATEMENT_CACHE_TRACK_COLD_INTERVAL("statementCacheTrackColdInterval"),
    STATEMENT_CACHE_MAX_TRACKED_STATEMENT_LENGTH("statementCacheMaxTrackedStatementLength"),
    CLIENT_SIDE_ENCRYPTION_VERSION("clientSideEncryptionVersion", ClientSideEncryptionVersion.Level3.getValue()),
    COLUMN_TRANSFORMATION_BATCH_SIZE("columnTransformationBatchSize", 10000),
    PRIMARY_CONNECTION("primaryConnection", "ANCHOR"),
    CLOSE_HANDLES_BY_PHANTOM_REFERENCE("closeHandlesByPhantomReference", false),
    QUOTE_CURRENT_SCHEMA("quoteCurrentSchema", true),
    CLIENT_RECONNECT_WAIT_TIMEOUT("clientReconnectWaitTimeout", -1),
    TABLE_OUTPUT_PARAMETER_META_DATA("tableOutputParameterMetaData", true),
    CSE_KEY_STORE_FILENAME("cseKeyStoreFilename"),
    REF_CURSORS("refCursors", false),
    NON_BLOCKING_IO_DIRECT_MEMORY("nonBlockingIODirectMemory", false),
    HEARTBEAT_SENDER("heartbeatSender", "BOTH"),
    HEARTBEAT_PING_REQUEST_TIMEOUT("heartbeatPingRequestTimeout", 5000),
    TRACE_LISTENER("traceListener"),
    TIME_ZONE_PER_OBJECT("timeZonePerObject", true),
    LOB_LOCATOR_0_FULL_VALUE("lobLocator0FullValue", true),
    SQL_EXCEPTION_VERSION("sqlExceptionVersion", 1),
    TRANSACTIONAL_LOBS_VERSION("transactionalLobsVersion", 1),
    DISABLE_CLOUD_REDIRECT("disableCloudRedirect", false),
    SUPPORT_FORCE_REROUTE("supportForceReroute", true),
    RETURN_TO_POOL_SETS_DEFAULTS("returnToPoolSetsDefaults", false),
    _TEST_SIMULATE_PORT_FORWARDING("_testSimulatePortForwarding", false),
    _TEST_SIMULATE_INVALID_TOPOLOGY("_testSimulateInvalidTopology", false),
    _TEST_TRACK_SEND_RECEIVE_EXCEPTION_ACTIONS("_testTrackSendReceiveExceptionActions", false),
    _TEST_TRACK_SECONDARY_SESSION_ATTEMPTS("_testTrackSecondarySessionAttempts", false),
    _FEATURE_HEARTBEAT("_featureHeartbeat", true);

    public static final String SESSION_VARIABLE_PREFIX = "sessionVariable:";
    public static final int SESSION_VARIABLE_PREFIX_LEN;
    public static final String JNI_AUTHENTICATION = "jniAuthentication";
    private static final Map<String, String> CANONICAL_NAME_MAP;
    private static final Map<String, ConnectionProperty> CONNECTION_PROPERTY_MAP;
    private final boolean _isPassword;
    private final String _canonicalName;
    private final String _defaultValue;

    public static String getCanonicalName(String name) {
        String canonicalName = CANONICAL_NAME_MAP.get(name);
        return canonicalName != null ? canonicalName : name;
    }

    public static ConnectionProperty getConnectionProperty(String name) {
        ConnectionProperty connectionProperty = CONNECTION_PROPERTY_MAP.get(name);
        return connectionProperty;
    }

    private ConnectionProperty(String canonicalName) {
        this(false, canonicalName, null);
    }

    private ConnectionProperty(String canonicalName, boolean defaultValue) {
        this(false, canonicalName, String.valueOf(defaultValue));
    }

    private ConnectionProperty(String canonicalName, int defaultValue) {
        this(false, canonicalName, String.valueOf(defaultValue));
    }

    private ConnectionProperty(String canonicalName, String defaultValue) {
        this(false, canonicalName, defaultValue);
    }

    private ConnectionProperty(boolean isPassword, String canonicalName) {
        this(isPassword, canonicalName, null);
    }

    private ConnectionProperty(boolean isPassword, String canonicalName, String defaultValue) {
        this._isPassword = isPassword;
        this._canonicalName = canonicalName;
        this._defaultValue = defaultValue;
    }

    public boolean isPassword() {
        return this._isPassword;
    }

    public String getName() {
        return this._canonicalName;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    private static String _getApplicationDefault() {
        String value = System.getProperty("sun.java.command");
        if (value == null || value.isEmpty()) {
            return value;
        }
        Matcher matcher = Pattern.compile("\"([^\"]*)\"|(\\S+)").matcher(value);
        if (matcher.find()) {
            value = matcher.group();
        }
        return value;
    }

    public String toString() {
        return this._canonicalName;
    }

    static {
        SESSION_VARIABLE_PREFIX_LEN = SESSION_VARIABLE_PREFIX.length();
        CANONICAL_NAME_MAP = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        CONNECTION_PROPERTY_MAP = new TreeMap<String, ConnectionProperty>();
        for (ConnectionProperty value : ConnectionProperty.values()) {
            CANONICAL_NAME_MAP.put(value._canonicalName, value._canonicalName);
            CONNECTION_PROPERTY_MAP.put(value._canonicalName, value);
            if (Dbg.runtimeEnabled && !value._canonicalName.matches("_?[A-Za-z0-9]+")) {
                throw new AssertionError((Object)("Invalid connection property name \"" + value._canonicalName + "\""));
            }
        }
    }
}

