/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.FetchChunk;
import com.sap.db.jdbc.FetchInfo;
import com.sap.db.jdbc.HanaResultSetMetaData;
import com.sap.db.jdbc.InternalCallableStatementSapDB;
import com.sap.db.jdbc.InternalPreparedStatementSapDB;
import com.sap.db.jdbc.InternalResultSetSapDB;
import com.sap.db.jdbc.InternalStatementSapDB;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PassportListener;
import com.sap.db.jdbc.ResultSetMetaDataSapDB;
import com.sap.db.jdbc.ServerKPIs;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.AbstractGetval;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbcext.wrapper.ResultSet;
import com.sap.db.util.Dbg;
import com.sap.db.util.DbgInstanceCount;
import com.sap.db.util.HexUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
public abstract class ResultSetSapDB
extends WrapperDummy
implements java.sql.ResultSet,
SQLParamController {
    public static final int HOLD_CURSORS_OVER_ROLLBACK = 1000001;
    public static final int HOLD_CURSORS_OVER_COMMIT_AND_ROLLBACK = 1000002;
    public static final int DEFAULT_FETCHSIZE = Short.MAX_VALUE;
    private static final int MIN_PREFETCH_SIZE = 50;
    private static final int MIN_PACKET_SIZE_FOR_DYNAMIC_FETCH_SIZE = 0x400000;
    protected final Tracer _tracer;
    protected final ConnectionSapDB _connection;
    protected final AtomicBoolean _isClosed;
    protected final AtomicBoolean _isClosedOnServer;
    protected final AtomicBoolean _isClosePending;
    private final Session _session;
    private final StatementSapDB _statement;
    private final FetchInfo _fetchInfo;
    private final int _rollbackCount;
    private final boolean _isFromMetaData;
    private final int _maxRows;
    private final boolean _isPrefetchAllowed;
    private final AtomicBoolean _isPrefetchOutstanding;
    private final ResultSetMetaDataSapDB _metaData;
    private final ServerKPIs _serverKPIs;
    private final boolean _transactionalLobs;
    private final int _transactionalLobsVersion;
    private final Object _lockAppLobs;
    @GuardedBy(value="_lockAppLobs")
    private List<AbstractGetval> _appLobs;
    private final Object _lockInputStreamsAndReaders = new Object();
    @GuardedBy(value="_lockInputStreamsAndReaders")
    private List<InputStream> _inputStreams;
    @GuardedBy(value="_lockInputStreamsAndReaders")
    private List<Reader> _readers;
    @GuardedBy(value="this")
    private int _fetchSize;
    @GuardedBy(value="this")
    private int _dynamicFetchSize;
    @GuardedBy(value="this")
    private boolean _useDynamicFetchSize;
    @GuardedBy(value="this")
    private int _weightedAverageRowSize;
    @GuardedBy(value="this")
    private boolean _isEmpty;
    @GuardedBy(value="this")
    private Position _positionState;
    @GuardedBy(value="this")
    private Position _positionStateOfChunk;
    @GuardedBy(value="this")
    private DataFormatDescription.NullIndicator _nullIndicator;
    @GuardedBy(value="this")
    private FetchChunk _currentChunk;
    @GuardedBy(value="this")
    private SQLException _prefetchSendCachedException;
    @GuardedBy(value="this")
    private int _prefetchRequestCount;

    public static ResultSetSapDB getResultSetSapDB(java.sql.ResultSet resultSet) {
        java.sql.ResultSet r = resultSet;
        while (!(r instanceof ResultSetSapDB)) {
            if (r instanceof ResultSet) {
                r = ((ResultSet)r).getInner();
                continue;
            }
            return null;
        }
        return (ResultSetSapDB)r;
    }

    protected ResultSetSapDB(Tracer tracer, ConnectionSapDB connection, Session session, StatementSapDB statement, FetchInfo fetchInfo, boolean isEmpty, HDataPart dataPart) throws SQLException {
        this._tracer = tracer;
        this._connection = connection;
        this._session = session;
        this._statement = statement;
        this._fetchInfo = fetchInfo;
        this._rollbackCount = connection._getRollbackCount();
        this._isFromMetaData = statement._isMetaDataStatement();
        this._maxRows = statement._getMaxRows();
        this._metaData = new HanaResultSetMetaData(tracer, connection, fetchInfo);
        this._serverKPIs = new ServerKPIs();
        this._isClosed = new AtomicBoolean();
        this._isClosedOnServer = new AtomicBoolean();
        this._isClosePending = new AtomicBoolean();
        this._transactionalLobs = connection.getTransactionalLobs();
        this._transactionalLobsVersion = connection.getTransactionalLobsVersion();
        this._lockAppLobs = this._transactionalLobs && this._transactionalLobsVersion >= 1 ? new Object() : null;
        this._setFetchSize(statement._getFetchSize());
        this._isEmpty = isEmpty;
        this._positionState = Position.BEFORE_FIRST;
        this._positionStateOfChunk = Position.NOT_AVAILABLE;
        this._isPrefetchAllowed = this._isPrefetchAllowed();
        AtomicBoolean atomicBoolean = this._isPrefetchOutstanding = this._isPrefetchAllowed ? new AtomicBoolean() : null;
        if (dataPart != null) {
            this._setCurrentChunk(dataPart, 1);
            this._positionState = Position.BEFORE_FIRST;
        } else {
            this._isClosedOnServer.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized boolean next() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("next") : null;
        try {
            boolean result;
            PassportListener pl;
            if (on) {
                this._tracer.printCall(this, "next", new Object[0]);
            }
            InitNextResult initNextResult = this._initNext();
            switch (initNextResult) {
                case FALSE: 
                case TRUE: {
                    pl = null;
                    break;
                }
                case RESULT_OF_FETCH_FIRST: 
                case RESULT_OF_FETCH_NEXT: {
                    pl = this._connection.getPassportListener();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected InitNextResult value: " + (Object)((Object)initNextResult)));
                }
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = this._finiNext(initNextResult);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public void close() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("close") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "close", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._close(true, this._connection.getTransactionalLobs());
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean wasNull() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("wasNull") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "wasNull", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._wasNull();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized SQLWarning getWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getWarnings") : null;
        try {
            SQLWarning result;
            if (on) {
                this._tracer.printCall(this, "getWarnings", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = null;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            SQLWarning sQLWarning = result;
            return sQLWarning;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void clearWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("clearWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearWarnings", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized String getCursorName() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getCursorName") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getCursorName", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._fetchInfo.getCursorID().toString();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMetaData") : null;
        try {
            ResultSetMetaDataSapDB result;
            if (on) {
                this._tracer.printCall(this, "getMetaData", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._metaData;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSetMetaDataSapDB resultSetMetaDataSapDB = result;
            return resultSetMetaDataSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int findColumn(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("findColumn") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "findColumn", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getConverter(columnLabel).getIndex();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Object getObject(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getObject") : null;
        try {
            AbstractConverter converter;
            Object result;
            if (on) {
                this._tracer.printCall(this, "getObject", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnIndex)).getObject(this, this._getDataPart(converter.getOutputFieldPos()))) instanceof AbstractGetval) {
                    this._addAppLob((AbstractGetval)result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Object getObject(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getObject") : null;
        try {
            AbstractConverter converter;
            Object result;
            if (on) {
                this._tracer.printCall(this, "getObject", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnLabel)).getObject(this, this._getDataPart(converter.getOutputFieldPos()))) instanceof AbstractGetval) {
                    this._addAppLob((AbstractGetval)result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBoolean") : null;
        try {
            boolean result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBoolean", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getBoolean(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean getBoolean(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBoolean") : null;
        try {
            boolean result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBoolean", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getBoolean(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized byte getByte(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getByte") : null;
        try {
            byte result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getByte", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getByte(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            byte by = result;
            return by;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized byte getByte(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getByte") : null;
        try {
            byte result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getByte", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getByte(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            byte by = result;
            return by;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized short getShort(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getShort") : null;
        try {
            short result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getShort", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getShort(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            short s = result;
            return s;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized short getShort(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getShort") : null;
        try {
            short result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getShort", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getShort(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            short s = result;
            return s;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getInt(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getInt") : null;
        try {
            int result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getInt", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getInt(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getInt(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getInt") : null;
        try {
            int result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getInt", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getInt(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized long getLong(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getLong") : null;
        try {
            long result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getLong", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getLong(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized long getLong(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getLong") : null;
        try {
            long result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getLong", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getLong(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized float getFloat(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getFloat") : null;
        try {
            float result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getFloat", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getFloat(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, Float.valueOf(result)));
            }
            float f = result;
            return f;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized float getFloat(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getFloat") : null;
        try {
            float result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getFloat", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getFloat(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, Float.valueOf(result)));
            }
            float f = result;
            return f;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized double getDouble(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDouble") : null;
        try {
            double result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getDouble", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getDouble(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            double d = result;
            return d;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized double getDouble(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDouble") : null;
        try {
            double result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getDouble", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getDouble(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            double d = result;
            return d;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @JDBCAPI(packetExchange="false")
    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBigDecimal") : null;
        try {
            BigDecimal result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", columnIndex, scale);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getBigDecimal(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @JDBCAPI(packetExchange="false")
    public synchronized BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBigDecimal") : null;
        try {
            BigDecimal result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", columnLabel, scale);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getBigDecimal(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Date getDate(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDate") : null;
        try {
            Date result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getDate", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getDate(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Date date = result;
            return date;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Date getDate(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDate") : null;
        try {
            Date result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getDate", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getDate(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Date date = result;
            return date;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Time getTime(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getTime") : null;
        try {
            Time result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTime", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getTime(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Time time = result;
            return time;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Time getTime(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getTime") : null;
        try {
            Time result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTime", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getTime(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Time time = result;
            return time;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getTimestamp") : null;
        try {
            Timestamp result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTimestamp", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getTimestamp(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Timestamp getTimestamp(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getTimestamp") : null;
        try {
            Timestamp result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTimestamp", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getTimestamp(this, this._getDataPart(converter.getOutputFieldPos()), null);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="lobOutputConverter")
    public synchronized String getString(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getString") : null;
        try {
            String result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getString", columnIndex);
            }
            PassportListener pl = (converter = this._getConverter(columnIndex)).isLOB() ? this._connection.getPassportListener() : null;
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="lobOutputConverter")
    public synchronized String getString(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getString") : null;
        try {
            String result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getString", columnLabel);
            }
            PassportListener pl = (converter = this._getConverter(columnLabel)).isLOB() ? this._connection.getPassportListener() : null;
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="lobOutputConverter")
    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBytes") : null;
        try {
            byte[] result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBytes", columnIndex);
            }
            PassportListener pl = (converter = this._getConverter(columnIndex)).isLOB() ? this._connection.getPassportListener() : null;
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = converter.getBytes(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, HexUtils.toDisplayHexString(result, 20)));
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="lobOutputConverter")
    public synchronized byte[] getBytes(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBytes") : null;
        try {
            byte[] result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBytes", columnLabel);
            }
            PassportListener pl = (converter = this._getConverter(columnLabel)).isLOB() ? this._connection.getPassportListener() : null;
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = converter.getBytes(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, HexUtils.toDisplayHexString(result, 20)));
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getAsciiStream") : null;
        try {
            AbstractConverter converter;
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getAsciiStream", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnIndex)).getAsciiStream(this, this._getDataPart(converter.getOutputFieldPos()))) != null) {
                    this._addInputStream(result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized InputStream getAsciiStream(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getAsciiStream") : null;
        try {
            AbstractConverter converter;
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getAsciiStream", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnLabel)).getAsciiStream(this, this._getDataPart(converter.getOutputFieldPos()))) != null) {
                    this._addInputStream(result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @JDBCAPI(packetExchange="false")
    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getUnicodeStream") : null;
        try {
            AbstractConverter converter;
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getUnicodeStream", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnIndex)).getUnicodeStream(this, this._getDataPart(converter.getOutputFieldPos()))) != null) {
                    this._addInputStream(result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @JDBCAPI(packetExchange="false")
    public synchronized InputStream getUnicodeStream(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getUnicodeStream") : null;
        try {
            AbstractConverter converter;
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getUnicodeStream", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnLabel)).getUnicodeStream(this, this._getDataPart(converter.getOutputFieldPos()))) != null) {
                    this._addInputStream(result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBinaryStream") : null;
        try {
            AbstractConverter converter;
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getBinaryStream", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnIndex)).getBinaryStream(this, this._getDataPart(converter.getOutputFieldPos()))) != null) {
                    this._addInputStream(result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized InputStream getBinaryStream(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBinaryStream") : null;
        try {
            AbstractConverter converter;
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getBinaryStream", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnLabel)).getBinaryStream(this, this._getDataPart(converter.getOutputFieldPos()))) != null) {
                    this._addInputStream(result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean isBeforeFirst() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("isBeforeFirst") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isBeforeFirst", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._isBeforeFirst();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean isAfterLast() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("isAfterLast") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isAfterLast", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._isAfterLast();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean isFirst() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("isFirst") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isFirst", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._isFirst();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean isLast() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("isLast") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isLast", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._isLast();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void beforeFirst() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("beforeFirst") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "beforeFirst", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getForwardOnlyException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void afterLast() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("afterLast") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "afterLast", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getForwardOnlyException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean first() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("first") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "first", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getForwardOnlyException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean last() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("last") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "last", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getForwardOnlyException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getRow") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getRow", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getRow();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean absolute(int row) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("absolute") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "absolute", row);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getForwardOnlyException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean relative(int rows) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("relative") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "relative", rows);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getForwardOnlyException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean previous() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("previous") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "previous", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getForwardOnlyException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getFetchDirection() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getFetchDirection") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getFetchDirection", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 1000;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setFetchDirection(int direction) throws SQLException {
        on = this._tracer.on();
        pon = this._tracer.pon();
        aon = on != false ? this._tracer.aon() : false;
        r = pon != false ? this._newTraceRecord("setFetchDirection") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFetchDirection", new Object[]{direction});
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                switch (direction) {
                    case 1000: {
                        ** break;
lbl14:
                        // 1 sources

                        break;
                    }
                    case 1001: 
                    case 1002: {
                        throw ResultSetSapDB._getForwardOnlyException();
                    }
                    default: {
                        throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", new String[]{"direction", "FETCH_FORWARD, FETCH_REVERSE, FETCH_UNKNOWN"});
                    }
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getFetchSize() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getFetchSize") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getFetchSize", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._fetchSize;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setFetchSize(int fetchSize) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("setFetchSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFetchSize", fetchSize);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if (fetchSize < 0) {
                    throw SQLExceptionSapDB.newInstance("error.invalid.fetchsize", String.valueOf(fetchSize));
                }
                this._setFetchSize(fetchSize);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getType() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getType") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getType", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 1003;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getConcurrency() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getConcurrency") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getConcurrency", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 1007;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean rowInserted() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("rowInserted") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "rowInserted", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean rowUpdated() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("rowUpdated") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "rowUpdated", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean rowDeleted() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("rowDeleted") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "rowDeleted", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void insertRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("insertRow") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "insertRow", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateRow") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateRow", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void deleteRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("deleteRow") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "deleteRow", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void refreshRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("refreshRow") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "refreshRow", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void cancelRowUpdates() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("cancelRowUpdates") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "cancelRowUpdates", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void moveToInsertRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("moveToInsertRow") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "moveToInsertRow", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void moveToCurrentRow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("moveToCurrentRow") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "moveToCurrentRow", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Statement getStatement() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getStatement") : null;
        try {
            StatementSapDB result;
            if (on) {
                this._tracer.printCall(this, "getStatement", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._isFromMetaData ? null : this._statement;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            StatementSapDB statementSapDB = result;
            return statementSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", columnIndex, map);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getUnsupportedMethodException("getObject( int, Map )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", columnLabel, map);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getUnsupportedMethodException("getObject( String, Map )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBigDecimal") : null;
        try {
            BigDecimal result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getBigDecimal(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBigDecimal") : null;
        try {
            BigDecimal result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getBigDecimal(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDate") : null;
        try {
            Date result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getDate", columnIndex, cal);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getDate(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Date date = result;
            return date;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Date getDate(String columnLabel, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDate") : null;
        try {
            Date result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getDate", columnLabel, cal);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getDate(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Date date = result;
            return date;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getTime") : null;
        try {
            Time result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTime", columnIndex, cal);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getTime(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Time time = result;
            return time;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Time getTime(String columnLabel, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getTime") : null;
        try {
            Time result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTime", columnLabel, cal);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getTime(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Time time = result;
            return time;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getTimestamp") : null;
        try {
            Timestamp result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTimestamp", columnIndex, cal);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getTimestamp(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getTimestamp") : null;
        try {
            Timestamp result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getTimestamp", columnLabel, cal);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getTimestamp(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getCharacterStream") : null;
        try {
            AbstractConverter converter;
            Reader result;
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnIndex)).getCharacterStream(this, this._getDataPart(converter.getOutputFieldPos()))) != null) {
                    this._addReader(result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Reader getCharacterStream(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getCharacterStream") : null;
        try {
            AbstractConverter converter;
            Reader result;
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnLabel)).getCharacterStream(this, this._getDataPart(converter.getOutputFieldPos()))) != null) {
                    this._addReader(result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Clob getClob(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getClob") : null;
        try {
            Clob result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getClob", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getClob(this, this._getDataPart(converter.getOutputFieldPos()));
                this._addAppLob((AbstractGetval)((Object)result));
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Clob clob = result;
            return clob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Clob getClob(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getClob") : null;
        try {
            Clob result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getClob", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getClob(this, this._getDataPart(converter.getOutputFieldPos()));
                this._addAppLob((AbstractGetval)((Object)result));
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Clob clob = result;
            return clob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Blob getBlob(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBlob") : null;
        try {
            Blob result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBlob", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getBlob(this, this._getDataPart(converter.getOutputFieldPos()));
                this._addAppLob((AbstractGetval)((Object)result));
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Blob blob = result;
            return blob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Blob getBlob(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getBlob") : null;
        try {
            Blob result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getBlob", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getBlob(this, this._getDataPart(converter.getOutputFieldPos()));
                this._addAppLob((AbstractGetval)((Object)result));
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Blob blob = result;
            return blob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Array getArray(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getArray") : null;
        try {
            Array result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getArray", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = converter.getArray(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Array array = result;
            return array;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Array getArray(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getArray") : null;
        try {
            Array result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getArray", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = converter.getArray(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Array array = result;
            return array;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Ref getRef(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRef", columnIndex);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getUnsupportedMethodException("getRef( int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Ref getRef(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRef", columnLabel);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getUnsupportedMethodException("getRef( String )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNull(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNull") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNull", columnIndex);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNull(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNull") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNull", columnLabel);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateObject(String columnLabel, Object x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnIndex, x, scale);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateObject(String columnLabel, Object x, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnLabel, x, scale);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBoolean") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBoolean", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBoolean(String columnLabel, boolean x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBoolean") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBoolean", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateByte") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateByte", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateByte(String columnLabel, byte x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateByte") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateByte", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateShort") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateShort", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateShort(String columnLabel, short x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateShort") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateShort", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateInt") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateInt", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateInt(String columnLabel, int x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateInt") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateInt", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateLong") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateLong", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateLong(String columnLabel, long x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateLong") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateLong", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateFloat") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateFloat", columnIndex, Float.valueOf(x));
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateFloat(String columnLabel, float x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateFloat") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateFloat", columnLabel, Float.valueOf(x));
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateDouble") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateDouble", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateDouble(String columnLabel, double x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateDouble") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateDouble", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBigDecimal") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBigDecimal", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBigDecimal") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBigDecimal", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateDate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateDate", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateDate(String columnLabel, Date x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateDate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateDate", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateTime") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateTime", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateTime(String columnLabel, Time x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateTime") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateTime", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateTimestamp") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateTimestamp", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateTimestamp") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateTimestamp", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateString") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateString", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateString(String columnLabel, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateString") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateString", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBytes") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBytes", columnIndex, HexUtils.toDisplayHexString(x, 20));
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBytes(String columnLabel, byte[] x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBytes") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBytes", columnLabel, HexUtils.toDisplayHexString(x, 20));
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateAsciiStream", columnIndex, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateAsciiStream", columnLabel, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateCharacterStream", columnIndex, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateCharacterStream", columnLabel, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBinaryStream", columnIndex, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBinaryStream", columnLabel, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized URL getURL(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getURL", columnIndex);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getUnsupportedMethodException("getURL( int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized URL getURL(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getURL", columnLabel);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getUnsupportedMethodException("getURL( String )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateClob(int columnIndex, Clob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateClob", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateClob(String columnLabel, Clob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateClob", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBlob(int columnIndex, Blob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBlob", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBlob(String columnLabel, Blob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBlob", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateArray(int columnIndex, Array x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateArray", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateArray(String columnLabel, Array x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateArray", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateRef(int columnIndex, Ref x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateRef", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateRef(String columnLabel, Ref x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateRef", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getHoldability() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getHoldability") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getHoldability", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._statement._getResultSetHoldability();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean isClosed() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("isClosed") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isClosed", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._isClosed() || this._isClosePending();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="lobOutputConverter")
    public synchronized String getNString(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getNString") : null;
        try {
            String result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getNString", columnIndex);
            }
            PassportListener pl = (converter = this._getConverter(columnIndex)).isLOB() ? this._connection.getPassportListener() : null;
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="lobOutputConverter")
    public synchronized String getNString(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getNString") : null;
        try {
            String result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getNString", columnLabel);
            }
            PassportListener pl = (converter = this._getConverter(columnLabel)).isLOB() ? this._connection.getPassportListener() : null;
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Reader getNCharacterStream(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getNCharacterStream") : null;
        try {
            AbstractConverter converter;
            Reader result;
            if (on) {
                this._tracer.printCall(this, "getNCharacterStream", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnIndex)).getCharacterStream(this, this._getDataPart(converter.getOutputFieldPos()))) != null) {
                    this._addReader(result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Reader getNCharacterStream(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getNCharacterStream") : null;
        try {
            AbstractConverter converter;
            Reader result;
            if (on) {
                this._tracer.printCall(this, "getNCharacterStream", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnLabel)).getCharacterStream(this, this._getDataPart(converter.getOutputFieldPos()))) != null) {
                    this._addReader(result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized NClob getNClob(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getNClob") : null;
        try {
            NClob result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getNClob", columnIndex);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnIndex);
                result = (NClob)converter.getClob(this, this._getDataPart(converter.getOutputFieldPos()));
                this._addAppLob((AbstractGetval)((Object)result));
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            NClob nClob = result;
            return nClob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized NClob getNClob(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getNClob") : null;
        try {
            NClob result;
            AbstractConverter converter;
            if (on) {
                this._tracer.printCall(this, "getNClob", columnLabel);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                converter = this._getConverter(columnLabel);
                result = (NClob)converter.getClob(this, this._getDataPart(converter.getOutputFieldPos()));
                this._addAppLob((AbstractGetval)((Object)result));
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            NClob nClob = result;
            return nClob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized RowId getRowId(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRowId", columnIndex);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getUnsupportedMethodException("getRowId( int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized RowId getRowId(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRowId", columnLabel);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getUnsupportedMethodException("getRowId( String )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized SQLXML getSQLXML(int columnIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getSQLXML", columnIndex);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getUnsupportedMethodException("getSQLXML( int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized SQLXML getSQLXML(String columnLabel) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getSQLXML", columnLabel);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getUnsupportedMethodException("getSQLXML( String )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNString(int columnIndex, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNString") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNString", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNString(String columnLabel, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNString") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNString", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateAsciiStream", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateAsciiStream", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateAsciiStream", columnIndex, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateAsciiStream", columnLabel, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateCharacterStream", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateCharacterStream", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateCharacterStream", columnIndex, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateCharacterStream", columnLabel, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNCharacterStream", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNCharacterStream", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNCharacterStream", columnIndex, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNCharacterStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNCharacterStream", columnLabel, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBinaryStream", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBinaryStream", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBinaryStream", columnIndex, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBinaryStream", columnLabel, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateClob(int columnIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateClob", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateClob(String columnLabel, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateClob", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateClob", columnIndex, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateClob", columnLabel, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNClob(int columnIndex, NClob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNClob", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNClob(String columnLabel, NClob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNClob", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNClob(int columnIndex, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNClob", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNClob(String columnLabel, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNClob", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNClob", columnIndex, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateNClob", columnLabel, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBlob(int columnIndex, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBlob", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBlob(String columnLabel, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBlob", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBlob", columnIndex, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateBlob", columnLabel, x, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateRowId(int columnIndex, RowId x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateRowId", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateRowId(String columnLabel, RowId x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateRowId", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateSQLXML", columnIndex, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateSQLXML", columnLabel, x);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getObject") : null;
        try {
            AbstractConverter converter;
            T result;
            if (on) {
                this._tracer.printCall(this, "getObject", columnIndex, type);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnIndex)).getObject(this, this._getDataPart(converter.getOutputFieldPos()), type)) instanceof AbstractGetval) {
                    this._addAppLob((AbstractGetval)result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            T t = result;
            return t;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getObject") : null;
        try {
            AbstractConverter converter;
            T result;
            if (on) {
                this._tracer.printCall(this, "getObject", columnLabel, type);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if ((result = (converter = this._getConverter(columnLabel)).getObject(this, this._getDataPart(converter.getOutputFieldPos()), type)) instanceof AbstractGetval) {
                    this._addAppLob((AbstractGetval)result);
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            T t = result;
            return t;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnIndex, x, targetSqlType);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnLabel, x, targetSqlType);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnIndex, x, targetSqlType, scaleOrLength);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updateObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "updateObject", columnLabel, x, targetSqlType, scaleOrLength);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw ResultSetSapDB._getNotUpdatableException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public ConnectionSapDB getConnectionSapDB() {
        return this._connection;
    }

    @Override
    public StatementSapDB getStatementSapDB() {
        return this._statement;
    }

    @Override
    public ResultSetSapDB getResultSetSapDB() {
        return this;
    }

    @Override
    public void assertControllerOpen() throws SQLException {
        if (this._connection._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }

    @Override
    public Session getSession() throws SQLException {
        return this._session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNullOrSpecialNull() {
        ResultSetSapDB resultSetSapDB = this;
        synchronized (resultSetSapDB) {
            return this._wasNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasSpecialNull() {
        ResultSetSapDB resultSetSapDB = this;
        synchronized (resultSetSapDB) {
            return this._nullIndicator == DataFormatDescription.NullIndicator.SPECIAL_NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNullIndicator(DataFormatDescription.NullIndicator nullIndicator) {
        ResultSetSapDB resultSetSapDB = this;
        synchronized (resultSetSapDB) {
            this._nullIndicator = nullIndicator;
        }
    }

    public String toString() {
        return this.getTraceString(true);
    }

    public static String getTraceString(String className, int hashCode, boolean isFullString, boolean isClosed, boolean isClosePending) {
        String s = className + "@" + Integer.toHexString(hashCode);
        if (!isFullString) {
            return s;
        }
        if (isClosePending) {
            return s + "[close pending]";
        }
        if (isClosed) {
            return s + "[closed]";
        }
        return s;
    }

    public String getTraceString(boolean isFullString) {
        return ResultSetSapDB.getTraceString(this.getClass().getName(), this.hashCode(), isFullString, this._isClosed(), this._isClosePending());
    }

    public Tracer getTracer() {
        return this._tracer;
    }

    public long getServerProcessingTime() {
        return this._serverKPIs.getServerProcessingTime();
    }

    public ServerKPIs getServerKPIs() {
        return this._serverKPIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppLob(AbstractGetval appLob) {
        Object object = this._lockAppLobs;
        synchronized (object) {
            if (this._appLobs == null) {
                this._appLobs = new ArrayList<AbstractGetval>();
            }
            this._appLobs.add(appLob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppLob(AbstractGetval appLob, boolean allowClose) throws SQLException {
        boolean isEmpty;
        boolean wasRemoved;
        Object object = this._lockAppLobs;
        synchronized (object) {
            if (this._appLobs == null || this._appLobs.isEmpty()) {
                return;
            }
            wasRemoved = this._appLobs.remove(appLob);
            isEmpty = this._appLobs.isEmpty();
        }
        if (allowClose && this._isClosePending() && wasRemoved && isEmpty) {
            this._close(true, false);
        }
    }

    protected Session _getSession() {
        return this._session;
    }

    protected CursorID _getCursorID() {
        return this._fetchInfo.getCursorID();
    }

    protected ParseInfo _getMetaDataStatementParseInfo() {
        return this._isFromMetaData ? this._statement._getParseInfo() : null;
    }

    protected boolean _isBeforeFirst() throws SQLException {
        return !this._isEmpty && this._positionState == Position.BEFORE_FIRST;
    }

    protected InitNextResult _initNext() throws SQLException {
        InitNextResult result;
        if (this._isEmpty) {
            this._positionState = Position.AFTER_LAST;
            return InitNextResult.FALSE;
        }
        this._closeInputStreamsAndReaders();
        switch (this._positionState) {
            case BEFORE_FIRST: {
                if (this._positionStateOfChunk == Position.INSIDE && this._currentChunk.getChunkRowCount() > 0) {
                    this._positionState = Position.INSIDE;
                    result = InitNextResult.TRUE;
                    break;
                }
                result = InitNextResult.RESULT_OF_FETCH_FIRST;
                break;
            }
            case INSIDE: {
                if (this._currentChunk.nextRow()) {
                    result = InitNextResult.TRUE;
                    this._checkPrefetchSend(this._session);
                    break;
                }
                if (this._currentChunk.isLastChunk()) {
                    this._positionState = Position.AFTER_LAST;
                    result = InitNextResult.FALSE;
                    break;
                }
                result = InitNextResult.RESULT_OF_FETCH_NEXT;
                break;
            }
            case AFTER_LAST: 
            case NOT_AVAILABLE: {
                result = InitNextResult.FALSE;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected position state: " + (Object)((Object)this._positionState)));
            }
        }
        return result;
    }

    protected boolean _finiNext(InitNextResult initNextResult) throws SQLException {
        switch (initNextResult) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case RESULT_OF_FETCH_FIRST: {
                return this._fetchFirstChunk();
            }
            case RESULT_OF_FETCH_NEXT: {
                return this._fetchNextChunk();
            }
        }
        throw new AssertionError((Object)("Unexpected InitNextResult value: " + (Object)((Object)initNextResult)));
    }

    protected boolean _next() throws SQLException {
        return this._finiNext(this._initNext());
    }

    protected String _getString(int columnIndex) throws SQLException {
        AbstractConverter converter = this._getConverter(columnIndex);
        return converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
    }

    protected byte[] _getBytes(int columnIndex) throws SQLException {
        AbstractConverter converter = this._getConverter(columnIndex);
        return converter.getBytes(this, this._getDataPart(converter.getOutputFieldPos()));
    }

    protected boolean _isClosedOnServer() {
        return this._isClosedOnServer.get();
    }

    protected boolean _isClosePending() {
        return this._isClosePending.get();
    }

    protected boolean _isClosed() {
        return this._isClosed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _close(boolean sendRequests, boolean allowClosePending) throws SQLException {
        if (this._isClosed()) {
            return;
        }
        this._closeInputStreamsAndReaders();
        if (allowClosePending && this._shouldClosePending()) {
            if (this._isClosePending()) {
                return;
            }
            this._statement._removeResultSet(this);
            this._isClosePending.set(true);
            this._connection._addResultSetClosePending(this);
            return;
        }
        boolean wasClosePending = this._isClosePending();
        try {
            ConnectionSapDB connectionSapDB = this._connection;
            synchronized (connectionSapDB) {
                block14: {
                    if (!this._isClosed() && !this._connection._isClosed()) break block14;
                    return;
                }
                this._checkPrefetchDiscard();
                if (sendRequests) {
                    this._clean();
                }
                this._isClosed.set(true);
                this._isClosedOnServer.set(true);
                this._isClosePending.set(false);
            }
        }
        finally {
            if (wasClosePending) {
                this._connection._removeResultSetClosePending(this);
            } else {
                this._statement._removeResultSet(this);
            }
            this._clearAppLobs();
        }
    }

    protected boolean _shouldClosePending() {
        if (this._transactionalLobsVersion >= 1) {
            return this._hasAppLobs();
        }
        return this._fetchInfo._hasLOB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _hasAppLobs() {
        if (this._lockAppLobs == null) {
            return false;
        }
        Object object = this._lockAppLobs;
        synchronized (object) {
            return this._appLobs != null && !this._appLobs.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _clearAppLobs() throws SQLException {
        ArrayList<AbstractGetval> appLobs;
        if (!this._transactionalLobs || this._transactionalLobsVersion <= 0) {
            return;
        }
        Iterator iterator = this._lockAppLobs;
        synchronized (iterator) {
            if (this._appLobs == null || this._appLobs.isEmpty()) {
                return;
            }
            appLobs = new ArrayList<AbstractGetval>(this._appLobs);
        }
        for (AbstractGetval appLob : appLobs) {
            appLob.removeAppLob(false);
        }
    }

    protected void _clean() throws SQLException {
        ResultSetSapDB._clean(this.getInstanceClassName(), this._connection, this._session, this._fetchInfo.getCursorID(), this._getMetaDataStatementParseInfo(), this._isClosed, this._isClosedOnServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void _clean(String instanceClassName, ConnectionSapDB connection, Session session, CursorID cursorID, ParseInfo parseInfoFromMetaData, AtomicBoolean isClosed, AtomicBoolean isClosedOnServer) throws SQLException {
        if (connection._isClosed() || isClosed.get()) {
            return;
        }
        ConnectionSapDB connectionSapDB = connection;
        synchronized (connectionSapDB) {
            if (!isClosedOnServer.get()) {
                connection._dropCursorID(session, cursorID);
            }
            if (parseInfoFromMetaData != null) {
                connection._dropParseIDs(parseInfoFromMetaData);
            }
        }
        if (Dbg.runtimeEnabled) {
            DbgInstanceCount.incrementCleanedCount(instanceClassName);
        }
    }

    private static SQLException _getUnsupportedMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, "ResultSet");
    }

    private static SQLException _getForwardOnlyException() {
        return SQLExceptionSapDB.newInstance("error.resultset.forwardonly", new String[0]);
    }

    private static SQLException _getNotUpdatableException() throws SQLException {
        return SQLExceptionSapDB.newInstance("error.resultset.notupdatable", new String[0]);
    }

    private Object _obfuscateEncrypted(AbstractConverter converter, Object x) throws SQLException {
        return !this._tracer.getTraceConfiguration().isShowPlainTextCSEEnabled() && converter.isEncrypted() ? "***" : x;
    }

    private TraceRecord _newTraceRecord(String methodName) {
        return new TraceRecord(this._connection, this._statement, this, "ResultSet", methodName);
    }

    private void _publish(TraceRecord r) {
        r.update(this._connection);
        TraceRecordPublisher.getInstance().publish(r);
    }

    private void _checkLocks() {
        if (this._statement instanceof InternalStatementSapDB || this._statement instanceof InternalPreparedStatementSapDB || this._statement instanceof InternalCallableStatementSapDB) {
            return;
        }
        if (Thread.holdsLock(this)) {
            return;
        }
        if (Thread.holdsLock(this._statement)) {
            // empty if block
        }
        if (Thread.holdsLock(this._statement._connection)) {
            // empty if block
        }
    }

    private void _assertOpen() throws SQLException {
        if (this._isClosed() || this._isClosePending() || this._connection._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
        switch (this._statement._getResultSetHoldability()) {
            case 1: 
            case 2: {
                if (this._rollbackCount >= this._connection._getRollbackCount()) break;
                throw SQLExceptionSapDB.newInstance("error.objectisclosedduetorollback", this.toString());
            }
            case 1000001: 
            case 1000002: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected result set holdability: " + this._statement._getResultSetHoldability()));
            }
        }
    }

    private boolean _wasNull() {
        return this._connection.emptyTimestampIsNull() ? this._nullIndicator == DataFormatDescription.NullIndicator.NULL || this._nullIndicator == DataFormatDescription.NullIndicator.SPECIAL_NULL : this._nullIndicator == DataFormatDescription.NullIndicator.NULL;
    }

    private AbstractConverter _getConverter(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this._fetchInfo.getResultSetColumnCount()) {
            throw SQLExceptionSapDB.newInstance("error.invalid.column.index", String.valueOf(columnIndex));
        }
        return this._fetchInfo.getResultSetConverter(columnIndex);
    }

    private AbstractConverter _getConverter(String columnLabel) throws SQLException {
        AbstractConverter converter = this._fetchInfo.getResultSetConverter(columnLabel);
        if (converter == null) {
            throw SQLExceptionSapDB.newInstance("error.invalid.column.name", columnLabel);
        }
        return converter;
    }

    private HDataPart _getDataPart(int outputFieldPos) throws SQLException {
        if (this._positionState == Position.BEFORE_FIRST) {
            throw SQLExceptionSapDB.newInstance("error.resultset.beforefirst", new String[0]);
        }
        if (this._positionState == Position.AFTER_LAST) {
            throw SQLExceptionSapDB.newInstance("error.resultset.afterlast", new String[0]);
        }
        HDataPart dataPart = this._currentChunk.getDataPart();
        dataPart.moveToField(outputFieldPos);
        return dataPart;
    }

    private boolean _isAfterLast() throws SQLException {
        return !this._isEmpty && this._positionState == Position.AFTER_LAST;
    }

    private boolean _isFirst() throws SQLException {
        return this._currentChunk != null && !this._isEmpty && this._positionState == Position.INSIDE && this._currentChunk.isFirstChunk() && this._currentChunk.isCurrentRowFirstOfChunk();
    }

    private boolean _isLast() throws SQLException {
        return this._currentChunk != null && !this._isEmpty && this._positionState == Position.INSIDE && this._currentChunk.isLastChunk() && this._currentChunk.isCurrentRowLastOfChunk();
    }

    private int _getRow() throws SQLException {
        if (this._positionState != Position.INSIDE) {
            return 0;
        }
        return this._currentChunk != null ? this._currentChunk.getCurrentRowIndex() : 0;
    }

    private boolean _fetchFirstChunk() throws SQLException {
        HDataPart dataPart = this._executeFetchNext();
        if (dataPart.getRecordCount() == 0) {
            this._isEmpty = true;
            this._positionState = Position.AFTER_LAST;
            this._positionStateOfChunk = Position.NOT_AVAILABLE;
            this._currentChunk = null;
            this._isClosedOnServer.set(dataPart.isResultSetClosedOnServer());
            return false;
        }
        this._setCurrentChunk(dataPart, 1);
        return true;
    }

    private boolean _fetchNextChunk() throws SQLException {
        HDataPart dataPart = this._executeFetchNext();
        if (dataPart.getRecordCount() == 0) {
            this._positionState = Position.AFTER_LAST;
            this._positionStateOfChunk = Position.NOT_AVAILABLE;
            this._currentChunk = null;
            this._isClosedOnServer.set(dataPart.isResultSetClosedOnServer());
            return false;
        }
        this._setCurrentChunk(dataPart, this._currentChunk.getLastRowIndex() + 1);
        return true;
    }

    private int _getUsedFetchSize() {
        int usedFetchSize;
        int maxFetchSize;
        int n = maxFetchSize = this._connection.getEngineFeatures().support32BitFetchSize() ? Integer.MAX_VALUE : Short.MAX_VALUE;
        int fetchSize = this._useDynamicFetchSize ? this._dynamicFetchSize : (this._fetchSize == 0 ? Short.MAX_VALUE : (this._fetchSize > maxFetchSize ? maxFetchSize : this._fetchSize));
        if (this._maxRows > 0) {
            int lastRowIndex = this._currentChunk != null ? this._currentChunk.getLastRowIndex() + 1 : 0;
            usedFetchSize = Math.min(this._maxRows - lastRowIndex, fetchSize);
        } else {
            usedFetchSize = fetchSize;
        }
        if (usedFetchSize < 1) {
            usedFetchSize = 1;
        }
        return usedFetchSize;
    }

    private void _setFetchSize(int fetchSize) {
        this._fetchSize = fetchSize;
        this._useDynamicFetchSize = this._connection.getBooleanConnectionProperty(ConnectionProperty.DYNAMIC_FETCH_SIZE) && this._fetchSize == 0 && !(this instanceof InternalResultSetSapDB);
    }

    private void _updateDynamicFetchSize() throws SQLException {
        int estimatedRowSize = this._fetchInfo._getEstimatedRowSize();
        if (this._weightedAverageRowSize == 0) {
            this._weightedAverageRowSize = estimatedRowSize;
        }
        if (this._currentChunk == null || this._currentChunk.getChunkRowCount() == 0) {
            return;
        }
        int averageRowSize = this._currentChunk.getDataPart().getLength() / this._currentChunk.getChunkRowCount();
        if (averageRowSize == 0) {
            this._setDynamicFetchSizeFromRowSize(estimatedRowSize);
        } else {
            this._weightedAverageRowSize = (estimatedRowSize + this._weightedAverageRowSize * 10 + averageRowSize * 9) / 20;
            this._setDynamicFetchSizeFromRowSize(this._weightedAverageRowSize);
        }
    }

    private void _setDynamicFetchSizeFromRowSize(int rowSize) {
        int packetSize;
        int numberOfRows;
        int maxFetchSize;
        int n = maxFetchSize = this._connection.getEngineFeatures().support32BitFetchSize() ? Integer.MAX_VALUE : Short.MAX_VALUE;
        this._dynamicFetchSize = rowSize == 0 ? 1 : ((numberOfRows = (packetSize = PacketAnalyzer.align(Math.max(this._statement.getPacketSize(), 0x400000))) / rowSize) == 0 ? 1 : (numberOfRows > maxFetchSize ? maxFetchSize : numberOfRows));
    }

    private HDataPart _executeFetchNext() throws SQLException {
        this._assertOpen();
        HReplyPacket replyPacket = this._checkPrefetchReceive();
        if (replyPacket == null) {
            int fetchSize = this._getUsedFetchSize();
            HRequestPacket requestPacket = this._connection.initFetchNext(this._session, this._fetchInfo.getCursorID(), fetchSize);
            replyPacket = this._connection.exchange(this._session, requestPacket, this._statement, new ConnectionSapDB.ExchangeFlag[0]);
        }
        this._serverKPIs.accumulate(replyPacket.findStatementContextPart(0));
        HDataPart resultSetPart = replyPacket.findResultSetPart(0);
        if (resultSetPart == null) {
            throw SQLExceptionSapDB.newInstance("error.packet.fetchnodatapart", new String[0]);
        }
        resultSetPart.setDataFormatDescription(this._fetchInfo);
        return resultSetPart;
    }

    private void _setCurrentChunk(HDataPart dataPart, int firstRowIndex) throws SQLException {
        this._currentChunk = new FetchChunk(dataPart, firstRowIndex, this._maxRows);
        this._positionState = this._positionStateOfChunk = Position.INSIDE;
        this._isClosedOnServer.set(dataPart.isResultSetClosedOnServer());
        if (this._useDynamicFetchSize) {
            this._updateDynamicFetchSize();
        }
    }

    private boolean _isPrefetchAllowed() {
        return !(!this._connection.getBooleanConnectionProperty(ConnectionProperty.PREFETCH) || this._connection.supportIdlePing() && !this._connection.supportIdlePingDuringRequest() || this._fetchInfo._hasLOB() || this._fetchSize != 0 && this._fetchSize < 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _checkPrefetchSend(Session session) throws SQLException {
        int usedFetchSize;
        if (!this._isPrefetchAllowed || this._isPrefetchOutstanding.get()) {
            return;
        }
        if (this._currentChunk.isLastChunk() || this._currentChunk.getCurrentRowIndex() != this._currentChunk.getMiddleRowIndex() || this._currentChunk.getChunkRowCount() < 50 || (usedFetchSize = this._getUsedFetchSize()) < 50) {
            return;
        }
        try {
            this._connection._prefetchSend(session, this, this._fetchInfo.getCursorID(), usedFetchSize);
        }
        catch (SQLException e) {
            this._prefetchSendCachedException = e;
        }
        finally {
            this._isPrefetchOutstanding.set(true);
            ++this._prefetchRequestCount;
        }
    }

    private HReplyPacket _checkPrefetchReceive() throws SQLException {
        HReplyPacket replyPacket;
        if (!this._isPrefetchAllowed || !this._isPrefetchOutstanding.get()) {
            return null;
        }
        if (this._prefetchSendCachedException != null) {
            try {
                throw this._prefetchSendCachedException;
            }
            catch (Throwable throwable) {
                this._prefetchSendCachedException = null;
                throw throwable;
            }
        }
        try {
            replyPacket = this._connection._prefetchReceive(this);
        }
        finally {
            this._isPrefetchOutstanding.set(false);
        }
        return replyPacket;
    }

    private void _checkPrefetchDiscard() {
        if (!this._isPrefetchAllowed || !this._isPrefetchOutstanding.get()) {
            return;
        }
        try {
            this._connection._prefetchDiscard(this);
        }
        catch (SQLException sQLException) {
        }
        finally {
            this._isPrefetchOutstanding.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addInputStream(InputStream inputStream) {
        Object object = this._lockInputStreamsAndReaders;
        synchronized (object) {
            if (this._inputStreams == null) {
                this._inputStreams = new ArrayList<InputStream>();
            }
            this._inputStreams.add(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeInputStream(InputStream inputStream) {
        Object object = this._lockInputStreamsAndReaders;
        synchronized (object) {
            if (this._inputStreams == null) {
                return;
            }
            this._inputStreams.remove(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addReader(Reader reader) {
        Object object = this._lockInputStreamsAndReaders;
        synchronized (object) {
            if (this._readers == null) {
                this._readers = new ArrayList<Reader>();
            }
            this._readers.add(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeReader(Reader reader) {
        Object object = this._lockInputStreamsAndReaders;
        synchronized (object) {
            if (this._readers == null) {
                return;
            }
            this._readers.remove(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _closeInputStreamsAndReaders() {
        ArrayList<Reader> readers;
        ArrayList<InputStream> inputStreams;
        Iterator iterator = this._lockInputStreamsAndReaders;
        synchronized (iterator) {
            inputStreams = this._inputStreams != null ? new ArrayList<InputStream>(this._inputStreams) : Collections.emptyList();
            readers = this._readers != null ? new ArrayList<Reader>(this._readers) : Collections.emptyList();
        }
        for (InputStream inputStream : inputStreams) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            continue;
            finally {
                this._removeInputStream(inputStream);
            }
        }
        for (Reader reader : readers) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            continue;
            finally {
                this._removeReader(reader);
            }
        }
    }

    private void _addAppLob(AbstractGetval appLob) {
        if (this._isClosed()) {
            return;
        }
        if (appLob != null) {
            appLob.addAppLob();
        }
    }

    public FetchInfo getFetchInfo() {
        return this._fetchInfo;
    }

    public int getUsedFetchSize() {
        return this._getUsedFetchSize();
    }

    public boolean isPrefetchAllowed() {
        return this._isPrefetchAllowed;
    }

    public boolean isPrefetchOutstanding() {
        return this._isPrefetchAllowed ? this._isPrefetchOutstanding.get() : false;
    }

    public synchronized SQLException getPrefetchedCachedException() {
        return this._prefetchSendCachedException;
    }

    public synchronized int getPrefetchRequestCount() {
        return this._prefetchRequestCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _getAppLobCount() {
        if (this._lockAppLobs == null) {
            return 0;
        }
        Object object = this._lockAppLobs;
        synchronized (object) {
            return this._appLobs != null ? this._appLobs.size() : 0;
        }
    }

    protected static enum InitNextResult {
        FALSE,
        TRUE,
        RESULT_OF_FETCH_FIRST,
        RESULT_OF_FETCH_NEXT;

    }

    private static enum Position {
        BEFORE_FIRST,
        INSIDE,
        AFTER_LAST,
        NOT_AVAILABLE;

    }
}

