/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.APIMetrics;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.CallableStatementSapDB;
import com.sap.db.jdbc.ClientInfo;
import com.sap.db.jdbc.ClientKeyPair;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ColumnReencryptInfo;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.DatabaseMetaDataSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.HanaCallableStatement;
import com.sap.db.jdbc.HanaCallableStatementFinalize;
import com.sap.db.jdbc.HanaCallableStatementPhantom;
import com.sap.db.jdbc.HanaDatabaseMetaData;
import com.sap.db.jdbc.HanaPreparedStatement;
import com.sap.db.jdbc.HanaPreparedStatementFinalize;
import com.sap.db.jdbc.HanaPreparedStatementPhantom;
import com.sap.db.jdbc.HanaSavepoint;
import com.sap.db.jdbc.HanaStatement;
import com.sap.db.jdbc.InternalCallableStatementSapDB;
import com.sap.db.jdbc.InternalPreparedStatementSapDB;
import com.sap.db.jdbc.InternalResultSetSapDB;
import com.sap.db.jdbc.InternalStatementSapDB;
import com.sap.db.jdbc.KeyCache;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PassportListener;
import com.sap.db.jdbc.PreferredAddress;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.SAPPassport;
import com.sap.db.jdbc.SavepointSapDB;
import com.sap.db.jdbc.ServerKPIs;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.SessionVariables;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.StatementCache;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.SystemInfo;
import com.sap.db.jdbc.Topologies;
import com.sap.db.jdbc.Transaction;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.exceptions.ConnectionException;
import com.sap.db.jdbc.exceptions.InternalConnectException;
import com.sap.db.jdbc.exceptions.InternalFallbackHintRoutedException;
import com.sap.db.jdbc.exceptions.InternalFallbackSecondaryException;
import com.sap.db.jdbc.exceptions.InternalForceRerouteException;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.ActiveActiveProtocolVersion;
import com.sap.db.jdbc.packet.ClientSideEncryptionVersion;
import com.sap.db.jdbc.packet.DistributionMode;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.jdbc.packet.HPartInfo;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.HSegmentInfo;
import com.sap.db.jdbc.packet.MessageType;
import com.sap.db.jdbc.packet.RedirectionType;
import com.sap.db.jdbc.packet.StatementContextFlag;
import com.sap.db.jdbc.packet.StatementContextOption;
import com.sap.db.jdbc.packet.TransactionFlag;
import com.sap.db.jdbc.packet.TransactionState;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbcext.XAExceptionSAP;
import com.sap.db.jdbcext.wrapper.Connection;
import com.sap.db.util.BackOffTimer;
import com.sap.db.util.Base64Utils;
import com.sap.db.util.CSEBlockCipher;
import com.sap.db.util.CSECipherFactory;
import com.sap.db.util.CSEStreamCipher;
import com.sap.db.util.Dbg;
import com.sap.db.util.DbgInstanceCount;
import com.sap.db.util.FileUtils;
import com.sap.db.util.HexUtils;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.StringUtils;
import com.sap.db.util.UUIDUtils;
import com.sap.db.util.UniqueID;
import com.sap.db.util.security.AbstractAuthenticationManager;
import com.sap.db.util.security.AuthenticationManager;
import com.sap.db.util.security.AuthenticationMethodType;
import com.sap.db.util.security.NativeAuthenticationManagerImpl;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

@ThreadSafe
public abstract class ConnectionSapDB
extends WrapperDummy
implements java.sql.Connection {
    protected static final String FALLBACK_FLAG = "FallbackFlag";
    protected final Tracer _tracer;
    protected final Properties _info;
    protected final ConnectionProperties _connectionProperties;
    protected final List<PreferredAddress> _preferredAddresses;
    protected final AtomicBoolean _isClosed;
    protected final AtomicReference<PassportListener> _passportListener;
    private final SessionPool _sessionPool;
    private final UniqueID _uniqueID;
    private final boolean _emptyTimestampIsNull;
    private final boolean _inexactDoubleToDecimalConversion;
    private final boolean _timeZonePerObject;
    private final boolean _splitBatchCommands;
    private final boolean _refCursors;
    private final int _maxLazyDroppedStatements;
    private final boolean _routeDirectExecute;
    private final boolean _deferredPrepare;
    private final boolean _transactionalLobs;
    private final int _transactionalLobsVersion;
    private final long _hintRoutingBackoffMin;
    private final long _hintRoutingBackoffMax;
    private final long _statementRoutingBackoffMin;
    private final long _statementRoutingBackoffMax;
    private final String _cseKeyStorePassword;
    private final int _packetSize;
    private final AtomicInteger _sentBytes;
    private final AtomicInteger _receivedBytes;
    private final AtomicReference<StatementSapDB> _executingStatement;
    private final AtomicReference<StatementSapDB> _alterTableStatement;
    private final AtomicBoolean _isInReconnect;
    private final AtomicBoolean _cancelReconnect;
    private final AtomicInteger _serverReconnectWaitTimeout;
    private final AtomicReference<String> _forceRouteSiteID;
    private final AtomicBoolean _supportIdlePing;
    private final AtomicBoolean _supportIdlePingDuringRequest;
    @GuardedBy(value="itself")
    private final Set<StatementSapDB> _statements = Collections.newSetFromMap(new WeakHashMap());
    @GuardedBy(value="itself")
    private final Set<PreparedStatementSapDB> _preparedStatementsClosePending = new HashSet<PreparedStatementSapDB>();
    @GuardedBy(value="itself")
    private final Set<ResultSetSapDB> _resultSetsClosePending = new HashSet<ResultSetSapDB>();
    @GuardedBy(value="this")
    private final Map<ResultSetSapDB, Object> _prefetchedCachedReplyMap;
    @GuardedBy(value="this")
    private final Map<Session, List<ParseID>> _queuedForLazyDrop = new WeakHashMap<Session, List<ParseID>>();
    @GuardedBy(value="this")
    private final HashMap<SiteTypeVolumeID, BackOffTimer> _statementRoutingBackOffTimers = new HashMap();
    @GuardedBy(value="this")
    private final Deque<HRequestPacket> _packetPool;
    @GuardedBy(value="this")
    private final SessionVariables _sessionVariables;
    @GuardedBy(value="this")
    private final ClientInfo _clientInfo;
    @GuardedBy(value="this")
    private final Transaction _transaction;
    @GuardedBy(value="this")
    private final StatementCache _statementCache;
    @GuardedBy(value="this")
    private Map<String, Class<?>> _typeMap;
    @GuardedBy(value="this")
    private int _resultSetHoldability;
    @GuardedBy(value="this")
    private boolean _isReadOnly;
    @GuardedBy(value="this")
    private int _isolationLevel;
    @GuardedBy(value="this")
    private String _currentSchema;
    @GuardedBy(value="this")
    private boolean _isIgnoringTopology;
    @GuardedBy(value="this")
    private DistributionMode _distributionMode;
    @GuardedBy(value="this")
    private int _networkTimeout;
    @GuardedBy(value="this")
    private byte[] _cookie;
    @GuardedBy(value="this")
    private Subject _authenticatedSubject;
    @GuardedBy(value="this")
    private EngineFeatures _engineFeatures;
    @GuardedBy(value="this")
    private boolean _isReadOnlyModeTransactionFlagSent;
    @GuardedBy(value="this")
    private SQLWarning _warnings;
    @GuardedBy(value="this")
    private DatabaseMetaDataSapDB _databaseMetaData;
    @GuardedBy(value="this")
    private String _defaultSchema;
    @GuardedBy(value="this")
    private int _rollbackCount;
    @GuardedBy(value="this")
    private int _savepointCount;
    @GuardedBy(value="this")
    private boolean _savedAutoCommitForGlobalTransaction;
    @GuardedBy(value="this")
    private BackOffTimer _backOffTimer;
    @GuardedBy(value="this")
    private byte[] _statementContext;
    @GuardedBy(value="this")
    private ResultSetSapDB _outstandingPrefetchResultSet;
    @GuardedBy(value="this")
    private Session _outstandingPrefetchSession;
    @GuardedBy(value="this")
    private SAPPassport _outstandingPrefetchPassport;
    @GuardedBy(value="this")
    private int _outstandingPrefetchPassportConnectionCounter;
    @GuardedBy(value="this")
    private Set<String> _cseKeyIDs;
    @GuardedBy(value="this")
    private boolean _isPropogatingIsolationLevelSetting;
    @GuardedBy(value="this")
    private boolean _isPropogatingDDLAutoCommitSetting;
    @GuardedBy(value="this")
    private TimerTask _heartbeatTask;
    @GuardedBy(value="this")
    private RedirectionType _redirectionType;
    @GuardedBy(value="this")
    private String _redirectedHost;
    @GuardedBy(value="this")
    private int _redirectedPort;
    @GuardedBy(value="this")
    private String _endPointHost;
    @GuardedBy(value="this")
    private int _endPointPort;
    private final String _endPointList;
    @GuardedBy(value="this")
    private SAPPassport _passport;
    @GuardedBy(value="this")
    private UUID _passportConnectionUUID;
    @GuardedBy(value="this")
    private int _passportConnectionCounter;
    @GuardedBy(value="this")
    private ServerKPIs _passportServerKPIs;
    @GuardedBy(value="this")
    private final List<SendReceiveExceptionAction> _sendReceiveExceptionActions;
    private final AtomicInteger _secondaryConnectionAttemptCount;
    private final AtomicReference<String> _lastAuthenticationMethodName;

    public static ConnectionSapDB getConnectionSapDB(java.sql.Connection connection) {
        java.sql.Connection c = connection;
        while (!(c instanceof ConnectionSapDB)) {
            if (c instanceof Connection) {
                c = ((Connection)c).getPhysicalConnection();
                continue;
            }
            return null;
        }
        return (ConnectionSapDB)c;
    }

    public static int getJdbcIsolationLevelForHanaIsolationLevel(int hanaIsolationLevel) throws SQLException {
        switch (hanaIsolationLevel) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
        }
        throw SQLExceptionSapDB.newInstance("error.invalid.transactionisolation", String.valueOf(hanaIsolationLevel));
    }

    public static String getSQLForJdbcIsolationLevel(int jdbcIsolationLevel) throws SQLException {
        switch (jdbcIsolationLevel) {
            case 0: 
            case 1: {
                return "READ UNCOMMITTED";
            }
            case 2: {
                return "READ COMMITTED";
            }
            case 4: {
                return "REPEATABLE READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        throw SQLExceptionSapDB.newInstance("error.invalid.transactionisolation", String.valueOf(jdbcIsolationLevel));
    }

    protected ConnectionSapDB(Tracer tracer, Properties info, ConnectionProperties connectionProperties, PassportListener passportListener, List<PreferredAddress> preferredAddresses) {
        this._tracer = tracer;
        this._info = info;
        this._connectionProperties = new ConnectionProperties(connectionProperties);
        this._preferredAddresses = Collections.unmodifiableList(preferredAddresses);
        this._isClosed = new AtomicBoolean();
        this._passportListener = new AtomicReference();
        this._sessionPool = new SessionPool(this);
        this._uniqueID = new UniqueID();
        this._emptyTimestampIsNull = this._connectionProperties.getBooleanProperty(ConnectionProperty.EMPTY_TIMESTAMP_IS_NULL);
        this._inexactDoubleToDecimalConversion = this._connectionProperties.getBooleanProperty(ConnectionProperty.INEXACT_DOUBLE_TO_DECIMAL_CONVERSION);
        this._timeZonePerObject = this._connectionProperties.getBooleanProperty(ConnectionProperty.TIME_ZONE_PER_OBJECT);
        this._splitBatchCommands = this._connectionProperties.getBooleanProperty(ConnectionProperty.SPLIT_BATCH_COMMANDS);
        this._refCursors = this._connectionProperties.getBooleanProperty(ConnectionProperty.REF_CURSORS);
        this._maxLazyDroppedStatements = this._connectionProperties.getIntProperty(ConnectionProperty.MAX_LAZY_DROPPED_STATEMENTS);
        this._routeDirectExecute = this._connectionProperties.getBooleanProperty(ConnectionProperty.ROUTE_DIRECT_EXECUTE);
        this._deferredPrepare = this._connectionProperties.getBooleanProperty(ConnectionProperty.DEFERRED_PREPARE);
        this._transactionalLobs = this._connectionProperties.getBooleanProperty(ConnectionProperty.TRANSACTIONAL_LOBS);
        this._transactionalLobsVersion = this._connectionProperties.getIntProperty(ConnectionProperty.TRANSACTIONAL_LOBS_VERSION);
        this._hintRoutingBackoffMin = this._connectionProperties.getLongProperty(ConnectionProperty.HINT_ROUTING_BACKOFF_MIN);
        this._hintRoutingBackoffMax = this._connectionProperties.getLongProperty(ConnectionProperty.HINT_ROUTING_BACKOFF_MAX);
        this._statementRoutingBackoffMin = this._connectionProperties.getLongProperty(ConnectionProperty.STATEMENT_ROUTING_BACKOFF_MIN);
        this._statementRoutingBackoffMax = this._connectionProperties.getLongProperty(ConnectionProperty.STATEMENT_ROUTING_BACKOFF_MAX);
        this._cseKeyStorePassword = this._connectionProperties.getProperty(ConnectionProperty.CSE_KEY_STORE_PASSWD);
        this._packetSize = this._connectionProperties.getIntProperty(ConnectionProperty.PACKET_SIZE);
        this._sentBytes = new AtomicInteger();
        this._receivedBytes = new AtomicInteger();
        this._executingStatement = new AtomicReference();
        this._alterTableStatement = new AtomicReference();
        this._isInReconnect = new AtomicBoolean();
        this._cancelReconnect = new AtomicBoolean();
        this._serverReconnectWaitTimeout = new AtomicInteger(-1);
        this._forceRouteSiteID = new AtomicReference();
        this._supportIdlePing = new AtomicBoolean();
        this._supportIdlePingDuringRequest = new AtomicBoolean();
        this._packetPool = new ArrayDeque<HRequestPacket>();
        this._sessionVariables = new SessionVariables();
        this._clientInfo = new ClientInfo();
        this._transaction = new Transaction(this);
        this._statementCache = StatementCache.getInstance(this);
        this._typeMap = new TreeMap();
        this._resultSetHoldability = ConnectionSapDB._getResultSetHoldabilityForConnectionPropertyValue(this._connectionProperties.getProperty(ConnectionProperty.CURSOR_HOLDABILITY_TYPE));
        this._transaction.setAutoCommit(this._connectionProperties.getBooleanProperty(ConnectionProperty.AUTO_COMMIT));
        this._isReadOnly = this._connectionProperties.getBooleanProperty(ConnectionProperty.READ_ONLY);
        this._isolationLevel = ConnectionSapDB._getJdbcIsolationLevelForConnectionPropertyValue(this._connectionProperties.getProperty(ConnectionProperty.ISOLATION));
        this._currentSchema = this._connectionProperties.getProperty(ConnectionProperty.CURRENT_SCHEMA);
        this._isIgnoringTopology = this._connectionProperties.getBooleanProperty(ConnectionProperty.IGNORE_TOPOLOGY);
        if (this._isIgnoringTopology) {
            this._distributionMode = DistributionMode.Off;
        } else {
            this._distributionMode = DistributionMode.decode(this._connectionProperties.getProperty(ConnectionProperty.DISTRIBUTION));
            if (this._deferredPrepare) {
                this._distributionMode = DistributionMode.withoutStatementDistribution(this._distributionMode);
            }
        }
        this._networkTimeout = this._connectionProperties.getIntProperty(ConnectionProperty.COMMUNICATION_TIMEOUT);
        String databaseName = this._connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME);
        this._redirectionType = databaseName != null && !databaseName.isEmpty() ? RedirectionType.DBNameBased : (this._connectionProperties.getBooleanProperty(ConnectionProperty.DISABLE_CLOUD_REDIRECT) ? RedirectionType.Disabled : RedirectionType.None);
        StringBuilder builder = new StringBuilder(128);
        for (PreferredAddress preferredAddress : this._preferredAddresses) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(preferredAddress.toString());
        }
        this._endPointList = builder.toString();
        this._prefetchedCachedReplyMap = new HashMap<ResultSetSapDB, Object>();
        if (this._connectionProperties.hasProperty(ConnectionProperty.CSE_KEY_STORE_PASSWD)) {
            KeyCache.setKeyStoreFilename(this._connectionProperties.getProperty(ConnectionProperty.CSE_KEY_STORE_FILENAME));
        }
        this._sendReceiveExceptionActions = this._connectionProperties.getBooleanProperty(ConnectionProperty._TEST_TRACK_SEND_RECEIVE_EXCEPTION_ACTIONS) ? new ArrayList() : null;
        this._secondaryConnectionAttemptCount = this._connectionProperties.getBooleanProperty(ConnectionProperty._TEST_TRACK_SECONDARY_SESSION_ATTEMPTS) ? new AtomicInteger() : null;
        this._lastAuthenticationMethodName = new AtomicReference();
        String passport = this._connectionProperties.getProperty(ConnectionProperty.PASSPORT);
        String passportComponentName = this._connectionProperties.getProperty(ConnectionProperty.PASSPORT_COMPONENT_NAME);
        if (passport != null && !passport.isEmpty() && passportComponentName != null && !passportComponentName.isEmpty()) {
            this.setPassport(passport, passportComponentName, passportListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public Statement createStatement() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("createStatement") : null;
        try {
            StatementSapDB result;
            if (on) {
                this._tracer.printCall(this, "createStatement", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._createStatement(1003, 1007, this._getHoldability(), null, 0);
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            StatementSapDB statementSapDB = result;
            return statementSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            PreparedStatementSapDB result;
            if (on) {
                this._tracer.printCall(this, "prepareStatement", sql);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                result = this._prepareStatement(sql, 1003, 1007, this._getHoldability(), null, 0, this._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE);
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            PreparedStatementSapDB preparedStatementSapDB = result;
            return preparedStatementSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public CallableStatement prepareCall(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("prepareCall") : null;
        try {
            CallableStatementSapDB result;
            if (on) {
                this._tracer.printCall(this, "prepareCall", sql);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                result = this._prepareCall(sql, 1003, 1007, this._getHoldability(), null, 0, this._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE);
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            CallableStatementSapDB callableStatementSapDB = result;
            return callableStatementSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized String nativeSQL(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("nativeSQL") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "nativeSQL", sql);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = sql;
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean getAutoCommit() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getAutoCommit") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "getAutoCommit", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this.isAutoCommit();
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("setAutoCommit") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAutoCommit", autoCommit);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                this._setAutoCommit(autoCommit);
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized void commit() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("commit") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "commit", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                this._commit();
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized void rollback() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("rollback") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "rollback", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                this._rollback();
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean isClosed() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("isClosed") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isClosed", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._isClosed();
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public void close() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("close") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "close", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                this._close();
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMetaData") : null;
        try {
            DatabaseMetaData result;
            if (on) {
                this._tracer.printCall(this, "getMetaData", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._getMetaData();
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            DatabaseMetaData databaseMetaData = result;
            return databaseMetaData;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean isReadOnly() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("isReadOnly") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isReadOnly", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._isReadOnly;
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized void setReadOnly(boolean isReadOnly) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("setReadOnly") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setReadOnly", isReadOnly);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                this._setReadOnly(isReadOnly, false);
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized String getCatalog() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getCatalog") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getCatalog", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = null;
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setCatalog(String catalog) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("setCatalog") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCatalog", catalog);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getTransactionIsolation() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getTransactionIsolation") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getTransactionIsolation", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._isolationLevel;
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("setTransactionIsolation") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTransactionIsolation", level);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                this._setTransactionIsolation(level);
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized SQLWarning getWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getWarnings") : null;
        try {
            SQLWarning result;
            if (on) {
                this._tracer.printCall(this, "getWarnings", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._warnings;
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            SQLWarning sQLWarning = result;
            return sQLWarning;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void clearWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("clearWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearWarnings", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                this._warnings = null;
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("createStatement") : null;
        try {
            StatementSapDB result;
            if (on) {
                this._tracer.printCall(this, "createStatement", resultSetType, resultSetConcurrency);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._createStatement(resultSetType, resultSetConcurrency, this._getHoldability(), null, 0);
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            StatementSapDB statementSapDB = result;
            return statementSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            PreparedStatementSapDB result;
            if (on) {
                this._tracer.printCall(this, "prepareStatement", sql, resultSetType, resultSetConcurrency);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                result = this._prepareStatement(sql, resultSetType, resultSetConcurrency, this._getHoldability(), null, 0, this._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE);
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            PreparedStatementSapDB preparedStatementSapDB = result;
            return preparedStatementSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("prepareCall") : null;
        try {
            CallableStatementSapDB result;
            if (on) {
                this._tracer.printCall(this, "prepareCall", sql, resultSetType, resultSetConcurrency);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                result = this._prepareCall(sql, resultSetType, resultSetConcurrency, this._getHoldability(), null, 0, this._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE);
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            CallableStatementSapDB callableStatementSapDB = result;
            return callableStatementSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getTypeMap") : null;
        try {
            Map<String, Class<?>> result;
            if (on) {
                this._tracer.printCall(this, "getTypeMap", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = Collections.unmodifiableMap(this._typeMap);
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Map<String, Class<?>> map = result;
            return map;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setTypeMap(Map<String, Class<?>> typeMap) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("setTypeMap") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTypeMap", typeMap);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                this._typeMap = typeMap != null ? new TreeMap(typeMap) : new TreeMap();
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("createStatement") : null;
        try {
            StatementSapDB result;
            if (on) {
                this._tracer.printCall(this, "createStatement", resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._createStatement(resultSetType, resultSetConcurrency, resultSetHoldability, null, 0);
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            StatementSapDB statementSapDB = result;
            return statementSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            PreparedStatementSapDB result;
            if (on) {
                this._tracer.printCall(this, "prepareStatement", sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                result = this._prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, null, 0, this._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE);
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            PreparedStatementSapDB preparedStatementSapDB = result;
            return preparedStatementSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("prepareCall") : null;
        try {
            CallableStatementSapDB result;
            if (on) {
                this._tracer.printCall(this, "prepareCall", sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                result = this._prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability, null, 0, this._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE);
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            CallableStatementSapDB callableStatementSapDB = result;
            return callableStatementSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            PreparedStatementSapDB result;
            if (on) {
                this._tracer.printCall(this, "prepareStatement", sql, autoGeneratedKeys);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                if (autoGeneratedKeys != 2) {
                    throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "autoGeneratedKeys", "NO_GENERATED_KEYS");
                }
                result = this._prepareStatement(sql, 1003, 1007, this._getHoldability(), null, 0, this._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE);
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            PreparedStatementSapDB preparedStatementSapDB = result;
            return preparedStatementSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "prepareStatement", sql, columnIndexes);
                }
                try {
                    if (aon) {
                        this.apiStart();
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("prepareStatement( String, int[] )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("prepareStatement") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "prepareStatement", sql, columnNames);
                }
                try {
                    if (aon) {
                        this.apiStart();
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("prepareStatement( String, String[] )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getHoldability() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getHoldability") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getHoldability", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._resultSetHoldability;
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setHoldability(int holdability) throws SQLException {
        on = this._tracer.on();
        pon = this._tracer.pon();
        aon = on != false ? this._tracer.aon() : false;
        r = pon != false ? this._newTraceRecord("setHoldability") : null;
        try {
            block22: {
                if (on) {
                    this._tracer.printCall(this, "setHoldability", new Object[]{holdability});
                }
                try {
                    if (aon) {
                        this.apiStart();
                    }
                    if (this._engineFeatures.holdCursorOverRollbackSupported()) {
                        switch (holdability) {
                            case 1: 
                            case 2: 
                            case 1000001: 
                            case 1000002: {
                                this._resultSetHoldability = holdability;
                                break block22;
                            }
                            default: {
                                throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", new String[]{"holdability", "CLOSE_CURSORS_AT_COMMIT, HOLD_CURSORS_OVER_COMMIT, com.sap.db.jdbc.ResultSetSapDB.HOLD_CURSORS_OVER_ROLLBACK, com.sap.db.jdbc.ResultSetSapDB.HOLD_CURSORS_OVER_COMMIT_AND_ROLLBACK"});
                            }
                        }
                    }
                    switch (holdability) {
                        case 1: 
                        case 2: {
                            this._resultSetHoldability = holdability;
                            ** break;
lbl22:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", new String[]{"holdability", "CLOSE_CURSORS_AT_COMMIT, HOLD_CURSORS_OVER_COMMIT,"});
                        }
                    }
                }
                finally {
                    if (aon) {
                        this.apiFinish();
                    }
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized Savepoint setSavepoint() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("setSavepoint") : null;
        try {
            Savepoint result;
            block16: {
                if (on) {
                    this._tracer.printCall(this, "setSavepoint", new Object[0]);
                }
                try {
                    if (aon || pl != null) {
                        this.apiStart();
                    }
                    if (this._engineFeatures.supportSavepointSQL()) {
                        result = this._setSavepoint(null);
                        break block16;
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("setSavepoint()");
                }
                finally {
                    if (aon || pl != null) {
                        this.apiFinish(aon, pl);
                    }
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Savepoint savepoint = result;
            return savepoint;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("setSavepoint") : null;
        try {
            Savepoint result;
            block16: {
                if (on) {
                    this._tracer.printCall(this, "setSavepoint", name);
                }
                try {
                    if (aon || pl != null) {
                        this.apiStart();
                    }
                    if (this._engineFeatures.supportSavepointSQL()) {
                        result = this._setSavepoint(name);
                        break block16;
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("setSavepoint( String )");
                }
                finally {
                    if (aon || pl != null) {
                        this.apiFinish(aon, pl);
                    }
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Savepoint savepoint = result;
            return savepoint;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("rollback") : null;
        try {
            block16: {
                if (on) {
                    this._tracer.printCall(this, "rollback", savepoint);
                }
                try {
                    if (aon || pl != null) {
                        this.apiStart();
                    }
                    if (this._engineFeatures.supportSavepointSQL()) {
                        this._rollbackToSavepoint(savepoint);
                        break block16;
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("rollback( Savepoint )");
                }
                finally {
                    if (aon || pl != null) {
                        this.apiFinish(aon, pl);
                    }
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("releaseSavepoint") : null;
        try {
            block16: {
                if (on) {
                    this._tracer.printCall(this, "releaseSavepoint", savepoint);
                }
                try {
                    if (aon || pl != null) {
                        this.apiStart();
                    }
                    if (this._engineFeatures.supportSavepointSQL()) {
                        this._releaseSavepoint(savepoint);
                        break block16;
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("releaseSavepoint( Savepoint )");
                }
                finally {
                    if (aon || pl != null) {
                        this.apiFinish(aon, pl);
                    }
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Clob createClob() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("createClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createClob", new Object[0]);
                }
                try {
                    if (aon) {
                        this.apiStart();
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("createClob()");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Blob createBlob() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("createBlob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createBlob", new Object[0]);
                }
                try {
                    if (aon) {
                        this.apiStart();
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("createBlob()");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized NClob createNClob() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("createNClob") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createNClob", new Object[0]);
                }
                try {
                    if (aon) {
                        this.apiStart();
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("createNClob()");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized SQLXML createSQLXML() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("createSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createSQLXML", new Object[0]);
                }
                try {
                    if (aon) {
                        this.apiStart();
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("createSQLXML()");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized boolean isValid(int timeout) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("isValid") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isValid", timeout);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                result = this._isValid(timeout);
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Properties getClientInfo() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getClientInfo") : null;
        try {
            Properties result;
            if (on) {
                this._tracer.printCall(this, "getClientInfo", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._getClientInfo();
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Properties properties = result;
            return properties;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized String getClientInfo(String key) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getClientInfo") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getClientInfo", key);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._getClientInfo(key);
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setClientInfo(Properties properties) throws SQLClientInfoException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("setClientInfo") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClientInfo", properties);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                this._setClientInfo(properties);
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setClientInfo(String key, String value) throws SQLClientInfoException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("setClientInfo") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClientInfo", key, value);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                this._setClientInfo(key, value);
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("createArrayOf") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createArrayOf", typeName, elements);
                }
                try {
                    if (aon) {
                        this.apiStart();
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("createArrayOf( String, Object[] )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("createStruct") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "createStruct", typeName, attributes);
                }
                try {
                    if (aon) {
                        this.apiStart();
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("createStruct( String, Object[] )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized String getSchema() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getSchema") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getSchema", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._currentSchema;
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized void setSchema(String schema) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("setSchema") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setSchema", schema);
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                this._setCurrentSchema(schema);
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void abort(Executor executor) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("abort") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "abort", executor);
                }
                try {
                    if (aon) {
                        this.apiStart();
                    }
                    throw ConnectionSapDB._getUnsupportedMethodException("abort( Executor )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getNetworkTimeout() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getNetworkTimeout") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getNetworkTimeout", new Object[0]);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                result = this._getNetworkTimeout();
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("setNetworkTimeout") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNetworkTimeout", executor, milliseconds);
            }
            try {
                if (aon) {
                    this.apiStart();
                }
                this._setNetworkTimeout(milliseconds);
            }
            finally {
                if (aon) {
                    this.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    public String toString() {
        return this.getTraceString(true);
    }

    public static String getTraceString(String className, int hashCode, boolean isFullString, boolean isClosed, int anchorConnectionID) {
        String s = className + "@" + Integer.toHexString(hashCode);
        if (!isFullString) {
            return s;
        }
        if (isClosed) {
            return s + "[closed]";
        }
        return s + "[ID:" + anchorConnectionID + "]";
    }

    public String getTraceString(boolean isFullString) {
        return ConnectionSapDB.getTraceString(this.getClass().getName(), this.hashCode(), isFullString, this._isClosed(), this.getAnchorConnectionID());
    }

    public Tracer getTracer() {
        return this._tracer;
    }

    public SessionPool getSessionPool() {
        return this._sessionPool;
    }

    public int getAnchorConnectionID() {
        return Driver.getAnchorConnID(this);
    }

    public int getPrimaryConnectionID() {
        return Driver.getPrimaryConnID(this);
    }

    public ConnectionProperties getConnectionProperties() {
        return this._connectionProperties;
    }

    public String getConnectionProperty(ConnectionProperty connectionProperty) {
        return this._connectionProperties.getProperty(connectionProperty);
    }

    public boolean getBooleanConnectionProperty(ConnectionProperty connectionProperty) {
        return this._connectionProperties.getBooleanProperty(connectionProperty);
    }

    public int getIntConnectionProperty(ConnectionProperty connectionProperty) {
        return this._connectionProperties.getIntProperty(connectionProperty);
    }

    public void setConnectionProperty(ConnectionProperty connectionProperty, String value) {
        this._connectionProperties.setProperty(connectionProperty, value);
    }

    public boolean emptyTimestampIsNull() {
        return this._emptyTimestampIsNull;
    }

    public boolean inexactDoubleToDecimalConversion() {
        return this._inexactDoubleToDecimalConversion;
    }

    public boolean timeZonePerObject() {
        return this._timeZonePerObject;
    }

    public boolean splitBatchCommands() {
        return this._splitBatchCommands;
    }

    public boolean refCursors() {
        return this._refCursors;
    }

    public boolean getTransactionalLobs() {
        return this._transactionalLobs;
    }

    public int getTransactionalLobsVersion() {
        return this._transactionalLobsVersion;
    }

    public int getPacketSize() {
        return this._packetSize;
    }

    public int getSentBytes() {
        return this._sentBytes.get();
    }

    public int getReceivedBytes() {
        return this._receivedBytes.get();
    }

    public boolean isReconnecting() {
        return this._isInReconnect.get();
    }

    public boolean supportIdlePing() {
        return this._supportIdlePing.get();
    }

    public boolean supportIdlePingDuringRequest() {
        return this._supportIdlePingDuringRequest.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<StatementSapDB> getStatements() {
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            return new HashSet<StatementSapDB>(this._statements);
        }
    }

    public synchronized boolean queueForLazyDrop(Session session, ParseID parseID) {
        if (!this._engineFeatures.supportDropStatementIDPart() || this._maxLazyDroppedStatements <= 0) {
            return false;
        }
        List<ParseID> parseIDs = this._queuedForLazyDrop.get(session);
        if (parseIDs != null && parseIDs.size() >= this._maxLazyDroppedStatements) {
            return false;
        }
        if (parseIDs == null) {
            parseIDs = new ArrayList<ParseID>();
            this._queuedForLazyDrop.put(session, parseIDs);
        }
        parseIDs.add(parseID);
        if (this._tracer.on()) {
            this._tracer.printStatementQueuedForLazyDrop(parseID);
        }
        return true;
    }

    public synchronized List<ParseID> dequeueForLazyDrop(Session session, ParseID parseID) {
        if (!this._engineFeatures.supportDropStatementIDPart() || this._maxLazyDroppedStatements <= 0) {
            return null;
        }
        List<ParseID> parseIDs = this._queuedForLazyDrop.remove(session);
        if (parseIDs == null) {
            return null;
        }
        if (parseID != null && parseIDs.contains(parseID)) {
            ArrayList<ParseID> reenqueue = new ArrayList<ParseID>();
            reenqueue.add(parseID);
            this._queuedForLazyDrop.put(session, reenqueue);
            parseIDs.remove(parseID);
            if (parseIDs.isEmpty()) {
                return null;
            }
        }
        if (this._tracer.on()) {
            this._tracer.printStatementsDequeuedForLazyDrop(parseIDs);
        }
        return parseIDs;
    }

    public synchronized boolean isAutoCommit() {
        return this._transaction.getAutoCommit();
    }

    public synchronized boolean isDDLAutoCommit() {
        return this._transaction.getDDLAutoCommit();
    }

    public synchronized TransactionState getTransactionState() {
        return this._transaction.getTransactionState();
    }

    public synchronized boolean isIgnoringTopology() {
        return this._isIgnoringTopology;
    }

    public synchronized DistributionMode getDistributionMode() {
        return this._distributionMode;
    }

    public synchronized byte[] getCookie() {
        return this._cookie;
    }

    public synchronized void setCookie(byte[] cookie) {
        this._cookie = cookie;
    }

    public synchronized Subject getAuthenticatedSubject() {
        return this._authenticatedSubject;
    }

    public synchronized void setAuthenticatedSubject(Subject authenticatedSubject) {
        this._authenticatedSubject = authenticatedSubject;
    }

    public synchronized String getTermID() {
        int processID = Driver.getProcessID();
        return processID == 0 ? "java@" + Integer.toHexString(this.hashCode()) : processID + "@" + Driver.getFullComputerName();
    }

    public synchronized EngineFeatures getEngineFeatures() {
        return this._engineFeatures;
    }

    public synchronized byte[] getStatementContext() {
        return this._statementContext;
    }

    public synchronized RedirectionType getRedirectionType() {
        return this._redirectionType;
    }

    public synchronized void setRedirectionType(RedirectionType redirectionType) {
        this._redirectionType = redirectionType;
    }

    public synchronized String getRedirectedHost() {
        return this._redirectedHost;
    }

    public synchronized void setRedirectedHost(String redirectedHost) {
        this._redirectedHost = redirectedHost;
    }

    public synchronized int getRedirectedPort() {
        return this._redirectedPort;
    }

    public synchronized void setRedirectedPort(int redirectedPort) {
        this._redirectedPort = redirectedPort;
    }

    public synchronized String getEndPointHost() {
        return this._endPointHost;
    }

    public synchronized int getEndPointPort() {
        return this._endPointPort;
    }

    public String getEndPointList() {
        return this._endPointList;
    }

    public PassportListener getPassportListener() {
        return this._passportListener.get();
    }

    public synchronized SAPPassport getPassport() {
        return this._passport;
    }

    public synchronized void setPassport(Object inboundObject, String componentName, PassportListener passportListener) {
        boolean hadPassport;
        boolean isInboundObjectByteArray;
        byte[] inboundBytes = null;
        String inboundHexString = null;
        if (inboundObject == null) {
            throw new IllegalArgumentException("passport is null");
        }
        if (inboundObject instanceof byte[]) {
            inboundBytes = (byte[])inboundObject;
            isInboundObjectByteArray = true;
        } else if (inboundObject instanceof String) {
            inboundHexString = (String)inboundObject;
            isInboundObjectByteArray = false;
        } else {
            throw new AssertionError((Object)"passport must be either a byte[] or String");
        }
        boolean bl = hadPassport = this._passport != null;
        if (isInboundObjectByteArray) {
            SAPPassport.validateInbound(inboundBytes);
        } else {
            SAPPassport.validateInbound(inboundHexString);
        }
        byte[] componentNameBytes = SAPPassport.validateComponentName(componentName);
        if (!hadPassport) {
            this._passportConnectionUUID = UUID.randomUUID();
            this._passportConnectionCounter = 1;
        }
        this._passport = isInboundObjectByteArray ? SAPPassport.newInstance(inboundBytes, componentNameBytes, this._passportConnectionUUID) : SAPPassport.newInstance(inboundHexString, componentNameBytes, this._passportConnectionUUID);
        this._passportListener.set(passportListener);
        this._passportServerKPIs = passportListener != null ? new ServerKPIs() : null;
        try {
            this._clientInfo._setProperty("SAP_PASSPORT", null);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            // empty catch block
        }
    }

    public synchronized void clearPassport() {
        boolean hadPassport = this._passport != null;
        this._passport = null;
        this._passportConnectionUUID = null;
        this._passportConnectionCounter = 1;
        this._passportListener.set(null);
        this._passportServerKPIs = null;
        if (hadPassport) {
            try {
                this._setClientInfo("SAP_PASSPORT", "");
            }
            catch (SQLClientInfoException sQLClientInfoException) {
                // empty catch block
            }
        }
    }

    public void apiStart() {
        APIMetrics.getInstance().apiStart();
    }

    public void apiFinish() {
        APIMetrics.getInstance().apiFinish();
    }

    public void apiFinish(boolean aon, PassportListener passportListener) {
        APIMetrics.getInstance().apiFinish(aon, passportListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HReplyPacket exchange(Session session, HRequestPacket requestPacket, StatementSapDB statement, ExchangeFlag ... exchangeFlags) throws SQLException {
        this._assertOpen();
        try {
            this._executingStatement.set(statement);
            this._send(session, requestPacket, exchangeFlags);
            HReplyPacket hReplyPacket = this._receive(session, requestPacket.getMessageType(), statement, requestPacket.getPassport(), requestPacket.getPassportConnectionCounter(), exchangeFlags);
            return hReplyPacket;
        }
        finally {
            this._executingStatement.set(null);
        }
    }

    public synchronized void send(Session session, HRequestPacket requestPacket, StatementSapDB statement, ExchangeFlag ... exchangeFlags) throws SQLException {
        this._assertOpen();
        try {
            this._executingStatement.set(statement);
            this._send(session, requestPacket, exchangeFlags);
        }
        catch (SQLException e) {
            this._executingStatement.set(null);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HReplyPacket receive(Session session, MessageType messageType, StatementSapDB statement, SAPPassport passport, int passportConnectionCounter, ExchangeFlag ... exchangeFlags) throws SQLException {
        this._assertOpen();
        try {
            this._executingStatement.set(statement);
            HReplyPacket hReplyPacket = this._receive(session, messageType, statement, passport, passportConnectionCounter, exchangeFlags);
            return hReplyPacket;
        }
        finally {
            this._executingStatement.set(null);
        }
    }

    public void sendPings() {
        if (this._sessionPool.getAnchorSession() == null) {
            return;
        }
        Collection<Session> sessions = this._sessionPool.getSessions().values();
        for (Session session : sessions) {
            session.sendPing();
        }
    }

    public synchronized void start(Xid xid, int flags) throws XAException {
        try {
            this._assertOpen();
            this._saveAndAlterAutoCommitForGlobalTransaction();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXAStart(this, session, xid, flags);
            this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized void end(Xid xid, int flags) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXAEnd(this, session, xid, flags);
            this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
        finally {
            this._restoreAutoCommitForGlobalTransaction();
        }
    }

    public synchronized int prepare(Xid xid) throws XAException {
        try {
            this._assertOpen();
            this._closeCursorsAtCommit();
            this._closePendingPreparedStatementsAndResultSets(true);
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXAPrepare(this, session, xid);
            HReplyPacket replyPacket = this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
            int returnCode = replyPacket.findXAReturnCode(0);
            this._transaction.clearTransaction(false);
            return returnCode;
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this._assertOpen();
            if (onePhase) {
                this._closeCursorsAtCommit();
                this._closePendingPreparedStatementsAndResultSets(true);
            }
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXACommit(this, session, xid, onePhase);
            this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
            if (onePhase) {
                this._transaction.clearTransaction(false);
            }
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized void rollback(Xid xid) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXARollback(this, session, xid);
            this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
            this._transaction.clearTransaction(false);
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized Xid[] recover(int flag) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXARecover(this, session, flag);
            HReplyPacket replyPacket = this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
            Xid[] xids = replyPacket.findXids(0);
            return xids;
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized void forget(Xid xid) throws XAException {
        try {
            this._assertOpen();
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initXAForget(this, session, xid);
            this.exchange(session, requestPacket, null, new ExchangeFlag[0]);
        }
        catch (SQLException e) {
            throw new XAExceptionSAP(e);
        }
    }

    public synchronized HRequestPacket initAuthenticate(Session session) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initAuthenticate(this);
        return requestPacket;
    }

    public synchronized HRequestPacket initConnect(Session session, AbstractAuthenticationManager authenticationManager, String userName, String passwd, String x509, String userNameFromServer) throws SQLException {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initConnect(this, session, authenticationManager, userName, passwd, x509, userNameFromServer);
        return requestPacket;
    }

    public synchronized HRequestPacket initExecuteDirect(Session session, int resultSetHoldability, int queryTimeout, String sql, String commandInfoSource, int commandInfoLine, boolean isBatch, boolean isForceRoute) throws SQLException {
        if (!isForceRoute) {
            this._transaction.handleTransaction(session, true, false);
        }
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initExecuteDirect(this, session, resultSetHoldability, queryTimeout, sql, commandInfoSource, commandInfoLine, isBatch);
        return requestPacket;
    }

    public synchronized HRequestPacket initPrepare(Session session, int resultSetHoldability, String sql, boolean fullCompileOnPrepare, String commandInfoSource, int commandInfoLine) throws SQLException {
        byte[] transactionID = this._transaction.handleTransaction(session, true, true);
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initPrepare(this, session, resultSetHoldability, sql, fullCompileOnPrepare, transactionID, commandInfoSource, commandInfoLine);
        return requestPacket;
    }

    public synchronized HRequestPacket initPrepareAndExecute(Session session, int resultSetHoldability, int queryTimeout, String sql, String commandInfoSource, int commandInfoLine) throws SQLException {
        return this.initPrepareAndExecute(session, resultSetHoldability, queryTimeout, sql, commandInfoSource, commandInfoLine, this._packetSize);
    }

    public synchronized HRequestPacket initPrepareAndExecute(Session session, int resultSetHoldability, int queryTimeout, String sql, String commandInfoSource, int commandInfoLine, int packetSize) throws SQLException {
        HRequestPacket requestPacket = this._getRequestPacket(session, packetSize);
        requestPacket.initPrepareAndExecute(this, session, resultSetHoldability, queryTimeout, sql, commandInfoSource, commandInfoLine);
        return requestPacket;
    }

    public synchronized HRequestPacket initExecute(Session session, int resultSetHoldability, int queryTimeout, ParseID parseID, boolean isForceRoute, String commandInfoSource, int commandInfoLine) throws SQLException {
        return this.initExecute(session, resultSetHoldability, queryTimeout, parseID, isForceRoute, commandInfoSource, commandInfoLine, this._packetSize);
    }

    public synchronized HRequestPacket initExecute(Session session, int resultSetHoldability, int queryTimeout, ParseID parseID, boolean isForceRoute, String commandInfoSource, int commandInfoLine, int packetSize) throws SQLException {
        byte[] transactionID = isForceRoute ? null : this._transaction.handleTransaction(session, true, true);
        HRequestPacket requestPacket = this._getRequestPacket(session, packetSize);
        requestPacket.initExecute(this, session, resultSetHoldability, queryTimeout, parseID, transactionID, commandInfoSource, commandInfoLine);
        return requestPacket;
    }

    public synchronized HRequestPacket initReadLOB(Session session, byte[] locatorID, long position, int packetSize) throws SQLException {
        this._transaction.handleTransaction(session, true, false);
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initReadLOB(this, session, locatorID, position, packetSize);
        return requestPacket;
    }

    public synchronized HRequestPacket initWriteLOB(Session session, int packetSize) throws SQLException {
        this._transaction.handleTransaction(session, true, false);
        HRequestPacket requestPacket = this._getRequestPacket(session, packetSize);
        requestPacket.initWriteLOB(this, session);
        return requestPacket;
    }

    public synchronized HRequestPacket initFetchNext(Session session, CursorID cursorID, int fetchSize) throws SQLException {
        this._transaction.handleTransaction(session, true, false);
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initFetchNext(this, session, cursorID, fetchSize);
        return requestPacket;
    }

    public synchronized HRequestPacket initDropStatementID(Session session, ParseID parseID) throws SQLException {
        this._transaction.handleTransaction(session, false, false);
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initDropStatementID(this, session, parseID);
        return requestPacket;
    }

    public synchronized HRequestPacket initCloseResultSet(Session session, CursorID cursorID) throws SQLException {
        this._transaction.handleTransaction(session, false, false);
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initCloseResultSet(this, session, cursorID);
        return requestPacket;
    }

    public synchronized HRequestPacket initStartDistributedTransaction(Session session) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initStartDistributedTransaction(this, session);
        return requestPacket;
    }

    public synchronized HRequestPacket initJoinDistributedTransaction(Session session, byte[] transactionID) {
        HRequestPacket requestPacket = this._getRequestPacket(session);
        requestPacket.initJoinDistributedTransaction(this, session, transactionID);
        return requestPacket;
    }

    public synchronized Map<String, String> generateClientInfoTransform(Session session) {
        String key;
        TreeMap<String, String> map = new TreeMap<String, String>();
        Properties connectionProperties = new Properties();
        connectionProperties.putAll((Map<?, ?>)this._sessionVariables._getProperties());
        connectionProperties.putAll((Map<?, ?>)this._clientInfo._getProperties());
        Properties sessionProperties = session.getCurrentSessionVariablesAndClientInfoProperties();
        for (Map.Entry<Object, Object> entry : connectionProperties.entrySet()) {
            key = (String)entry.getKey();
            String desiredValue = (String)entry.getValue();
            String currentValue = sessionProperties.getProperty(key);
            if (currentValue != null && currentValue.equals(desiredValue)) continue;
            map.put(key, desiredValue);
        }
        for (Object object : sessionProperties.keySet()) {
            key = (String)object;
            if (key.equals("_SYS_DEFAULT_SCHEMA") || connectionProperties.containsKey(key)) continue;
            map.put(key, null);
        }
        return map;
    }

    public synchronized void reinitialize(boolean toFactorySettings, boolean factoryAutoCommitSetting) throws SQLException {
        if (!toFactorySettings) {
            this._cacheOnInternalReconnect();
            return;
        }
        if (this._tracer.on()) {
            this._tracer.printConnectionMessage(this, "Returned to pool", new String[0]);
            this._tracer.printConnectionStatistics(this);
        }
        this._closeStatements(true);
        this._transaction.setAutoCommit(factoryAutoCommitSetting);
        this._setReadOnly(false, true);
        this._setTransactionIsolation(2);
        this._setDDLAutoCommit(true);
        this._setCurrentSchema(this._defaultSchema);
        this._typeMap.clear();
        this._resultSetHoldability = 1;
        this._initClientInfoFromProperties(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void returnToPool() throws SQLException {
        String currentSchema;
        String initialSchema;
        boolean initialAutoCommit;
        boolean currentAutoCommit;
        if (this._tracer.on()) {
            this._tracer.printConnectionMessage(this, "Returning to pool", new String[0]);
            this._tracer.printConnectionStatistics(this);
        }
        this._closeStatements(true);
        boolean isAutoCommit = this.getAutoCommit();
        if (!isAutoCommit) {
            this.rollback();
        }
        if ((currentAutoCommit = isAutoCommit) != (initialAutoCommit = this._connectionProperties.getBooleanProperty(ConnectionProperty.AUTO_COMMIT))) {
            this.setAutoCommit(initialAutoCommit);
        }
        boolean initialReadOnly = this._connectionProperties.getBooleanProperty(ConnectionProperty.READ_ONLY);
        boolean currentReadOnly = this.isReadOnly();
        if (currentReadOnly != initialReadOnly) {
            this.setReadOnly(initialReadOnly);
        }
        int initialIsolationLevel = ConnectionSapDB._getJdbcIsolationLevelForConnectionPropertyValue(this._connectionProperties.getProperty(ConnectionProperty.ISOLATION));
        int currentIsolationLevel = this.getTransactionIsolation();
        if (currentIsolationLevel != initialIsolationLevel) {
            this.setTransactionIsolation(initialIsolationLevel);
        }
        if ((initialSchema = this._connectionProperties.getProperty(ConnectionProperty.CURRENT_SCHEMA)) == null) {
            initialSchema = this._defaultSchema;
        }
        if (!Objects.equals(currentSchema = this.getSchema(), initialSchema)) {
            this.setSchema(initialSchema);
        }
        int initialNetworkTimeout = this._connectionProperties.getIntProperty(ConnectionProperty.COMMUNICATION_TIMEOUT);
        int currrentNetworkTimeout = this.getNetworkTimeout();
        if (currrentNetworkTimeout != initialNetworkTimeout) {
            this.setNetworkTimeout(null, initialNetworkTimeout);
        }
        boolean initialDDLAutoCommit = true;
        boolean currentDDLAutoCommit = this.isDDLAutoCommit();
        if (currentDDLAutoCommit != initialDDLAutoCommit) {
            this._setDDLAutoCommit(initialDDLAutoCommit);
        }
        this._typeMap.clear();
        this._resultSetHoldability = 1;
        this._initClientInfoFromProperties(true);
        Statement stmt = null;
        if (this._queuedForLazyDrop.size() > 0) {
            try {
                stmt = this.createStatement();
                stmt.executeUpdate("SELECT 'DEQUEUE LAZY DROP' FROM DUMMY");
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        this.clearWarnings();
        if (this._tracer.on()) {
            this._tracer.printConnectionMessage(this, "Returned to pool", new String[0]);
        }
    }

    public boolean isPreparedStatementCacheEnabled() {
        return this._statementCache != null;
    }

    public int getPreparedStatementCurrentCacheSize() {
        return this._statementCache != null ? this._statementCache.getCurrentCacheSize() : -1;
    }

    public int getPreparedStatementCurrentTrackSize() {
        return this._statementCache != null ? this._statementCache.getCurrentTrackSize() : -1;
    }

    public int getPreparedStatementCount() {
        return this._statementCache != null ? this._statementCache.getPrepareCount() : -1;
    }

    public int getPreparedStatementCacheHitCount() {
        return this._statementCache != null ? this._statementCache.getCacheHitCount() : -1;
    }

    public int getPreparedStatementExecuteCount() {
        return this._statementCache != null ? this._statementCache.getExecuteCount() : -1;
    }

    public int getPreparedStatementDropCount() {
        return this._statementCache != null ? this._statementCache.getDropCount() : -1;
    }

    public int getPreparedStatementApproxUniqueSQLTextCount() {
        return this._statementCache != null ? this._statementCache.getApproxUniqueSQLTextCount() : -1;
    }

    public int getPreparedStatementCacheRejectedFullCount() {
        return this._statementCache != null ? this._statementCache.getCacheRejectedFullCount() : -1;
    }

    public int getPreparedStatementCacheEvictedFullCount() {
        return this._statementCache != null ? this._statementCache.getCacheEvictedFullCount() : -1;
    }

    public int getPreparedStatementCacheEvictedColdCount() {
        return this._statementCache != null ? this._statementCache.getCacheEvictedColdCount() : -1;
    }

    public int getPreparedStatementTrackEvictedFullCount() {
        return this._statementCache != null ? this._statementCache.getTrackEvictedFullCount() : -1;
    }

    public int getPreparedStatementTrackEvictedColdCount() {
        return this._statementCache != null ? this._statementCache.getTrackEvictedColdCount() : -1;
    }

    public synchronized ColumnEncryptionKey retrieveColumnEncryptionKey(String cekId) throws SQLException {
        ColumnEncryptionKey cek = KeyCache.getCachedColumnEncryptionKey(cekId, this._cseKeyStorePassword);
        if (cek != null) {
            return cek;
        }
        Set<String> clientKeyPairIds = KeyCache.getClientKeyPairIds(this._cseKeyStorePassword);
        for (String ckpId : clientKeyPairIds) {
            try {
                cek = this._retrieveColumnEncryptionKey(cekId, ckpId);
                if (cek == null) continue;
                break;
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -11488) continue;
                throw e;
            }
        }
        if (cek == null) {
            throw SQLExceptionSapDB.newInstance("error.couldnotretrievecek", cekId);
        }
        return cek;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getCurrentUserFromServer() throws SQLException {
        InternalStatementSapDB is = null;
        ResultSetSapDB irs = null;
        String currentUser = null;
        try {
            is = InternalStatementSapDB.newInstance(this, StatementSapDB.StatementFlag.INTERNAL_RESULT_SETS);
            irs = (InternalResultSetSapDB)is._executeQuery("SELECT CURRENT_USER FROM DUMMY");
            if (irs != null && irs._next()) {
                currentUser = irs._getString(1);
            }
        }
        finally {
            if (irs != null) {
                try {
                    irs._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
            if (is != null) {
                try {
                    is._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
        }
        return currentUser;
    }

    protected synchronized Session _connectAnchor(boolean isReconnect, SiteType reconnectSiteType) throws RTEException, SQLException {
        SiteType siteType;
        boolean isConnectionDistribution;
        boolean isIgnoringTopology;
        SessionFactory factory = Driver.getSessionFactory(this._tracer, this._connectionProperties);
        boolean isWrongSiteType = false;
        int failedAddressesCount = 0;
        RTEException firstRTEException = null;
        StringBuilder errorMessage = null;
        if (isReconnect) {
            isIgnoringTopology = this._isIgnoringTopology;
            isConnectionDistribution = isIgnoringTopology ? false : this._distributionMode.isConnectionDistribution();
            siteType = reconnectSiteType;
            if (this._redirectionType == RedirectionType.TenantWithAZAware) {
                this._redirectionType = RedirectionType.None;
            }
            this._redirectedHost = null;
            this._redirectedPort = 0;
        } else {
            isIgnoringTopology = this._connectionProperties.getBooleanProperty(ConnectionProperty.IGNORE_TOPOLOGY);
            isConnectionDistribution = isIgnoringTopology ? false : DistributionMode.decode(this._connectionProperties.getProperty(ConnectionProperty.DISTRIBUTION)).isConnectionDistribution();
            siteType = SiteType.decode(this._connectionProperties.getProperty(ConnectionProperty.SITE_TYPE));
        }
        PreferredAddress[] outPreferredAddress = new PreferredAddress[1];
        List<? extends Address> addressesList = ConnectionSapDB._buildAddressesList(this._preferredAddresses, isConnectionDistribution, siteType, outPreferredAddress);
        if (this._tracer.on()) {
            this._tracer.printConnectionOpening(this, "Properties:         " + Driver.getDisplayProperties(this._connectionProperties), "PreferredAddresses: " + Arrays.toString(this._preferredAddresses.toArray()), "ResolvedAddresses:  " + Arrays.toString(addressesList.toArray()));
        }
        for (Address address : addressesList) {
            try {
                Session session = Session.newInstance(factory, this, address, true);
                if (isIgnoringTopology && !session.getAddress().equals(address)) {
                    session.destroy();
                    throw SQLExceptionSapDB.newInstance("error.connection.invalidproperties", "databaseName", "ignoreTopology=true");
                }
                if (address instanceof PublicAddress) {
                    this._endPointHost = outPreferredAddress[0].getHost();
                    this._endPointPort = outPreferredAddress[0].getPort();
                } else {
                    this._endPointHost = address.getHost();
                    this._endPointPort = address.getPort();
                }
                session = this._authenticateAndConnectSession(factory, session, true);
                if (siteType != SiteType.NONE && !session.getSiteType().equals(siteType)) {
                    this._sessionPool.releaseAll();
                    isWrongSiteType = true;
                    continue;
                }
                if (isReconnect) {
                    this._refreshMetaData();
                } else {
                    this._databaseMetaData = new HanaDatabaseMetaData(this._tracer, this);
                    this._defaultSchema = this._databaseMetaData._getUserName();
                    if (this._currentSchema == null) {
                        this._currentSchema = this._defaultSchema;
                    }
                    this._initClientInfoFromProperties(false);
                }
                if (session.getSessionType().isChannel() && this._supportIdlePing.get() && !isReconnect) {
                    int seconds = this._engineFeatures.getLRRPingTime();
                    if (seconds == 0) {
                        seconds = this._connectionProperties.getIntProperty(ConnectionProperty.HEARTBEAT_TIME);
                    }
                    if (seconds > 0) {
                        this._heartbeatTask = new HeartbeatTask(this);
                        Driver._addHeartbeatTask(this.toString(), this._heartbeatTask, seconds);
                    }
                }
                if (this._tracer.on()) {
                    this._tracer.printConnectionOpened(this);
                }
                return session;
            }
            catch (RTEException e) {
                switch (++failedAddressesCount) {
                    case 1: {
                        firstRTEException = e;
                        break;
                    }
                    case 2: {
                        errorMessage = new StringBuilder();
                        errorMessage.append(firstRTEException.getMessage());
                    }
                    default: {
                        errorMessage.append("; host = ");
                        errorMessage.append(address.toString());
                        errorMessage.append(" error = ");
                        errorMessage.append(e.getMessage());
                        break;
                    }
                }
            }
            catch (InternalConnectException e) {
                return this._connectAnchor(false, null);
            }
        }
        if (isWrongSiteType) {
            throw SQLExceptionSapDB.newInstance("error.wrong.site", this._connectionProperties.getProperty(ConnectionProperty.SITE_TYPE));
        }
        if (failedAddressesCount > 1) {
            throw RTEException.newInstance(this._tracer, MessageTranslator.translate("error.connect.rteexceptionMultipleHosts", errorMessage), RteReturnCode.SQLNOTOK, -708, firstRTEException);
        }
        throw firstRTEException;
    }

    protected Session _connectSecondary(SiteTypeVolumeID siteTypeVolumeID) throws RTEException, SQLException {
        SystemInfo systemInfo = this._sessionPool.getSystemInfo();
        if (systemInfo == null) {
            if (this._tracer.on()) {
                this._tracer.printConnectionMessage(this, "No SystemInfo available", new String[0]);
            }
            throw SQLExceptionSapDB.newInstance("error.connection.secondarysession", "No SystemInfo available");
        }
        PublicAddress publicAddress = systemInfo.getAddress(siteTypeVolumeID);
        if (publicAddress == null) {
            if (this._tracer.on()) {
                this._tracer.printConnectionMessage(this, "No public address for SiteTypeVolumeID " + siteTypeVolumeID, new String[0]);
            }
            throw SQLExceptionSapDB.newInstance("error.connection.secondarysession", "No public address for SiteTypeVolumeID " + siteTypeVolumeID);
        }
        if (this._secondaryConnectionAttemptCount != null) {
            this._secondaryConnectionAttemptCount.incrementAndGet();
        }
        SessionFactory factory = Driver.getSessionFactory(this._tracer, this._connectionProperties);
        Session session = Session.newInstance(factory, this, publicAddress, false);
        try {
            Session newSession = this._authenticateAndConnectSession(factory, session, false);
            if (session != newSession) {
                if (this._tracer.on()) {
                    this._tracer.printConnectionMessage(this, "Unexpected session change for secondary session", new String[0]);
                }
                throw SQLExceptionSapDB.newInstance("error.connection.secondarysession", "Unexpected session change for secondary session");
            }
        }
        catch (InternalConnectException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.secondarysession", e.getMessage());
        }
        return session;
    }

    protected static SQLException _getUnsupportedMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, "Connection");
    }

    protected static String _getSessionVariableFromProperties(String name, Properties info) {
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            String sessionVariableValue;
            String sessionVariableName = ConnectionSapDB._getSessionVariableName(entry.getKey());
            if (sessionVariableName == null || !sessionVariableName.equalsIgnoreCase(name) || (sessionVariableValue = ConnectionSapDB._getSessionVariableValue(entry.getValue())) == null) continue;
            return sessionVariableValue;
        }
        return null;
    }

    protected TraceRecord _newTraceRecord(String methodName) {
        return new TraceRecord(this, null, null, "Connection", methodName);
    }

    protected void _publish(TraceRecord r) {
        r.update(this);
        TraceRecordPublisher.getInstance().publish(r);
    }

    protected StatementSapDB _createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability, String commandInfoSource, int commandInfoLine) throws SQLException {
        this._assertOpen();
        return HanaStatement.newInstance(this._tracer, this, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, this._routeDirectExecute ? StatementSapDB.StatementFlag.ROUTE_DIRECT : StatementSapDB.StatementFlag.NONE);
    }

    protected PreparedStatementSapDB _prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String commandInfoSource, int commandInfoLine, StatementSapDB.StatementFlag ... statementFlags) throws SQLException {
        this._assertOpen();
        if (Driver._createPhantomClass(this._connectionProperties)) {
            return HanaPreparedStatementPhantom.newInstance(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, statementFlags);
        }
        if (Driver._createFinalizerClass(this._connectionProperties)) {
            return HanaPreparedStatementFinalize.newInstance(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, statementFlags);
        }
        return HanaPreparedStatement.newInstance(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, statementFlags);
    }

    protected CallableStatementSapDB _prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String commandInfoSource, int commandInfoLine, StatementSapDB.StatementFlag ... statementFlags) throws SQLException {
        this._assertOpen();
        if (Driver._createPhantomClass(this._connectionProperties)) {
            return HanaCallableStatementPhantom.newInstance(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, statementFlags);
        }
        if (Driver._createFinalizerClass(this._connectionProperties)) {
            return HanaCallableStatementFinalize.newInstance(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, statementFlags);
        }
        return HanaCallableStatement.newInstance(this._tracer, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, statementFlags);
    }

    protected void _assertOpen() throws SQLException {
        if (this._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }

    protected UniqueID _getUniqueID() {
        return this._uniqueID;
    }

    protected synchronized boolean _isDeferredPrepare() {
        return this._deferredPrepare && this._engineFeatures.supportDeferredPrepare();
    }

    protected synchronized Properties _getSessionVariables() {
        return (Properties)this._sessionVariables._getProperties().clone();
    }

    protected synchronized Properties _getClientInfo() {
        return (Properties)this._clientInfo._getProperties().clone();
    }

    protected synchronized String _getClientInfo(String key) {
        return this._clientInfo._getProperty(key);
    }

    protected synchronized void _setClientInfo(Properties properties) throws SQLClientInfoException {
        String value;
        if (properties != null && (value = properties.getProperty("FORCE_ROUTE_TO_SITE")) != null) {
            this._setForceRouteSiteID(value);
        }
        if (this._passport != null && properties != null && properties.getProperty("SAP_PASSPORT") != null) {
            properties = (Properties)properties.clone();
            properties.remove("SAP_PASSPORT");
        }
        this._clientInfo._setProperties(properties);
        this._sessionPool.setSendClientInfoFlag();
    }

    protected synchronized void _setClientInfo(String key, String value) throws SQLClientInfoException {
        if (key != null && key.equals("FORCE_ROUTE_TO_SITE")) {
            this._setForceRouteSiteID(value);
        }
        if (this._passport != null && key != null && key.equals("SAP_PASSPORT")) {
            return;
        }
        this._clientInfo._setProperty(key, value);
        this._sessionPool.setSendClientInfoFlag();
    }

    protected synchronized void _assertForceRouteAllowed() throws SQLException {
        Address anchorAddress;
        this._assertOpen();
        Session anchorSession = this._sessionPool.getAnchorSession();
        Address address = anchorAddress = anchorSession != null ? anchorSession.getAddress() : null;
        if (!(anchorAddress instanceof PublicAddress)) {
            throw SQLExceptionSapDB.newInstance("error.force.route.anchorpublicaddressnotavailable", new String[0]);
        }
        PublicAddress anchorPublicAddress = (PublicAddress)anchorAddress;
        if (this._engineFeatures.getActiveActiveProtocolVersion().getValue() < ActiveActiveProtocolVersion.Level1.getValue() || !anchorPublicAddress.isHSR()) {
            throw SQLExceptionSapDB.newInstance("error.force.route.activeactivedisabled", new String[0]);
        }
        if (!anchorPublicAddress.isNoneOrPrimarySite()) {
            throw SQLExceptionSapDB.newInstance("error.force.route.anchorconnectionisnotprimary", new String[0]);
        }
        if (this._isolationLevel == 4 || this._isolationLevel == 8) {
            throw SQLExceptionSapDB.newInstance("error.force.route.invalidisolationlevel", new String[0]);
        }
        TransactionState transactionState = this.getTransactionState();
        if (transactionState != TransactionState.None && transactionState != TransactionState.ReadTransaction) {
            throw SQLExceptionSapDB.newInstance("error.force.route.invalidtransactionstate", new String[0]);
        }
    }

    protected void _setForceRouteSiteID(String siteIdStr) {
        if (this._isDeferredPrepare()) {
            return;
        }
        this._forceRouteSiteID.set(siteIdStr);
    }

    protected Integer _getAndUnsetForceRouteSiteIDIfSpecified() throws SQLException {
        if (this._isDeferredPrepare()) {
            return null;
        }
        String value = this._forceRouteSiteID.getAndSet(null);
        Integer forceRouteSiteID = null;
        if (value != null) {
            try {
                forceRouteSiteID = Integer.parseInt(value);
                if (forceRouteSiteID < 0 || forceRouteSiteID > 255) {
                    throw SQLExceptionSapDB.newInstance("error.force.route.invalidsiteid", value);
                }
            }
            catch (NumberFormatException e) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.force.route.invalidsiteid", value);
            }
        }
        return forceRouteSiteID;
    }

    protected synchronized int _getHoldability() {
        return this._resultSetHoldability;
    }

    protected synchronized int _getTransactionIsolation() {
        return this._isolationLevel;
    }

    protected synchronized int _getRollbackCount() {
        return this._rollbackCount;
    }

    protected synchronized void _commitInternal() throws SQLException {
        block3: {
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initCommit(this, session);
            try {
                this.exchange(session, requestPacket, null, ExchangeFlag.IS_STATEMENT, ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
            }
            catch (InternalFallbackSecondaryException | InternalReconnectException sQLException) {
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 700) break block3;
                throw e;
            }
        }
    }

    protected synchronized void _rollbackInternal() throws SQLException {
        block3: {
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this._getRequestPacket(session);
            requestPacket.initRollback(this, session);
            try {
                this.exchange(session, requestPacket, null, ExchangeFlag.IS_STATEMENT, ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
            }
            catch (InternalFallbackSecondaryException | InternalReconnectException sQLException) {
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 700) break block3;
                throw e;
            }
        }
    }

    protected synchronized Session _getOrOpenSession(SiteTypeVolumeID siteTypeVolumeID) throws SQLException {
        boolean isHintRouting;
        if (this._isIgnoringTopology) {
            throw SQLExceptionSapDB.newInstance("error.connection.ignoringtopology", new String[0]);
        }
        Session anchorSession = this._sessionPool.getAnchorSession();
        if (anchorSession == null || !anchorSession.isConnected()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
        Session session = this._sessionPool.getSession(siteTypeVolumeID);
        boolean bl = isHintRouting = anchorSession.isNoneOrPrimarySite() && siteTypeVolumeID.isSecondarySite();
        if (session == null) {
            try {
                session = this._connectSecondary(siteTypeVolumeID);
            }
            catch (RTEException e) {
                if (isHintRouting) {
                    this._handleFailedHintRouted();
                } else {
                    this._handleFailedStatementRouted(siteTypeVolumeID);
                }
                throw SQLExceptionSapDB.newInstance(e.getCause(), "error.connect.rteexception", "", e.getDetailErrorCode(), 0, e.getRTEReturnCode(), SQLExceptionSapDB.NO_UPDATE_COUNTS, "SiteTypeVolumeID=" + siteTypeVolumeID, e.getMessage());
            }
        }
        if (isHintRouting) {
            this._handleSuccessHintRouted();
        } else {
            this._handleSuccessStatementRouted(siteTypeVolumeID);
        }
        return session;
    }

    protected synchronized void _handleFailedHintRouted() {
        if (this._backOffTimer == null) {
            this._backOffTimer = new BackOffTimer(this._hintRoutingBackoffMin, this._hintRoutingBackoffMax);
        }
        this._backOffTimer.backOff();
    }

    protected synchronized void _handleSuccessHintRouted() {
        if (this._backOffTimer == null) {
            return;
        }
        this._backOffTimer.reset();
    }

    protected synchronized boolean _isSecondarySiteReady() {
        if (this._backOffTimer == null) {
            return true;
        }
        return this._backOffTimer.isRetryOk();
    }

    protected synchronized void _handleFailedStatementRouted(SiteTypeVolumeID node) {
        if (!this._connectionProperties.getBooleanProperty(ConnectionProperty.STATEMENT_ROUTING_FAILURE_BACKOFF) || node == null) {
            return;
        }
        BackOffTimer timer = this._statementRoutingBackOffTimers.get(node);
        if (timer == null) {
            timer = new BackOffTimer(this._statementRoutingBackoffMin, this._statementRoutingBackoffMax, BackOffTimer.RoutingType.STATEMENT);
            this._statementRoutingBackOffTimers.put(node, timer);
        }
        timer.backOff();
    }

    protected synchronized void _handleSuccessStatementRouted(SiteTypeVolumeID node) {
        if (!this._connectionProperties.getBooleanProperty(ConnectionProperty.STATEMENT_ROUTING_FAILURE_BACKOFF) || node == null) {
            return;
        }
        BackOffTimer timer = this._statementRoutingBackOffTimers.get(node);
        if (timer != null) {
            timer.reset();
        }
    }

    protected synchronized boolean _isNodeReady(SiteTypeVolumeID node) {
        boolean nodeExists;
        if (!this._connectionProperties.getBooleanProperty(ConnectionProperty.STATEMENT_ROUTING_FAILURE_BACKOFF)) {
            return true;
        }
        BackOffTimer timer = this._statementRoutingBackOffTimers.get(node);
        SystemInfo systemInfo = this.getSessionPool().getSystemInfo();
        boolean bl = nodeExists = systemInfo != null && systemInfo.getAddress(node) != null;
        if (nodeExists) {
            return timer == null || timer.isRetryOk();
        }
        return false;
    }

    protected synchronized void _dropParseIDs(ParseInfo parseInfo) throws SQLException {
        for (Map.Entry<Session, ParseID> entry : new HashMap<Session, ParseID>(parseInfo.getParseIDs()).entrySet()) {
            ParseID parseID;
            Session session = entry.getKey();
            if (this.queueForLazyDrop(session, parseID = entry.getValue())) continue;
            this._dropParseID(session, parseID);
            parseInfo.removeParseID(session);
        }
    }

    protected synchronized void _dropParseID(Session session, ParseID parseID) {
        if (session == null || !session.isConnected() || parseID == null) {
            return;
        }
        try {
            HRequestPacket requestPacket = this.initDropStatementID(session, parseID);
            this.exchange(session, requestPacket, null, ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected synchronized void _dropCursorID(Session session, CursorID cursorID) throws SQLException {
        if (session == null || !session.isConnected() || cursorID == null) {
            return;
        }
        try {
            HRequestPacket requestPacket = this.initCloseResultSet(session, cursorID);
            this.exchange(session, requestPacket, null, ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean _isClosed() {
        return this._isClosed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _close() throws SQLException {
        if (this._isClosed()) {
            return;
        }
        if (this._tracer.on()) {
            this._tracer.printConnectionClosing(this);
            this._tracer.printConnectionStatistics(this);
        }
        this._closeStatements(false);
        try {
            ConnectionSapDB connectionSapDB = this;
            synchronized (connectionSapDB) {
                block12: {
                    if (!this._isClosed()) break block12;
                    return;
                }
                if (this._heartbeatTask != null) {
                    Driver._removeHeartbeatTask(this.toString(), this._heartbeatTask);
                }
                this._clean();
                this._databaseMetaData = null;
                this._packetPool.clear();
                this._transaction.clearTransaction(true);
                this._isClosed.set(true);
            }
        }
        finally {
            Driver._removeConnection(this);
            if (this._tracer.on()) {
                this._tracer.printConnectionClosed(this);
            }
        }
    }

    protected void _clean() throws SQLException {
        ConnectionSapDB._clean(this.getInstanceClassName(), this._sessionPool, this._isClosed);
    }

    protected static void _clean(String instanceClassName, SessionPool sessionPool, AtomicBoolean isClosed) throws SQLException {
        if (isClosed.get()) {
            return;
        }
        sessionPool.releaseAll();
        if (Dbg.runtimeEnabled) {
            DbgInstanceCount.incrementCleanedCount(instanceClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _cancel(Statement statement) throws SQLException {
        if (this._executingStatement.get() != statement && this._alterTableStatement.get() != statement) {
            return;
        }
        if (this._isInReconnect.get() && this._getReconnectWaitTimeout() > 0) {
            this._cancelReconnect.set(true);
            return;
        }
        ConnectionSapDB conn = null;
        StatementSapDB is = null;
        try {
            conn = ConnectionSapDB.getConnectionSapDB(Driver.getInstance().getConnection(this._connectionProperties.getProperty(ConnectionProperty.DBURL), this._connectionProperties.toProperties()));
            int connectionID = this.getAnchorConnectionID();
            is = InternalStatementSapDB.newInstance(conn, new StatementSapDB.StatementFlag[0]);
            is._executeUpdate("ALTER SYSTEM CANCEL SESSION '" + connectionID + "'");
        }
        finally {
            if (is != null) {
                try {
                    is._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn._close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addStatement(StatementSapDB statement) {
        if (statement instanceof InternalStatementSapDB || statement instanceof InternalPreparedStatementSapDB || statement instanceof InternalCallableStatementSapDB) {
            return;
        }
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            this._statements.add(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeStatement(StatementSapDB statement) {
        if (statement instanceof InternalStatementSapDB || statement instanceof InternalPreparedStatementSapDB || statement instanceof InternalCallableStatementSapDB) {
            return;
        }
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            this._statements.remove(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closeStatements(boolean sendRequests) throws SQLException {
        HashSet<StatementSapDB> statements;
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            statements = new HashSet<StatementSapDB>(this._statements);
        }
        for (StatementSapDB statement : statements) {
            statement._close(sendRequests, false);
        }
        this._closePendingPreparedStatementsAndResultSets(sendRequests);
        this._cacheOnCloseStatements(sendRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closeCursorsAtCommit() throws SQLException {
        HashSet<StatementSapDB> statements;
        Set<StatementSapDB> set = this._statements;
        synchronized (set) {
            statements = new HashSet<StatementSapDB>(this._statements);
        }
        block7: for (StatementSapDB statement : statements) {
            switch (statement._getResultSetHoldability()) {
                case 1: 
                case 1000002: {
                    continue block7;
                }
                case 2: 
                case 1000001: {
                    statement._closeResultSets(true, false);
                    continue block7;
                }
            }
            throw new AssertionError((Object)("Unexpected result set holdability: " + statement._getResultSetHoldability()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addPreparedStatementClosePending(PreparedStatementSapDB statement) {
        Set<PreparedStatementSapDB> set = this._preparedStatementsClosePending;
        synchronized (set) {
            this._preparedStatementsClosePending.add(statement);
        }
        if (this._tracer.on()) {
            this._tracer.printStatementQueuedForPendingClose(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removePreparedStatementClosePending(PreparedStatementSapDB statement) {
        Set<PreparedStatementSapDB> set = this._preparedStatementsClosePending;
        synchronized (set) {
            this._preparedStatementsClosePending.remove(statement);
        }
        if (this._tracer.on()) {
            this._tracer.printStatementDequeuedForPendingClose(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addResultSetClosePending(ResultSetSapDB resultSet) {
        Set<ResultSetSapDB> set = this._resultSetsClosePending;
        synchronized (set) {
            this._resultSetsClosePending.add(resultSet);
        }
        if (this._tracer.on()) {
            this._tracer.printResultSetQueuedForPendingClose(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeResultSetClosePending(ResultSetSapDB resultSet) {
        Set<ResultSetSapDB> set = this._resultSetsClosePending;
        synchronized (set) {
            this._resultSetsClosePending.remove(resultSet);
        }
        if (this._tracer.on()) {
            this._tracer.printResultSetDequeuedForPendingClose(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closePendingPreparedStatementsAndResultSets(boolean sendRequests) throws SQLException {
        HashSet<ResultSetSapDB> resultSets;
        HashSet<PreparedStatementSapDB> preparedStatements;
        Object object = this._preparedStatementsClosePending;
        synchronized (object) {
            preparedStatements = new HashSet<PreparedStatementSapDB>(this._preparedStatementsClosePending);
        }
        for (PreparedStatementSapDB preparedStatement : preparedStatements) {
            preparedStatement._close(sendRequests, false);
        }
        object = this._resultSetsClosePending;
        synchronized (object) {
            resultSets = new HashSet<ResultSetSapDB>(this._resultSetsClosePending);
        }
        for (ResultSetSapDB resultSet : resultSets) {
            resultSet._close(sendRequests, false);
        }
    }

    protected synchronized void _prefetchSend(Session session, ResultSetSapDB resultSet, CursorID cursorID, int fetchSize) throws SQLException {
        HRequestPacket requestPacket = this.initFetchNext(session, cursorID, fetchSize);
        this.send(session, requestPacket, resultSet.getStatementSapDB(), new ExchangeFlag[0]);
        this._outstandingPrefetchResultSet = resultSet;
        this._outstandingPrefetchSession = session;
        this._outstandingPrefetchPassport = requestPacket.getPassport();
        this._outstandingPrefetchPassportConnectionCounter = requestPacket.getPassportConnectionCounter();
    }

    protected synchronized HReplyPacket _prefetchReceive(ResultSetSapDB resultSet) throws SQLException {
        HReplyPacket replyPacket;
        Object cachedPrefetchObject = this._prefetchedCachedReplyMap.remove(resultSet);
        if (cachedPrefetchObject == null) {
            replyPacket = this._receiveOutstandingPrefetch(this._outstandingPrefetchSession, resultSet, this._outstandingPrefetchPassport, this._outstandingPrefetchPassportConnectionCounter);
        } else if (cachedPrefetchObject instanceof HReplyPacket) {
            replyPacket = (HReplyPacket)cachedPrefetchObject;
        } else {
            if (cachedPrefetchObject instanceof SQLException) {
                throw (SQLException)cachedPrefetchObject;
            }
            throw new AssertionError((Object)("Unexpected cached prefetch object type:" + cachedPrefetchObject.getClass().getName()));
        }
        return replyPacket;
    }

    protected synchronized void _prefetchDiscard(ResultSetSapDB resultSet) throws SQLException {
        Object cachedPrefetchObject = this._prefetchedCachedReplyMap.remove(resultSet);
        if (cachedPrefetchObject == null && this._outstandingPrefetchResultSet == resultSet) {
            this._receiveOutstandingPrefetch(this._outstandingPrefetchSession, resultSet, this._outstandingPrefetchPassport, this._outstandingPrefetchPassportConnectionCounter);
        }
    }

    protected synchronized ParseInfo _cacheOnPrepareGetCached(String sql) {
        if (this._statementCache == null) {
            return null;
        }
        return this._statementCache.onPrepareGetCached(sql);
    }

    protected synchronized void _cacheOnPrepareSetTracked(ParseInfo parseInfo) throws SQLException {
        if (this._statementCache == null) {
            return;
        }
        this._statementCache.onPrepareSetTracked(parseInfo);
    }

    protected synchronized void _cacheOnSetPoolable(ParseInfo parseInfo, boolean oldValue, boolean newValue) throws SQLException {
        if (this._statementCache == null) {
            return;
        }
        this._statementCache.onSetPoolable(parseInfo, oldValue, newValue);
    }

    protected synchronized void _cacheOnExecute() throws SQLException {
        if (this._statementCache == null) {
            return;
        }
        this._statementCache.onExecute();
    }

    protected synchronized boolean _cacheOnDrop(ParseInfo parseInfo, boolean isPoolable) throws SQLException {
        if (this._statementCache == null) {
            return false;
        }
        return this._statementCache.onDrop(parseInfo, isPoolable);
    }

    protected synchronized void _cacheOnSchemaChange() throws SQLException {
        if (this._statementCache == null) {
            return;
        }
        this._statementCache.onSchemaChange();
    }

    protected synchronized void _cacheOnInternalReconnect() throws SQLException {
        if (this._statementCache == null) {
            return;
        }
        this._statementCache.onInternalReconnect();
    }

    protected synchronized void _cacheOnCloseStatements(boolean sendRequests) throws SQLException {
        if (this._statementCache == null) {
            return;
        }
        this._statementCache.onCloseStatements(sendRequests);
    }

    protected synchronized void _createColumnEncryptionKey(String ckpId, String ckpName, String cekId, String cekName, String schemaName, String algorithmName, boolean isEmptyKeyCase) throws SQLException {
        String sql;
        this._assertOpen();
        CSEBlockCipher cipher = CSECipherFactory.getBlockCipher(algorithmName);
        Key cek = cipher.generateKey();
        Key publicKey = this._retrieveClientPublicKey(ckpId);
        CSEStreamCipher keyPairCipher = CSECipherFactory.getStreamCipher(publicKey);
        byte[] encryptedKey = keyPairCipher.encrypt(publicKey, cek.getEncoded());
        String encodedEncryptedKey = Base64Utils.encodeToString(encryptedKey);
        if (isEmptyKeyCase) {
            KeyCache.addColumnEncryptionKey(cekId, new ColumnEncryptionKey(cek, this._engineFeatures.getDatabaseName(), cekName, cekId, algorithmName));
            sql = "ALTER CLIENTSIDE ENCRYPTION COLUMN KEY " + StringUtils.quoteSqlIdentifier(schemaName) + "." + StringUtils.quoteSqlIdentifier(cekName) + " ENCRYPTED WITH KEYPAIR " + StringUtils.quoteSqlIdentifier(ckpName) + " ENCRYPTED COLUMN KEYVALUE '" + encodedEncryptedKey + "'";
        } else {
            UUID uuid = UUID.randomUUID();
            KeyCache.addColumnEncryptionKey(uuid.toString(), new ColumnEncryptionKey(cek, this._engineFeatures.getDatabaseName(), cekName, uuid.toString(), algorithmName));
            sql = "CREATE CLIENTSIDE ENCRYPTION COLUMN KEY " + StringUtils.quoteSqlIdentifier(schemaName) + "." + StringUtils.quoteSqlIdentifier(cekName) + " ALGORITHM '" + algorithmName + "' ENCRYPTED WITH KEYPAIR " + StringUtils.quoteSqlIdentifier(ckpName) + " ENCRYPTED COLUMN KEYVALUE '" + encodedEncryptedKey + "' COLUMN KEY ID '" + UUIDUtils.toHexString(uuid) + "'";
        }
        this._executeInternalStatement(sql);
    }

    protected synchronized void _dropColumnEncryptionKey(String cekId) {
        KeyCache.deleteCachedColumnEncryptionKey(cekId, this._cseKeyStorePassword);
    }

    protected synchronized void _dropColumnEncryptionKeyMultiple(Set<String> cekIDs) {
        for (String cekId : cekIDs) {
            KeyCache.deleteCachedColumnEncryptionKey(cekId, this._cseKeyStorePassword);
        }
    }

    protected synchronized void _grantAccessColumnEncryptionKey(String ckpName, String cekId, String cekName, String schemaName, String pemEncodedPublicKey, String algorithmName) throws SQLException {
        this._assertOpen();
        ColumnEncryptionKey cek = this.retrieveColumnEncryptionKey(cekId);
        CSEStreamCipher keyPairCipher = CSECipherFactory.getStreamCipher(algorithmName);
        PublicKey publicKey = keyPairCipher.generatePublicKeyFromBytes(Base64Utils.decodePublicKey(pemEncodedPublicKey), algorithmName);
        byte[] encryptedKey = keyPairCipher.encrypt(publicKey, cek.getKey().getEncoded());
        String encodedEncryptedKey = Base64Utils.encodeToString(encryptedKey);
        this._executeInternalStatement("ALTER CLIENTSIDE ENCRYPTION COLUMN KEY " + StringUtils.quoteSqlIdentifier(schemaName) + "." + StringUtils.quoteSqlIdentifier(cekName) + " ADD KEYCOPY ENCRYPTED WITH KEYPAIR " + StringUtils.quoteSqlIdentifier(ckpName) + " ENCRYPTED COLUMN KEYVALUE '" + encodedEncryptedKey + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _grantAccessColumnEncryptionKeyMultiple(String schemaName, String ckpName, String cekName, String algorithmName) throws SQLException {
        boolean preAutoCommit = this._transaction.getAutoCommit();
        boolean preDDLAutoCommit = this._transaction.getDDLAutoCommit();
        String keyIdTableName = null;
        StatementSapDB is = null;
        ResultSetSapDB irs = null;
        try {
            if (preAutoCommit) {
                this._setAutoCommit(false);
            } else {
                this._commit();
            }
            if (preDDLAutoCommit) {
                this._setDDLAutoCommit(false);
            }
            this._lockClientKeypair(ckpName);
            ClientKeyPair keypair = this._retrievePublicKey(ckpName, algorithmName);
            Set<String> keypairIDs = KeyCache.getClientKeyPairIds(this._cseKeyStorePassword);
            keyIdTableName = this._createKeyIdTable(keypairIDs, true);
            String sql = "CALL SYS.CLIENTSIDE_ENCRYPTION_COLUMN_KEYS_DEV( '" + keyIdTableName + "', " + StringUtils.quoteSqlString(schemaName) + ", " + StringUtils.quoteSqlString(cekName) + ", ? )";
            is = InternalStatementSapDB.newInstance(this, StatementSapDB.StatementFlag.INTERNAL_RESULT_SETS);
            irs = (InternalResultSetSapDB)is._executeQuery(sql);
            if (irs == null) {
                throw SQLExceptionSapDB.newInstance("error.encrypt.failed", "Failed to execute CLIENTSIDE_ENCRYPTION_COLUMN_KEYS_DEV query.");
            }
            ArrayList<String> updatedCekIDs = new ArrayList<String>();
            while (irs._next()) {
                byte[] decryptedCekBytes;
                String cekSchemaName = irs._getString(1);
                UUID cekId = UUIDUtils.newInstance(irs._getBytes(2));
                byte[] encryptedCekBytes = irs._getBytes(3);
                UUID decryptingCkpId = UUIDUtils.newInstance(irs._getBytes(4));
                if (updatedCekIDs.contains(cekId.toString())) continue;
                try {
                    decryptedCekBytes = this._decryptCek(cekId.toString(), encryptedCekBytes, decryptingCkpId.toString());
                }
                catch (Exception e) {
                    throw SQLExceptionSapDB.newInstance((Throwable)e, "error.decrypt.failed", "Key pair with ID '" + UUIDUtils.toHexString(decryptingCkpId) + "' not found in local keystore");
                }
                byte[] reencryptedCekBytes = this._encryptCek(keypair.getPublicKey(), decryptedCekBytes);
                this._sendAddKeyCopyStatement(cekName, cekSchemaName, UUIDUtils.toHexString(cekId), ckpName, keypair.getKeyUuid(), reencryptedCekBytes);
                updatedCekIDs.add(cekId.toString());
            }
        }
        catch (Throwable throwable) {
            try {
                if (irs != null) {
                    irs._close(true, false);
                }
                if (is != null) {
                    is._close(true, false);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._commit();
            if (keyIdTableName != null) {
                this._dropKeyIdTable(keyIdTableName);
            }
            if (preAutoCommit) {
                this._setAutoCommit(preAutoCommit);
            }
            if (preDDLAutoCommit) {
                this._setDDLAutoCommit(true);
            }
            throw throwable;
        }
        try {
            if (irs != null) {
                irs._close(true, false);
            }
            if (is != null) {
                is._close(true, false);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._commit();
        if (keyIdTableName != null) {
            this._dropKeyIdTable(keyIdTableName);
        }
        if (preAutoCommit) {
            this._setAutoCommit(preAutoCommit);
        }
        if (preDDLAutoCommit) {
            this._setDDLAutoCommit(true);
        }
    }

    protected synchronized void _createClientKeyPair(String ckpName, String algorithmName) throws SQLException {
        UUID uuid = UUID.randomUUID();
        CSEStreamCipher keyPairCipher = CSECipherFactory.getStreamCipher(algorithmName);
        KeyPair keyPair = keyPairCipher.generateKeyPair();
        this._storeClientKeyPair(ckpName, algorithmName, uuid, keyPair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _transformColumns(String schemaName, String tableName, List<ColumnReencryptInfo> reencryptColumns, List<String> primaryKey, StatementSapDB stmtObject) throws SQLException {
        boolean preAutoCommit = this._transaction.getAutoCommit();
        boolean preDDLAutoCommit = this._transaction.getDDLAutoCommit();
        int preIsolationLevel = this._isolationLevel;
        InternalCallableStatementSapDB selectPs = null;
        StatementSapDB updatePs = null;
        StatementSapDB is = null;
        ResultSetSapDB irs = null;
        try {
            this._alterTableStatement.set(stmtObject);
            if (preAutoCommit) {
                this._setAutoCommit(false);
            } else {
                this._commit();
            }
            this._setTransactionIsolation(4);
            if (preDDLAutoCommit) {
                this._setDDLAutoCommit(false);
            }
            if (stmtObject._wasCancelled.get()) {
                throw SQLExceptionSapDB.newInstance("error.statement.cancelled", new String[0]);
            }
            selectPs = this._createTransformSelectStmt(schemaName, tableName, reencryptColumns, primaryKey);
            updatePs = this._createTransformUpdateStmt(schemaName, tableName, reencryptColumns, primaryKey);
            is = InternalStatementSapDB.newInstance(this, new StatementSapDB.StatementFlag[0]);
            int MAX_RETRY_COUNT = 10;
            int INITIAL_WAIT_TIME = 10;
            int failCount = 0;
            int waitTime = 10;
            boolean failed = false;
            boolean lockAcquired = false;
            while (true) {
                int colCount;
                if (failed) {
                    ++failCount;
                    waitTime *= 2;
                } else {
                    failCount = 0;
                    waitTime = 10;
                }
                if (failCount == 10) {
                    throw SQLExceptionSapDB.newInstance("error.column.transformation.failed", " too many serialization errors from the server");
                }
                irs = (InternalResultSetSapDB)selectPs._executeQuery();
                if (stmtObject._wasCancelled.get()) {
                    throw SQLExceptionSapDB.newInstance("error.statement.cancelled", new String[0]);
                }
                if (irs == null || !irs._isBeforeFirst()) {
                    if (!lockAcquired) {
                        this._setTransactionIsolation(2);
                        is._executeUpdate("LOCK TABLE " + StringUtils.quoteSqlIdentifier(schemaName) + "." + StringUtils.quoteSqlIdentifier(tableName) + " IN EXCLUSIVE MODE");
                        lockAcquired = true;
                    }
                    if ((irs = (InternalResultSetSapDB)selectPs._executeQuery()) == null || !irs._isBeforeFirst()) {
                        is._executeUpdate("ALTER TABLE " + StringUtils.quoteSqlIdentifier(schemaName) + "." + StringUtils.quoteSqlIdentifier(tableName) + " FINISH CLIENTSIDE ENCRYPTION");
                        break;
                    }
                }
                if ((colCount = irs.getFetchInfo().getResultSetColumnCount()) != reencryptColumns.size() + primaryKey.size()) {
                    throw SQLExceptionSapDB.newInstance("error.column.transformation.failed", "Unexpected number of columns in result set");
                }
                while (irs.next()) {
                    for (int i = 1; i <= colCount; ++i) {
                        ((PreparedStatementSapDB)updatePs)._setObject(i, irs.getObject(i));
                    }
                    ((PreparedStatementSapDB)updatePs)._addBatch();
                }
                if (stmtObject._wasCancelled.get()) {
                    throw SQLExceptionSapDB.newInstance("error.statement.cancelled", new String[0]);
                }
                try {
                    ((PreparedStatementSapDB)updatePs)._executeBatch();
                    failed = false;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 138) {
                        failed = true;
                        try {
                            Thread.sleep(waitTime);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    throw e;
                }
                if (lockAcquired) continue;
                this._commit();
            }
        }
        finally {
            this._alterTableStatement.set(null);
            this._commit();
            if (preAutoCommit) {
                this._setAutoCommit(preAutoCommit);
            }
            this._setTransactionIsolation(preIsolationLevel);
            if (preDDLAutoCommit) {
                this._setDDLAutoCommit(true);
            }
            if (irs != null) {
                try {
                    irs._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
            if (is != null) {
                try {
                    is._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
            if (selectPs != null) {
                try {
                    selectPs._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
            if (updatePs != null) {
                try {
                    updatePs._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected void _dropClientKeyPair(String ckpId) throws SQLException {
        KeyCache.deleteClientKeyPair(ckpId, this._cseKeyStorePassword);
    }

    protected void _dropClientKeyPairMultiple(Set<String> ckpIDs) throws SQLException {
        for (String ckpId : ckpIDs) {
            KeyCache.deleteClientKeyPair(ckpId, this._cseKeyStorePassword);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _createNewClientKeypairVersion(String ckpName, String latestCkpId, String algorithmName) throws SQLException {
        ResultSetSapDB irs;
        StatementSapDB is;
        String keyIdTableName;
        boolean preDDLAutoCommit;
        boolean preAutoCommit;
        block29: {
            preAutoCommit = this._transaction.getAutoCommit();
            preDDLAutoCommit = this._transaction.getDDLAutoCommit();
            UUID newCkpId = UUID.randomUUID();
            keyIdTableName = null;
            is = null;
            irs = null;
            try {
                if (preAutoCommit) {
                    this._setAutoCommit(false);
                } else {
                    this._commit();
                }
                if (preDDLAutoCommit) {
                    this._setDDLAutoCommit(false);
                }
                this._lockClientKeypair(ckpName);
                try {
                    KeyCache.getCachedPrivateClientKey(latestCkpId, this._cseKeyStorePassword);
                }
                catch (Exception e) {
                    throw SQLExceptionSapDB.newInstance((Throwable)e, "error.cse.ckpnewversionfailed", "Failed to retrieve latest version of the client keypair from the local keystore.");
                }
                CSEStreamCipher keyPairCipher = CSECipherFactory.getStreamCipher(algorithmName);
                KeyPair newKeyPair = keyPairCipher.generateKeyPair();
                KeyCache.storeClientKeyPair(ClientKeyPair.newInstance(newKeyPair, this._engineFeatures.getDatabaseName(), ckpName, newCkpId.toString(), algorithmName), this._cseKeyStorePassword);
                try {
                    this._executeInternalStatement("ALTER CLIENTSIDE ENCRYPTION KEYPAIR " + StringUtils.quoteSqlIdentifier(ckpName) + " ADD NEW VERSION ENCODED PUBLIC KEYVALUE '" + Base64Utils.encodePublicKey(newKeyPair.getPublic().getEncoded()) + "' KEYPAIR ID '" + UUIDUtils.toHexString(newCkpId) + "'");
                }
                catch (SQLException e) {
                    try {
                        KeyCache.deleteClientKeyPair(newCkpId.toString(), this._cseKeyStorePassword);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw e;
                }
                keyIdTableName = this._createKeyIdTable(this._cseKeyIDs, true);
                String sql = "CALL SYS.CLIENTSIDE_ENCRYPTION_COLUMN_KEYS_DEV( '" + keyIdTableName + "', '', '', ? )";
                is = InternalStatementSapDB.newInstance(this, StatementSapDB.StatementFlag.INTERNAL_RESULT_SETS);
                irs = (InternalResultSetSapDB)is._executeQuery(sql);
                if (irs == null) {
                    throw SQLExceptionSapDB.newInstance("error.cse.ckpnewversionfailed", "Failed to execute CLIENTSIDE_ENCRYPTION_COLUMN_KEYS_DEV query.");
                }
                ArrayList<String> updatedCekIDs = new ArrayList<String>();
                ArrayList<String> skippedCekIDs = new ArrayList<String>();
                while (irs._next()) {
                    byte[] decryptedCekBytes;
                    String schemaName = irs._getString(1);
                    String cekName = irs._getString(2);
                    UUID cekId = UUIDUtils.newInstance(irs._getBytes(3));
                    byte[] encryptedCekBytes = irs._getBytes(4);
                    UUID ckpId = UUIDUtils.newInstance(irs._getBytes(5));
                    if (updatedCekIDs.contains(cekId.toString())) continue;
                    try {
                        decryptedCekBytes = this._decryptCek(cekId.toString(), encryptedCekBytes, ckpId.toString());
                    }
                    catch (Exception e) {
                        if (skippedCekIDs.contains(cekId.toString())) continue;
                        skippedCekIDs.add(cekId.toString());
                        continue;
                    }
                    byte[] reencryptedCekBytes = this._encryptCek(newKeyPair.getPublic(), decryptedCekBytes);
                    this._sendAddKeyCopyStatement(cekName, schemaName, cekId, ckpName, newCkpId, reencryptedCekBytes);
                    updatedCekIDs.add(cekId.toString());
                    skippedCekIDs.remove(cekId.toString());
                }
                if (skippedCekIDs.size() <= 0) break block29;
                throw SQLExceptionSapDB.newInstance("error.cse.ckpnewversionfailed", "No keypair version found in the local store to decrypt one of the CEK copies");
            }
            catch (Throwable throwable) {
                try {
                    if (irs != null) {
                        irs._close(true, false);
                    }
                    if (is != null) {
                        is._close(true, false);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this._commit();
                if (keyIdTableName != null) {
                    this._dropKeyIdTable(keyIdTableName);
                }
                if (preAutoCommit) {
                    this._setAutoCommit(preAutoCommit);
                }
                if (preDDLAutoCommit) {
                    this._setDDLAutoCommit(true);
                }
                throw throwable;
            }
        }
        try {
            if (irs != null) {
                irs._close(true, false);
            }
            if (is != null) {
                is._close(true, false);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._commit();
        if (keyIdTableName != null) {
            this._dropKeyIdTable(keyIdTableName);
        }
        if (preAutoCommit) {
            this._setAutoCommit(preAutoCommit);
        }
        if (preDDLAutoCommit) {
            this._setDDLAutoCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _createNewColumnEncryptionKeyVersion(String schemaName, String cekName, String algorithmName) throws SQLException {
        boolean preAutoCommit = this._transaction.getAutoCommit();
        boolean preDDLAutoCommit = this._transaction.getDDLAutoCommit();
        String keyIdTableName = null;
        UUID newCekId = UUID.randomUUID();
        StatementSapDB is = null;
        ResultSetSapDB irs = null;
        try {
            if (preAutoCommit) {
                this._setAutoCommit(false);
            } else {
                this._commit();
            }
            if (preDDLAutoCommit) {
                this._setDDLAutoCommit(false);
            }
            CSEBlockCipher cekCipher = CSECipherFactory.getBlockCipher(algorithmName);
            Key newCek = cekCipher.generateKey();
            HashSet<String> cekIdSet = new HashSet<String>();
            String sql = "CALL SYS.CLIENTSIDE_ENCRYPTION_COLUMN_KEYS_DEV( 'DUMMY', " + StringUtils.quoteSqlString(schemaName) + ", " + StringUtils.quoteSqlString(cekName) + ", ? )";
            is = InternalStatementSapDB.newInstance(this, StatementSapDB.StatementFlag.INTERNAL_RESULT_SETS);
            irs = (InternalResultSetSapDB)is._executeQuery(sql);
            if (irs == null) {
                throw SQLExceptionSapDB.newInstance("error.cse.ceknewversionfailed", "Failed to execute CLIENTSIDE_ENCRYPTION_COLUMN_KEYS_DEV query.");
            }
            while (irs._next()) {
                UUID cekId = UUIDUtils.newInstance(irs._getBytes(3));
                cekIdSet.add(cekId.toString());
            }
            keyIdTableName = this._createKeyIdTable(cekIdSet, false);
            ArrayList<String> updatedCkpIDs = new ArrayList<String>();
            boolean needKeyAdmin = true;
            sql = "CALL SYS.CLIENTSIDE_ENCRYPTION_PUBLIC_KEYVALUE_DEV( '" + keyIdTableName + "', '', ? )";
            irs = (InternalResultSetSapDB)is._executeQuery(sql);
            if (irs == null) {
                throw SQLExceptionSapDB.newInstance("error.cse.ceknewversionfailed", "Failed to execute CLIENTSIDE_ENCRYPTION_PUBLIC_KEYVALUE_DEV query.");
            }
            while (irs._next()) {
                byte[] encryptedKey;
                CSEStreamCipher keyPairCipher;
                String ckpName = irs._getString(2);
                UUID ckpId = UUIDUtils.newInstance(irs._getBytes(3));
                String ckpAlgorithmName = irs._getString(4);
                String pemEncodedPublicKeyBytes = irs._getString(5);
                String keyAdminString = irs._getString(6);
                if (needKeyAdmin) {
                    if (!keyAdminString.equalsIgnoreCase("TRUE")) continue;
                    keyPairCipher = CSECipherFactory.getStreamCipher(ckpAlgorithmName);
                    encryptedKey = this._encryptCek(keyPairCipher.generatePublicKeyFromBytes(Base64Utils.decodePublicKey(pemEncodedPublicKeyBytes), ckpAlgorithmName), newCek.getEncoded());
                    String encodedEncryptedKey = Base64Utils.encodeToString(encryptedKey);
                    this._executeInternalStatement("ALTER CLIENTSIDE ENCRYPTION COLUMN KEY " + StringUtils.quoteSqlIdentifier(schemaName) + "." + StringUtils.quoteSqlIdentifier(cekName) + " ADD NEW VERSION ENCRYPTED WITH KEYPAIR " + StringUtils.quoteSqlIdentifier(ckpName) + " KEYPAIR ID '" + UUIDUtils.toHexString(ckpId) + "' ENCRYPTED COLUMN KEYVALUE '" + encodedEncryptedKey + "' COLUMN KEY ID '" + UUIDUtils.toHexString(newCekId) + "'");
                    updatedCkpIDs.add(ckpId.toString());
                    needKeyAdmin = false;
                    irs._close(true, false);
                    irs = (InternalResultSetSapDB)is._executeQuery(sql);
                    if (irs != null) continue;
                    throw SQLExceptionSapDB.newInstance("error.cse.ceknewversionfailed", "Failed to execute CLIENTSIDE_ENCRYPTION_PUBLIC_KEYVALUE_DEV query.");
                }
                if (updatedCkpIDs.contains(ckpId.toString())) continue;
                keyPairCipher = CSECipherFactory.getStreamCipher(ckpAlgorithmName);
                encryptedKey = this._encryptCek(keyPairCipher.generatePublicKeyFromBytes(Base64Utils.decodePublicKey(pemEncodedPublicKeyBytes), ckpAlgorithmName), newCek.getEncoded());
                this._sendAddKeyCopyStatement(cekName, schemaName, newCekId, ckpName, ckpId, encryptedKey);
                updatedCkpIDs.add(ckpId.toString());
            }
            if (needKeyAdmin) {
                throw SQLExceptionSapDB.newInstance("error.cse.ceknewversionfailed", "Did not receive a public key from any key admin.");
            }
            KeyCache.addColumnEncryptionKey(newCekId.toString(), new ColumnEncryptionKey(newCek, this._engineFeatures.getDatabaseName(), cekName, newCekId.toString(), algorithmName));
        }
        catch (Throwable throwable) {
            try {
                if (irs != null) {
                    irs._close(true, false);
                }
                if (is != null) {
                    is._close(true, false);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._commit();
            if (keyIdTableName != null) {
                this._dropKeyIdTable(keyIdTableName);
            }
            if (preAutoCommit) {
                this._setAutoCommit(preAutoCommit);
            }
            if (preDDLAutoCommit) {
                this._setDDLAutoCommit(true);
            }
            throw throwable;
        }
        try {
            if (irs != null) {
                irs._close(true, false);
            }
            if (is != null) {
                is._close(true, false);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._commit();
        if (keyIdTableName != null) {
            this._dropKeyIdTable(keyIdTableName);
        }
        if (preAutoCommit) {
            this._setAutoCommit(preAutoCommit);
        }
        if (preDDLAutoCommit) {
            this._setDDLAutoCommit(true);
        }
    }

    protected synchronized void _setCSEKeyIDs(Set<String> keyIDs) {
        this._cseKeyIDs = keyIDs;
    }

    private void _init() {
        this._sessionPool.releaseAll();
        this._statementContext = null;
        this._outstandingPrefetchResultSet = null;
        this._outstandingPrefetchSession = null;
        this._outstandingPrefetchPassport = null;
        this._outstandingPrefetchPassportConnectionCounter = -1;
        this._prefetchedCachedReplyMap.clear();
    }

    private static List<? extends Address> _buildAddressesList(List<PreferredAddress> preferredAddresses, boolean isConnectionDistributionEnabled, SiteType requestedSiteType, PreferredAddress[] outPreferredAddress) {
        ArrayList mergedAddresses = new ArrayList();
        ArrayList<PublicAddress> bestPublic = null;
        ArrayList<PreferredAddress> bestPreferred = null;
        ArrayList<PublicAddress> standbyPublic = null;
        ArrayList<PreferredAddress> unreachablePreferred = null;
        ArrayList<PublicAddress> unreachablePublic = null;
        ArrayList<PublicAddress> wrongSiteTypePublic = null;
        ArrayList<PublicAddress> tempList = null;
        Topologies.TopologyInfo foundTopologyInfo = null;
        for (PreferredAddress preferredAddress : preferredAddresses) {
            Topologies.TopologyInfo topologyInfo;
            if (Topologies.isUnreachable(preferredAddress)) {
                if (unreachablePreferred == null) {
                    unreachablePreferred = new ArrayList<PreferredAddress>();
                }
                unreachablePreferred.add(preferredAddress);
            } else {
                if (bestPreferred == null) {
                    bestPreferred = new ArrayList<PreferredAddress>();
                }
                bestPreferred.add(preferredAddress);
            }
            if (!isConnectionDistributionEnabled || (topologyInfo = Topologies.getTopologyInfo(preferredAddress)) == null) continue;
            if (foundTopologyInfo == null) {
                foundTopologyInfo = topologyInfo;
                outPreferredAddress[0] = preferredAddress;
                continue;
            }
            if (!SystemInfo.areDifferentSystems(topologyInfo.getSystemInfo(), foundTopologyInfo.getSystemInfo())) continue;
            Topologies.clear();
            return preferredAddresses;
        }
        if (isConnectionDistributionEnabled && foundTopologyInfo != null) {
            int size;
            SiteType siteType = requestedSiteType != SiteType.NONE ? requestedSiteType : foundTopologyInfo.getSiteType();
            for (PublicAddress publicAddress : foundTopologyInfo.getSystemInfo().getAddresses()) {
                if (!publicAddress.isIndexServer() && !publicAddress.isNameServer()) continue;
                if (siteType != SiteType.NONE && !publicAddress.getSiteType().equals(siteType)) {
                    if (wrongSiteTypePublic == null) {
                        wrongSiteTypePublic = new ArrayList<PublicAddress>();
                    }
                    wrongSiteTypePublic.add(publicAddress);
                    continue;
                }
                if (Topologies.isUnreachable(publicAddress)) {
                    if (unreachablePublic == null) {
                        unreachablePublic = new ArrayList<PublicAddress>();
                    }
                    unreachablePublic.add(publicAddress);
                    continue;
                }
                if (publicAddress.isStandby()) {
                    if (standbyPublic == null) {
                        standbyPublic = new ArrayList<PublicAddress>();
                    }
                    standbyPublic.add(publicAddress);
                    continue;
                }
                if (tempList == null) {
                    tempList = new ArrayList<PublicAddress>();
                }
                tempList.add(publicAddress);
            }
            if (tempList != null && (size = tempList.size()) > 0) {
                if (size > 1) {
                    Collections.rotate(tempList, -foundTopologyInfo.getNextAddressCounter() % size);
                }
                if (bestPublic == null) {
                    bestPublic = new ArrayList<PublicAddress>();
                }
                bestPublic.addAll(tempList);
            }
        }
        if (bestPublic != null) {
            mergedAddresses.addAll(bestPublic);
        }
        if (bestPreferred != null) {
            mergedAddresses.addAll(bestPreferred);
        }
        if (standbyPublic != null) {
            mergedAddresses.addAll(standbyPublic);
        }
        if (unreachablePreferred != null) {
            mergedAddresses.addAll(unreachablePreferred);
        }
        if (unreachablePublic != null) {
            mergedAddresses.addAll(unreachablePublic);
        }
        if (wrongSiteTypePublic != null) {
            mergedAddresses.addAll(wrongSiteTypePublic);
        }
        return mergedAddresses;
    }

    private static String _getSessionVariableName(Object key) {
        String keyString;
        String string = keyString = key instanceof String ? (String)key : key.toString();
        if (!keyString.regionMatches(true, 0, "sessionVariable:", 0, ConnectionProperty.SESSION_VARIABLE_PREFIX_LEN)) {
            return null;
        }
        String sessionVariableName = keyString.substring(ConnectionProperty.SESSION_VARIABLE_PREFIX_LEN);
        if (sessionVariableName.isEmpty()) {
            return null;
        }
        return sessionVariableName;
    }

    private static String _getSessionVariableValue(Object value) {
        String sessionVariableValue;
        String string = sessionVariableValue = value instanceof String ? (String)value : value.toString();
        if (sessionVariableValue.isEmpty()) {
            return null;
        }
        return sessionVariableValue;
    }

    private void _refreshMetaData() {
        this._databaseMetaData._getDBInfo();
    }

    private int _getReconnectWaitTimeout() {
        int serverReconnectWaitTimeout = this._serverReconnectWaitTimeout.get();
        if (this._connectionProperties.hasProperty(ConnectionProperty.CLIENT_RECONNECT_WAIT_TIMEOUT) && serverReconnectWaitTimeout != 0) {
            return this._connectionProperties.getIntProperty(ConnectionProperty.CLIENT_RECONNECT_WAIT_TIMEOUT);
        }
        return serverReconnectWaitTimeout;
    }

    private HReplyPacket _receiveOutstandingPrefetch(Session session, ResultSetSapDB resultSet, SAPPassport passport, int passportConnectionCounter) throws SQLException {
        this._outstandingPrefetchResultSet = null;
        this._outstandingPrefetchSession = null;
        this._outstandingPrefetchPassport = null;
        this._outstandingPrefetchPassportConnectionCounter = -1;
        HReplyPacket replyPacket = this.receive(session, MessageType.FetchNext, resultSet.getStatementSapDB(), passport, passportConnectionCounter, new ExchangeFlag[0]);
        return replyPacket;
    }

    private static int _getResultSetHoldabilityForConnectionPropertyValue(String value) {
        if (value == null || value.isEmpty()) {
            return 1;
        }
        int resultSetHoldability = value.equalsIgnoreCase("COMMIT") ? 1 : (value.equalsIgnoreCase("NONE") ? 2 : (value.equalsIgnoreCase("ROLLBACK") ? 1000001 : (value.equalsIgnoreCase("COMMIT_AND_ROLLBACK") ? 1000002 : 1)));
        return resultSetHoldability;
    }

    private static int _getJdbcIsolationLevelForConnectionPropertyValue(String value) {
        int jdbcIsolationLevel;
        block7: {
            if (value == null || value.isEmpty()) {
                return 2;
            }
            jdbcIsolationLevel = -1;
            try {
                jdbcIsolationLevel = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                if (value.equalsIgnoreCase("TRANSACTION_READ_UNCOMMITTED")) {
                    jdbcIsolationLevel = 1;
                }
                if (value.equalsIgnoreCase("TRANSACTION_READ_COMMITTED")) {
                    jdbcIsolationLevel = 2;
                }
                if (value.equalsIgnoreCase("TRANSACTION_REPEATABLE_READ")) {
                    jdbcIsolationLevel = 4;
                }
                if (!value.equalsIgnoreCase("TRANSACTION_SERIALIZABLE")) break block7;
                jdbcIsolationLevel = 8;
            }
        }
        if (jdbcIsolationLevel >= 1 && jdbcIsolationLevel <= 8) {
            return jdbcIsolationLevel;
        }
        return 1;
    }

    private HRequestPacket _getRequestPacket(Session session) {
        HRequestPacket requestPacket = this._packetPool.isEmpty() ? session.newRequestPacket() : this._packetPool.pop();
        return requestPacket;
    }

    private HRequestPacket _getRequestPacket(Session session, int packetSize) {
        if (packetSize == this._packetSize) {
            return this._getRequestPacket(session);
        }
        return session.newRequestPacket(packetSize);
    }

    private void _freeRequestPacket(HRequestPacket requestPacket) {
        if (requestPacket.isPooled()) {
            this._packetPool.push(requestPacket);
        }
    }

    private void _setAutoCommit(boolean autoCommit) throws SQLException {
        this._assertOpen();
        if (autoCommit && !this._transaction.getAutoCommit()) {
            this._commitInternal();
        }
        this._transaction.setAutoCommit(autoCommit);
    }

    private void _setReadOnly(boolean isReadOnly, boolean force) throws SQLException {
        if (!force && this._isReadOnlyModeTransactionFlagSent && this._isReadOnly == isReadOnly) {
            return;
        }
        this._assertOpen();
        this._executeInternalStatement("SET TRANSACTION " + (isReadOnly ? "READ ONLY" : "READ WRITE"));
        if (!this._isReadOnlyModeTransactionFlagSent) {
            this._isReadOnly = isReadOnly;
        }
    }

    private void _setTransactionIsolation(int isolationLevel) throws SQLException {
        this._executeTransactionIsolation(isolationLevel, null);
    }

    private void _executeTransactionIsolation(int isolationLevel, Session session) throws SQLException {
        this._assertOpen();
        this._executeInternalStatement("SET TRANSACTION ISOLATION LEVEL " + ConnectionSapDB.getSQLForJdbcIsolationLevel(isolationLevel), session);
    }

    private void _setDDLAutoCommit(boolean ddlAutoCommit) throws SQLException {
        this._executeDDLAutoCommit(ddlAutoCommit, null);
    }

    private void _executeDDLAutoCommit(boolean ddlAutoCommit, Session session) throws SQLException {
        this._assertOpen();
        this._executeInternalStatement("SET TRANSACTION AUTOCOMMIT DDL " + (ddlAutoCommit ? "ON" : "OFF"), session);
    }

    private void _setCurrentSchema(String schema) throws SQLException {
        this._assertOpen();
        boolean isDoubleQuoted = schema != null && schema.startsWith("\"") && schema.endsWith("\"");
        String schemaArgument = this.getBooleanConnectionProperty(ConnectionProperty.QUOTE_CURRENT_SCHEMA) && !isDoubleQuoted ? "\"" + schema.replaceAll("\"", "\"\"") + "\"" : schema;
        this._executeInternalStatement("SET SCHEMA " + schemaArgument);
    }

    private void _lockClientKeypair(String ckpName) throws SQLException {
        this._executeInternalStatement("LOCK CLIENTSIDE ENCRYPTION KEYPAIR " + StringUtils.quoteSqlIdentifier(ckpName));
    }

    private String _createKeyIdTable(Set<String> keyIDs, boolean isKeyPairTable) throws SQLException {
        String tableName = this.getCurrentUserFromServer();
        tableName = tableName == null ? "" : tableName + ".";
        tableName = tableName + "__KEYIDS_" + UUIDUtils.toHexString(UUID.randomUUID());
        this._executeInternalStatement("CREATE ROW TABLE " + tableName + " ( " + (isKeyPairTable ? "ENCRYPTED_WITH_KEYPAIR_ID" : "COLUMN_ENCRYPTION_KEY_ID") + " VARCHAR(32) )");
        InternalCallableStatementSapDB ps = InternalCallableStatementSapDB.newInstance(this, "INSERT INTO " + tableName + " VALUES( ? )", new StatementSapDB.StatementFlag[0]);
        int BATCH_SIZE = 10000;
        int curCount = 0;
        for (String keyId : keyIDs) {
            ps._setObject(1, UUIDUtils.toHexString(keyId));
            ps._addBatch();
            if (++curCount != 10000) continue;
            ps._executeBatch();
            curCount = 0;
        }
        if (curCount > 0) {
            ps._executeBatch();
        }
        this._commit();
        return tableName;
    }

    private void _dropKeyIdTable(String tableName) throws SQLException {
        try {
            this._executeInternalStatement("DROP TABLE " + tableName);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private InternalCallableStatementSapDB _createTransformSelectStmt(String schemaName, String tableName, List<ColumnReencryptInfo> reencryptColumns, List<String> primaryKey) throws SQLException {
        StringBuilder sql = new StringBuilder();
        boolean firstColumn = true;
        sql.append("SELECT TOP ").append(this._connectionProperties.getIntProperty(ConnectionProperty.COLUMN_TRANSFORMATION_BATCH_SIZE)).append(" ");
        for (ColumnReencryptInfo colInfo : reencryptColumns) {
            if (!firstColumn) {
                sql.append(", ");
            }
            firstColumn = false;
            sql.append(StringUtils.quoteSqlIdentifier(colInfo.getColumnName()));
        }
        for (String pColName : primaryKey) {
            sql.append(", ").append(StringUtils.quoteSqlIdentifier(pColName));
        }
        sql.append(" FROM ").append(StringUtils.quoteSqlIdentifier(schemaName)).append(".").append(StringUtils.quoteSqlIdentifier(tableName));
        firstColumn = true;
        sql.append(" WHERE ");
        for (ColumnReencryptInfo colInfo : reencryptColumns) {
            if (!firstColumn) {
                sql.append(" OR ");
            }
            firstColumn = false;
            String colName = StringUtils.quoteSqlIdentifier(colInfo.getTrackingColumnName());
            sql.append(colName).append(" IS NULL OR ").append(colName).append(" <> TRUE");
        }
        return InternalCallableStatementSapDB.newInstance(this, sql.toString(), StatementSapDB.StatementFlag.INTERNAL_RESULT_SETS);
    }

    private InternalCallableStatementSapDB _createTransformUpdateStmt(String schemaName, String tableName, List<ColumnReencryptInfo> reencryptColumns, List<String> primaryKey) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(StringUtils.quoteSqlIdentifier(schemaName)).append(".").append(StringUtils.quoteSqlIdentifier(tableName)).append(" SET ");
        boolean firstColumn = true;
        for (ColumnReencryptInfo colInfo : reencryptColumns) {
            if (!firstColumn) {
                sql.append(", ");
            }
            firstColumn = false;
            sql.append(StringUtils.quoteSqlIdentifier(colInfo.getHiddenColumnName())).append(" = ?, ").append(StringUtils.quoteSqlIdentifier(colInfo.getTrackingColumnName())).append(" = TRUE");
        }
        sql.append(" WHERE ");
        firstColumn = true;
        for (String pColName : primaryKey) {
            if (!firstColumn) {
                sql.append(" AND ");
            }
            firstColumn = false;
            sql.append(StringUtils.quoteSqlIdentifier(pColName)).append(" = ?");
        }
        return InternalCallableStatementSapDB.newInstance(this, sql.toString(), new StatementSapDB.StatementFlag[0]);
    }

    private DatabaseMetaData _getMetaData() throws SQLException {
        this._assertOpen();
        return this._databaseMetaData;
    }

    private void _addWarning(SQLWarning warning) {
        if (this._warnings == null) {
            this._warnings = warning;
        } else {
            this._warnings.setNextWarning(warning);
        }
    }

    private void _commit() throws SQLException {
        this._assertOpen();
        if (this.isAutoCommit()) {
            throw SQLExceptionSapDB.newInstance("error.connection.autocommit", new String[0]);
        }
        this._commitInternal();
    }

    private void _rollback() throws SQLException {
        this._assertOpen();
        if (this.isAutoCommit()) {
            throw SQLExceptionSapDB.newInstance("error.connection.autocommit", new String[0]);
        }
        this._rollbackInternal();
    }

    private Savepoint _setSavepoint(String name) throws SQLException {
        this._assertOpen();
        if (this.isAutoCommit()) {
            throw SQLExceptionSapDB.newInstance("error.connection.autocommit", new String[0]);
        }
        HanaSavepoint savepoint = new HanaSavepoint(this, ++this._savepointCount, name);
        this._executeInternalStatement("SAVEPOINT " + StringUtils.quoteSqlIdentifier(savepoint._getName()));
        this._transaction.setSavepoint(savepoint);
        return savepoint;
    }

    private void _rollbackToSavepoint(Savepoint savepoint) throws SQLException {
        this._assertOpen();
        if (this.isAutoCommit()) {
            throw SQLExceptionSapDB.newInstance("error.connection.autocommit", new String[0]);
        }
        String name = savepoint instanceof SavepointSapDB ? ((SavepointSapDB)savepoint)._getName() : savepoint.getSavepointName();
        SavepointSapDB sp = this._transaction.getSavepoint(name);
        if (sp != null && sp != savepoint) {
            throw SQLExceptionSapDB.newInstance("error.invalid.savepoint", name);
        }
        this._executeInternalStatement("ROLLBACK TO SAVEPOINT " + StringUtils.quoteSqlIdentifier(name));
    }

    private void _releaseSavepoint(Savepoint savepoint) throws SQLException {
        this._assertOpen();
        if (this.isAutoCommit()) {
            throw SQLExceptionSapDB.newInstance("error.connection.autocommit", new String[0]);
        }
        String name = savepoint instanceof SavepointSapDB ? ((SavepointSapDB)savepoint)._getName() : savepoint.getSavepointName();
        SavepointSapDB sp = this._transaction.getSavepoint(name);
        if (sp != null && sp != savepoint) {
            throw SQLExceptionSapDB.newInstance("error.invalid.savepoint", name);
        }
        this._executeInternalStatement("RELEASE SAVEPOINT " + StringUtils.quoteSqlIdentifier(name));
    }

    private boolean _isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue", String.valueOf(timeout));
        }
        if (this._isClosed()) {
            return false;
        }
        try {
            Session session = this._sessionPool.getPrimarySession();
            HRequestPacket requestPacket = this.initExecuteDirect(session, 2, timeout, "SELECT 'PING' FROM SYS.DUMMY", null, 0, false, false);
            this.exchange(session, requestPacket, null, ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
        }
        catch (InternalReconnectException e) {
            Session session = e.getNewSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.objectisclosed", this.toString());
            }
            return this._isValid(timeout);
        }
        catch (InternalFallbackSecondaryException e) {
            Session session = this._sessionPool.getAnchorSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.objectisclosed", this.toString());
            }
            return this._isValid(timeout);
        }
        catch (SQLException exc) {
            this._close();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _send(Session session, HRequestPacket requestPacket, ExchangeFlag ... exchangeFlags) throws SQLException {
        block11: {
            if (this._outstandingPrefetchResultSet != null) {
                ResultSetSapDB outstandingPrefetchResultSet = this._outstandingPrefetchResultSet;
                try {
                    HReplyPacket replyPacket = this._receiveOutstandingPrefetch(this._outstandingPrefetchSession, outstandingPrefetchResultSet, this._outstandingPrefetchPassport, this._outstandingPrefetchPassportConnectionCounter);
                    this._prefetchedCachedReplyMap.put(outstandingPrefetchResultSet, replyPacket);
                }
                catch (SQLException e) {
                    this._prefetchedCachedReplyMap.put(outstandingPrefetchResultSet, e);
                    if (!e.getSQLState().equals("HY000") || e.getErrorCode() != 139) break block11;
                    throw e;
                }
            }
        }
        EnumSet<ExchangeFlag> flags = exchangeFlags.length > 0 ? EnumSet.copyOf(Arrays.asList(exchangeFlags)) : EnumSet.noneOf(ExchangeFlag.class);
        try {
            this._tracer.checkTraceSettings();
            requestPacket.setStatementContextAndProfileTimes(this._statementContext, session.getSendTime(), session.getReceiveTime());
            if (requestPacket.setPassportConnectionCounter(this._passportConnectionCounter)) {
                ++this._passportConnectionCounter;
            }
            this._sentBytes.getAndAdd(requestPacket.getLength());
            session.send(requestPacket, this._engineFeatures);
            session.setSentAsPartOfTransaction();
        }
        catch (RTEException e) {
            this._handleSendReceiveException(e, session, requestPacket.getMessageType(), null, flags, false);
        }
        finally {
            if (flags.contains((Object)ExchangeFlag.IS_PREPARED_EXECUTE) && session.isNoneOrPrimarySite()) {
                this._sessionPool.setLastPreparedExecuteSessionForNoneOrPrimarySite(session);
            }
            if (requestPacket != null) {
                this._freeRequestPacket(requestPacket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HReplyPacket _receive(Session session, MessageType messageType, StatementSapDB statement, SAPPassport passport, int passportConnectionCounter, ExchangeFlag ... exchangeFlags) throws SQLException {
        if (this._outstandingPrefetchResultSet != null) {
            throw SQLExceptionSapDB.newInstance("error.resultset.invalidprefetch", new String[0]);
        }
        EnumSet<ExchangeFlag> flags = exchangeFlags.length > 0 ? EnumSet.copyOf(Arrays.asList(exchangeFlags)) : EnumSet.noneOf(ExchangeFlag.class);
        boolean isStatement = flags.contains((Object)ExchangeFlag.IS_STATEMENT);
        boolean isPrepareOnly = flags.contains((Object)ExchangeFlag.IS_PREPARE_ONLY);
        boolean ignoreErrors = flags.contains((Object)ExchangeFlag.IGNORE_ERRORS);
        HReplyPacket replyPacket = null;
        SQLException sqlExceptionChain = null;
        HOptionsPart transFlags = null;
        HOptionsPart scpart = null;
        HOptionsPart topoPart = null;
        HOptionsPart connectOptionsPart = null;
        boolean serverFallbackFlag = false;
        boolean serverForceReroute = false;
        PassportListener passportListener = this._passportListener.get();
        FunctionCode functionCode = statement != null ? statement._getFunctionCode() : null;
        try {
            block92: {
                try {
                    this._tracer.checkTraceSettings();
                    replyPacket = session.receive(this._engineFeatures);
                    this._receivedBytes.getAndAdd(replyPacket.getLength());
                    functionCode = replyPacket.getFunctionCode(0);
                    for (HPartInfo partInfo : replyPacket.parts(0)) {
                        switch (partInfo.getPartKind()) {
                            case Error: {
                                sqlExceptionChain = partInfo.getSQLExceptionChain(this);
                                break;
                            }
                            case TransactionID: {
                                this._transaction.setTransactionID(replyPacket.findTransactionID(0, this._transaction.getTransactionID()));
                                break;
                            }
                            case TransactionFlags: {
                                transFlags = partInfo.getOptionsPart();
                                break;
                            }
                            case StatementContext: {
                                scpart = partInfo.getOptionsPart();
                                break;
                            }
                            case TopologyInformation: {
                                if (this._isIgnoringTopology) break;
                                topoPart = partInfo.getMultiLineOptionsPart();
                                break;
                            }
                            case ConnectOptions: {
                                connectOptionsPart = partInfo.getOptionsPart();
                                break;
                            }
                            case SessionVariable: {
                                this._cacheSessionVariables(partInfo.getSessionVariables());
                                break;
                            }
                            case PartitionInformation: {
                                SystemInfo systemInfo;
                                if (this._isIgnoringTopology || messageType != MessageType.Execute || !(statement instanceof PreparedStatementSapDB) || (systemInfo = this._sessionPool.getSystemInfo()) == null) break;
                                ParseInfo parseInfo = ((PreparedStatementSapDB)statement).getParseInfo();
                                parseInfo.addPartitionInformationNode(partInfo, systemInfo.getSiteIDToSiteTypeMap());
                                break;
                            }
                            case TableLocation: {
                                SystemInfo systemInfo;
                                if (this._isIgnoringTopology || messageType != MessageType.Execute || !(statement instanceof PreparedStatementSapDB) || (systemInfo = this._sessionPool.getSystemInfo()) == null) break;
                                ParseInfo parseInfo = ((PreparedStatementSapDB)statement).getParseInfo();
                                parseInfo.setTableLocations(partInfo.getTableLocations(systemInfo.getSiteIDToSiteTypeMap()));
                            }
                        }
                    }
                    if (passportListener != null) {
                        this._passportServerKPIs.clearAll();
                        for (HSegmentInfo segmentInfo : replyPacket.segments()) {
                            this._passportServerKPIs.accumulate(segmentInfo.findStatementContextPart());
                        }
                    }
                    if (connectOptionsPart != null) {
                        this._engineFeatures = new EngineFeatures(connectOptionsPart);
                        this._isReadOnlyModeTransactionFlagSent = ConnectionSapDB._isReadOnlyModeTransactionFlagSent(this._engineFeatures.getServerVersionString());
                        this._supportIdlePing.set(this._engineFeatures.supportIdlePing());
                        this._supportIdlePingDuringRequest.set(this._engineFeatures.supportIdlePingDuringRequest());
                        this._serverReconnectWaitTimeout.set(this._engineFeatures.getReconnectWaitTimeout());
                        String databaseName = this._connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME);
                        if (this._redirectionType != RedirectionType.TenantWithAZAware && (databaseName == null || databaseName.isEmpty()) && !this._engineFeatures.getDatabaseName().isEmpty()) {
                            this._connectionProperties.setProperty(ConnectionProperty.DATABASE_NAME, this._engineFeatures.getDatabaseName());
                        }
                        if (!this._isIgnoringTopology) {
                            this._distributionMode = this._engineFeatures.getDistributionMode();
                        }
                        if (this._sessionPool.getAnchorSession() == null && this._engineFeatures.getClientSideEncryptionVersion().getValue() >= ClientSideEncryptionVersion.Level1.getValue() && ConnectionSapDB._isServerAffectedByBug163474(this._engineFeatures.getServerVersionString())) {
                            this._connectionProperties.setProperty(ConnectionProperty.CLIENT_SIDE_ENCRYPTION_VERSION, String.valueOf(ClientSideEncryptionVersion.Unsupported.getValue()));
                            if (!this._tracer.on()) throw new InternalConnectException(InternalConnectException.Reason.CSE_BUG_163474);
                            this._tracer.printConnectionMessage(this, "Reconnecting with client-side encryption disabled", new String[0]);
                            throw new InternalConnectException(InternalConnectException.Reason.CSE_BUG_163474);
                        }
                    }
                    if (topoPart != null) {
                        if (topoPart.getArgumentCount() > 0) {
                            this._processTopologyPart(session, (HMultiLineOptionsPart)topoPart, connectOptionsPart != null);
                        } else {
                            this._isIgnoringTopology = true;
                            this._distributionMode = DistributionMode.Off;
                        }
                    }
                    if (scpart != null) {
                        block47: do {
                            switch (StatementContextOption.decode(scpart.getOptionName())) {
                                case StatementSequenceInfo: {
                                    this._statementContext = scpart.getOptionBinaryValue(this._statementContext);
                                    break;
                                }
                                case SchemaName: {
                                    this._currentSchema = scpart.getOptionStringValue();
                                    this._cacheSessionVariables(Collections.singletonMap("_SYS_DEFAULT_SCHEMA", this._currentSchema));
                                    this._cacheOnSchemaChange();
                                    break;
                                }
                                case FlagSet: {
                                    if ((scpart.getOptionTinyIntValue() & StatementContextFlag.ActiveActive_FallbackRouting.getValue()) == 0 || !session.isHintRouted()) continue block47;
                                    serverFallbackFlag = true;
                                    break;
                                }
                                case ClientReconnectionWaitTimeout: {
                                    this._serverReconnectWaitTimeout.set(scpart.getOptionIntValue());
                                }
                            }
                        } while (scpart.nextOption());
                    }
                    boolean doClearTransaction = false;
                    boolean doCloseCursorsAtCommit = false;
                    boolean doClosePendingPreparedStatementsAndResultSets = false;
                    boolean doIncrementRollbackCount = false;
                    TransactionState newTransactionState = null;
                    boolean doAddSessionToTransaction = false;
                    boolean doRefreshMetaData = false;
                    boolean doPropagateIsolationLevelSetting = false;
                    boolean doPropagateDDLAutoCommitSetting = false;
                    if (transFlags != null) {
                        boolean commit = false;
                        boolean rollback = false;
                        boolean writeTrans = false;
                        boolean noWriteTrans = false;
                        block48: do {
                            switch (TransactionFlag.decode(transFlags.getOptionName())) {
                                case Committed: {
                                    if (!transFlags.getOptionBooleanValue()) break;
                                    commit = true;
                                    break;
                                }
                                case RolledBack: {
                                    if (!transFlags.getOptionBooleanValue()) break;
                                    rollback = true;
                                    break;
                                }
                                case NewIsolationLevel: {
                                    if (this._isPropogatingIsolationLevelSetting) break;
                                    int oldValue = this._isolationLevel;
                                    int newValue = ConnectionSapDB.getJdbcIsolationLevelForHanaIsolationLevel(transFlags.getOptionIntValue());
                                    if (newValue == oldValue) continue block48;
                                    this._isolationLevel = newValue;
                                    doPropagateIsolationLevelSetting = true;
                                    break;
                                }
                                case DDLCommitModeChanged: {
                                    if (this._isPropogatingDDLAutoCommitSetting) break;
                                    int oldValue = this._transaction.getDDLAutoCommit() ? 1 : 0;
                                    int newValue = transFlags.getOptionBooleanValue() ? 1 : 0;
                                    if (newValue == oldValue) continue block48;
                                    this._transaction.setDDLAutoCommit(newValue != 0);
                                    doPropagateDDLAutoCommitSetting = true;
                                    break;
                                }
                                case WriteTransactionStarted: {
                                    if (!transFlags.getOptionBooleanValue()) break;
                                    writeTrans = true;
                                    break;
                                }
                                case NoWriteTransactionStarted: {
                                    if (!transFlags.getOptionBooleanValue()) break;
                                    noWriteTrans = true;
                                    break;
                                }
                                case SessionClosingTransactionError: {
                                    session.destroy();
                                    throw RTEException.newInstance(this._tracer, MessageTranslator.translate("error.data.receivefailed.reason", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                                }
                                case ReadOnlyMode: {
                                    this._isReadOnly = transFlags.getOptionBooleanValue();
                                }
                            }
                        } while (transFlags.nextOption());
                        if (commit) {
                            doClearTransaction = true;
                            doCloseCursorsAtCommit = true;
                            doClosePendingPreparedStatementsAndResultSets = true;
                        } else if (rollback) {
                            doClearTransaction = true;
                            doIncrementRollbackCount = true;
                            doClosePendingPreparedStatementsAndResultSets = true;
                        }
                        if (writeTrans) {
                            newTransactionState = TransactionState.WriteTransaction;
                        } else if (noWriteTrans) {
                            newTransactionState = TransactionState.ReadTransaction;
                        }
                        if ((commit || rollback) && (writeTrans || noWriteTrans)) {
                            doAddSessionToTransaction = true;
                        }
                    } else if (!(this.isAutoCommit() || isPrepareOnly || this._transaction.isWriteTransaction())) {
                        newTransactionState = this._transaction.getNewTransactionState(session, functionCode);
                    }
                    if (!isPrepareOnly) {
                        switch (functionCode) {
                            case Connect: {
                                this._sessionPool.releaseAllHintRouted();
                                if (this._transaction.getDDLAutoCommit()) {
                                    doClearTransaction = true;
                                    doCloseCursorsAtCommit = true;
                                    doClosePendingPreparedStatementsAndResultSets = true;
                                }
                                doRefreshMetaData = true;
                                break;
                            }
                            case Commit: {
                                if (this._tracer.on()) {
                                    this._tracer.printDistributionState(this, "Commit Tx " + this._transaction.getDisplayTransactionID());
                                }
                                doClearTransaction = true;
                                doCloseCursorsAtCommit = true;
                                doClosePendingPreparedStatementsAndResultSets = true;
                                break;
                            }
                            case Rollback: {
                                if (this._tracer.on()) {
                                    this._tracer.printDistributionState(this, "Rollback Tx " + this._transaction.getDisplayTransactionID());
                                }
                                doClearTransaction = true;
                                doClosePendingPreparedStatementsAndResultSets = true;
                                doIncrementRollbackCount = true;
                            }
                        }
                    }
                    if (isStatement && this.isAutoCommit()) {
                        doClearTransaction = true;
                        doCloseCursorsAtCommit = true;
                        doClosePendingPreparedStatementsAndResultSets = true;
                        newTransactionState = null;
                    }
                    if (doClearTransaction) {
                        this._transaction.clearTransaction(false);
                    }
                    if (doCloseCursorsAtCommit) {
                        this._closeCursorsAtCommit();
                    }
                    if (doClosePendingPreparedStatementsAndResultSets) {
                        this._closePendingPreparedStatementsAndResultSets(true);
                    }
                    if (doIncrementRollbackCount) {
                        ++this._rollbackCount;
                    }
                    if (newTransactionState != null) {
                        this._transaction.setTransactionState(session, newTransactionState);
                    }
                    if (doAddSessionToTransaction) {
                        this._transaction.addSessionToTransaction(session);
                    }
                    if (doRefreshMetaData) {
                        this._refreshMetaData();
                    }
                    if (doPropagateIsolationLevelSetting) {
                        try {
                            this._isPropogatingIsolationLevelSetting = true;
                            this._executeTransactionIsolation(this._isolationLevel, session);
                        }
                        finally {
                            this._isPropogatingIsolationLevelSetting = false;
                        }
                    }
                    if (!doPropagateDDLAutoCommitSetting) break block92;
                    try {
                        this._isPropogatingDDLAutoCommitSetting = true;
                        this._executeDDLAutoCommit(this._transaction.getDDLAutoCommit(), session);
                    }
                    finally {
                        this._isPropogatingDDLAutoCommitSetting = false;
                    }
                }
                catch (RTEException e) {
                    this._handleSendReceiveException(e, session, messageType, functionCode, flags, true);
                }
                finally {
                    if (sqlExceptionChain != null) {
                        if (sqlExceptionChain instanceof SQLWarning) {
                            this._addWarning((SQLWarning)sqlExceptionChain);
                        } else if (sqlExceptionChain.getErrorCode() == 1040) {
                            serverForceReroute = true;
                        } else {
                            if (this._transaction.getAutoCommit()) {
                                ++this._rollbackCount;
                            }
                            if (!ignoreErrors) {
                                throw sqlExceptionChain;
                            }
                        }
                    }
                }
            }
            if (serverForceReroute) {
                throw new InternalForceRerouteException(sqlExceptionChain);
            }
            if (serverFallbackFlag) {
                throw new InternalFallbackHintRoutedException(FALLBACK_FLAG);
            }
            if (passportListener == null) return replyPacket;
        }
        catch (Throwable throwable) {
            if (passportListener == null) throw throwable;
            APIMetrics.getInstance().handleReceivedPacket(passportListener, new PassportListener.PacketInfo(messageType, statement != null ? statement.getSQL() : null, statement != null ? HexUtils.toHexString(statement.getSQLHash()) : null, this._passportServerKPIs.getServerProcessingTime(), this._passportServerKPIs.getServerCPUTime(), this._passportServerKPIs.getServerMemoryUsage(), passport, passportConnectionCounter));
            throw throwable;
        }
        APIMetrics.getInstance().handleReceivedPacket(passportListener, new PassportListener.PacketInfo(messageType, statement != null ? statement.getSQL() : null, statement != null ? HexUtils.toHexString(statement.getSQLHash()) : null, this._passportServerKPIs.getServerProcessingTime(), this._passportServerKPIs.getServerCPUTime(), this._passportServerKPIs.getServerMemoryUsage(), passport, passportConnectionCounter));
        return replyPacket;
    }

    private static boolean _isServerAffectedByBug163474(String serverVersion) {
        return serverVersion.startsWith("2.00.01") || serverVersion.startsWith("2.00.02");
    }

    private static boolean _isReadOnlyModeTransactionFlagSent(String serverVersion) {
        int idx = serverVersion.indexOf(46);
        return idx != -1 && Integer.parseInt(serverVersion.substring(0, idx)) >= 2;
    }

    private void _processTopologyPart(Session session, HMultiLineOptionsPart topologyPart, boolean isConnectReply) throws SQLException {
        DistributionMode clientDistributionMode;
        byte newSecondarySiteID;
        byte oldSecondarySiteID;
        PublicAddress publicAddress;
        Address sessionAddress = session.getAddress();
        boolean isPublicAddress = sessionAddress instanceof PublicAddress;
        PublicAddress ownAddress = SystemInfo.getOwnAddress(topologyPart);
        boolean isAnchorConnectReply = isConnectReply && this._sessionPool.getAnchorSession() == null;
        String sidAndDatabaseName = this._getSidAndDatabaseName();
        boolean staleTopologyAssumed = false;
        if (this.getBooleanConnectionProperty(ConnectionProperty._TEST_SIMULATE_INVALID_TOPOLOGY) || ownAddress == null) {
            if (this._tracer.on()) {
                this._tracer.printSessionMessage(session, "Invalid topology (no own address) detected: Ignoring topology", "Cached:   " + sessionAddress.getPort());
            }
            this._isIgnoringTopology = true;
            this._distributionMode = DistributionMode.Off;
            return;
        }
        if (isPublicAddress) {
            publicAddress = (PublicAddress)sessionAddress;
            if (isConnectReply) {
                Session anchorSession;
                if (!publicAddress.getSystemInfo().getSidAndDatabaseName().equals(sidAndDatabaseName)) {
                    if (this._tracer.on()) {
                        this._tracer.printSessionMessage(session, "SID+DatabaseName mismatch: Assuming stale topology", "Cached:   " + publicAddress.getSystemInfo().getSidAndDatabaseName(), "Received: " + sidAndDatabaseName);
                    }
                    staleTopologyAssumed = true;
                }
                if (!publicAddress.getSiteType().equals(ownAddress.getSiteType())) {
                    if (this._tracer.on()) {
                        this._tracer.printSessionMessage(session, "SiteType mismatch: Assuming stale topology and releasing all hint-routed sessions", "Cached:   " + publicAddress.getSiteType(), "Received: " + ownAddress.getSiteType());
                    }
                    staleTopologyAssumed = true;
                    this._sessionPool.releaseAllHintRouted();
                }
                if (publicAddress.getSiteVolumeID().getVolumeID() != ownAddress.getSiteVolumeID().getVolumeID()) {
                    if (this._tracer.on()) {
                        this._tracer.printSessionMessage(session, "VolumeID mismatch: Assuming stale topology", "Cached:   " + publicAddress.getSiteVolumeID().getVolumeID(), "Received: " + ownAddress.getSiteVolumeID().getVolumeID());
                    }
                    staleTopologyAssumed = true;
                }
                if (!isAnchorConnectReply && (anchorSession = this._sessionPool.getAnchorSession()) != null) {
                    if (anchorSession.isNoneOrPrimarySite() && session.isSecondarySite()) {
                        session.setHintRouted(true);
                    } else if (anchorSession.isSecondarySite() && session.isNoneOrPrimarySite()) {
                        if (this._tracer.on()) {
                            this._tracer.printSessionMessage(session, "Invalid routing: Assuming stale topology", "Anchor:    " + anchorSession.getTraceString(true, true), "Secondary: " + session.getTraceString(true, true));
                        }
                        staleTopologyAssumed = true;
                    }
                }
                if (staleTopologyAssumed) {
                    Topologies.clear();
                    throw new InternalConnectException(InternalConnectException.Reason.STALE_TOPOLOGY_ASSUMED);
                }
            }
            if (publicAddress.getSiteVolumeID().getSiteID() != ownAddress.getSiteVolumeID().getSiteID()) {
                if (this._tracer.on()) {
                    this._tracer.printSessionMessage(session, "Site ID mismatch: Releasing all hint-routed sessions", "Cached:   " + publicAddress.getSiteVolumeID().getSiteID(), "Received: " + ownAddress.getSiteVolumeID().getSiteID());
                }
                this._sessionPool.releaseAllHintRouted();
            }
        }
        if (this.getBooleanConnectionProperty(ConnectionProperty._TEST_SIMULATE_PORT_FORWARDING) || ownAddress.getPort() != sessionAddress.getPort()) {
            SiteType siteType;
            if (this._tracer.on()) {
                this._tracer.printSessionMessage(session, "Port-forwarding detected: Ignoring topology", "Cached:   " + sessionAddress.getPort(), "Received: " + ownAddress.getPort());
            }
            if ((siteType = SiteType.decode(this._connectionProperties.getProperty(ConnectionProperty.SITE_TYPE))) == SiteType.PRIMARY || siteType == SiteType.SECONDARY) {
                throw SQLExceptionSapDB.newInstance("error.connection.invalidproperties", "siteType", "port-forwarding");
            }
            this._isIgnoringTopology = true;
            this._distributionMode = DistributionMode.Off;
            return;
        }
        PublicAddress[] outOwnAddress = new PublicAddress[1];
        SystemInfo systemInfo = new SystemInfo(sidAndDatabaseName, topologyPart, outOwnAddress);
        ownAddress = outOwnAddress[0];
        SystemInfo oldSystemInfo = this._sessionPool.setSystemInfo(systemInfo);
        if (oldSystemInfo != null && (oldSecondarySiteID = oldSystemInfo.getSiteID(SiteType.SECONDARY)) != -1 && (newSecondarySiteID = systemInfo.getSiteID(SiteType.SECONDARY)) != oldSecondarySiteID) {
            if (this._tracer.on()) {
                this._tracer.printSessionMessage(session, "Secondary Site ID changed: Releasing all hint-routed sessions", "Old Secondary Site ID: " + oldSecondarySiteID, "New Secondary Site ID: " + newSecondarySiteID);
            }
            this._sessionPool.releaseAllHintRouted();
        }
        if (isAnchorConnectReply && (clientDistributionMode = DistributionMode.decode(this._connectionProperties.getProperty(ConnectionProperty.DISTRIBUTION))).isConnectionDistribution() && !this._engineFeatures.getDistributionMode().isConnectionDistribution() && systemInfo.getPerSiteIndexServerCount() > 1) {
            this._connectionProperties.setProperty(ConnectionProperty.DISTRIBUTION, DistributionMode.withoutConnectionDistribution(clientDistributionMode).name());
            if (this._tracer.on()) {
                this._tracer.printConnectionMessage(this, "Reconnecting with connection distribution disabled", new String[0]);
            }
            throw new InternalConnectException(InternalConnectException.Reason.CONNECTION_DISTRIBUTION_DISABLED);
        }
        this._sessionPool._setSessionPublicAddress(session, ownAddress);
        for (Map.Entry<SiteTypeVolumeID, Session> entry : this._sessionPool.getSessions().entrySet()) {
            SiteTypeVolumeID siteTypeVolumeID = entry.getKey();
            Session aSession = entry.getValue();
            if (aSession == session) continue;
            publicAddress = systemInfo.getAddress(siteTypeVolumeID);
            if (publicAddress != null) {
                this._sessionPool._setSessionPublicAddress(aSession, publicAddress);
                continue;
            }
            if (!this._tracer.on()) continue;
            this._tracer.printSessionMessage(session, "No public address for SiteTypeVolumeID " + entry.getKey(), new String[0]);
        }
        if (this._distributionMode.isConnectionDistribution()) {
            PreferredAddress preferredAddress;
            if (isPublicAddress) {
                publicAddress = (PublicAddress)sessionAddress;
                preferredAddress = Topologies.getPreferredAddress(publicAddress);
            } else {
                preferredAddress = (PreferredAddress)sessionAddress;
                publicAddress = ownAddress;
                Topologies.setPreferredAddress(publicAddress, preferredAddress);
            }
            if (preferredAddress != null) {
                Topologies.setTopologyInfo(preferredAddress, systemInfo, ownAddress.getSiteType());
            }
        }
    }

    private String _getSidAndDatabaseName() {
        String sid = this._engineFeatures.getSystemID();
        String databaseName = this._engineFeatures.getDatabaseName();
        if (databaseName == null || databaseName.isEmpty()) {
            databaseName = this._connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME);
        }
        String sidAndDatabaseName = databaseName != null && !databaseName.isEmpty() ? sid + databaseName : sid;
        return sidAndDatabaseName;
    }

    private void _handleSendReceiveException(RTEException e, Session session, MessageType messageType, FunctionCode functionCode, Set<ExchangeFlag> flags, boolean receiveFailed) throws SQLException {
        SendReceiveExceptionAction action;
        Session anchorSession = this._sessionPool.getAnchorSession();
        boolean isSecondarySession = anchorSession != null && anchorSession.isConnected() && session != anchorSession;
        boolean isHintRouted = session.isHintRouted();
        boolean isForceRoute = flags.contains((Object)ExchangeFlag.FORCE_ROUTE_NO_FALLBACK);
        boolean allowReconnectOrFallback = flags.contains((Object)ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
        if (isHintRouted && isForceRoute) {
            action = SendReceiveExceptionAction.FALLBACK_NOT_ALLOWED;
        } else if (isHintRouted && allowReconnectOrFallback) {
            action = SendReceiveExceptionAction.FALLBACK_HINT_ROUTED;
        } else if (!(!allowReconnectOrFallback || this._isInReconnect.get() || this._connectionProperties.getIntProperty(ConnectionProperty.COMMUNICATION_TIMEOUT) != 0 && e.isTimeoutError() || e.isDecompressError() || e.isInvalidPacketError() || this._transaction.isWriteTransaction() && session.isPartOfTransaction() && session.hasSentAsPartOfTransaction() || this._isolationLevel != 2)) {
            boolean doSecondarySessionFallback = false;
            if (isSecondarySession) {
                switch (messageType) {
                    case ExecuteDirect: {
                        doSecondarySessionFallback = !receiveFailed;
                        break;
                    }
                    case Execute: {
                        if (receiveFailed) {
                            doSecondarySessionFallback = functionCode == FunctionCode.Select;
                            break;
                        }
                        doSecondarySessionFallback = true;
                        break;
                    }
                    case Prepare: 
                    case Commit: 
                    case Rollback: 
                    case DropStatementID: 
                    case CloseResultSet: {
                        doSecondarySessionFallback = true;
                        break;
                    }
                    default: {
                        doSecondarySessionFallback = false;
                    }
                }
            }
            if (doSecondarySessionFallback) {
                action = SendReceiveExceptionAction.FALLBACK_SECONDARY;
            } else if (this.getBooleanConnectionProperty(ConnectionProperty.RECONNECT) && this._getReconnectWaitTimeout() != 0) {
                boolean doReconnect;
                switch (messageType) {
                    case Execute: {
                        if (receiveFailed) {
                            doReconnect = functionCode == FunctionCode.Select;
                            break;
                        }
                        doReconnect = true;
                        break;
                    }
                    case Prepare: 
                    case Commit: 
                    case Rollback: 
                    case DropStatementID: 
                    case CloseResultSet: {
                        doReconnect = true;
                        break;
                    }
                    default: {
                        doReconnect = !receiveFailed;
                    }
                }
                action = doReconnect ? SendReceiveExceptionAction.RECONNECT : SendReceiveExceptionAction.DISCONNECT;
            } else {
                action = SendReceiveExceptionAction.DISCONNECT;
            }
        } else if (isSecondarySession) {
            switch (messageType) {
                case Authenticate: 
                case Connect: {
                    action = SendReceiveExceptionAction.DISCONNECT_SECONDARY;
                    break;
                }
                default: {
                    action = SendReceiveExceptionAction.DISCONNECT;
                    break;
                }
            }
        } else {
            action = SendReceiveExceptionAction.DISCONNECT;
        }
        if (this._sendReceiveExceptionActions != null) {
            this._sendReceiveExceptionActions.add(action);
        }
        switch (action) {
            case FALLBACK_NOT_ALLOWED: {
                this._sessionPool.releaseAllHintRouted();
                throw SQLExceptionSapDB.newInstance("error.force.route.fallbacknotallowed", new String[0]);
            }
            case FALLBACK_HINT_ROUTED: {
                this._handleFailedHintRouted();
                this._sessionPool.releaseAllHintRouted();
                throw new InternalFallbackHintRoutedException(e);
            }
            case FALLBACK_SECONDARY: {
                this._handleFailedStatementRouted(this.getSessionPool().getSessionSiteTypeVolumeID(session));
                this._sessionPool.releaseSecondary(session);
                throw new InternalFallbackSecondaryException(e);
            }
            case RECONNECT: {
                this._sessionPool.releaseAll();
                this._tryReconnect(e, this._sessionPool.getAnchorSession());
                break;
            }
            case DISCONNECT_SECONDARY: {
                this._sessionPool.releaseSecondary(session);
                throw ConnectionException.createException(e);
            }
            case DISCONNECT: {
                this._sessionPool.releaseAll();
                throw ConnectionException.createException(e);
            }
            default: {
                throw new AssertionError((Object)("Unexpected action: " + (Object)((Object)action)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session _authenticateAndConnectSession(SessionFactory factory, Session session, boolean isAnchorSession) throws RTEException, SQLException {
        try {
            String passwd;
            AbstractAuthenticationManager authenticationManager;
            if (this.getBooleanConnectionProperty(ConnectionProperty.NATIVE_AUTHENTICATION)) {
                try {
                    authenticationManager = new NativeAuthenticationManagerImpl();
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == -11204) {
                        if (this._tracer.on()) {
                            this._tracer.printDebugThrowable(e, "Cannot load native authentication library");
                        }
                        authenticationManager = new AuthenticationManager();
                    }
                    throw e;
                }
            } else {
                authenticationManager = new AuthenticationManager();
            }
            String userName = this._connectionProperties.getProperty(ConnectionProperty.USER);
            if (userName == null) {
                userName = "";
            }
            passwd = (passwd = this._connectionProperties.getProperty(ConnectionProperty.PASSWD)) == null ? "" : StringUtils.stripPasswd(passwd);
            String authenticationMethods = this._connectionProperties.getProperty(ConnectionProperty.AUTHENTICATION_METHODS);
            Set<AuthenticationMethodType> authMethods = AuthenticationMethodType.decode(authenticationMethods);
            String x509 = this._connectionProperties.getProperty(ConnectionProperty.AUTHENTICATION_X509);
            if (authMethods.contains((Object)AuthenticationMethodType.X509)) {
                if (x509 != null && !x509.isEmpty()) {
                    if (!x509.startsWith("-----BEGIN")) {
                        try {
                            x509 = FileUtils.readString(x509, StandardCharsets.UTF_8);
                        }
                        catch (IOException e) {
                            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.x509.readfile", e.getMessage());
                        }
                    }
                } else {
                    x509 = this._connectionProperties.getProperty(ConnectionProperty.SSL_KEY_STORE);
                }
            }
            if (isAnchorSession) {
                this._init();
            }
            session = authenticationManager.authenticate(factory, this, session, isAnchorSession, userName, passwd, x509, authMethods);
            authenticationManager.connect(this, session, userName, passwd, x509);
            this._lastAuthenticationMethodName.set(authenticationManager.getMethodName());
            int sessionTimeout = this._calculateSessionTimeout(this._networkTimeout);
            session.setTimeout(sessionTimeout);
            session.setConnectionID(this._engineFeatures.getConnectionID());
            this._sessionPool.addSession(session);
            if (this._tracer.on()) {
                this._tracer.printSessionOpened(session);
                if (!isAnchorSession) {
                    this._tracer.printDistributionState(this, "New session added");
                }
            }
            if (isAnchorSession || !this._engineFeatures.supportSessionContextPartOnConnect()) {
                session.setSendSessionContextFlag();
            }
            if (this._sessionVariables._hasProperties()) {
                session.setSendSessionVariablesFlag();
            }
            if (this._clientInfo._hasProperties()) {
                session.setSendClientInfoFlag();
            }
            if (this._isReadOnly) {
                this._setReadOnly(true, true);
            }
            if (this._isolationLevel != 2) {
                this._setTransactionIsolation(this._isolationLevel);
            }
            if (!(this._currentSchema == null || this._currentSchema.isEmpty() || this._currentSchema.equals(this._defaultSchema) || session.isHintRouted())) {
                boolean tempDDLCommitted = this._transaction.getDDLAutoCommit();
                try {
                    this._transaction.setDDLAutoCommit(false);
                    this._setCurrentSchema(this._currentSchema);
                }
                finally {
                    this._transaction.setDDLAutoCommit(tempDDLCommitted);
                }
            }
            if (!this._transaction.getDDLAutoCommit()) {
                this._setDDLAutoCommit(false);
            }
        }
        catch (SQLException e) {
            session.destroy();
            throw e;
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _tryReconnect(RTEException outerRteExc, Session anchorSession) throws SQLException {
        Session newSession = null;
        try {
            Address anchorAddress;
            this._isInReconnect.set(true);
            SiteType anchorSiteType = anchorSession != null && (anchorAddress = anchorSession.getAddress()) instanceof PublicAddress ? ((PublicAddress)anchorAddress).getSiteType() : SiteType.decode(this._connectionProperties.getProperty(ConnectionProperty.SITE_TYPE));
            this._transaction.clearTransaction(true);
            this.reinitialize(false, false);
            long reconnectWaitTimeout = (long)this._getReconnectWaitTimeout() * 1000L;
            long start = System.currentTimeMillis();
            while (true) {
                try {
                    newSession = this._connectAnchor(true, anchorSiteType);
                }
                catch (RTEException | SQLException e) {
                    if (reconnectWaitTimeout < 0L) {
                    } else {
                        long elapsedTime = System.currentTimeMillis() - start;
                        if (this._doSleep(elapsedTime, reconnectWaitTimeout, outerRteExc)) {
                            if (elapsedTime < reconnectWaitTimeout) continue;
                        }
                    }
                }
                break;
            }
        }
        finally {
            this._isInReconnect.set(false);
            this._cancelReconnect.set(false);
        }
        if (newSession == null || !newSession.isConnected()) {
            throw ConnectionException.createException(outerRteExc);
        }
        throw new InternalReconnectException(outerRteExc, newSession);
    }

    private boolean _doSleep(long elapsedTime, long reconnectWaitTimeout, RTEException outerRteExc) throws SQLException {
        if (elapsedTime < reconnectWaitTimeout) {
            if (this._cancelReconnect.get()) {
                throw ConnectionException.createException(outerRteExc);
            }
            long sleepTime = Math.min(reconnectWaitTimeout - elapsedTime, 1000L);
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void _initClientInfoFromProperties(boolean clear) throws SQLException {
        if (clear) {
            this._setClientInfo(new Properties());
        }
        this._setClientInfo("APPLICATION", this._connectionProperties.getProperty(ConnectionProperty.APPLICATION));
        this._setClientInfo("APPLICATIONUSER", this._connectionProperties.getProperty(ConnectionProperty.APPLICATIONUSER));
        this._setClientInfo("DRIVERVERSION", Driver.getVersionInfo().toShortVersionNumberString());
        for (Map.Entry<Object, Object> entry : this._info.entrySet()) {
            String sessionVariableValue;
            String sessionVariableName = ConnectionSapDB._getSessionVariableName(entry.getKey());
            if (sessionVariableName == null || (sessionVariableValue = ConnectionSapDB._getSessionVariableValue(entry.getValue())) == null) continue;
            this._setClientInfo(sessionVariableName, sessionVariableValue);
        }
    }

    private void _cacheSessionVariables(Map<String, String> map) {
        this._sessionVariables._updateProperties(map);
        this._sessionPool.setSendSessionVariablesFlag();
    }

    private void _executeInternalStatement(String sql) throws SQLException {
        this._executeInternalStatement(sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _executeInternalStatement(String sql, Session excludeSession) throws SQLException {
        InternalStatementSapDB is = InternalStatementSapDB.newInstance(this, new StatementSapDB.StatementFlag[0]);
        try {
            if (excludeSession != null) {
                is._executeUpdateOnAllOtherSessions(sql, excludeSession);
            } else {
                is._executeUpdate(sql);
            }
        }
        finally {
            try {
                is._close(true, false);
            }
            catch (SQLException sQLException) {}
        }
    }

    private ColumnEncryptionKey _retrieveColumnEncryptionKey(String cekId, String ckpId) throws SQLException {
        byte[] encryptedCekBytes;
        String algorithmName;
        block16: {
            this._assertOpen();
            StatementSapDB is = null;
            ResultSetSapDB irs = null;
            try {
                String sql = "CALL SYS.CLIENTSIDE_ENCRYPTION_COLUMN_KEYVALUE_DEV( '" + UUIDUtils.toHexString(cekId) + "', '" + UUIDUtils.toHexString(ckpId) + "', ? )";
                is = InternalStatementSapDB.newInstance(this, StatementSapDB.StatementFlag.INTERNAL_RESULT_SETS);
                irs = (InternalResultSetSapDB)is._executeQuery(sql);
                if (irs != null && irs._next()) {
                    algorithmName = irs._getString(1);
                    encryptedCekBytes = irs._getBytes(2);
                    break block16;
                }
                throw SQLExceptionSapDB.newInstance("error.columnencryptionkeynotfound", ckpId);
            }
            catch (SQLException e) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.columnencryptionkeynotfound", ckpId);
            }
            finally {
                if (irs != null) {
                    try {
                        irs._close(true, false);
                    }
                    catch (SQLException sQLException) {}
                }
                if (is != null) {
                    try {
                        is._close(true, false);
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        Key privateKey = this._retrieveClientPrivateKey(ckpId);
        CSEStreamCipher keypairCipher = CSECipherFactory.getStreamCipher(privateKey);
        byte[] decryptedCekBytes = keypairCipher.decrypt(privateKey, encryptedCekBytes);
        CSEBlockCipher blockCipher = CSECipherFactory.getBlockCipher(algorithmName);
        ColumnEncryptionKey columnEncryptionKey = new ColumnEncryptionKey(blockCipher.getKey(decryptedCekBytes, algorithmName), this._engineFeatures.getDatabaseName(), "", cekId, algorithmName);
        KeyCache.addColumnEncryptionKey(cekId, columnEncryptionKey);
        return columnEncryptionKey;
    }

    private ClientKeyPair _retrievePublicKey(String ckpName, String algorithmName) throws SQLException {
        String pemEncodedPublicKeyBytes;
        UUID ckpId;
        block12: {
            this._assertOpen();
            StatementSapDB is = null;
            ResultSetSapDB irs = null;
            try {
                String sql = "CALL SYS.CLIENTSIDE_ENCRYPTION_PUBLIC_KEYVALUE_DEV( 'DUMMY', " + StringUtils.quoteSqlString(ckpName) + ", ? )";
                is = InternalStatementSapDB.newInstance(this, StatementSapDB.StatementFlag.INTERNAL_RESULT_SETS);
                irs = (InternalResultSetSapDB)is._executeQuery(sql);
                if (irs != null && irs._next()) {
                    ckpId = UUIDUtils.newInstance(irs._getBytes(1));
                    pemEncodedPublicKeyBytes = irs._getString(2);
                    break block12;
                }
                throw SQLExceptionSapDB.newInstance("error.encrypt.failed", "Failed to retrieve public key from the server");
            }
            catch (SQLException e) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", "Failed to retrieve public key from the server");
            }
            finally {
                try {
                    if (irs != null) {
                        irs._close(true, false);
                    }
                    if (is != null) {
                        is._close(true, false);
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        byte[] publicKeyBytes = Base64Utils.decodePublicKey(pemEncodedPublicKeyBytes);
        return ClientKeyPair.newInstance(publicKeyBytes, null, null, ckpName, ckpId.toString(), algorithmName);
    }

    private byte[] _decryptCek(String cekId, byte[] encryptedCekBytes, String ckpId) throws SQLException {
        ColumnEncryptionKey cek = KeyCache.getCachedColumnEncryptionKey(cekId, this._cseKeyStorePassword);
        if (cek != null) {
            return cek.getKey().getEncoded();
        }
        Key privateKey = this._retrieveClientPrivateKey(ckpId);
        CSEStreamCipher keypairCipher = CSECipherFactory.getStreamCipher(privateKey);
        return keypairCipher.decrypt(privateKey, encryptedCekBytes);
    }

    private byte[] _encryptCek(PublicKey publicKey, byte[] unencryptedCekBytes) throws SQLException {
        CSEStreamCipher keyPairCipher = CSECipherFactory.getStreamCipher(publicKey);
        return keyPairCipher.encrypt(publicKey, unencryptedCekBytes);
    }

    private void _sendAddKeyCopyStatement(String cekName, String schemaName, UUID cekId, String ckpName, UUID ckpId, byte[] encryptedCekBytes) throws SQLException {
        this._sendAddKeyCopyStatement(cekName, schemaName, UUIDUtils.toHexString(cekId), ckpName, UUIDUtils.toHexString(ckpId), encryptedCekBytes);
    }

    private void _sendAddKeyCopyStatement(String cekName, String schemaName, String cekId, String ckpName, String ckpId, byte[] encryptedCekBytes) throws SQLException {
        String encodedEncryptedKey = Base64Utils.encodeToString(encryptedCekBytes);
        this._executeInternalStatement("ALTER CLIENTSIDE ENCRYPTION COLUMN KEY " + StringUtils.quoteSqlIdentifier(schemaName) + "." + StringUtils.quoteSqlIdentifier(cekName) + " ADD KEYCOPY ENCRYPTED WITH KEYPAIR " + StringUtils.quoteSqlIdentifier(ckpName) + " KEYPAIR ID '" + UUIDUtils.toHexString(ckpId) + "' ENCRYPTED COLUMN KEYVALUE '" + encodedEncryptedKey + "' COLUMN KEY ID '" + UUIDUtils.toHexString(cekId) + "'");
    }

    private void _storeClientKeyPair(String ckpName, String algorithmName, UUID uuid, KeyPair keyPair) throws SQLException {
        this._assertOpen();
        KeyCache.storeClientKeyPair(ClientKeyPair.newInstance(keyPair, this._engineFeatures.getDatabaseName(), ckpName, uuid.toString(), algorithmName), this._cseKeyStorePassword);
        try {
            this._executeInternalStatement("CREATE CLIENTSIDE ENCRYPTION KEYPAIR " + StringUtils.quoteSqlIdentifier(ckpName) + " ALGORITHM '" + algorithmName + "' ENCODED PUBLIC KEYVALUE '" + Base64Utils.encodePublicKey(keyPair.getPublic().getEncoded()) + "' KEYPAIR ID '" + UUIDUtils.toHexString(uuid) + "'");
        }
        catch (SQLException e) {
            try {
                KeyCache.deleteClientKeyPair(uuid.toString(), this._cseKeyStorePassword);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    private Key _retrieveClientPublicKey(String uuid) throws SQLException {
        return KeyCache.getCachedPublicClientKey(uuid, this._cseKeyStorePassword);
    }

    private Key _retrieveClientPrivateKey(String uuid) throws SQLException {
        return KeyCache.getCachedPrivateClientKey(uuid, this._cseKeyStorePassword);
    }

    private void _saveAndAlterAutoCommitForGlobalTransaction() {
        boolean autoCommit;
        this._savedAutoCommitForGlobalTransaction = autoCommit = this._transaction.getAutoCommit();
        if (autoCommit) {
            this._transaction.setAutoCommit(false);
        }
    }

    private void _restoreAutoCommitForGlobalTransaction() {
        boolean autoCommit = this._transaction.getAutoCommit();
        if (autoCommit != this._savedAutoCommitForGlobalTransaction) {
            this._transaction.setAutoCommit(this._savedAutoCommitForGlobalTransaction);
        }
    }

    private int _getNetworkTimeout() throws SQLException {
        return this._networkTimeout;
    }

    private void _setNetworkTimeout(int milliseconds) throws SQLException {
        this._networkTimeout = milliseconds;
        int sessionTimeout = this._calculateSessionTimeout(milliseconds);
        for (Session session : this._sessionPool.getSessions().values()) {
            session.setTimeout(sessionTimeout);
        }
    }

    private int _calculateSessionTimeout(int milliseconds) {
        int lrrPingTime = this.getEngineFeatures().getLRRPingTime();
        int sessionTimeout = lrrPingTime > 0 && milliseconds > 0 ? Math.min(milliseconds, lrrPingTime * 1000 * 4) : milliseconds;
        return sessionTimeout;
    }

    public synchronized int getMessageID() {
        Session anchorSession = this._sessionPool.getAnchorSession();
        return anchorSession != null ? anchorSession.getMessageID() : -1;
    }

    public synchronized void clearPacketPool() {
        this._packetPool.clear();
    }

    public synchronized Transaction getTransaction() {
        return this._transaction;
    }

    public synchronized int getSavepointCount() {
        return this._transaction.getSavepointCount();
    }

    public synchronized boolean isPrefetchReplyPacketCached(ResultSetSapDB resultSet) {
        return this._prefetchedCachedReplyMap.get(resultSet) instanceof HReplyPacket;
    }

    public synchronized boolean isPrefetchErrorCached(ResultSetSapDB resultSet) {
        return this._prefetchedCachedReplyMap.get(resultSet) instanceof SQLException;
    }

    public synchronized int prefetchedCachedReplyMapSize() {
        return this._prefetchedCachedReplyMap.size();
    }

    public synchronized SQLException getPrefetchCachedError(ResultSetSapDB resultSet) {
        Object object = this._prefetchedCachedReplyMap.get(resultSet);
        return object instanceof SQLException ? (SQLException)object : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PreparedStatementSapDB> getPreparedStatementsClosePending() {
        Set<PreparedStatementSapDB> set = this._preparedStatementsClosePending;
        synchronized (set) {
            return new HashSet<PreparedStatementSapDB>(this._preparedStatementsClosePending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResultSetSapDB> getResultSetsClosePending() {
        Set<ResultSetSapDB> set = this._resultSetsClosePending;
        synchronized (set) {
            return new HashSet<ResultSetSapDB>(this._resultSetsClosePending);
        }
    }

    public synchronized Map<Session, List<ParseID>> getQueuedForLazyDrop() {
        return this._queuedForLazyDrop;
    }

    public synchronized int getCurrentCacheSize() {
        return this._statementCache != null ? this._statementCache.getCurrentCacheSize() : -1;
    }

    public synchronized int getCurrentTrackSize() {
        return this._statementCache != null ? this._statementCache.getCurrentTrackSize() : -1;
    }

    public synchronized boolean isCached(String sql) {
        return this._statementCache != null && this._statementCache.isCached(sql);
    }

    public synchronized boolean isCached(ParseInfo parseInfo) {
        return this._statementCache != null && this._statementCache.isCached(parseInfo);
    }

    public synchronized boolean isTracked(String sql) {
        return this._statementCache != null && this._statementCache.isTracked(sql);
    }

    public synchronized List<SendReceiveExceptionAction> getSendReceiveExceptionActions() {
        return this._sendReceiveExceptionActions;
    }

    public synchronized void clearSendReceiveExceptionActions() {
        this._sendReceiveExceptionActions.clear();
    }

    public synchronized boolean isSecondaryReady() {
        return this._isSecondarySiteReady();
    }

    public int getSecondaryConnectionAttemptCount() {
        if (this._secondaryConnectionAttemptCount != null) {
            return this._secondaryConnectionAttemptCount.get();
        }
        return -1;
    }

    public void clearSecondaryConnectionAttemptCount() {
        if (this._secondaryConnectionAttemptCount != null) {
            this._secondaryConnectionAttemptCount.set(0);
        }
    }

    public String getLastAuthenticationMethodName() {
        return this._lastAuthenticationMethodName.get();
    }

    public UUID getPassportConnectionUUID() {
        return this._passportConnectionUUID;
    }

    private static class HeartbeatTask
    extends TimerTask {
        private final WeakReference<ConnectionSapDB> _connection;
        private final String _connectionToString;

        private HeartbeatTask(ConnectionSapDB connection) {
            this._connection = new WeakReference<ConnectionSapDB>(connection);
            this._connectionToString = connection.toString();
        }

        @Override
        public void run() {
            ConnectionSapDB connection = (ConnectionSapDB)this._connection.get();
            if (connection == null) {
                Driver._removeHeartbeatTask(this._connectionToString + ": garbage collected", this);
                return;
            }
            connection.sendPings();
        }
    }

    public static enum SendReceiveExceptionAction {
        FALLBACK_NOT_ALLOWED,
        FALLBACK_HINT_ROUTED,
        FALLBACK_SECONDARY,
        RECONNECT,
        DISCONNECT_SECONDARY,
        DISCONNECT;

    }

    public static enum ExchangeFlag {
        NOP,
        IS_STATEMENT,
        IS_PREPARED_EXECUTE,
        IS_PREPARE_ONLY,
        IGNORE_ERRORS,
        ALLOW_RECONNECT_OR_FALLBACK,
        FORCE_ROUTE_NO_FALLBACK;

    }
}

