/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.FetchInfo;
import com.sap.db.jdbc.HanaResultSet;
import com.sap.db.jdbc.HanaResultSetClean;
import com.sap.db.jdbc.HanaResultSetFinalize;
import com.sap.db.jdbc.HanaResultSetPhantom;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.trace.TraceRecord;
import java.sql.SQLException;
import java.util.regex.Pattern;

@ThreadSafe
public interface StatementSapDB9Interface {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    default public String enquoteLiteral(ConnectionSapDB connectionSapDB, StatementSapDB statementSapDB, String string) throws SQLException {
        boolean bl = statementSapDB._tracer.on();
        boolean bl2 = statementSapDB._tracer.pon();
        boolean bl3 = bl ? statementSapDB._tracer.aon() : false;
        TraceRecord traceRecord = bl2 ? statementSapDB._newTraceRecord("Statement", "enquoteLiteral") : null;
        try {
            String string2;
            if (bl) {
                statementSapDB._tracer.printCall(this, "enquoteLiteral", string);
            }
            try {
                if (bl3) {
                    connectionSapDB.apiStart();
                }
                string2 = "'" + string.replace("'", "''") + "'";
            }
            finally {
                if (bl3) {
                    connectionSapDB.apiFinish();
                }
            }
            if (bl) {
                statementSapDB._tracer.printResult(string2);
            }
            String string3 = string2;
            return string3;
        }
        catch (Throwable throwable) {
            if (bl) {
                statementSapDB._tracer.printException(throwable);
            }
            if (bl2) {
                traceRecord.setException(throwable);
            }
            throw throwable;
        }
        finally {
            if (bl2) {
                statementSapDB._publish(traceRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    default public String enquoteNCharLiteral(ConnectionSapDB connectionSapDB, StatementSapDB statementSapDB, String string) throws SQLException {
        boolean bl = statementSapDB._tracer.on();
        boolean bl2 = statementSapDB._tracer.pon();
        boolean bl3 = bl ? statementSapDB._tracer.aon() : false;
        TraceRecord traceRecord = bl2 ? statementSapDB._newTraceRecord("Statement", "enquoteNCharLiteral") : null;
        try {
            String string2;
            if (bl) {
                statementSapDB._tracer.printCall(this, "enquoteNCharLiteral", string);
            }
            try {
                if (bl3) {
                    connectionSapDB.apiStart();
                }
                string2 = "N'" + string.replace("'", "''") + "'";
            }
            finally {
                if (bl3) {
                    connectionSapDB.apiFinish();
                }
            }
            if (bl) {
                statementSapDB._tracer.printResult(string2);
            }
            String string3 = string2;
            return string3;
        }
        catch (Throwable throwable) {
            if (bl) {
                statementSapDB._tracer.printException(throwable);
            }
            if (bl2) {
                traceRecord.setException(throwable);
            }
            throw throwable;
        }
        finally {
            if (bl2) {
                statementSapDB._publish(traceRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    default public String enquoteIdentifier(ConnectionSapDB connectionSapDB, StatementSapDB statementSapDB, String string, boolean bl) throws SQLException {
        boolean bl2 = statementSapDB._tracer.on();
        boolean bl3 = statementSapDB._tracer.pon();
        boolean bl4 = bl2 ? statementSapDB._tracer.aon() : false;
        TraceRecord traceRecord = bl3 ? statementSapDB._newTraceRecord("Statement", "enquoteIdentifier") : null;
        try {
            Object object;
            block19: {
                if (bl2) {
                    statementSapDB._tracer.printCall(this, "enquoteIdentifier", string, bl);
                }
                try {
                    int n;
                    if (bl4) {
                        connectionSapDB.apiStart();
                    }
                    if ((n = string.length()) < 1 || n > 127) {
                        throw new SQLException("Invalid name");
                    }
                    if (Pattern.compile("[\\p{Alpha}][\\p{Alnum}_]*").matcher(string).matches()) {
                        object = bl ? "\"" + string + "\"" : string;
                        break block19;
                    }
                    if (string.matches("^\".+\"$")) {
                        string = string.substring(1, n - 1);
                    }
                    if (Pattern.compile("[^\u0000\"]+").matcher(string).matches()) {
                        object = "\"" + string + "\"";
                        break block19;
                    }
                    throw new SQLException("Invalid name");
                }
                finally {
                    if (bl4) {
                        connectionSapDB.apiFinish();
                    }
                }
            }
            if (bl2) {
                statementSapDB._tracer.printResult(object);
            }
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable) {
            if (bl2) {
                statementSapDB._tracer.printException(throwable);
            }
            if (bl3) {
                traceRecord.setException(throwable);
            }
            throw throwable;
        }
        finally {
            if (bl3) {
                statementSapDB._publish(traceRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    default public boolean isSimpleIdentifier(ConnectionSapDB connectionSapDB, StatementSapDB statementSapDB, String string) throws SQLException {
        boolean bl = statementSapDB._tracer.on();
        boolean bl2 = statementSapDB._tracer.pon();
        boolean bl3 = bl ? statementSapDB._tracer.aon() : false;
        TraceRecord traceRecord = bl2 ? statementSapDB._newTraceRecord("Statement", "isSimpleIdentifier") : null;
        try {
            boolean bl4;
            boolean bl5;
            if (bl) {
                statementSapDB._tracer.printCall(this, "isSimpleIdentifier", string);
            }
            try {
                if (bl3) {
                    connectionSapDB.apiStart();
                }
                bl4 = (bl5 = string.length()) >= true && bl5 <= 127 != 0 && Pattern.compile("[\\p{Alpha}][\\p{Alnum}_]*").matcher(string).matches();
            }
            finally {
                if (bl3) {
                    connectionSapDB.apiFinish();
                }
            }
            if (bl) {
                statementSapDB._tracer.printResult(bl4);
            }
            bl5 = bl4;
            return bl5;
        }
        catch (Throwable throwable) {
            if (bl) {
                statementSapDB._tracer.printException(throwable);
            }
            if (bl2) {
                traceRecord.setException(throwable);
            }
            throw throwable;
        }
        finally {
            if (bl2) {
                statementSapDB._publish(traceRecord);
            }
        }
    }

    default public void _createResultSet(StatementSapDB statementSapDB, Session session, FetchInfo fetchInfo, boolean bl, HDataPart hDataPart, ConnectionProperties connectionProperties) throws SQLException {
        ConnectionSapDB connectionSapDB = statementSapDB._connection;
        if (Driver._createPhantomClass(connectionProperties)) {
            HanaResultSetPhantom.newInstance(connectionSapDB.getTracer(), connectionSapDB, session, statementSapDB, fetchInfo, bl, hDataPart);
        } else if (Driver._createCleanerClass(connectionProperties)) {
            HanaResultSetClean.newInstance(connectionSapDB.getTracer(), connectionSapDB, session, statementSapDB, fetchInfo, bl, hDataPart);
        } else if (Driver._createFinalizerClass(connectionProperties)) {
            HanaResultSetFinalize.newInstance(connectionSapDB.getTracer(), connectionSapDB, session, statementSapDB, fetchInfo, bl, hDataPart);
        } else {
            HanaResultSet.newInstance(connectionSapDB.getTracer(), connectionSapDB, session, statementSapDB, fetchInfo, bl, hDataPart);
        }
    }
}

