/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

@Immutable
public enum ConnectOptionFlagSet1 {
    HoldCursorOverRollbackSupported(1),
    SupportDropStatementIDPart(2),
    SupportFullCompileOnPrepare(4),
    Support32BitFetchSize(8),
    SupportSessionContextOnSecondary(16),
    SupportSavepointSQL(32),
    SupportDeferredPrepare(64),
    SupportImplicitXAJoinOnPrepare(128),
    SupportSessionContextPartOnConnect(256),
    SupportInputTableParameter(512),
    SupportIdlePing(1024),
    SupportIdlePingDuringRequest(2048),
    LobLocator0FullValueOK(4096),
    SupportClientRoutingInfo(8192),
    DisabledClientRouting_IgnoreTopology(16384),
    SupportForceReroute(32768);

    private static final ConnectOptionFlagSet1[] VALUES;
    private final int _value;

    public static Set<ConnectOptionFlagSet1> decode(int value) {
        EnumSet<ConnectOptionFlagSet1> flags = EnumSet.noneOf(ConnectOptionFlagSet1.class);
        for (ConnectOptionFlagSet1 flag : VALUES) {
            if ((value & flag.getValue()) == 0) continue;
            flags.add(flag);
        }
        return flags;
    }

    public static String getDisplayString(int value) {
        Set<ConnectOptionFlagSet1> flags = ConnectOptionFlagSet1.decode(value);
        return value + (flags.isEmpty() ? "(none)" : Arrays.toString(flags.toArray()));
    }

    private ConnectOptionFlagSet1(int value) {
        if (Integer.numberOfTrailingZeros(value) != this.ordinal()) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
        this._value = value;
    }

    public int getValue() {
        return this._value;
    }

    static {
        VALUES = ConnectOptionFlagSet1.values();
    }
}

