/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.jdbc.packet.StatementContextOption;

@ThreadSafe
class ServerKPIs {
    @GuardedBy(value="this")
    private long _serverProcessingTime;
    @GuardedBy(value="this")
    private long _serverCPUTime;
    @GuardedBy(value="this")
    private long _serverMemoryUsage;
    @GuardedBy(value="this")
    private int _resetCount;
    @GuardedBy(value="this")
    private int _accumulateCount;

    ServerKPIs() {
    }

    synchronized long getServerProcessingTime() {
        return this._serverProcessingTime;
    }

    synchronized long getServerCPUTime() {
        return this._serverCPUTime;
    }

    synchronized long getServerMemoryUsage() {
        return this._serverMemoryUsage;
    }

    synchronized void reset() {
        this._serverProcessingTime = 0L;
        this._serverCPUTime = 0L;
        this._serverMemoryUsage = 0L;
        ++this._resetCount;
    }

    synchronized void accumulate(HOptionsPart statementContextPart) {
        if (statementContextPart == null) {
            return;
        }
        do {
            switch (StatementContextOption.decode(statementContextPart.getOptionName())) {
                case ServerProcessingTime: {
                    long value = statementContextPart.getOptionLongValue();
                    if (value == -1L) break;
                    this._serverProcessingTime += value;
                    break;
                }
                case ServerCPUTime: {
                    long value = statementContextPart.getOptionLongValue();
                    this._serverCPUTime += value;
                    break;
                }
                case ServerMemoryUsage: {
                    long value = statementContextPart.getOptionLongValue();
                    if (value <= this._serverMemoryUsage) break;
                    this._serverMemoryUsage = value;
                }
            }
        } while (statementContextPart.nextOption());
        ++this._accumulateCount;
    }

    synchronized int getResetCount() {
        return this._resetCount;
    }

    synchronized int getAccumulateCount() {
        return this._accumulateCount;
    }

    synchronized void clearAll() {
        this._serverProcessingTime = 0L;
        this._serverCPUTime = 0L;
        this._serverMemoryUsage = 0L;
        this._resetCount = 0;
        this._accumulateCount = 0;
    }
}

