/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnReencryptInfo;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.FetchInfo;
import com.sap.db.jdbc.HanaResultSet;
import com.sap.db.jdbc.HanaResultSetFinalize;
import com.sap.db.jdbc.HanaResultSetPhantom;
import com.sap.db.jdbc.InternalCallableStatementSapDB;
import com.sap.db.jdbc.InternalPreparedStatementSapDB;
import com.sap.db.jdbc.InternalResultSetSapDB;
import com.sap.db.jdbc.InternalStatementSapDB;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PassportListener;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.ServerKPIs;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.db.jdbc.exceptions.InternalFallbackSecondaryException;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.HPartInfo;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.HSegmentInfo;
import com.sap.db.jdbc.packet.SQLPrintOptions;
import com.sap.db.jdbc.packet.SQLReplyOptions;
import com.sap.db.jdbc.packet.SQLStatementType;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbcext.wrapper.CallableStatement;
import com.sap.db.jdbcext.wrapper.PreparedStatement;
import com.sap.db.jdbcext.wrapper.Statement;
import com.sap.db.util.Cesu8Utils;
import com.sap.db.util.HexUtils;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.UUIDUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public abstract class StatementSapDB
extends WrapperDummy
implements java.sql.Statement {
    protected final Tracer _tracer;
    protected final ConnectionSapDB _connection;
    protected final int _resultSetType;
    protected final int _resultSetConcurrency;
    protected final int _resultSetHoldability;
    protected final boolean _isRoutedDirect;
    protected final boolean _isMetaDataStatement;
    protected final boolean _createInternalResultSets;
    protected final ServerKPIs _serverKPIs;
    protected final AtomicBoolean _isPoolable;
    protected final AtomicBoolean _wasCancelled;
    protected final AtomicBoolean _isClosed;
    protected final AtomicBoolean _isClosePending;
    private final AtomicReference<PreparedStatementSapDB> _routedDirect;
    private final AtomicBoolean _wasLastExecuteRouted;
    private final AtomicReference<String> _sql;
    private final Object _lockResultSets;
    @GuardedBy(value="_lockResultSets")
    private List<ResultSetSapDB> _resultSets;
    @GuardedBy(value="_lockResultSets")
    private ResultSetSapDB _currentResultSet;
    @GuardedBy(value="_lockResultSets")
    private int _currentResultSetIndex;
    @GuardedBy(value="_lockResultSets")
    private Map<String, ResultSetSapDB> _tableOutputParametersMap;
    @GuardedBy(value="this")
    protected String _commandInfoSource;
    @GuardedBy(value="this")
    protected int _commandInfoLine;
    @GuardedBy(value="this")
    protected int _rowsAffected;
    @GuardedBy(value="this")
    protected boolean _hasRowCount;
    @GuardedBy(value="this")
    protected boolean _hasReturnedRowsAffected;
    @GuardedBy(value="this")
    protected int _queryTimeout;
    @GuardedBy(value="this")
    protected int _packetSize;
    @GuardedBy(value="this")
    private int _maxFieldSize;
    @GuardedBy(value="this")
    private int _maxRows;
    @GuardedBy(value="this")
    private int _fetchDirection;
    @GuardedBy(value="this")
    private int _fetchSize;
    @GuardedBy(value="this")
    private List<String> _batchSQL;
    @GuardedBy(value="this")
    private List<String> _printLines;
    private static final AtomicInteger _routedDirectCount = new AtomicInteger();
    @GuardedBy(value="this")
    private boolean _shouldTrackLastForceRoutedSession;
    @GuardedBy(value="this")
    private Session _lastForceRoutedSession;

    public static StatementSapDB getStatementSapDB(java.sql.Statement statement) {
        java.sql.Statement s = statement;
        while (!(s instanceof StatementSapDB)) {
            if (s instanceof Statement) {
                s = ((Statement)s).getInner();
                continue;
            }
            if (s instanceof PreparedStatement) {
                s = ((PreparedStatement)s).getInner();
                continue;
            }
            if (s instanceof CallableStatement) {
                s = ((CallableStatement)s).getInner();
                continue;
            }
            return null;
        }
        return (StatementSapDB)s;
    }

    protected StatementSapDB(Tracer tracer, ConnectionSapDB connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String commandInfoSource, int commandInfoLine, StatementFlag ... statementFlags) throws SQLException {
        block15: {
            block14: {
                this._lockResultSets = new Object();
                switch (resultSetType) {
                    case 1003: {
                        break;
                    }
                    default: {
                        throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "resultSetType", "TYPE_FORWARD_ONLY");
                    }
                }
                switch (resultSetConcurrency) {
                    case 1007: {
                        break;
                    }
                    default: {
                        throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "resultSetConcurrency", "CONCUR_READ_ONLY");
                    }
                }
                if (!connection.getEngineFeatures().holdCursorOverRollbackSupported()) break block14;
                switch (resultSetHoldability) {
                    case 1: 
                    case 2: 
                    case 1000001: 
                    case 1000002: {
                        break block15;
                    }
                    default: {
                        throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "resultSetHoldability", "CLOSE_CURSORS_AT_COMMIT, HOLD_CURSORS_OVER_COMMIT, com.sap.db.jdbc.ResultSetSapDB.HOLD_CURSORS_OVER_ROLLBACK, com.sap.db.jdbc.ResultSetSapDB.HOLD_CURSORS_OVER_COMMIT_AND_ROLLBACK");
                    }
                }
            }
            switch (resultSetHoldability) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "resultSetHoldability", "CLOSE_CURSORS_AT_COMMIT, HOLD_CURSORS_OVER_COMMIT,");
                }
            }
        }
        this._tracer = tracer;
        this._connection = connection;
        this._resultSetType = resultSetType;
        this._resultSetConcurrency = resultSetConcurrency;
        this._resultSetHoldability = resultSetHoldability;
        EnumSet<StatementFlag> flags = statementFlags.length > 0 ? EnumSet.copyOf(Arrays.asList(statementFlags)) : EnumSet.noneOf(StatementFlag.class);
        this._isRoutedDirect = flags.contains((Object)StatementFlag.ROUTE_DIRECT);
        this._isMetaDataStatement = flags.contains((Object)StatementFlag.META_DATA_STATEMENT);
        this._createInternalResultSets = flags.contains((Object)StatementFlag.INTERNAL_RESULT_SETS);
        this._serverKPIs = new ServerKPIs();
        this._isPoolable = new AtomicBoolean(this instanceof PreparedStatementSapDB);
        this._wasCancelled = new AtomicBoolean();
        this._isClosed = new AtomicBoolean();
        this._isClosePending = new AtomicBoolean();
        this._commandInfoSource = commandInfoSource;
        this._commandInfoLine = commandInfoLine;
        this._rowsAffected = -1;
        this._packetSize = this._connection.getPacketSize();
        this._fetchDirection = 1000;
        if (this._isRoutedDirect) {
            this._routedDirect = new AtomicReference<PreparedStatementSapDB>(connection._prepareStatement(null, resultSetType, resultSetConcurrency, resultSetHoldability, this._commandInfoSource, this._commandInfoLine, StatementFlag.DUMMY));
            this._wasLastExecuteRouted = new AtomicBoolean();
            this._sql = null;
        } else {
            this._routedDirect = null;
            this._wasLastExecuteRouted = null;
            this._sql = new AtomicReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeQuery") : null;
        try {
            ResultSet result;
            if (on) {
                this._tracer.printCall(this, "executeQuery", sql);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = this._isRoutedDirect ? this._newRouted(sql)._executeQuery() : this._executeQuery(sql);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized int executeUpdate(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeUpdate") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "executeUpdate", sql);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = this._isRoutedDirect ? this._newRouted(sql)._executeUpdate() : this._executeUpdate(sql);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public void close() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "close") : null;
        boolean transactionalLobs = this._connection.getTransactionalLobs();
        try {
            if (on) {
                this._tracer.printCall(this, "close", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                if (this._isRoutedDirect) {
                    this._routedDirect.get()._close(true, transactionalLobs);
                }
                this._close(true, transactionalLobs);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getMaxFieldSize() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getMaxFieldSize") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxFieldSize", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._maxFieldSize;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setMaxFieldSize(int maxFieldSize) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setMaxFieldSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setMaxFieldSize", maxFieldSize);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if (maxFieldSize < 0) {
                    throw SQLExceptionSapDB.newInstance("error.invalid.maxfieldsize", String.valueOf(maxFieldSize));
                }
                this._maxFieldSize = maxFieldSize;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getMaxRows() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getMaxRows") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxRows", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._maxRows;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setMaxRows(int maxRows) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setMaxRows") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setMaxRows", maxRows);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if (maxRows < 0) {
                    throw SQLExceptionSapDB.newInstance("error.invalid.maxrows", String.valueOf(maxRows));
                }
                if (this._isRoutedDirect) {
                    this._routedDirect.get()._setMaxRows(maxRows);
                }
                this._setMaxRows(maxRows);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setEscapeProcessing") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setEscapeProcessing", enable);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getQueryTimeout() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getQueryTimeout") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getQueryTimeout", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._queryTimeout;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setQueryTimeout") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setQueryTimeout", seconds);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if (seconds < 0) {
                    throw SQLExceptionSapDB.newInstance("error.invalid.querytimeout", String.valueOf(seconds));
                }
                if (this._isRoutedDirect) {
                    this._routedDirect.get()._setQueryTimeout(seconds);
                }
                this._setQueryTimeout(seconds);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public void cancel() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "cancel") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "cancel", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                if (this._isRoutedDirect) {
                    this._routedDirect.get()._cancel();
                }
                this._cancel();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized SQLWarning getWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getWarnings") : null;
        try {
            SQLWarning result;
            if (on) {
                this._tracer.printCall(this, "getWarnings", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = null;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            SQLWarning sQLWarning = result;
            return sQLWarning;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void clearWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "clearWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearWarnings", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setCursorName(String cursorName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setCursorName") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCursorName", cursorName);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized boolean execute(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "execute") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "execute", sql);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = this._isRoutedDirect ? this._newRouted(sql)._execute() : this._execute(sql);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized ResultSet getResultSet() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getResultSet") : null;
        try {
            ResultSetSapDB result;
            if (on) {
                this._tracer.printCall(this, "getResultSet", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._isRoutedDirect ? this._routedDirect.get()._getCurrentResultSet() : this._getCurrentResultSet();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSetSapDB resultSetSapDB = result;
            return resultSetSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getUpdateCount() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getUpdateCount") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getUpdateCount", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._isRoutedDirect ? this._routedDirect.get()._getUpdateCount() : this._getUpdateCount();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized boolean getMoreResults() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getMoreResults") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "getMoreResults", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = this._isRoutedDirect ? this._routedDirect.get()._getMoreResults(3) : this._getMoreResults(3);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getFetchDirection() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getFetchDirection") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getFetchDirection", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._fetchDirection;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setFetchDirection(int fetchDirection) throws SQLException {
        on = this._tracer.on();
        pon = this._tracer.pon();
        aon = on != false ? this._tracer.aon() : false;
        r = pon != false ? this._newTraceRecord("Statement", "setFetchDirection") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFetchDirection", new Object[]{fetchDirection});
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                switch (fetchDirection) {
                    case 1000: 
                    case 1001: 
                    case 1002: {
                        this._fetchDirection = fetchDirection;
                        ** break;
lbl15:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", new String[]{"direction", "FETCH_FORWARD, FETCH_REVERSE, FETCH_UNKNOWN"});
                    }
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getFetchSize() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getFetchSize") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getFetchSize", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._fetchSize;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setFetchSize(int fetchSize) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setFetchSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFetchSize", fetchSize);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if (fetchSize < 0) {
                    throw SQLExceptionSapDB.newInstance("error.invalid.fetchsize", String.valueOf(fetchSize));
                }
                if (this._isRoutedDirect) {
                    this._routedDirect.get()._setFetchSize(fetchSize);
                }
                this._setFetchSize(fetchSize);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getResultSetConcurrency() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getResultSetConcurrency") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getResultSetConcurrency", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._resultSetConcurrency;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getResultSetType() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getResultSetType") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getResultSetType", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._resultSetType;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void addBatch(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "addBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "addBatch", sql);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if (this._batchSQL == null) {
                    this._batchSQL = new ArrayList<String>();
                }
                this._batchSQL.add(sql);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void clearBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "clearBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearBatch", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if (this._batchSQL != null) {
                    this._batchSQL.clear();
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized int[] executeBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeBatch") : null;
        try {
            int[] result;
            if (on) {
                this._tracer.printCall(this, "executeBatch", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = this._executeBatch();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int[] nArray = result;
            return nArray;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized Connection getConnection() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getConnection") : null;
        try {
            ConnectionSapDB result;
            if (on) {
                this._tracer.printCall(this, "getConnection", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._connection;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ConnectionSapDB connectionSapDB = result;
            return connectionSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized boolean getMoreResults(int current) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getMoreResults") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "getMoreResults", current);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = this._isRoutedDirect ? this._routedDirect.get()._getMoreResults(current) : this._getMoreResults(current);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getGeneratedKeys") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getGeneratedKeys", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeUpdate") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "executeUpdate", sql, autoGeneratedKeys);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                if (autoGeneratedKeys == 1) {
                    throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
                }
                result = this._isRoutedDirect ? this._newRouted(sql)._executeUpdate() : this._executeUpdate(sql);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeUpdate") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "executeUpdate", sql, columnIndexes);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                if (columnIndexes.length > 0) {
                    throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
                }
                result = this._isRoutedDirect ? this._newRouted(sql)._executeUpdate() : this._executeUpdate(sql);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeUpdate") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "executeUpdate", sql, columnNames);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                if (columnNames.length > 0) {
                    throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
                }
                result = this._isRoutedDirect ? this._newRouted(sql)._executeUpdate() : this._executeUpdate(sql);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "execute") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "execute", sql, autoGeneratedKeys);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                if (autoGeneratedKeys == 1) {
                    throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
                }
                result = this._isRoutedDirect ? this._newRouted(sql)._execute() : this._execute(sql);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "execute") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "execute", sql, columnIndexes);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                if (columnIndexes.length > 0) {
                    throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
                }
                result = this._isRoutedDirect ? this._newRouted(sql)._execute() : this._execute(sql);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "execute") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "execute", sql, columnNames);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                if (columnNames.length > 0) {
                    throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
                }
                result = this._isRoutedDirect ? this._newRouted(sql)._execute() : this._execute(sql);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getResultSetHoldability() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getResultSetHoldability") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getResultSetHoldability", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._resultSetHoldability;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean isClosed() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "isClosed") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isClosed", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._isClosed() || this._isClosePending();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean isPoolable() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "isPoolable") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isPoolable", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._isPoolable.get();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setPoolable(boolean isPoolable) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setPoolable") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setPoolable", isPoolable);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                if (this._isRoutedDirect) {
                    this._routedDirect.get()._setPoolable(isPoolable);
                }
                this._setPoolable(isPoolable);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized boolean isCloseOnCompletion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "isCloseOnCompletion") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "isCloseOnCompletion", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw StatementSapDB._getUnsupportedMethodException("isCloseOnCompletion()");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void closeOnCompletion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "closeOnCompletion") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "closeOnCompletion", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw StatementSapDB._getUnsupportedMethodException("closeOnCompletion()");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized long getLargeUpdateCount() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getLargeUpdateCount") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getLargeUpdateCount", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw StatementSapDB._getUnsupportedMethodException("getLargeUpdateCount()");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized long getLargeMaxRows() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getLargeMaxRows") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getLargeMaxRows", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw StatementSapDB._getUnsupportedMethodException("getLargeMaxRows()");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized void setLargeMaxRows(long max) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setLargeMaxRows") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setLargeMaxRows", max);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw StatementSapDB._getUnsupportedMethodException("setLargeMaxRows( long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized long[] executeLargeBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeBatch") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeBatch", new Object[0]);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw StatementSapDB._getUnsupportedMethodException("executeLargeBatch()");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized long executeLargeUpdate(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw StatementSapDB._getUnsupportedMethodException("executeLargeUpdate( String )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, autoGeneratedKeys);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw StatementSapDB._getUnsupportedMethodException("executeLargeUpdate( String, int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, columnIndexes);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw StatementSapDB._getUnsupportedMethodException("executeLargeUpdate( String, int[] )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, columnNames);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw StatementSapDB._getUnsupportedMethodException("executeLargeUpdate( String, String[] )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public String toString() {
        return this.getTraceString(true);
    }

    public static String getTraceString(String className, int hashCode, boolean isFullString, boolean isClosed, boolean isClosePending) {
        String s = className + "@" + HexUtils.toHexString(hashCode);
        if (!isFullString) {
            return s;
        }
        if (isClosePending) {
            return s + "[close pending]";
        }
        if (isClosed) {
            return s + "[closed]";
        }
        return s;
    }

    public String getTraceString(boolean isFullString) {
        String s = StatementSapDB.getTraceString(this.getClass().getName(), this.hashCode(), isFullString, this._isClosed(), this._isClosePending());
        if (this._isRoutedDirect) {
            s = s + "[Routed:" + this._routedDirect.get().getTraceString(isFullString) + "]";
        }
        return s;
    }

    public Tracer getTracer() {
        return this._tracer;
    }

    public long getServerProcessingTime() {
        if (this._isRoutedDirect && this._wasLastExecuteRouted.get()) {
            return this._routedDirect.get().getServerProcessingTime();
        }
        return this._serverKPIs.getServerProcessingTime();
    }

    public ServerKPIs getServerKPIs() {
        if (this._isRoutedDirect && this._wasLastExecuteRouted.get()) {
            return this._routedDirect.get().getServerKPIs();
        }
        return this._serverKPIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultSetSapDB> getResultSets() {
        Object object = this._lockResultSets;
        synchronized (object) {
            if (this._resultSets == null || this._resultSets.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<ResultSetSapDB>(this._resultSets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommandInfo(String source, int line) throws SQLException {
        StatementSapDB statementSapDB = this;
        synchronized (statementSapDB) {
            this._commandInfoSource = source;
            this._commandInfoLine = line;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPacketSize() {
        StatementSapDB statementSapDB = this;
        synchronized (statementSapDB) {
            return this._packetSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPacketSize(int packetSize) {
        StatementSapDB statementSapDB = this;
        synchronized (statementSapDB) {
            this._packetSize = Math.max(packetSize, 0x100000);
        }
    }

    public String getSQL() {
        if (this._isRoutedDirect) {
            return this._routedDirect.get().getSQL();
        }
        return this._sql.get();
    }

    public byte[] getSQLHash() {
        return this._calculateSQLHash(this.getSQL());
    }

    public synchronized List<String> getBatchSQL() {
        return this._batchSQL != null ? Collections.unmodifiableList(this._batchSQL) : Collections.emptyList();
    }

    protected static SQLException _getUnsupportedMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, "Statement");
    }

    protected static SQLException _getAutoGeneratedKeysNotSupportedException() {
        return SQLExceptionSapDB.newInstance("error.autogenkeys.retrieval.unsupported", new String[0]);
    }

    protected byte[] _calculateSQLHash(String sql) {
        if (sql == null) {
            return null;
        }
        try {
            return MessageDigest.getInstance("MD5").digest(Cesu8Utils.getBytes(sql));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)("Unexpected exception (MD5 is guaranteed to be supported): " + e.getMessage()));
        }
    }

    protected TraceRecord _newTraceRecord(String className, String methodName) {
        return new TraceRecord(this._connection, this, null, className, methodName);
    }

    protected void _publish(TraceRecord r) {
        r.update(this._connection);
        TraceRecordPublisher.getInstance().publish(r);
    }

    protected void _checkLocks() {
        if (this instanceof InternalStatementSapDB || this instanceof InternalPreparedStatementSapDB || this instanceof InternalCallableStatementSapDB) {
            return;
        }
        if (Thread.holdsLock(this)) {
            return;
        }
        if (Thread.holdsLock(this._connection)) {
            // empty if block
        }
    }

    protected void _assertOpen() throws SQLException {
        if (this._isClosed() || this._isClosePending() || this._connection._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }

    protected int _getResultSetHoldability() {
        return this._resultSetHoldability;
    }

    protected boolean _isMetaDataStatement() {
        return this._isMetaDataStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _getMaxRows() {
        StatementSapDB statementSapDB = this;
        synchronized (statementSapDB) {
            return this._maxRows;
        }
    }

    protected synchronized void _setMaxRows(int maxRows) {
        this._maxRows = maxRows;
    }

    protected synchronized void _setQueryTimeout(int seconds) {
        this._queryTimeout = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _getFetchSize() {
        StatementSapDB statementSapDB = this;
        synchronized (statementSapDB) {
            return this._fetchSize;
        }
    }

    protected synchronized void _setFetchSize(int fetchSize) {
        this._fetchSize = fetchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSetSapDB _getCurrentResultSet() {
        Object object = this._lockResultSets;
        synchronized (object) {
            return this._currentResultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ResultSetSapDB> _getTableOutputParametersMap() {
        Object object = this._lockResultSets;
        synchronized (object) {
            return this._tableOutputParametersMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet _executeQuery(String sql) throws SQLException {
        this._execute(sql);
        Object object = this._lockResultSets;
        synchronized (object) {
            if (this._currentResultSet == null) {
                throw SQLExceptionSapDB.newInstance("error.sqlstatement.noresultset", new String[0]);
            }
            return this._currentResultSet;
        }
    }

    protected int _executeUpdate(String sql) throws SQLException {
        boolean isQuery = this._execute(sql);
        if (isQuery) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.resultset", new String[0]);
        }
        return this._hasRowCount ? this._rowsAffected : 0;
    }

    protected boolean _execute(String sql) throws SQLException {
        Session session;
        boolean isForceRoute;
        this._sql.set(sql);
        Integer forceRouteSiteID = this instanceof InternalStatementSapDB ? null : this._connection._getAndUnsetForceRouteSiteIDIfSpecified();
        if (forceRouteSiteID != null) {
            isForceRoute = true;
            session = this._getOrOpenSessionForForceRouteSiteID(forceRouteSiteID);
        } else {
            isForceRoute = false;
            session = this._getPrimarySession();
        }
        this._setLastExecutedSession(session);
        return this._execute(sql, session, isForceRoute);
    }

    protected Session _getOrOpenSessionForForceRouteSiteID(Integer forceRouteSiteID) throws SQLException {
        this._connection._assertForceRouteAllowed();
        Session session = null;
        if (forceRouteSiteID != null) {
            SiteTypeVolumeID forceRouteSiteTypeVolumeID = this._connection.getSessionPool().getCorrespondingSiteTypeVolumeIDForSiteID(forceRouteSiteID);
            if (forceRouteSiteTypeVolumeID == null || !forceRouteSiteTypeVolumeID.isValid()) {
                throw SQLExceptionSapDB.newInstance("error.force.route.invalidsiteid", forceRouteSiteTypeVolumeID == null ? "Unknown site ID" : forceRouteSiteID.toString());
            }
            session = this._connection._getOrOpenSession(forceRouteSiteTypeVolumeID, null);
        }
        if (session == null) {
            throw SQLExceptionSapDB.newInstance("error.force.route.sessionnotconnected", forceRouteSiteID == null ? "Unknown site ID" : forceRouteSiteID.toString());
        }
        return session;
    }

    protected boolean _execute(String sql, Session session, boolean isForceRoute) throws SQLException {
        boolean isQuery;
        this._assertOpen();
        this._resetForExecute();
        if (sql == null || sql.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.null", new String[0]);
        }
        try {
            HReplyPacket replyPacket = this._executeDirect(sql, session, isForceRoute);
            isQuery = this._parseResult(session, replyPacket, new ArrayList<AbstractConverter>(), null);
        }
        catch (InternalReconnectException e) {
            session = e.getNewSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.objectisclosed", this.toString());
            }
            isQuery = this._execute(sql, session, false);
        }
        catch (InternalFallbackSecondaryException e) {
            session = this._connection.getSessionPool().getAnchorSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.objectisclosed", this.toString());
            }
            isQuery = this._execute(sql, session, false);
        }
        return isQuery;
    }

    protected HReplyPacket _executeDirect(String sql, Session session, boolean isForceRoute) throws SQLException {
        HRequestPacket requestPacket = this._connection.initExecuteDirect(session, this._resultSetHoldability, this._queryTimeout, sql, this._commandInfoSource, this._commandInfoLine, false, isForceRoute);
        HReplyPacket replyPacket = this._connection.exchange(session, requestPacket, this, ConnectionSapDB.ExchangeFlag.IS_STATEMENT, isForceRoute ? ConnectionSapDB.ExchangeFlag.FORCE_ROUTE_NO_FALLBACK : ConnectionSapDB.ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
        return replyPacket;
    }

    protected int _executeUpdateOnAllOtherSessions(String sql, Session excludeSession) throws SQLException {
        SessionPool sessionPool = this._connection.getSessionPool();
        Session primarySession = sessionPool.getPrimarySession();
        boolean isQuery = false;
        if (primarySession != excludeSession && !primarySession.isHintRouted()) {
            isQuery = this._execute(sql, primarySession, false);
        }
        for (Session session : sessionPool.getSessions().values()) {
            if (session == excludeSession || session == primarySession || !session.isConnected() || session.isHintRouted()) continue;
            isQuery = this._execute(sql, session, false);
        }
        if (isQuery) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.resultset", new String[0]);
        }
        return this._hasRowCount ? this._rowsAffected : 0;
    }

    protected void _resetForExecute() throws SQLException {
        boolean transactionalLobs = this._connection.getTransactionalLobs();
        if (this._isRoutedDirect) {
            this._routedDirect.get()._closeResultSets(true, transactionalLobs);
        }
        this._closeResultSets(true, transactionalLobs);
        this._serverKPIs.reset();
        if (this._printLines != null) {
            this._printLines.clear();
        }
        this._rowsAffected = -1;
        this._hasRowCount = false;
        this._hasReturnedRowsAffected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _parseResult(Session session, HReplyPacket replyPacket, List<AbstractConverter> converters, Set<String> tableOutputParameters) throws SQLException {
        FunctionCode functionCode = replyPacket.getFunctionCode(0);
        boolean isQuery = false;
        CursorID cursorID = null;
        boolean rowNotFound = false;
        HDataPart dataPart = null;
        switch (functionCode) {
            case Select: 
            case SelectForUpdate: 
            case DBProcedureCallWithResultSet: {
                isQuery = true;
            }
        }
        for (HPartInfo partInfo : replyPacket.parts(0)) {
            switch (partInfo.getPartKind()) {
                case RowsAffected: {
                    this._rowsAffected = partInfo.getRowsAffected();
                    this._hasRowCount = true;
                    this._hasReturnedRowsAffected = false;
                    break;
                }
                case StatementContext: {
                    this._serverKPIs.accumulate(partInfo.getOptionsPart());
                    break;
                }
                case ResultSet: {
                    dataPart = partInfo.getResultSetPart();
                    if (dataPart.isRowNotFound()) {
                        rowNotFound = true;
                    }
                    if (!isQuery || converters.size() <= 0 || cursorID == null) break;
                    if (dataPart == null) {
                        dataPart = HDataPart.createEmptyPart();
                    }
                    this._createResultSet(session, cursorID, converters, rowNotFound, dataPart, tableOutputParameters);
                    cursorID = null;
                    converters = new ArrayList<AbstractConverter>();
                    dataPart = null;
                    rowNotFound = false;
                    break;
                }
                case ResultSetID: {
                    if (isQuery && converters.size() > 0 && cursorID != null) {
                        if (dataPart == null) {
                            dataPart = HDataPart.createEmptyPart();
                        }
                        this._createResultSet(session, cursorID, converters, rowNotFound, dataPart, tableOutputParameters);
                        converters = new ArrayList<AbstractConverter>();
                        rowNotFound = false;
                        dataPart = null;
                    }
                    cursorID = new CursorID(partInfo.getCursorID());
                    break;
                }
                case ResultSetMetaData: {
                    if (isQuery && converters.size() > 0 && cursorID != null) {
                        if (dataPart == null) {
                            dataPart = HDataPart.createEmptyPart();
                        }
                        this._createResultSet(session, cursorID, converters, rowNotFound, dataPart, tableOutputParameters);
                        cursorID = null;
                        converters = new ArrayList<AbstractConverter>();
                        rowNotFound = false;
                        dataPart = null;
                    }
                    partInfo.getResultSetMetaData(this._connection, converters);
                    break;
                }
                case SQLReplyOptions: {
                    this._handleSqlReplyOptions(partInfo.getMultiLineOptionsPart());
                    break;
                }
                case PrintOptions: {
                    this._handlePrintOptions(partInfo.getMultiLineOptionsPart());
                }
            }
        }
        if (isQuery && converters.size() > 0 && cursorID != null) {
            if (dataPart == null) {
                dataPart = HDataPart.createEmptyPart();
            }
            this._createResultSet(session, cursorID, converters, rowNotFound, dataPart, tableOutputParameters);
        }
        Object object = this._lockResultSets;
        synchronized (object) {
            if (isQuery && this._resultSets != null && !this._resultSets.isEmpty()) {
                this._currentResultSet = this._resultSets.get(0);
            }
        }
        return isQuery;
    }

    protected ParseInfo _getParseInfo() {
        return null;
    }

    protected FunctionCode _getFunctionCode() {
        return null;
    }

    protected void _setPoolable(boolean isPoolable) throws SQLException {
        this._isPoolable.set(isPoolable);
    }

    protected boolean _isClosePending() {
        return this._isClosePending.get();
    }

    protected boolean _isClosed() {
        return this._isClosed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _close(boolean sendRequests, boolean allowClosePending) throws SQLException {
        if (this._isClosed()) {
            return;
        }
        this._closeResultSets(sendRequests, allowClosePending);
        if (allowClosePending && this._shouldClosePending()) {
            if (this._isClosePending()) {
                return;
            }
            this._connection._removeStatement(this);
            this._isClosePending.set(true);
            this._connection._addPreparedStatementClosePending((PreparedStatementSapDB)this);
            return;
        }
        boolean wasClosePending = this._isClosePending();
        try {
            ConnectionSapDB connectionSapDB = this._connection;
            synchronized (connectionSapDB) {
                block14: {
                    if (!this._isClosed() && !this._connection._isClosed()) break block14;
                    return;
                }
                if (sendRequests) {
                    this._clean();
                }
                this._isClosed.set(true);
                this._isClosePending.set(false);
            }
        }
        finally {
            if (wasClosePending) {
                this._connection._removePreparedStatementClosePending((PreparedStatementSapDB)this);
            } else {
                this._connection._removeStatement(this);
            }
            this._clearAppLobs();
        }
    }

    protected boolean _shouldClosePending() {
        return false;
    }

    protected void _clearAppLobs() throws SQLException {
    }

    protected void _clean() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addResultSet(ResultSetSapDB resultSet) {
        FetchInfo fetchInfo = resultSet.getFetchInfo();
        Object object = this._lockResultSets;
        synchronized (object) {
            if (fetchInfo.isTableOutputParameter()) {
                if (this._tableOutputParametersMap == null) {
                    this._tableOutputParametersMap = new HashMap<String, ResultSetSapDB>();
                }
                this._tableOutputParametersMap.put(HexUtils.toHexString(fetchInfo.getCursorID().getCursorID()), resultSet);
            } else {
                if (this._resultSets == null) {
                    this._resultSets = new ArrayList<ResultSetSapDB>();
                }
                this._resultSets.add(resultSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeResultSet(ResultSetSapDB resultSet) {
        FetchInfo fetchInfo = resultSet.getFetchInfo();
        Object object = this._lockResultSets;
        synchronized (object) {
            if (fetchInfo.isTableOutputParameter()) {
                if (this._tableOutputParametersMap == null) {
                    return;
                }
                this._tableOutputParametersMap.remove(HexUtils.toHexString(fetchInfo.getCursorID().getCursorID()));
            } else {
                if (this._resultSets == null) {
                    return;
                }
                this._resultSets.remove(resultSet);
            }
        }
    }

    protected void _closeResultSets(boolean sendRequests, boolean allowClosePending) throws SQLException {
        this._closeResultSets(sendRequests, allowClosePending, -1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closeResultSets(boolean sendRequests, boolean allowClosePending, int lastIdx, boolean closeTableOutputParameters) throws SQLException {
        HashMap<String, ResultSetSapDB> tableOutputParametersMap;
        ArrayList<ResultSetSapDB> resultSets;
        Object object = this._lockResultSets;
        synchronized (object) {
            if (this._resultSets == null && this._tableOutputParametersMap == null) {
                return;
            }
            resultSets = this._resultSets != null ? new ArrayList<ResultSetSapDB>(this._resultSets) : null;
            HashMap<String, ResultSetSapDB> hashMap = tableOutputParametersMap = closeTableOutputParameters && this._tableOutputParametersMap != null ? new HashMap<String, ResultSetSapDB>(this._tableOutputParametersMap) : null;
            if (lastIdx == -1) {
                this._resultSets = null;
                this._currentResultSet = null;
                this._currentResultSetIndex = 0;
            }
            if (closeTableOutputParameters) {
                this._tableOutputParametersMap = null;
            }
        }
        if (resultSets != null) {
            int n;
            for (int i = n = lastIdx == -1 ? resultSets.size() - 1 : lastIdx; i >= 0; --i) {
                ResultSetSapDB resultSet = (ResultSetSapDB)resultSets.get(i);
                resultSet._close(sendRequests, allowClosePending);
            }
        }
        if (tableOutputParametersMap != null) {
            for (ResultSetSapDB tableOutputParameter : tableOutputParametersMap.values()) {
                tableOutputParameter._close(sendRequests, allowClosePending);
            }
        }
    }

    protected synchronized List<String> _getPrintLines() {
        if (this._isRoutedDirect && this._wasLastExecuteRouted.get()) {
            return this._routedDirect.get()._getPrintLines();
        }
        return this._printLines == null || this._printLines.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(this._printLines));
    }

    protected void _cancel() throws SQLException {
        this._wasCancelled.set(true);
        this._connection._cancel(this);
    }

    protected void _createResultSet(Session session, FetchInfo fetchInfo, boolean rowNotFound, HDataPart dataPart, ConnectionProperties connectionProperties) throws SQLException {
        if (Driver._createPhantomClass(connectionProperties)) {
            HanaResultSetPhantom.newInstance(this._connection.getTracer(), this._connection, session, this, fetchInfo, rowNotFound, dataPart);
        } else if (Driver._createFinalizerClass(connectionProperties)) {
            HanaResultSetFinalize.newInstance(this._connection.getTracer(), this._connection, session, this, fetchInfo, rowNotFound, dataPart);
        } else {
            HanaResultSet.newInstance(this._connection.getTracer(), this._connection, session, this, fetchInfo, rowNotFound, dataPart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean _getMoreResults(int current) throws SQLException {
        boolean ret;
        int currentResultSetIndex;
        ResultSetSapDB currentResultSet;
        ArrayList<ResultSetSapDB> resultSets;
        this._assertOpen();
        Object object = this._lockResultSets;
        synchronized (object) {
            if (this._resultSets == null || this._currentResultSet == null) {
                return false;
            }
            resultSets = new ArrayList<ResultSetSapDB>(this._resultSets);
            currentResultSet = this._currentResultSet;
            currentResultSetIndex = this._currentResultSetIndex;
        }
        switch (current) {
            case 1: {
                currentResultSet._close(true, this._connection.getTransactionalLobs());
                break;
            }
            case 2: {
                if (!resultSets.contains(currentResultSet)) break;
                ++currentResultSetIndex;
                break;
            }
            case 3: {
                if (!resultSets.contains(currentResultSet)) break;
                this._closeResultSets(true, this._connection.getTransactionalLobs(), currentResultSetIndex, false);
                break;
            }
            default: {
                throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "getMoreResults", "Statement.CLOSE_CURRENT_RESULT, Statement.KEEP_CURRENT_RESULT, or Statement.CLOSE_ALL_RESULTS");
            }
        }
        object = this._lockResultSets;
        synchronized (object) {
            this._currentResultSetIndex = currentResultSetIndex;
            if (this._currentResultSetIndex < this._resultSets.size()) {
                this._currentResultSet = this._resultSets.get(this._currentResultSetIndex);
                ret = true;
            } else {
                this._currentResultSet = null;
                ret = false;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int _getUpdateCount() throws SQLException {
        int ret;
        ResultSetSapDB currentResultSet;
        this._assertOpen();
        Object object = this._lockResultSets;
        synchronized (object) {
            currentResultSet = this._currentResultSet;
        }
        if (currentResultSet == null) {
            if (this._hasRowCount && !this._hasReturnedRowsAffected) {
                this._hasReturnedRowsAffected = true;
                ret = this._rowsAffected;
            } else {
                ret = -1;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    private PreparedStatementSapDB _newRouted(String sql) throws SQLException {
        PreparedStatementSapDB oldRouted = this._routedDirect.get();
        oldRouted._close(true, this._connection.getTransactionalLobs());
        this._assertOpen();
        PreparedStatementSapDB newRouted = this._connection._prepareStatement(sql, this._resultSetType, this._resultSetConcurrency, this._resultSetHoldability, this._commandInfoSource, this._commandInfoLine, new StatementFlag[0]);
        newRouted._setMaxRows(this._maxRows);
        newRouted._setQueryTimeout(this._queryTimeout);
        newRouted._setFetchSize(this._fetchSize);
        newRouted._setPoolable(this._isPoolable.get());
        this._routedDirect.set(newRouted);
        this._wasLastExecuteRouted.set(true);
        _routedDirectCount.incrementAndGet();
        return newRouted;
    }

    private Session _getPrimarySession() throws SQLException {
        return this._connection.getSessionPool().getPrimarySession();
    }

    private void _createResultSet(Session session, CursorID cursorID, List<AbstractConverter> converters, boolean rowNotFound, HDataPart dataPart, Set<String> tableOutputParameters) throws SQLException {
        boolean isTableOutputParameter = false;
        ParseInfo parseInfo = this._getParseInfo();
        if (tableOutputParameters != null) {
            isTableOutputParameter = tableOutputParameters.contains(HexUtils.toHexString(cursorID.getCursorID()));
        }
        FetchInfo fetchInfo = new FetchInfo(cursorID, isTableOutputParameter, converters);
        dataPart.setDataFormatDescription(fetchInfo);
        if (parseInfo != null && fetchInfo._hasLOB()) {
            parseInfo.setHasResultSetLOB();
        }
        if (this._createInternalResultSets) {
            InternalResultSetSapDB.newInstance(this._connection, session, this, fetchInfo, rowNotFound, dataPart);
        } else {
            ConnectionProperties connectionProperties = this._connection.getConnectionProperties();
            this._createResultSet(session, fetchInfo, rowNotFound, dataPart, connectionProperties);
        }
    }

    private void _handleSqlReplyOptions(HMultiLineOptionsPart sqlReplyOptionsPart) throws SQLException {
        do {
            SQLStatementType stmtType = SQLStatementType.Unknown;
            String cekName = null;
            String cekId = null;
            String algorithmName = null;
            String ckpName = null;
            String ckpId = null;
            String pemEncodedPublicKey = null;
            String schemaName = null;
            String tableName = null;
            String columnName = null;
            String hiddenColumnName = null;
            ArrayList<String> primaryKey = new ArrayList<String>();
            HashSet<String> keyIds = new HashSet<String>();
            ArrayList<ColumnReencryptInfo> reencryptColumns = null;
            block33: do {
                switch (SQLReplyOptions.decode(sqlReplyOptionsPart.getOptionName())) {
                    case SQLStatementType: {
                        stmtType = SQLStatementType.decode(sqlReplyOptionsPart.getOptionIntValue());
                        break;
                    }
                    case ColumnEncryptionKeyName: {
                        cekName = sqlReplyOptionsPart.getOptionStringValue();
                        break;
                    }
                    case ColumnEncryptionKeyID: {
                        cekId = UUIDUtils.newInstance(sqlReplyOptionsPart.getOptionBinaryValue()).toString();
                        if (stmtType != SQLStatementType.CEKDropMultiple) break;
                        keyIds.add(cekId);
                        break;
                    }
                    case EncryptionAlgorithmName: {
                        algorithmName = sqlReplyOptionsPart.getOptionStringValue();
                        break;
                    }
                    case ClientKeyPairName: {
                        ckpName = sqlReplyOptionsPart.getOptionStringValue();
                        break;
                    }
                    case ClientKeyPairID: {
                        ckpId = UUIDUtils.newInstance(sqlReplyOptionsPart.getOptionBinaryValue()).toString();
                        if (stmtType != SQLStatementType.CKPNewVersionAddWithKeyValue && stmtType != SQLStatementType.CKPDropMultiple) continue block33;
                        keyIds.add(ckpId);
                        break;
                    }
                    case EncodedPublicKeyValue: {
                        pemEncodedPublicKey = sqlReplyOptionsPart.getOptionStringValue();
                        break;
                    }
                    case PreColumnEncryptionKeyID: 
                    case NewColumnEncryptionKeyID: 
                    case EncryptionType: {
                        break;
                    }
                    case TableName: {
                        tableName = sqlReplyOptionsPart.getOptionStringValue();
                        break;
                    }
                    case ColumnName: {
                        columnName = sqlReplyOptionsPart.getOptionStringValue();
                        break;
                    }
                    case HiddenColumnName: {
                        hiddenColumnName = sqlReplyOptionsPart.getOptionStringValue();
                        break;
                    }
                    case SecondHiddenColumnName: {
                        String secondHiddenColumnName = sqlReplyOptionsPart.getOptionStringValue();
                        this._checkColumnName(columnName);
                        this._checkHiddenColumnName(hiddenColumnName);
                        this._checkHiddenColumnName(secondHiddenColumnName);
                        if (reencryptColumns == null) {
                            reencryptColumns = new ArrayList<ColumnReencryptInfo>();
                        }
                        ColumnReencryptInfo colInfo = new ColumnReencryptInfo(columnName, hiddenColumnName, secondHiddenColumnName);
                        reencryptColumns.add(colInfo);
                        break;
                    }
                    case PrimaryKey: {
                        primaryKey.add(sqlReplyOptionsPart.getOptionStringValue());
                        break;
                    }
                    case SchemaName: {
                        schemaName = sqlReplyOptionsPart.getOptionStringValue();
                    }
                }
            } while (sqlReplyOptionsPart.nextOption());
            if (stmtType == SQLStatementType.Unknown) {
                throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Statement Type");
            }
            switch (stmtType) {
                case CEKCreation: {
                    this._checkCkpId(ckpId);
                    this._checkCkpName(ckpName);
                    this._checkCekName(cekName);
                    this._checkSchemaName(schemaName);
                    this._checkAlgorithmName(algorithmName);
                    this._connection._createColumnEncryptionKey(ckpId, ckpName, cekId, cekName, schemaName, algorithmName, false);
                    break;
                }
                case CKPCreation: {
                    this._checkCkpName(ckpName);
                    this._checkAlgorithmName(algorithmName);
                    this._connection._createClientKeyPair(ckpName, algorithmName);
                    break;
                }
                case EmptyCEKPopulating: {
                    this._checkCkpId(ckpId);
                    this._checkCkpName(ckpName);
                    this._checkCekId(cekId);
                    this._checkCekName(cekName);
                    this._checkSchemaName(schemaName);
                    this._checkAlgorithmName(algorithmName);
                    this._connection._createColumnEncryptionKey(ckpId, ckpName, cekId, cekName, schemaName, algorithmName, true);
                    break;
                }
                case AccessCEKGranting: {
                    this._checkCkpName(ckpName);
                    this._checkCekName(cekName);
                    this._checkCekId(cekId);
                    this._checkSchemaName(schemaName);
                    this._checkPemEncodedPublicKey(pemEncodedPublicKey);
                    this._checkAlgorithmName(algorithmName);
                    this._connection._grantAccessColumnEncryptionKey(ckpName, cekId, cekName, schemaName, pemEncodedPublicKey, algorithmName);
                    break;
                }
                case CEKChanging: 
                case CEKChangingMultiple: 
                case ColumnEncryption: 
                case ColumnUnEncryption: {
                    this._checkSchemaName(schemaName);
                    this._checkTableName(tableName);
                    this._checkReencryptColumns(reencryptColumns);
                    this._checkPrimaryKey(primaryKey);
                    this._connection._transformColumns(schemaName, tableName, reencryptColumns, primaryKey, this);
                    break;
                }
                case CKPDrop: {
                    this._checkCkpId(ckpId);
                    this._connection._dropClientKeyPair(ckpId);
                    break;
                }
                case CEKDrop: 
                case CEKKeyCopyDrop: {
                    this._checkCekId(cekId);
                    this._connection._dropColumnEncryptionKey(cekId);
                    break;
                }
                case CKPNewVersionAdd: {
                    this._checkCkpName(ckpName);
                    this._checkCkpId(ckpId);
                    this._checkAlgorithmName(algorithmName);
                    this._connection._createNewClientKeypairVersion(ckpName, ckpId, algorithmName);
                    break;
                }
                case CKPNewVersionAddWithKeyValue: {
                    this._checkCkpIds(keyIds);
                    this._connection._setCSEKeyIDs(keyIds);
                    break;
                }
                case AccessCEKGrantingMultiple: {
                    this._checkCkpName(schemaName);
                    this._checkCkpName(ckpName);
                    this._checkCekName(cekName);
                    this._checkAlgorithmName(algorithmName);
                    this._connection._grantAccessColumnEncryptionKeyMultiple(schemaName, ckpName, cekName, algorithmName);
                    break;
                }
                case CEKNewVersionAdd: {
                    this._checkSchemaName(schemaName);
                    this._checkCekName(cekName);
                    this._checkAlgorithmName(algorithmName);
                    this._connection._createNewColumnEncryptionKeyVersion(schemaName, cekName, algorithmName);
                    break;
                }
                case CEKRotation: {
                    throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Statement Type");
                }
                case CKPDropMultiple: {
                    this._connection._dropClientKeyPairMultiple(keyIds);
                    break;
                }
                case CEKDropMultiple: {
                    this._connection._dropColumnEncryptionKeyMultiple(keyIds);
                }
            }
        } while (sqlReplyOptionsPart.nextLine());
    }

    private void _checkCkpId(String ckpId) throws SQLException {
        if (ckpId == null || ckpId.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Client key pair ID");
        }
    }

    private void _checkCkpIds(Set<String> ckpIds) throws SQLException {
        if (ckpIds == null || ckpIds.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Client key pair IDs");
        }
    }

    private void _checkCkpName(String ckpName) throws SQLException {
        if (ckpName == null || ckpName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Client key pair name");
        }
    }

    private void _checkCekId(String cekId) throws SQLException {
        if (cekId == null || cekId.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Column encryption key ID");
        }
    }

    private void _checkCekName(String cekName) throws SQLException {
        if (cekName == null || cekName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Column encryption key name");
        }
    }

    private void _checkAlgorithmName(String algorithmName) throws SQLException {
        if (algorithmName == null || algorithmName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Algorithm name");
        }
    }

    private void _checkPemEncodedPublicKey(String pemEncodedPublicKey) throws SQLException {
        if (pemEncodedPublicKey == null || pemEncodedPublicKey.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "PEM encoded public key");
        }
    }

    private void _checkSchemaName(String schemaName) throws SQLException {
        if (schemaName == null || schemaName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Schema name");
        }
    }

    private void _checkTableName(String tableName) throws SQLException {
        if (tableName == null || tableName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Table name");
        }
    }

    private void _checkColumnName(String columnName) throws SQLException {
        if (columnName == null || columnName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Column name");
        }
    }

    private void _checkHiddenColumnName(String hiddenColumnName) throws SQLException {
        if (hiddenColumnName == null || hiddenColumnName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Hidden column name");
        }
    }

    private void _checkPrimaryKey(List<String> primaryKey) throws SQLException {
        if (primaryKey == null || primaryKey.size() == 0) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Primary key");
        }
    }

    private void _checkReencryptColumns(List<ColumnReencryptInfo> reencryptColumns) throws SQLException {
        if (reencryptColumns == null || reencryptColumns.size() == 0) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Column Info");
        }
    }

    private void _handlePrintOptions(HMultiLineOptionsPart printOptionsPart) throws SQLException {
        do {
            switch (SQLPrintOptions.decode(printOptionsPart.getOptionName())) {
                case Op_String: {
                    String value = printOptionsPart.getOptionStringValue();
                    if (this._printLines == null) {
                        this._printLines = new ArrayList<String>();
                    }
                    this._printLines.add(value);
                    break;
                }
            }
        } while (printOptionsPart.nextOption() || printOptionsPart.nextLine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] _executeBatch() throws SQLException {
        try {
            this._assertOpen();
            this._resetForExecute();
            if (this._isRoutedDirect) {
                this._wasLastExecuteRouted.set(false);
            }
            if (this._batchSQL == null || this._batchSQL.isEmpty()) {
                int[] nArray = new int[]{};
                return nArray;
            }
            int itemCount = this._batchSQL.size();
            int[] updateCounts = new int[itemCount];
            int sendCount = 0;
            int receiveCount = 0;
            int batchUpdateExceptionIdx = -1;
            Throwable batchUpdateExceptionChain = null;
            Object object = this._connection;
            synchronized (object) {
                Session session = this._getPrimarySession();
                while (sendCount < itemCount) {
                    HRequestPacket requestPacket = this._connection.initExecuteDirect(session, this._resultSetHoldability, this._queryTimeout, this._batchSQL.get(sendCount), this._commandInfoSource, this._commandInfoLine, true, false);
                    ++sendCount;
                    while (sendCount < itemCount && requestPacket.addExecuteDirectSegment(this._connection, session, this._resultSetHoldability, this._queryTimeout, this._batchSQL.get(sendCount), this._commandInfoSource, this._commandInfoLine)) {
                        ++sendCount;
                    }
                    requestPacket.close();
                    HReplyPacket replyPacket = this._connection.exchange(session, requestPacket, this, ConnectionSapDB.ExchangeFlag.IGNORE_ERRORS, ConnectionSapDB.ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
                    for (HSegmentInfo segmentInfo : replyPacket.segments()) {
                        FunctionCode functionCode;
                        SQLException sqlExceptionChain;
                        if (batchUpdateExceptionIdx == -1 && (sqlExceptionChain = segmentInfo.findSQLExceptionChain(this._connection)) != null && !(sqlExceptionChain instanceof SQLWarning)) {
                            batchUpdateExceptionIdx = receiveCount;
                            batchUpdateExceptionChain = sqlExceptionChain;
                        }
                        if ((functionCode = segmentInfo.getFunctionCode()) == FunctionCode.Select || functionCode == FunctionCode.SelectForUpdate) {
                            updateCounts[receiveCount] = -3;
                            if (batchUpdateExceptionIdx == -1) {
                                batchUpdateExceptionIdx = receiveCount;
                            }
                        } else {
                            int rowsAffected = segmentInfo.findRowsAffected();
                            updateCounts[receiveCount] = rowsAffected != -1 ? rowsAffected : -2;
                            this._serverKPIs.accumulate(segmentInfo.findStatementContextPart());
                        }
                        ++receiveCount;
                    }
                }
                if (batchUpdateExceptionIdx != -1) {
                    if (batchUpdateExceptionChain != null) {
                        throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batch.withnumber", String.valueOf(batchUpdateExceptionIdx + 1), batchUpdateExceptionChain.getMessage()), (SQLException)batchUpdateExceptionChain, updateCounts);
                    }
                    throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset.withnumber", String.valueOf(batchUpdateExceptionIdx + 1)), "2A000", updateCounts);
                }
            }
            object = updateCounts;
            return object;
        }
        catch (InternalReconnectException e) {
            Session session = e.getNewSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.objectisclosed", this.toString());
            }
            int[] nArray = this._executeBatch();
            return nArray;
        }
        catch (InternalFallbackSecondaryException e) {
            Session session = this._connection.getSessionPool().getAnchorSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.objectisclosed", this.toString());
            }
            int[] nArray = this._executeBatch();
            return nArray;
        }
        finally {
            if (this._batchSQL != null) {
                this._batchSQL.clear();
            }
        }
    }

    public static void resetRoutedDirectCount() {
        _routedDirectCount.set(0);
    }

    public static int getRoutedDirectCount() {
        return _routedDirectCount.get();
    }

    public synchronized void _shouldTrackLastExecutedSession(boolean shouldTrack) {
        this._shouldTrackLastForceRoutedSession = shouldTrack;
    }

    public synchronized void _setLastExecutedSession(Session session) {
        if (this._shouldTrackLastForceRoutedSession) {
            this._lastForceRoutedSession = session;
        }
    }

    public synchronized Session _getLastExecutedSession() {
        return this._shouldTrackLastForceRoutedSession ? this._lastForceRoutedSession : null;
    }

    public static enum StatementFlag {
        NONE,
        ROUTE_DIRECT,
        DUMMY,
        DEFER_PREPARE,
        META_DATA_STATEMENT,
        INTERNAL_RESULT_SETS;

    }
}

