/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HReadLOBReplyPart;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.BufferUtils;
import com.sap.db.util.JdbcObject;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Arrays;

@NotThreadSafe
public abstract class AbstractGetval
extends JdbcObject {
    private static final byte[] LOB_LOCATOR_0_FULL_VALUE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected final SQLParamController _controller;
    protected final HDataPart _dataPart;
    protected final int _lobFieldOffset;
    protected final int _length;
    protected final Tracer _tracer;
    protected final long _charLength;
    protected final long _byteLength;
    protected final ConnectionSapDB _connection;
    private final StatementSapDB _statement;
    private final ResultSetSapDB _resultSet;
    private final Session _session;
    private final byte[] _locatorID;
    protected long _firstPosition;
    protected long _currentPosition;
    protected boolean _isLastChunk;
    protected ByteBuffer _byteBuffer;
    protected boolean _atEnd;

    protected AbstractGetval(SQLParamController controller, HDataPart dataPart, int lobFieldOffset, int length) throws SQLException {
        this._controller = controller;
        this._dataPart = dataPart;
        this._lobFieldOffset = lobFieldOffset;
        this._length = length;
        this._connection = controller.getConnectionSapDB();
        this._statement = controller.getStatementSapDB();
        this._resultSet = controller.getResultSetSapDB();
        this._session = controller.getSession();
        this._tracer = this._connection.getTracer();
        this._isLastChunk = dataPart.getLOBIsLastChunk(this._lobFieldOffset);
        this._charLength = dataPart.getLOBCharLength(this._lobFieldOffset);
        this._byteLength = dataPart.getLOBByteLength(this._lobFieldOffset);
        this._locatorID = dataPart.getLOBLocatorID(this._lobFieldOffset);
        this._byteBuffer = dataPart.getLOBByteBuffer(this._lobFieldOffset);
        this._currentPosition = 1L;
        this._firstPosition = 1L;
    }

    protected abstract long _length();

    protected abstract String _getString() throws SQLException;

    protected abstract byte[] _getBytes() throws SQLException;

    protected abstract Reader _getCharacterStream(boolean var1) throws SQLException;

    protected abstract InputStream _getAsciiStream(boolean var1) throws SQLException;

    protected abstract InputStream _getBinaryStream(boolean var1) throws SQLException;

    public void addAppLob() {
        if (!this._connection.getTransactionalLobs() || this._connection.getTransactionalLobsVersion() <= 0) {
            return;
        }
        if (Arrays.equals(this._locatorID, LOB_LOCATOR_0_FULL_VALUE)) {
            return;
        }
        if (this._statement != null && this._statement instanceof PreparedStatementSapDB) {
            ((PreparedStatementSapDB)this._statement).addAppLob(this);
        }
        if (this._resultSet != null) {
            this._resultSet.addAppLob(this);
        }
    }

    public void removeAppLob(boolean allowClose) throws SQLException {
        if (!this._connection.getTransactionalLobs() || this._connection.getTransactionalLobsVersion() <= 0) {
            return;
        }
        if (Arrays.equals(this._locatorID, LOB_LOCATOR_0_FULL_VALUE)) {
            return;
        }
        if (this._resultSet != null) {
            this._resultSet.removeAppLob(this, allowClose);
        }
        if (this._statement != null && this._statement instanceof PreparedStatementSapDB) {
            ((PreparedStatementSapDB)this._statement).removeAppLob(this, allowClose);
        }
    }

    protected static SQLException _getUnsupportedMethodException(String className, String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, className);
    }

    protected TraceRecord _newTraceRecord(String className, String methodName) {
        return new TraceRecord(this._connection, null, this._resultSet, className, methodName);
    }

    protected void _publish(TraceRecord r) {
        r.update(this._connection);
        TraceRecordPublisher.getInstance().publish(r);
    }

    protected void _changeBytePosition(long newPosition) throws SQLException {
        this._currentPosition = newPosition;
        if (this._byteLength == 0L) {
            return;
        }
        if (newPosition >= this._firstPosition && newPosition <= this._firstPosition + (long)this._byteBuffer.limit()) {
            BufferUtils.position(this._byteBuffer, (int)(newPosition - this._firstPosition));
        } else {
            this._atEnd = false;
            this._isLastChunk = false;
            this._nextChunk();
        }
    }

    protected void _nextChunk() throws SQLException {
        this._controller.assertControllerOpen();
        if (this._isLastChunk || this._atEnd) {
            this._atEnd = true;
            return;
        }
        HRequestPacket requestPacket = this._connection.initReadLOB(this._session, this._locatorID, this._currentPosition, this._statement.getPacketSize());
        HReplyPacket replyPacket = this._connection.exchange(this._session, requestPacket, this._statement, new ConnectionSapDB.ExchangeFlag[0]);
        HReadLOBReplyPart readLOBReplyPart = replyPacket.findReadLOBReplyPart(0);
        if (readLOBReplyPart == null) {
            throw SQLExceptionSapDB.newInstance("error.longdata.expected", new String[0]);
        }
        this._isLastChunk = readLOBReplyPart.isLastChunk();
        this._byteBuffer = readLOBReplyPart.getByteBuffer();
        this._firstPosition = this._currentPosition;
    }

    public synchronized Session getSession() {
        return this._session;
    }
}

