/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum FunctionCode {
    Nil(0),
    DDL(1),
    Insert(2),
    Update(3),
    Delete(4),
    Select(5),
    SelectForUpdate(6),
    Explain(7),
    DBProcedureCall(8),
    DBProcedureCallWithResultSet(9),
    Fetch(10),
    Commit(11),
    Rollback(12),
    Savepoint(13),
    Connect(14),
    WriteLOB(15),
    ReadLOB(16),
    Ping(17),
    Disconnect(18),
    CloseCursor(19),
    FindLOB(20),
    ABAPStream(21),
    XAStart(22),
    XAJoin(23),
    ItabWrite(24),
    XOpen_XAControl(25),
    XOpen_XAPrepare(26),
    XOpen_XARecover(27),
    Unknown(-1);

    private static final FunctionCode[] VALUES;

    public static FunctionCode decode(int value) {
        return value >= 0 && value < VALUES.length - 1 ? VALUES[value] : Unknown;
    }

    public static String getDisplayName(int value) {
        return FunctionCode.decode(value).name() + '(' + value + ')';
    }

    private FunctionCode(int value) {
        if (value != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = FunctionCode.values();
    }
}

