/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.Tracer;
import java.sql.SQLException;

@ThreadSafe
class InternalStatementSapDB
extends StatementSapDB {
    protected static InternalStatementSapDB newInstance(ConnectionSapDB connection, boolean isMetaDataStatement, boolean createInternalResultSets) throws SQLException {
        InternalStatementSapDB statement = new InternalStatementSapDB(connection, isMetaDataStatement, createInternalResultSets);
        connection._addStatement(statement);
        return statement;
    }

    private InternalStatementSapDB(ConnectionSapDB connection, boolean isMetaDataStatement, boolean createInternalResultSets) throws SQLException {
        super(Tracer.DUMMY, connection, 1003, 1007, 1, isMetaDataStatement, createInternalResultSets);
    }

    @Override
    protected HReplyPacket _executeDirect(String sql, Session session) throws SQLException {
        HRequestPacket requestPacket = this._connection.initExecuteDirect(session, this._resultSetHoldability, this._queryTimeout, sql, null, -1, false);
        HReplyPacket replyPacket = this._connection.exchange(session, requestPacket, this, ConnectionSapDB.ExchangeFlag.IS_STATEMENT, ConnectionSapDB.ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
        return replyPacket;
    }

    protected int _executeUpdateOnAllSessions(String sql) throws SQLException {
        SessionPool sessionPool = this._connection.getSessionPool();
        Session primarySession = sessionPool.getPrimarySession();
        boolean isQuery = false;
        this._connection.handleTransaction(primarySession, true);
        if (!primarySession.isHintRouted()) {
            isQuery = this._execute(sql, primarySession);
        }
        for (Session session : sessionPool.getSessions().values()) {
            if (session == primarySession || !session.isConnected() || session.isHintRouted()) continue;
            this._connection.handleTransaction(session, true);
            isQuery = this._execute(sql, session);
        }
        if (isQuery) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.resultset", new String[0]);
        }
        return this._hasRowCount ? this._rowsAffected : 0;
    }
}

