/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.TransactionState;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.HexUtils;
import java.sql.SQLException;

@NotThreadSafe
public class Transaction {
    private final SessionPool _sessionPool;
    private final Tracer _tracer;
    private boolean _autoCommit;
    private TransactionState _transactionState;
    private int _numberOfSessionsInvolved;
    private byte[] _transactionID;

    Transaction(SessionPool sessionPool, Tracer tracer) {
        this._sessionPool = sessionPool;
        this._tracer = tracer;
        this._autoCommit = true;
        this._transactionState = TransactionState.None;
    }

    boolean getAutoCommit() {
        return this._autoCommit;
    }

    void setAutoCommit(boolean autoCommit) {
        this._autoCommit = autoCommit;
    }

    TransactionState getTransactionState() {
        return this._transactionState;
    }

    boolean isWriteTransaction() {
        return this._transactionState == TransactionState.WriteTransaction || this._transactionState == TransactionState.DistributedTransaction;
    }

    void setTransactionState(Session session, TransactionState newState) {
        if (!this._checkSession(session)) {
            return;
        }
        if (this._transactionState == TransactionState.None && (newState == TransactionState.ReadTransaction || newState == TransactionState.WriteTransaction) || this._transactionState == TransactionState.ReadTransaction && newState == TransactionState.WriteTransaction) {
            this._sessionPool.setPrimarySession(session);
        }
        this._transactionState = newState;
        if (this._tracer.on()) {
            this._tracer.printDistribution("Change Tx " + HexUtils.toDisplayHexString(this._transactionID) + " state to " + this._transactionState.name() + " on session " + session.getLocation().getAsShortString());
        }
    }

    TransactionState getNewTransactionState(Session session, FunctionCode functionCode, boolean isDDLCommitted) {
        TransactionState newState;
        if (!this._checkSession(session)) {
            return null;
        }
        switch (functionCode) {
            case Commit: 
            case Rollback: 
            case Connect: 
            case Disconnect: {
                newState = TransactionState.None;
                break;
            }
            case XAStart: 
            case XAJoin: 
            case Nil: 
            case CloseCursor: 
            case DDL: {
                newState = null;
                break;
            }
            default: {
                newState = TransactionState.ReadTransaction;
            }
        }
        return newState;
    }

    void handleTransaction(ConnectionSapDB connection, Session session, boolean allowChangePrimaryAndXAJoin) throws SQLException {
        if (session.isHintRouted()) {
            return;
        }
        this.addSessionToTransaction(session);
        if (!allowChangePrimaryAndXAJoin) {
            return;
        }
        if (this._transactionState == TransactionState.None) {
            this._sessionPool.setPrimarySession(session);
        }
        if (this._transactionState == TransactionState.DistributedTransaction) {
            if (!session.isPartOfDistributedTransaction()) {
                this._joinDistributedTransaction(connection, session);
            }
        } else if (this._numberOfSessionsInvolved > 1) {
            switch (this._transactionState) {
                case None: 
                case ReadTransaction: {
                    break;
                }
                default: {
                    this._startDistributedTransaction(connection);
                    this._joinDistributedTransaction(connection, session);
                }
            }
        }
    }

    void addSessionToTransaction(Session session) {
        if (session.isPartOfTransaction()) {
            return;
        }
        session.joinTransaction();
        ++this._numberOfSessionsInvolved;
    }

    void clearTransaction(ConnectionSapDB connection, boolean forCloseOrReconnect) {
        String primaryConnectionPreference;
        this._transactionState = TransactionState.None;
        for (Session session : this._sessionPool.getSessions().values()) {
            session.leaveTransaction();
        }
        if (this._tracer.on() && this._transactionState != TransactionState.Unknown) {
            this._tracer.printDistributionState(connection, "Close Tx " + HexUtils.toDisplayHexString(this._transactionID));
        }
        this._numberOfSessionsInvolved = 0;
        this._transactionID = null;
        if (!forCloseOrReconnect && !(primaryConnectionPreference = connection.getConnectionProperty(ConnectionProperty.PRIMARY_CONNECTION)).equalsIgnoreCase("LASTPRIMARY")) {
            if (connection.getLastExecutedSession() != null && primaryConnectionPreference.equalsIgnoreCase("LASTEXECUTE")) {
                this._sessionPool.setPrimarySession(connection.getLastExecutedSession());
            } else if (this._sessionPool.getAnchorSession() != null) {
                this._sessionPool.setPrimarySession(this._sessionPool.getAnchorSession());
            }
        }
    }

    private boolean _checkSession(Session session) {
        Session anchorSession = this._sessionPool.getAnchorSession();
        return anchorSession == null || anchorSession.getSiteVolumeID().getSiteID() == session.getSiteVolumeID().getSiteID() || !anchorSession.isPrimarySite();
    }

    private void _startDistributedTransaction(ConnectionSapDB connection) throws SQLException {
        if (this._transactionState == TransactionState.DistributedTransaction) {
            return;
        }
        Session session = this._sessionPool.getPrimarySession();
        HRequestPacket requestPacket = connection.initStartDistributedTransaction(session);
        HReplyPacket replyPacket = connection.exchange(session, requestPacket, null, new ConnectionSapDB.ExchangeFlag[0]);
        this._transactionID = replyPacket.findTransactionID(0, this._transactionID);
        this._transactionState = TransactionState.DistributedTransaction;
        session.joinDistributedTransaction();
        if (this._tracer.on()) {
            this._tracer.printDistribution("Start Distributed Tx " + HexUtils.toDisplayHexString(this._transactionID) + " on session " + session.getLocation().getAsShortString());
        }
    }

    private void _joinDistributedTransaction(ConnectionSapDB connection, Session session) throws SQLException {
        if (session.isPartOfDistributedTransaction()) {
            return;
        }
        HRequestPacket requestPacket = connection.initJoinDistributedTransaction(session, this._transactionID);
        connection.exchange(session, requestPacket, null, new ConnectionSapDB.ExchangeFlag[0]);
        session.joinDistributedTransaction();
        if (this._tracer.on()) {
            this._tracer.printDistribution("Join Distributed Tx " + HexUtils.toDisplayHexString(this._transactionID) + " on session " + session.getLocation().getAsShortString());
        }
    }
}

