/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractDateTimeConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

@ThreadSafe
class DateConverter
extends AbstractDateTimeConverter {
    protected DateConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getEstimatedColumnSize() {
        return 4;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof byte[])) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        return 5;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof byte[])) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        byte[] value = (byte[])data;
        return dataPart.putBytesAsDate(value);
    }

    @Override
    public int getPrecision() {
        return 10;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsDate(controller, dataPart, null);
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Date) {
            return this.setDate((java.sql.Date)value, null);
        }
        if (value instanceof Timestamp) {
            return this.setTimestamp((Timestamp)value, null);
        }
        if (value instanceof Date) {
            Date utilDate = (Date)value;
            return this.setDate(new java.sql.Date(utilDate.getTime()), null);
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public java.sql.Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getValueAsDate(controller, dataPart, cal);
    }

    public byte[] setDate(java.sql.Date value, Calendar cal) throws SQLException {
        return value != null ? DateConverter._convertMillisecondsToDate(value.getTime(), cal) : null;
    }

    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        java.sql.Date date = this._getValueAsDate(controller, dataPart, cal);
        return date != null ? new Time(DateConverter._normalizeTimeMilliseconds(date.getTime())) : null;
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        java.sql.Date date = this._getValueAsDate(controller, dataPart, cal);
        return date != null ? new Timestamp(date.getTime()) : null;
    }

    public byte[] setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        return value != null ? DateConverter._convertMillisecondsToDate(value.getTime(), cal) : null;
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        java.sql.Date date = this._getValueAsDate(controller, dataPart, null);
        return date != null ? String.valueOf(date) : null;
    }

    public byte[] setString(String value) throws SQLException {
        return value != null ? this._convertStringToDate(value) : null;
    }

    private java.sql.Date _getValueAsDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        if (dataPart.isNull(controller)) {
            return null;
        }
        byte[] buffer = dataPart.getRawPacketArray();
        int offset = dataPart.getNonNullDataOffset();
        return new java.sql.Date(DateConverter._convertDateToMilliseconds(buffer, offset, cal));
    }
}

