/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractDateTimeConverter;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

@ThreadSafe
class LongDateConverter
extends AbstractDateTimeConverter {
    protected LongDateConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getEstimatedColumnSize() {
        return 8;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Long)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        return 9;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Long)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        Long value = (Long)data;
        return dataPart.putLongAsLongDate(value);
    }

    @Override
    public int getPrecision() {
        return 27;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getTimestamp(controller, dataPart, null);
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Date) {
            return this.setDate((java.sql.Date)value, null);
        }
        if (value instanceof Time) {
            return this.setTime((Time)value, null);
        }
        if (value instanceof Timestamp) {
            return this.setTimestamp((Timestamp)value, null);
        }
        if (value instanceof Date) {
            Date utilDate = (Date)value;
            return this.setTimestamp(new Timestamp(utilDate.getTime()), null);
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public java.sql.Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getDate(controller, dataPart, cal);
    }

    @Override
    public Long setDate(java.sql.Date value, Calendar cal) throws SQLException {
        return value != null ? Long.valueOf(LongDateConverter._convertMillisecondsAndNanosecondsToLongDate(value.getTime(), 0, cal)) : null;
    }

    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getTime(controller, dataPart, cal);
    }

    @Override
    public Long setTime(Time value, Calendar cal) throws SQLException {
        return value != null ? Long.valueOf(LongDateConverter._convertMillisecondsAndNanosecondsToLongDate(value.getTime(), 0, cal)) : null;
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getTimestamp(controller, dataPart, cal);
    }

    @Override
    public Long setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        return value != null ? Long.valueOf(LongDateConverter._convertMillisecondsAndNanosecondsToLongDate(value.getTime(), value.getNanos(), cal)) : null;
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return LongDateConverter._formatTimestamp(this._getNonNullTimestamp(dataPart, null), true);
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : "";
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    @Override
    public Long setString(String value) throws SQLException {
        return value != null ? Long.valueOf(this._convertStringToLongDate(value)) : null;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) {
        return dataPart.putNull(DataType.TIMESTAMP);
    }

    private long _getValueAsLongDate(HDataPart dataPart) throws SQLException {
        long longDate = dataPart.getBigIntAsLong();
        return longDate;
    }

    private java.sql.Date _getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return new java.sql.Date(LongDateConverter._convertLongDateToMilliseconds(this._getValueAsLongDate(dataPart), cal));
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : new java.sql.Date(-62135769601000L);
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    private Time _getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return new Time(LongDateConverter._normalizeTimeMilliseconds(LongDateConverter._convertLongDateToMilliseconds(this._getValueAsLongDate(dataPart), cal)));
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : new Time(-62135769601000L);
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    private Timestamp _getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return this._getNonNullTimestamp(dataPart, cal);
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                if (this._emptyTimestampIsNull) {
                    return null;
                }
                Timestamp ts = new Timestamp(-62135769600001L);
                ts.setNanos(999999900);
                return ts;
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    private Timestamp _getNonNullTimestamp(HDataPart dataPart, Calendar cal) throws SQLException {
        long longDate = this._getValueAsLongDate(dataPart);
        Timestamp timestamp = new Timestamp(LongDateConverter._convertLongDateToMilliseconds(longDate, cal));
        timestamp.setNanos(LongDateConverter._convertLongDateToNanoseconds(longDate));
        return timestamp;
    }
}

