/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractDateTimeConverter;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

@ThreadSafe
class SecondTimeConverter
extends AbstractDateTimeConverter {
    protected SecondTimeConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getEstimatedColumnSize() {
        return 4;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Integer)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        return 5;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Integer)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        Integer value = (Integer)data;
        return dataPart.putIntAsSecondTime(value);
    }

    @Override
    public int getPrecision() {
        return 8;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getTime(controller, dataPart, null);
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            return this.setTime((Time)value, null);
        }
        if (value instanceof Timestamp) {
            return this.setTimestamp((Timestamp)value, null);
        }
        if (value instanceof Date) {
            Date utilDate = (Date)value;
            return this.setTime(new Time(utilDate.getTime()), null);
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public java.sql.Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getDate(controller, dataPart, cal);
    }

    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getTime(controller, dataPart, cal);
    }

    @Override
    public Integer setTime(Time value, Calendar cal) throws SQLException {
        return value != null ? Integer.valueOf(SecondTimeConverter._convertMillisecondsToSecondTime(value.getTime(), cal)) : null;
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getTimestamp(controller, dataPart, cal);
    }

    @Override
    public Integer setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        return value != null ? Integer.valueOf(SecondTimeConverter._convertMillisecondsToSecondTime(value.getTime(), cal)) : null;
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return String.valueOf(new Time(SecondTimeConverter._convertSecondTimeToMilliseconds(this._getValueAsSecondTime(dataPart), null, false)));
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : "";
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    @Override
    public Integer setString(String value) throws SQLException {
        return value != null ? Integer.valueOf(this._convertStringToSecondTime(value)) : null;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) {
        return dataPart.putNull(DataType.TIME);
    }

    private int _getValueAsSecondTime(HDataPart dataPart) throws SQLException {
        int secondTime = dataPart.getIntAsInt();
        return secondTime;
    }

    private java.sql.Date _getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return new java.sql.Date(SecondTimeConverter._convertSecondTimeToMilliseconds(this._getValueAsSecondTime(dataPart), cal, true));
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : new java.sql.Date(-62135769601000L);
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    private Time _getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return new Time(SecondTimeConverter._convertSecondTimeToMilliseconds(this._getValueAsSecondTime(dataPart), cal, false));
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : new Time(-62135769601000L);
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    private Timestamp _getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return new Timestamp(SecondTimeConverter._convertSecondTimeToMilliseconds(this._getValueAsSecondTime(dataPart), cal, true));
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : new Timestamp(-62135769601000L);
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }
}

