/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext.wrapper;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbcext.wrapper.Array;
import com.sap.db.jdbcext.wrapper.Blob;
import com.sap.db.jdbcext.wrapper.Clob;
import com.sap.db.jdbcext.wrapper.Connection;
import com.sap.db.jdbcext.wrapper.ParameterMetaData;
import com.sap.db.jdbcext.wrapper.ResultSet;
import com.sap.db.jdbcext.wrapper.ResultSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

@ThreadSafe
public class PreparedStatement
implements java.sql.PreparedStatement {
    private final java.sql.PreparedStatement _inner;
    private final Object _creator;
    private final Connection _clientConnection;
    @GuardedBy(value="this")
    private java.sql.ResultSet _wrappedResultSet;
    @GuardedBy(value="this")
    private java.sql.ResultSetMetaData _wrappedResultSetMetaData;
    @GuardedBy(value="this")
    private java.sql.ParameterMetaData _wrappedParameterMetaData;

    public static PreparedStatement newInstance(java.sql.PreparedStatement inner, Object creator, Connection clientConnection) {
        return new PreparedStatement(inner, creator, clientConnection);
    }

    private PreparedStatement(java.sql.PreparedStatement inner, Object creator, Connection clientConnection) {
        this._inner = inner;
        this._creator = creator;
        this._clientConnection = clientConnection;
        this._clientConnection._addStatement(this);
    }

    @Override
    public synchronized java.sql.ResultSet executeQuery(String sql) throws SQLException {
        try {
            this._wrappedResultSet = null;
            java.sql.ResultSet result = this._inner.executeQuery(sql);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            this._wrappedResultSet = result;
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate(sql);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this._inner.close();
            this._clientConnection.sendStatementClosedEvent(this);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
        finally {
            this._clientConnection._removeStatement(this);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this._inner.getMaxFieldSize();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        try {
            this._inner.setMaxFieldSize(maxFieldSize);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this._inner.getMaxRows();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        try {
            this._inner.setMaxRows(maxRows);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this._inner.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this._inner.getQueryTimeout();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        try {
            this._inner.setQueryTimeout(queryTimeout);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this._inner.cancel();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this._inner.getWarnings();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this._inner.clearWarnings();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setCursorName(String cursorName) throws SQLException {
        try {
            this._inner.setCursorName(cursorName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute(sql);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized java.sql.ResultSet getResultSet() throws SQLException {
        try {
            if (this._wrappedResultSet == null) {
                this._wrappedResultSet = this._inner.getResultSet();
            }
            if (this._wrappedResultSet != null) {
                this._wrappedResultSet = ResultSet.newInstance(this._wrappedResultSet, this, this._clientConnection);
            }
            return this._wrappedResultSet;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this._inner.getUpdateCount();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.getMoreResults();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this._inner.getFetchDirection();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        try {
            this._inner.setFetchDirection(fetchDirection);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this._inner.getFetchSize();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        try {
            this._inner.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this._inner.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this._inner.getResultSetType();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this._inner.addBatch(sql);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this._inner.clearBatch();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeBatch();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return (java.sql.Connection)this._creator;
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.getMoreResults(current);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getGeneratedKeys();
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this._inner.getResultSetHoldability();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this._inner.isClosed();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this._inner.isPoolable();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setPoolable(boolean isPoolable) throws SQLException {
        try {
            this._inner.setPoolable(isPoolable);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            return this._inner.isCloseOnCompletion();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            this._inner.closeOnCompletion();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            return this._inner.getLargeUpdateCount();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            return this._inner.getLargeMaxRows();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        try {
            this._inner.setLargeMaxRows(max);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeBatch();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate(sql);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized java.sql.ResultSet executeQuery() throws SQLException {
        try {
            this._wrappedResultSet = null;
            java.sql.ResultSet result = this._inner.executeQuery();
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            this._wrappedResultSet = result;
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this._inner.setNull(parameterIndex, sqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            this._inner.setObject(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            this._inner.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            this._inner.setBoolean(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            this._inner.setByte(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            this._inner.setShort(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            this._inner.setInt(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            this._inner.setLong(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            this._inner.setFloat(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            this._inner.setDouble(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            this._inner.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            this._inner.setDate(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            this._inner.setTime(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            this._inner.setTimestamp(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            this._inner.setString(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            this._inner.setBytes(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this._inner.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this._inner.setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this._inner.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this._inner.clearParameters();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            this._inner.addBatch();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            this._inner.setNull(parameterIndex, sqlType, typeName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        try {
            this._inner.setDate(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        try {
            this._inner.setTime(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        try {
            this._inner.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        try {
            this._inner.setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setClob(int parameterIndex, java.sql.Clob x) throws SQLException {
        try {
            this._inner.setClob(parameterIndex, Clob.getInner(x));
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, java.sql.Blob x) throws SQLException {
        try {
            this._inner.setBlob(parameterIndex, Blob.getInner(x));
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setArray(int parameterIndex, java.sql.Array x) throws SQLException {
        try {
            this._inner.setArray(parameterIndex, Array.getInner(x));
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        try {
            this._inner.setRef(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized java.sql.ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (this._wrappedResultSetMetaData == null) {
                this._wrappedResultSetMetaData = this._inner.getMetaData();
            }
            if (this._wrappedResultSetMetaData != null) {
                this._wrappedResultSetMetaData = ResultSetMetaData.newInstance(this._wrappedResultSetMetaData, this, this._clientConnection);
            }
            return this._wrappedResultSetMetaData;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        try {
            this._inner.setURL(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            if (this._wrappedParameterMetaData == null) {
                this._wrappedParameterMetaData = this._inner.getParameterMetaData();
            }
            if (this._wrappedParameterMetaData != null) {
                this._wrappedParameterMetaData = ParameterMetaData.newInstance(this._wrappedParameterMetaData, this, this._clientConnection);
            }
            return this._wrappedParameterMetaData;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        try {
            this._inner.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        try {
            this._inner.setNString(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this._inner.setAsciiStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            this._inner.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        try {
            this._inner.setCharacterStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            this._inner.setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        try {
            this._inner.setNCharacterStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            this._inner.setNCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this._inner.setBinaryStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            this._inner.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        try {
            this._inner.setClob(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            this._inner.setClob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        try {
            this._inner.setNClob(parameterIndex, (NClob)Clob.getInner(x));
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        try {
            this._inner.setNClob(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            this._inner.setNClob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        try {
            this._inner.setBlob(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            this._inner.setBlob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        try {
            this._inner.setRowId(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        try {
            this._inner.setSQLXML(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        try {
            this._inner.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            this._inner.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this._inner.unwrap(iface);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this._inner.isWrapperFor(iface);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    public java.sql.PreparedStatement getInner() {
        return this._inner;
    }

    private void _exceptionOccurred(SQLException e) {
        this._clientConnection.sendConnectionErrorEvent(e);
        this._clientConnection.sendStatementErrorEvent(e, this);
    }
}

