/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.org.java_websocket.client.WebSocketClient;
import com.sap.db.util.org.java_websocket.drafts.Draft_6455;
import com.sap.db.util.org.java_websocket.exceptions.WebsocketNotConnectedException;
import com.sap.db.util.org.java_websocket.handshake.ServerHandshake;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;

@ThreadSafe
class HanaWebSocket
extends WebSocketClient {
    private final Tracer _tracer;
    private final Session _session;
    private final long _communicationTimeout;
    private final boolean _doCommunicationTimeoutCheckOnPing;
    @GuardedBy(value="this")
    private final Queue<ByteBuffer> _queue;
    @GuardedBy(value="this")
    private boolean _isOpened;
    @GuardedBy(value="this")
    private boolean _isClosed;
    @GuardedBy(value="this")
    private ByteBuffer _buffer;
    @GuardedBy(value="this")
    private Exception _exception;
    @GuardedBy(value="this")
    private long _lastReadMillis;

    HanaWebSocket(Tracer tracer, Session session, ConnectionProperties connectionProperties, URI serverUrl, Socket socket) throws RTEException {
        super(serverUrl, new Draft_6455(), null, connectionProperties.getIntProperty(ConnectionProperty.CONNECT_TIMEOUT));
        int webSocketPingTimeout = connectionProperties.getIntProperty(ConnectionProperty.WEB_SOCKET_PING_TIMEOUT);
        this.setSocket(socket);
        this._tracer = tracer;
        this._session = session;
        this._communicationTimeout = connectionProperties.getIntProperty(ConnectionProperty.COMMUNICATION_TIMEOUT);
        this._doCommunicationTimeoutCheckOnPing = this._communicationTimeout > 0L && webSocketPingTimeout > 0;
        this._queue = new LinkedList<ByteBuffer>();
        this._isOpened = false;
        this._isClosed = true;
        try {
            if (!super.connectBlocking()) {
                throw RTEException.newInstance(tracer, session, MessageTranslator.translate("error.host.connect", serverUrl.toString(), this._exception != null ? this._exception.getMessage() : "Unknown error", RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
            }
        }
        catch (InterruptedException e) {
            throw RTEException.newInstance(tracer, session, MessageTranslator.translate("error.host.connect", serverUrl.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, e);
        }
        if (this._exception != null) {
            throw RTEException.newInstance(tracer, session, MessageTranslator.translate("error.host.connect", serverUrl.toString(), this._exception.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, this._exception);
        }
        this.setConnectionLostTimeout(webSocketPingTimeout);
    }

    @Override
    public synchronized void onOpen(ServerHandshake handshakedata) {
        this._isOpened = true;
        this._isClosed = false;
        this.notify();
    }

    @Override
    public void onMessage(String message) {
    }

    @Override
    public synchronized void onClose(int code, String reason, boolean remote) {
        this._isClosed = true;
        this.notify();
    }

    @Override
    public synchronized void onError(Exception e) {
        this._exception = e;
        this.close();
    }

    @Override
    protected synchronized boolean onCheckCommunicationTimeout() {
        long now;
        long elapsed;
        return this._doCommunicationTimeoutCheckOnPing && (elapsed = (now = System.currentTimeMillis()) - this._lastReadMillis) > this._communicationTimeout;
    }

    @Override
    public synchronized void onMessage(ByteBuffer buffer) {
        this._queue.add(buffer);
        this.notify();
    }

    synchronized void _writeSocket(byte[] buffer, int len) throws RTEException {
        while (!this._isOpened && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw RTEException.newInstance(this._tracer, this._session, MessageTranslator.translate("error.send.write", e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN, e);
            }
        }
        if (this._isClosed) {
            throw RTEException.newInstance(this._tracer, this._session, MessageTranslator.translate("error.send.write", "Connection closed"), RteReturnCode.SQLSEND_LINE_DOWN);
        }
        if (this._exception != null) {
            throw RTEException.newInstance(this._tracer, this._session, MessageTranslator.translate("error.send.write", this._exception.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN, this._exception);
        }
        try {
            super.send(ByteBuffer.wrap(buffer, 0, len));
        }
        catch (WebsocketNotConnectedException e) {
            throw RTEException.newInstance(this._tracer, this._session, MessageTranslator.translate("error.send.write", "WebsocketNotConnectedException"), RteReturnCode.SQLSEND_LINE_DOWN, e);
        }
    }

    synchronized int _readSocket(byte[] buffer, int off, int len) throws RTEException {
        int remaining;
        if (this._doCommunicationTimeoutCheckOnPing) {
            this._lastReadMillis = System.currentTimeMillis();
        }
        int n = remaining = this._buffer != null ? this._buffer.remaining() : 0;
        if (remaining == 0) {
            while (this._queue.isEmpty() && !this._isClosed && this._exception == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw RTEException.newInstance(this._tracer, this._session, MessageTranslator.translate("error.data.receivefailed.reason", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN, e);
                }
            }
            if (this._isClosed) {
                throw RTEException.newInstance(this._tracer, this._session, MessageTranslator.translate("error.data.receivefailed.reason", "Connection closed"), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            if (this._exception != null) {
                throw RTEException.newInstance(this._tracer, this._session, MessageTranslator.translate("error.data.receivefailed.reason", this._exception.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN, this._exception);
            }
            this._buffer = this._queue.poll();
            if (this._buffer == null) {
                throw RTEException.newInstance(this._tracer, this._session, MessageTranslator.translate("error.data.receivefailed.reason", "No data"), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            remaining = this._buffer.remaining();
        }
        int returned = Math.min(len, remaining);
        this._buffer.get(buffer, off, returned);
        return returned;
    }
}

