/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DBConnectInfo;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.RedirectionType;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.security.AbstractAuthenticationManager;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import com.sap.db.util.security.AuthenticationMethodType;
import com.sap.db.util.security.GSSAuthentication;
import com.sap.db.util.security.JWTAuthentication;
import com.sap.db.util.security.LDAPAuthentication;
import com.sap.db.util.security.SAMLAuthentication;
import com.sap.db.util.security.SAPLogonAuthentication;
import com.sap.db.util.security.ScramPBKDF2SHA256Authentication;
import com.sap.db.util.security.ScramSHA256Authentication;
import com.sap.db.util.security.SessionCookieAuthentication;
import com.sap.db.util.security.X509Authentication;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ietf.jgss.GSSException;

@NotThreadSafe
public class AuthenticationManager
extends AbstractAuthenticationManager {
    private final Map<String, AbstractAuthenticationMethod> _methods = new LinkedHashMap<String, AbstractAuthenticationMethod>();
    private AbstractAuthenticationMethod _currentMethod;

    @Override
    public Session authenticate(SessionFactory factory, ConnectionSapDB connection, Session session, boolean isAnchorSession, String userName, String passwd, String x509, Set<AuthenticationMethodType> activeMethods, boolean isReattach, Integer[] outServerReattachStatus) throws RTEException, SQLException {
        HReplyPacket replyPacket;
        byte[] data;
        String methodName;
        HAuthenticationPart authenticationPart;
        HRequestPacket requestPacket;
        boolean errorOccurred;
        boolean hasX509;
        Tracer tracer = connection.getTracer();
        boolean hasUserName = userName != null && !userName.isEmpty();
        boolean hasPasswd = !passwd.isEmpty();
        boolean bl = hasX509 = x509 != null && !x509.isEmpty();
        if (activeMethods.contains((Object)AuthenticationMethodType.SESSIONCOOKIE) && hasUserName && connection.getCookie() != null) {
            this._methods.put("SessionCookie", new SessionCookieAuthentication(connection));
            if (tracer.on()) {
                tracer.printDebugMessage("Using SESSIONCOOKIE Authentication");
            }
        } else {
            block46: {
                if (activeMethods.contains((Object)AuthenticationMethodType.X509) && !hasUserName && !hasPasswd && hasX509 && x509.startsWith("-----BEGIN")) {
                    this._methods.put("X509", new X509Authentication());
                    if (tracer.on()) {
                        tracer.printDebugMessage("Including X509 Authentication");
                    }
                }
                if (!hasPasswd) {
                    try {
                        if (activeMethods.contains((Object)AuthenticationMethodType.KERBEROS)) {
                            this._methods.put("GSS", new GSSAuthentication(connection));
                        }
                        if (tracer.on()) {
                            tracer.printDebugMessage("Including KERBEROS Authentication");
                        }
                        break block46;
                    }
                    catch (GSSException e) {
                        if (tracer.on()) {
                            tracer.printDebugThrowable(e, "Rejecting KERBEROS Authentication");
                        }
                        break block46;
                    }
                }
                if (tracer.on()) {
                    tracer.printDebugMessage("Rejecting KERBEROS Authentication: Password is not empty");
                }
                if (!hasUserName) {
                    if (activeMethods.contains((Object)AuthenticationMethodType.SAML) && passwd.startsWith("<")) {
                        this._methods.put("SAML", new SAMLAuthentication());
                        if (tracer.on()) {
                            tracer.printDebugMessage("Including SAML Authentication");
                        }
                    } else if (activeMethods.contains((Object)AuthenticationMethodType.SAPLOGON) && passwd.startsWith("Aj")) {
                        this._methods.put("SAPLogon", new SAPLogonAuthentication());
                        if (tracer.on()) {
                            tracer.printDebugMessage("Including SAPLOGON Authentication");
                        }
                    } else if (activeMethods.contains((Object)AuthenticationMethodType.JWT) && passwd.startsWith("ey")) {
                        this._methods.put("JWT", new JWTAuthentication());
                        if (tracer.on()) {
                            tracer.printDebugMessage("Including JWT Authentication");
                        }
                    } else if (tracer.on()) {
                        tracer.printDebugMessage("Rejecting SAML, SAPLOGON, and JWT Authentication: Unknown ticket prefix or authentication methods excluded");
                    }
                } else if (tracer.on()) {
                    tracer.printDebugMessage("Rejecting SAML, SAPLOGON, and JWT Authentication: User name is not empty");
                }
            }
            if (activeMethods.contains((Object)AuthenticationMethodType.LDAP) && hasUserName && hasPasswd) {
                this._methods.put("LDAP", new LDAPAuthentication());
                if (tracer.on()) {
                    tracer.printDebugMessage("Including LDAP Authentication");
                }
            }
            if (activeMethods.contains((Object)AuthenticationMethodType.PBKDF2)) {
                this._methods.put("SCRAMPBKDF2SHA256", new ScramPBKDF2SHA256Authentication());
                if (tracer.on()) {
                    tracer.printDebugMessage("Including PBKDF2 Authentication");
                }
            }
            if (activeMethods.contains((Object)AuthenticationMethodType.PASSWORD)) {
                this._methods.put("SCRAMSHA256", new ScramSHA256Authentication());
                if (tracer.on()) {
                    tracer.printDebugMessage("Including PASSWORD Authentication");
                }
            }
        }
        if (this._methods.isEmpty()) {
            throw new SQLException(MessageTranslator.translate("error.connection.noauthenticationmethodavailable", new Object[0]), "08001", -11111);
        }
        do {
            errorOccurred = false;
            requestPacket = connection.initAuthenticate(session);
            authenticationPart = requestPacket.addAuthenticationPart();
            authenticationPart.addArg();
            authenticationPart.addRow(2 * this._methods.size() + 1);
            authenticationPart.addString(userName);
            for (Map.Entry<String, AbstractAuthenticationMethod> entry : new LinkedHashMap<String, AbstractAuthenticationMethod>(this._methods).entrySet()) {
                methodName = entry.getKey();
                AbstractAuthenticationMethod method = entry.getValue();
                try {
                    authenticationPart.addBytes(methodName.getBytes(StandardCharsets.UTF_8));
                    authenticationPart.addBytes(method.getInitialData(passwd.getBytes(StandardCharsets.UTF_8)));
                }
                catch (SQLException e) {
                    errorOccurred = true;
                    if (tracer.on()) {
                        tracer.printDebugThrowable(e, "Reject authentication method " + method.getMethodName());
                    }
                    this._methods.remove(methodName);
                    if (!this._methods.isEmpty()) continue;
                    throw new SQLException(MessageTranslator.translate("error.connection.noauthenticationmethodavailable", new Object[0]), "08001", -11111);
                }
            }
            if (errorOccurred) continue;
            authenticationPart.close();
            if (isReattach) {
                requestPacket.addSessionReattachPart(session);
                continue;
            }
            if (!isAnchorSession || connection.getRedirectionType() != RedirectionType.None) continue;
            requestPacket.addDBConnectInfoPart(connection.getConnectionProperty(ConnectionProperty.NETWORK_GROUP));
        } while (errorOccurred);
        do {
            requestPacket.close();
            replyPacket = connection.exchange(session, requestPacket, null, ConnectionSapDB.ExchangeFlag.IGNORE_ERRORS);
            DBConnectInfo dbConnectInfo = replyPacket.findDBConnectInfo(0);
            if (dbConnectInfo != null) {
                Session newSession;
                connection.setRedirectionType(RedirectionType.TenantWithAZAware);
                connection.setRedirectedHost(dbConnectInfo.getHost());
                connection.setRedirectedPort(dbConnectInfo.getPort());
                try {
                    newSession = session._processDBConnectInfoPart(factory, dbConnectInfo);
                }
                catch (RTEException e) {
                    if (connection.getBooleanConnectionProperty(ConnectionProperty.RETRY_PREFERRED_ADDRESS_ON_REDIRECT_FAIL)) {
                        connection.setRedirectionType(RedirectionType.Disabled);
                        connection.setRedirectedHost(null);
                        connection.setRedirectedPort(0);
                        newSession = session._retryPreferredAddress(factory);
                    }
                    throw e;
                }
                return this.authenticate(factory, connection, newSession, isAnchorSession, userName, passwd, x509, activeMethods, isReattach, outServerReattachStatus);
            }
            SQLException sqlExceptionChain = replyPacket.findSQLExceptionChain(null, 0);
            if (sqlExceptionChain != null) {
                throw sqlExceptionChain;
            }
            authenticationPart = replyPacket.findAuthenticationPart(0);
            if (authenticationPart == null || !authenticationPart.nextField()) {
                throw SQLExceptionSapDB.newInstance("error.connection.noauthenticationmethodavailable", new String[0]);
            }
            methodName = authenticationPart.getValueAsString();
            this._currentMethod = this._methods.get(methodName);
            authenticationPart.nextField();
            data = this._currentMethod.evaluateAuthenticateReply(tracer, authenticationPart);
            if (data == null) continue;
            requestPacket = connection.initAuthenticate(session);
            authenticationPart = requestPacket.addAuthenticationPart();
            authenticationPart.addArg();
            authenticationPart.addRow(2);
            authenticationPart.addBytes(methodName.getBytes(StandardCharsets.UTF_8));
            authenticationPart.addBytes(data);
            authenticationPart.close();
        } while (data != null);
        if (isReattach && outServerReattachStatus != null) {
            outServerReattachStatus[0] = replyPacket.findServerReattachStatus(0);
        }
        return session;
    }

    @Override
    public void setClientProofPart(HAuthenticationPart authenticationPart, String userName, String passwd, String x509) throws SQLException {
        authenticationPart.addArg();
        authenticationPart.addRow(3);
        authenticationPart.addString(userName);
        authenticationPart.addString(this._currentMethod.getMethodName());
        authenticationPart.addBytes(this._currentMethod.getFinalData(passwd, x509));
    }

    @Override
    public String getMethodName() {
        return this._currentMethod != null ? this._currentMethod.getMethodName() : "NULL";
    }

    @Override
    public String evaluateConnectReply(Tracer tracer, HAuthenticationPart authenticationPart) throws SQLException {
        return this._currentMethod != null ? this._currentMethod.evaluateConnectReply(tracer, authenticationPart) : null;
    }

    @Override
    String getUserNameFromServer() {
        return this._currentMethod != null ? this._currentMethod.getUserNameFromServer() : null;
    }

    @Override
    void onAuthenticationCompleted() {
        if (this._currentMethod != null) {
            this._currentMethod.onAuthenticationCompleted();
        }
    }
}

