/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.Base64Utils;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.SQLException;
import java.util.List;

@NotThreadSafe
class X509Authentication
extends AbstractAuthenticationMethod {
    static final String METHOD_NAME = "X509";
    static final String METHOD_TICKET_PREFIX = "-----BEGIN";
    private byte[] _serverNonce;
    private String _userName;

    X509Authentication() {
    }

    @Override
    String getMethodName() {
        return METHOD_NAME;
    }

    @Override
    byte[] getInitialData(byte[] passwd) throws SQLException {
        return new byte[0];
    }

    @Override
    byte[] getFinalData(String passwd, String x509) throws SQLException {
        int signatureOutputLengthIndicatorLength;
        int signatureOutputLength;
        byte[] signatureOutput;
        int i;
        int totalChainCertificatesLength;
        int[] chainCertificateLengthIndicatorLengths;
        int[] chainCertificateLengths;
        byte[][] chainCertificates;
        List<byte[]> keys = Base64Utils.decodePrivateKeys(x509);
        List<byte[]> certs = Base64Utils.decodeCertificates(x509);
        if (keys.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.connection.x509.missingprivatekey", new String[0]);
        }
        if (certs.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.connection.x509.missingcertificates", new String[0]);
        }
        byte[] ownCertificate = certs.get(0);
        int ownCertificateLength = ownCertificate.length;
        int ownCertificateLengthIndicatorLength = HAuthenticationPart.getLengthIndicatorLength(ownCertificateLength);
        int chainCertificateCount = certs.size() - 1;
        if (chainCertificateCount > 0) {
            chainCertificates = new byte[chainCertificateCount][];
            chainCertificateLengths = new int[chainCertificateCount];
            chainCertificateLengthIndicatorLengths = new int[chainCertificateCount];
            totalChainCertificatesLength = 2;
            for (i = 0; i < chainCertificateCount; ++i) {
                chainCertificates[i] = certs.get(i + 1);
                chainCertificateLengths[i] = chainCertificates[i].length;
                chainCertificateLengthIndicatorLengths[i] = HAuthenticationPart.getLengthIndicatorLength(chainCertificateLengths[i]);
                totalChainCertificatesLength += chainCertificateLengthIndicatorLengths[i] + chainCertificateLengths[i];
            }
        } else {
            chainCertificates = null;
            chainCertificateLengths = null;
            chainCertificateLengthIndicatorLengths = null;
            totalChainCertificatesLength = 0;
        }
        int totalChainCertificatesLengthIndicatorLength = HAuthenticationPart.getLengthIndicatorLength(totalChainCertificatesLength);
        try {
            PrivateKey privateKey = X509Authentication._createPrivateKeyFromBytes(keys.get(0));
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(ownCertificate);
            for (i = 0; i < chainCertificateCount; ++i) {
                signature.update(chainCertificates[i]);
            }
            signature.update(this._serverNonce);
            signatureOutput = signature.sign();
            signatureOutputLength = signatureOutput.length;
            signatureOutputLengthIndicatorLength = HAuthenticationPart.getLengthIndicatorLength(signatureOutputLength);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.x509.signingfailed", e.getMessage());
        }
        int totalLength = 2 + ownCertificateLengthIndicatorLength + ownCertificateLength + totalChainCertificatesLengthIndicatorLength + totalChainCertificatesLength + signatureOutputLengthIndicatorLength + signatureOutputLength;
        byte[] bytes = new byte[totalLength];
        int offset = 0;
        ByteUtils.putShort(3, bytes, offset);
        HAuthenticationPart.putLengthIndicator(ownCertificateLength, bytes, offset += 2);
        ByteUtils.putBytes(ownCertificate, bytes, offset += ownCertificateLengthIndicatorLength);
        HAuthenticationPart.putLengthIndicator(totalChainCertificatesLength, bytes, offset += ownCertificateLength);
        offset += totalChainCertificatesLengthIndicatorLength;
        if (chainCertificateCount > 0) {
            ByteUtils.putShort(chainCertificateCount, bytes, offset);
            offset += 2;
            for (i = 0; i < chainCertificateCount; ++i) {
                HAuthenticationPart.putLengthIndicator(chainCertificateLengths[i], bytes, offset);
                ByteUtils.putBytes(chainCertificates[i], bytes, offset += chainCertificateLengthIndicatorLengths[i]);
                offset += chainCertificateLengths[i];
            }
        }
        HAuthenticationPart.putLengthIndicator(signatureOutputLength, bytes, offset);
        ByteUtils.putBytes(signatureOutput, bytes, offset += signatureOutputLengthIndicatorLength);
        offset += signatureOutputLength;
        return bytes;
    }

    @Override
    byte[] evaluateAuthenticateReply(Tracer tracer, HAuthenticationPart authenticationPart) throws SQLException {
        this._serverNonce = authenticationPart.getValueAsBytes();
        return null;
    }

    @Override
    String evaluateConnectReply(Tracer tracer, HAuthenticationPart authenticationPart) throws SQLException {
        HAuthenticationPart part = new HAuthenticationPart(authenticationPart);
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.packet.wrongpacketformat", new String[0]);
        }
        this._userName = part.getValueAsString();
        if (tracer.on()) {
            tracer.printDebugMessage("X509 Authentication: User: " + this._userName);
        }
        if (!part.nextField()) {
            return null;
        }
        String sessionCookie = part.getValueAsString();
        if (tracer.on()) {
            tracer.printDebugMessage("X509 Authentication: Received session cookie");
        }
        return sessionCookie;
    }

    @Override
    String getUserNameFromServer() {
        return this._userName;
    }

    private static PrivateKey _createPrivateKeyFromBytes(byte[] keyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        PrivateKey key = factory.generatePrivate(keySpec);
        return key;
    }
}

