/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.AbstractDateTimeConverter;
import com.sap.db.jdbc.converters.InputStreamFilter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.Cesu8Utils;
import com.sap.db.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
class CharacterConverter
extends AbstractConverter {
    private static final ThreadLocal<Calendar> _staticCal = ThreadLocal.withInitial(Calendar::getInstance);
    protected final Lock _calLock;
    @GuardedBy(value="_calLock")
    protected final Calendar _cal;

    protected CharacterConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
        if (this._timeZonePerObject) {
            this._calLock = new ReentrantLock();
            this._cal = Calendar.getInstance();
        } else {
            this._calLock = null;
            this._cal = null;
        }
    }

    @Override
    public int getEstimatedColumnSize() {
        int dataLen = this._isEncrypted ? this._cipher.getEncryptedLength(this._isDeterministic ? this._length : this._length + 1) : this._length;
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        return dataLen + dataLengthIndicatorLen;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof String)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        String value = (String)data;
        int valueLength = Cesu8Utils.getByteLength(value);
        int dataLen = this._isEncrypted ? this._cipher.getEncryptedLength(this._isDeterministic ? valueLength : valueLength + 1) : valueLength;
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        return dataLen + dataLengthIndicatorLen + 1;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof String)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        String value = (String)data;
        if (this._isEncrypted) {
            int off;
            byte[] bytes;
            int len = Cesu8Utils.getByteLength(value);
            if (this._isDeterministic) {
                bytes = new byte[len];
                off = 0;
            } else {
                bytes = new byte[len + 1];
                ByteUtils.putByte(1, bytes, 0);
                off = 1;
            }
            Cesu8Utils.putBytes(value, bytes, off);
            byte[] encrypted = this._getEncryptedBuffer(bytes);
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putStringAsString(value);
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsString(controller, dataPart, null);
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return this.setBoolean((Boolean)value);
        }
        if (value instanceof Byte) {
            return this.setByte((Byte)value);
        }
        if (value instanceof Short) {
            return this.setShort((Short)value);
        }
        if (value instanceof Integer) {
            return this.setInt((Integer)value);
        }
        if (value instanceof Long) {
            return this.setLong((Long)value);
        }
        if (value instanceof Float) {
            return this.setFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.setDouble((Double)value);
        }
        if (value instanceof BigDecimal) {
            return this.setBigDecimal((BigDecimal)value);
        }
        if (value instanceof Date) {
            return this.setDate((Date)value, null);
        }
        if (value instanceof Time) {
            return this.setTime((Time)value, null);
        }
        if (value instanceof Timestamp) {
            return this.setTimestamp((Timestamp)value, null);
        }
        if (value instanceof LocalDate) {
            return this.setLocalDate((LocalDate)value);
        }
        if (value instanceof LocalTime) {
            return this.setLocalTime((LocalTime)value);
        }
        if (value instanceof LocalDateTime) {
            return this.setLocalDateTime((LocalDateTime)value);
        }
        if (value instanceof OffsetTime) {
            return this.setOffsetTime((OffsetTime)value);
        }
        if (value instanceof OffsetDateTime) {
            return this.setOffsetDateTime((OffsetDateTime)value);
        }
        if (value instanceof ZonedDateTime) {
            return this.setZonedDateTime((ZonedDateTime)value);
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        if (value instanceof byte[]) {
            return this.setBytes((byte[])value);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, outIsNull);
        if (value == null) {
            return false;
        }
        if (Boolean.parseBoolean(value)) {
            return true;
        }
        try {
            return !new BigDecimal(value).equals(BigDecimal.ZERO);
        }
        catch (NumberFormatException e1) {
            return false;
        }
    }

    @Override
    public String setBoolean(boolean value) throws SQLException {
        return this._checkLength(value ? "1" : "0");
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, outIsNull);
        if (value == null) {
            return 0;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            try {
                return new BigDecimal(value).byteValue();
            }
            catch (NumberFormatException e1) {
                throw CharacterConverter._newGetConversionException(value, "byte");
            }
        }
    }

    @Override
    public String setByte(byte value) throws SQLException {
        return this._checkLength(String.valueOf(value));
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, outIsNull);
        if (value == null) {
            return 0;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            try {
                return new BigDecimal(value).shortValue();
            }
            catch (NumberFormatException e1) {
                throw CharacterConverter._newGetConversionException(value, "short");
            }
        }
    }

    @Override
    public String setShort(short value) throws SQLException {
        return this._checkLength(String.valueOf(value));
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, outIsNull);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            try {
                return new BigDecimal(value).intValue();
            }
            catch (NumberFormatException e1) {
                throw CharacterConverter._newGetConversionException(value, "int");
            }
        }
    }

    @Override
    public String setInt(int value) throws SQLException {
        return this._checkLength(String.valueOf(value));
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, outIsNull);
        if (value == null) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            try {
                return new BigDecimal(value).longValue();
            }
            catch (NumberFormatException e1) {
                throw CharacterConverter._newGetConversionException(value, "long");
            }
        }
    }

    @Override
    public String setLong(long value) throws SQLException {
        return this._checkLength(String.valueOf(value));
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, outIsNull);
        if (value == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            try {
                return new BigDecimal(value).floatValue();
            }
            catch (NumberFormatException e1) {
                throw CharacterConverter._newGetConversionException(value, "float");
            }
        }
    }

    @Override
    public String setFloat(float value) throws SQLException {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw CharacterConverter._newSetNumericValueInvalidException(String.valueOf(value));
        }
        return this._checkLength(StringUtils.DECIMAL_FORMAT.get().format(value));
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, outIsNull);
        if (value == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            try {
                return new BigDecimal(value).doubleValue();
            }
            catch (NumberFormatException e1) {
                throw CharacterConverter._newGetConversionException(value, "double");
            }
        }
    }

    @Override
    public String setDouble(double value) throws SQLException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw CharacterConverter._newSetNumericValueInvalidException(String.valueOf(value));
        }
        return this._checkLength(StringUtils.DECIMAL_FORMAT.get().format(value));
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        if (value == null) {
            return null;
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e1) {
            throw CharacterConverter._newGetConversionException(value, "java.math.BigDecimal");
        }
    }

    @Override
    public String setBigDecimal(BigDecimal value) throws SQLException {
        return value != null ? this._checkLength(value.toPlainString()) : null;
    }

    @Override
    public Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        if (value == null) {
            return null;
        }
        try {
            return this._getDate(value, cal);
        }
        catch (IllegalArgumentException e) {
            try {
                return new Date(this._getTimestamp(value, cal).getTime());
            }
            catch (IllegalArgumentException e1) {
                throw CharacterConverter._newGetConversionException(value, "java.sql.Date");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setDate(Date value, Calendar cal) throws SQLException {
        int dayOfMonth;
        int month;
        int year;
        if (value == null) {
            return null;
        }
        if (cal == null && this._timeZonePerObject) {
            this._calLock.lock();
        }
        try {
            Calendar calendar = cal == null ? (this._timeZonePerObject ? this._cal : _staticCal.get()) : cal;
            calendar.setTime(value);
            year = calendar.get(1);
            month = calendar.get(2);
            dayOfMonth = calendar.get(5);
        }
        finally {
            if (cal == null && this._timeZonePerObject) {
                this._calLock.unlock();
            }
        }
        return this._checkLength(String.format("%04d-%02d-%02d", year, month + 1, dayOfMonth));
    }

    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        if (value == null) {
            return null;
        }
        try {
            return this._getTime(value, cal);
        }
        catch (IllegalArgumentException e) {
            if (cal == null && this._timeZonePerObject) {
                this._calLock.lock();
            }
            try {
                Calendar calendar = cal == null ? (this._timeZonePerObject ? this._cal : _staticCal.get()) : cal;
                Time time = new Time(AbstractDateTimeConverter._normalizeTimeMilliseconds(this._getTimestamp(value, cal).getTime(), calendar));
                return time;
            }
            catch (IllegalArgumentException e1) {
                throw CharacterConverter._newGetConversionException(value, "java.sql.Time");
            }
            finally {
                if (cal == null && this._timeZonePerObject) {
                    this._calLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setTime(Time value, Calendar cal) throws SQLException {
        int second;
        int minute;
        int hourOfDay;
        if (value == null) {
            return null;
        }
        if (cal == null && this._timeZonePerObject) {
            this._calLock.lock();
        }
        try {
            Calendar calendar = cal == null ? (this._timeZonePerObject ? this._cal : _staticCal.get()) : cal;
            calendar.setTime(value);
            hourOfDay = calendar.get(11);
            minute = calendar.get(12);
            second = calendar.get(13);
        }
        finally {
            if (cal == null && this._timeZonePerObject) {
                this._calLock.unlock();
            }
        }
        return this._checkLength(String.format("%02d:%02d:%02d", hourOfDay, minute, second));
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        if (value == null) {
            return null;
        }
        try {
            return this._getTimestamp(value, cal);
        }
        catch (IllegalArgumentException e) {
            try {
                return new Timestamp(this._getDate(value, cal).getTime());
            }
            catch (IllegalArgumentException e1) {
                throw CharacterConverter._newGetConversionException(value, "java.sql.Timestamp");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        int second;
        int minute;
        int hourOfDay;
        int dayOfMonth;
        int month;
        int year;
        if (value == null) {
            return null;
        }
        if (cal == null && this._timeZonePerObject) {
            this._calLock.lock();
        }
        try {
            Calendar calendar = cal == null ? (this._timeZonePerObject ? this._cal : _staticCal.get()) : cal;
            calendar.setTime(value);
            year = calendar.get(1);
            month = calendar.get(2);
            dayOfMonth = calendar.get(5);
            hourOfDay = calendar.get(11);
            minute = calendar.get(12);
            second = calendar.get(13);
        }
        finally {
            if (cal == null && this._timeZonePerObject) {
                this._calLock.unlock();
            }
        }
        return this._checkLength(String.format("%04d-%02d-%02d %02d:%02d:%02d.%09d", year, month + 1, dayOfMonth, hourOfDay, minute, second, value.getNanos()));
    }

    @Override
    public LocalDate getLocalDate(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        if (value == null) {
            return null;
        }
        try {
            return LocalDate.parse(value);
        }
        catch (DateTimeParseException e) {
            try {
                return this._getDate(value, null).toLocalDate();
            }
            catch (IllegalArgumentException e1) {
                try {
                    return new Date(this._getTimestamp(value, null).getTime()).toLocalDate();
                }
                catch (IllegalArgumentException e2) {
                    throw CharacterConverter._newGetConversionException(value, "java.time.LocalDate");
                }
            }
        }
    }

    @Override
    public String setLocalDate(LocalDate value) throws SQLException {
        return value != null ? this._checkLength(value.toString()) : null;
    }

    @Override
    public LocalTime getLocalTime(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        if (value == null) {
            return null;
        }
        try {
            return LocalTime.parse(value);
        }
        catch (DateTimeParseException e) {
            try {
                return this._getTimestamp(value, null).toLocalDateTime().toLocalTime();
            }
            catch (IllegalArgumentException e1) {
                try {
                    return new Timestamp(this._getDate(value, null).getTime()).toLocalDateTime().toLocalTime();
                }
                catch (IllegalArgumentException e2) {
                    throw CharacterConverter._newGetConversionException(value, "java.time.LocalTime");
                }
            }
        }
    }

    @Override
    public String setLocalTime(LocalTime value) throws SQLException {
        return value != null ? this._checkLength(value.toString()) : null;
    }

    @Override
    public LocalDateTime getLocalDateTime(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        if (value == null) {
            return null;
        }
        try {
            return LocalDateTime.parse(value);
        }
        catch (DateTimeParseException e) {
            try {
                return this._getTimestamp(value, null).toLocalDateTime();
            }
            catch (IllegalArgumentException e1) {
                try {
                    return new Timestamp(this._getDate(value, null).getTime()).toLocalDateTime();
                }
                catch (IllegalArgumentException e2) {
                    throw CharacterConverter._newGetConversionException(value, "java.time.LocalDateTime");
                }
            }
        }
    }

    @Override
    public String setLocalDateTime(LocalDateTime value) throws SQLException {
        return value != null ? this._checkLength(value.toString()) : null;
    }

    @Override
    public OffsetTime getOffsetTime(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        if (value == null) {
            return null;
        }
        try {
            return OffsetTime.parse(value);
        }
        catch (DateTimeParseException e) {
            try {
                return OffsetTime.of(this._getTimestamp(value, null).toLocalDateTime().toLocalTime(), ZoneOffset.UTC);
            }
            catch (IllegalArgumentException e1) {
                try {
                    return OffsetTime.of(new Timestamp(this._getDate(value, null).getTime()).toLocalDateTime().toLocalTime(), ZoneOffset.UTC);
                }
                catch (IllegalArgumentException e2) {
                    throw CharacterConverter._newGetConversionException(value, "java.time.OffsetTime");
                }
            }
        }
    }

    @Override
    public String setOffsetTime(OffsetTime value) throws SQLException {
        return value != null ? this._checkLength(value.toString()) : null;
    }

    @Override
    public OffsetDateTime getOffsetDateTime(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        if (value == null) {
            return null;
        }
        try {
            return OffsetDateTime.parse(value);
        }
        catch (DateTimeParseException e) {
            try {
                return OffsetDateTime.of(this._getTimestamp(value, null).toLocalDateTime(), ZoneOffset.UTC);
            }
            catch (IllegalArgumentException e1) {
                try {
                    return OffsetDateTime.of(new Timestamp(this._getDate(value, null).getTime()).toLocalDateTime(), ZoneOffset.UTC);
                }
                catch (IllegalArgumentException e2) {
                    throw CharacterConverter._newGetConversionException(value, "java.time.OffsetDateTime");
                }
            }
        }
    }

    @Override
    public String setOffsetDateTime(OffsetDateTime value) throws SQLException {
        return value != null ? this._checkLength(value.toString()) : null;
    }

    @Override
    public ZonedDateTime getZonedDateTime(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        if (value == null) {
            return null;
        }
        try {
            return ZonedDateTime.parse(value);
        }
        catch (DateTimeParseException e) {
            try {
                return ZonedDateTime.of(this._getTimestamp(value, null).toLocalDateTime(), ZoneOffset.UTC);
            }
            catch (IllegalArgumentException e1) {
                try {
                    return ZonedDateTime.of(new Timestamp(this._getDate(value, null).getTime()).toLocalDateTime(), ZoneOffset.UTC);
                }
                catch (IllegalArgumentException e2) {
                    throw CharacterConverter._newGetConversionException(value, "java.time.ZonedDateTime");
                }
            }
        }
    }

    @Override
    public String setZonedDateTime(ZonedDateTime value) throws SQLException {
        return value != null ? this._checkLength(value.toString()) : null;
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsString(controller, dataPart, null);
    }

    @Override
    public String setString(String value) throws SQLException {
        return this._checkLength(value);
    }

    @Override
    public byte[] getBytes(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        return value != null ? value.getBytes() : null;
    }

    @Override
    public String setBytes(byte[] value) throws SQLException {
        return value != null ? this._checkLength(new String(value)) : null;
    }

    @Override
    public Reader getCharacterStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        return value != null ? new StringReader(value) : null;
    }

    @Override
    public String setCharacterStream(Reader value, long length) throws SQLException {
        return value != null ? this._checkLength(CharacterConverter._convertReaderToString(value, length)) : null;
    }

    @Override
    public InputStream getAsciiStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        return value != null ? new ByteArrayInputStream(value.getBytes(StandardCharsets.ISO_8859_1)) : null;
    }

    @Override
    public String setAsciiStream(InputStream value, long length) throws SQLException {
        return value != null ? this._checkLength(CharacterConverter._convertReaderToString(new InputStreamReader(length >= 0L ? new InputStreamFilter(value, length) : value, StandardCharsets.ISO_8859_1), -1L)) : null;
    }

    @Override
    public InputStream getBinaryStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart, null);
        return value != null ? new ByteArrayInputStream(value.getBytes()) : null;
    }

    @Override
    public String setBinaryStream(InputStream value, long length) throws SQLException {
        return value != null ? this._checkLength(CharacterConverter._convertReaderToString(new InputStreamReader(length >= 0L ? new InputStreamFilter(value, length) : value), -1L)) : null;
    }

    protected String _getValueAsString(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        boolean isNull = dataPart.isNull(this, controller, decrypted);
        if (outIsNull != null) {
            outIsNull[0] = isNull;
        }
        if (isNull) {
            return null;
        }
        if (this._isEncrypted) {
            int len;
            int off;
            if (this._isDeterministic) {
                decrypted = this._getDecryptedBuffer(dataPart);
                off = 0;
                len = decrypted.length;
            } else {
                off = 1;
                len = decrypted.length - 1;
            }
            return Cesu8Utils.getString(decrypted, off, len, this._lenientCESU8);
        }
        return dataPart.getCharacterAsString(this._lenientCESU8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date _getDate(String value, Calendar cal) throws IllegalArgumentException {
        int dayOfMonth;
        int month;
        int year;
        Date date = Date.valueOf(value);
        if (cal == null) {
            return date;
        }
        if (this._timeZonePerObject) {
            this._calLock.lock();
        }
        try {
            Calendar calendar = this._timeZonePerObject ? this._cal : _staticCal.get();
            calendar.setTime(date);
            year = calendar.get(1);
            month = calendar.get(2);
            dayOfMonth = calendar.get(5);
        }
        finally {
            if (this._timeZonePerObject) {
                this._calLock.unlock();
            }
        }
        cal.clear();
        cal.set(year, month, dayOfMonth);
        date.setTime(cal.getTimeInMillis());
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Time _getTime(String value, Calendar cal) throws IllegalArgumentException {
        int second;
        int minute;
        int hourOfDay;
        Time time = new Time(AbstractDateTimeConverter._normalizeTimeMilliseconds(Time.valueOf(value).getTime()));
        if (cal == null) {
            return time;
        }
        if (this._timeZonePerObject) {
            this._calLock.lock();
        }
        try {
            Calendar calendar = this._timeZonePerObject ? this._cal : _staticCal.get();
            calendar.setTime(time);
            hourOfDay = calendar.get(11);
            minute = calendar.get(12);
            second = calendar.get(13);
        }
        finally {
            if (this._timeZonePerObject) {
                this._calLock.unlock();
            }
        }
        cal.clear();
        cal.set(11, hourOfDay);
        cal.set(12, minute);
        cal.set(13, second);
        time.setTime(AbstractDateTimeConverter._normalizeTimeMilliseconds(cal.getTimeInMillis()));
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp _getTimestamp(String value, Calendar cal) throws IllegalArgumentException {
        int second;
        int minute;
        int hourOfDay;
        int dayOfMonth;
        int month;
        int year;
        Timestamp timestamp = Timestamp.valueOf(value);
        if (cal == null) {
            return timestamp;
        }
        if (this._timeZonePerObject) {
            this._calLock.lock();
        }
        try {
            Calendar calendar = this._timeZonePerObject ? this._cal : _staticCal.get();
            calendar.setTime(timestamp);
            year = calendar.get(1);
            month = calendar.get(2);
            dayOfMonth = calendar.get(5);
            hourOfDay = calendar.get(11);
            minute = calendar.get(12);
            second = calendar.get(13);
        }
        finally {
            if (this._timeZonePerObject) {
                this._calLock.unlock();
            }
        }
        int nanos = timestamp.getNanos();
        cal.clear();
        cal.set(year, month, dayOfMonth, hourOfDay, minute, second);
        timestamp.setTime(cal.getTimeInMillis());
        timestamp.setNanos(nanos);
        return timestamp;
    }

    private String _checkLength(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (this._isEncrypted && value.length() > this._length) {
            throw CharacterConverter._newSetCharacterBinaryValueTooLargeException(value, String.valueOf(this._length));
        }
        return value;
    }
}

