/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.APIMetrics;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ConnectionInjectionHandler;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaWebSocket;
import com.sap.db.jdbc.PassportListener;
import com.sap.db.jdbc.PreferredAddress;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.SecureSession;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.Topologies;
import com.sap.db.jdbc.exceptions.InternalSkipReattachException;
import com.sap.db.jdbc.exceptions.RTEDecompressException;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.RTEInvalidPacketException;
import com.sap.db.jdbc.exceptions.RTETimeoutException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.db.jdbc.packet.DBConnectInfo;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.MessageType;
import com.sap.db.jdbc.packet.PacketOption;
import com.sap.db.jdbc.packet.SessionReattachStatusOption;
import com.sap.db.jdbc.packet.SessionReattachType;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.BufferUtils;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.DbgInstanceCount;
import com.sap.db.util.HexUtils;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.ProxyUtils;
import com.sap.db.util.ReferenceUtils;
import com.sap.db.util.SocketUtils;
import com.sap.db.util.net.jpountz.lz4.LZ4Compressor;
import com.sap.db.util.net.jpountz.lz4.LZ4Exception;
import com.sap.db.util.net.jpountz.lz4.LZ4FastDecompressor;
import com.sap.db.util.net.jpountz.lz4.LZ4JavaSafeCompressor;
import com.sap.db.util.net.jpountz.lz4.LZ4JavaSafeFastDecompressor;
import com.sap.db.util.org.java_websocket.exceptions.WebsocketNotConnectedException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NetworkChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.ReadPendingException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.WritePendingException;
import java.security.cert.Certificate;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.cert.X509Certificate;

@NotThreadSafe
public abstract class Session
extends DbgInstanceCount {
    private static final Set<Session> INSTANCES = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final int MIN_COMPRESSION_SIZE = 10240;
    private static final double MAX_COMPRESSION_PERCENTAGE = 0.95;
    @GuardedBy(value="Session.class")
    private static LZ4Compressor _compressor;
    @GuardedBy(value="Session.class")
    private static LZ4FastDecompressor _decompressor;
    protected final WeakReference<ConnectionSapDB> _connection;
    protected final ReentrantLock _socketLock;
    protected final Tracer _tracer;
    protected final AtomicReference<Address> _address;
    protected final ConnectionProperties _connectionProperties;
    private final long _instantiationTime;
    private final String _bindAddress;
    private final int _heartbeatPingRequestTimeout;
    private final boolean _usePermanentSelectors;
    private final boolean _sendDisconnect;
    private final int _reattachTimeout;
    private final int _requestPacketSize;
    private final ReferenceUtils.RefType _bufferRefType;
    private final AtomicInteger _connectionID;
    private final AtomicBoolean _isFirstReplyVerified;
    private final AtomicLong _sessionID;
    private final AtomicInteger _messageID;
    private final AtomicLong _sendTime;
    private final AtomicLong _receiveTime;
    private final AtomicLong _totalSendTime;
    private final AtomicLong _totalReceiveTime;
    private final AtomicLong _sentPacketCount;
    private final AtomicLong _receivedPacketCount;
    private final AtomicLong _sentByteCount;
    private final AtomicLong _receivedByteCount;
    private final AtomicLong _uncompressedSentByteCount;
    private final AtomicLong _uncompressedReceivedByteCount;
    private final AtomicBoolean _isConnecting;
    private final AtomicBoolean _isReattaching;
    private final AtomicBoolean _isHintRouted;
    private final AtomicBoolean _isDestroyed;
    private final SessionType _sessionType;
    private final AtomicInteger _timeout;
    private final AtomicReference<SQLException> _cachedReattachException;
    @GuardedBy(value="_socketLock")
    private Reference<ByteBuffer> _sendBuffer;
    @GuardedBy(value="_socketLock")
    private Reference<ByteBuffer> _receiveBuffer;
    @GuardedBy(value="_socketLock")
    private SoftReference<byte[]> _compressionBuffer;
    @GuardedBy(value="_socketLock")
    private HRequestPacket _pingPacket;
    @GuardedBy(value="_socketLock")
    private boolean _isDuringRequest;
    @GuardedBy(value="_socketLock")
    private Address _localAddress;
    @GuardedBy(value="_socketLock")
    private Socket _socket;
    @GuardedBy(value="_socketLock")
    private InputStream _inputStream;
    @GuardedBy(value="_socketLock")
    private OutputStream _outputStream;
    @GuardedBy(value="_socketLock")
    private HanaWebSocket _webSocket;
    @GuardedBy(value="_socketLock")
    private AsynchronousSocketChannel _asynchChannel;
    @GuardedBy(value="_socketLock")
    private SocketChannel _selectableChannel;
    @GuardedBy(value="_socketLock")
    private Selector _selector;
    @GuardedBy(value="_socketLock")
    private SelectionKey _selectionKey;
    @GuardedBy(value="_socketLock")
    private Address _detachLocalAddress;
    @GuardedBy(value="_socketLock")
    private Socket _detachSocket;
    @GuardedBy(value="_socketLock")
    private InputStream _detachInputStream;
    @GuardedBy(value="_socketLock")
    private OutputStream _detachOutputStream;
    @GuardedBy(value="_socketLock")
    private AsynchronousSocketChannel _detachAsynchChannel;
    @GuardedBy(value="_socketLock")
    private SocketChannel _detachSelectableChannel;
    @GuardedBy(value="_socketLock")
    private Selector _detachSelector;
    @GuardedBy(value="_socketLock")
    private SelectionKey _detachSelectionKey;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isSendSessionContextFlagSet;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isSendSessionVariablesFlagSet;
    @GuardedBy(value="_connection (implicit)")
    private boolean _isSendClientInfoFlagSet;
    @GuardedBy(value="_connection (implicit)")
    private Properties _currentSessionVariablesAndClientInfoProperties;
    @GuardedBy(value="_connection (implicit)")
    private byte[] _reattachToken;
    private static int _compressedPacketCount;
    private static int _decompressedPacketCount;
    private final AtomicInteger _pingSentCount;
    private final AtomicInteger _pingReceivedCount;
    private final AtomicInteger _gcSendBufferCount;
    private final AtomicInteger _gcReceiveBufferCount;

    public static Session newInstance(SessionFactory factory, ConnectionSapDB connection, Address address, boolean doConnectExchange) throws RTEException {
        ConnectionProperties connectionProperties = connection.getConnectionProperties();
        PassportListener passportListener = connection.getPassportListener();
        try {
            Session initialSession = factory.newInstance(connection, address);
            initialSession._doInfoExchange(passportListener);
            Session returnedSession = doConnectExchange ? initialSession._doConnectExchange(factory, connection, passportListener, connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME), connectionProperties.getProperty(ConnectionProperty.NETWORK_GROUP)) : initialSession;
            Topologies.setUnreachable(address, false);
            return returnedSession;
        }
        catch (RTEException e) {
            Topologies.setUnreachable(address, true);
            throw e;
        }
    }

    Session(ConnectionSapDB connection, Address address) throws RTEException {
        int networkTimeout;
        INSTANCES.add(this);
        this._instantiationTime = System.currentTimeMillis();
        this._connection = new WeakReference<ConnectionSapDB>(connection);
        this._socketLock = new ReentrantLock();
        this._tracer = connection.getTracer();
        this._address = new AtomicReference<Address>(address);
        this._connectionProperties = connection.getConnectionProperties();
        this._bindAddress = this._connectionProperties.getProperty(ConnectionProperty.BIND_ADDRESS);
        this._heartbeatPingRequestTimeout = this._connectionProperties.getIntProperty(ConnectionProperty.HEARTBEAT_PING_REQUEST_TIMEOUT);
        this._usePermanentSelectors = this._connectionProperties.getBooleanProperty(ConnectionProperty.USE_PERMANENT_SELECTORS);
        this._sendDisconnect = this._connectionProperties.getBooleanProperty(ConnectionProperty.SEND_DISCONNECT);
        this._reattachTimeout = this._connectionProperties.getIntProperty(ConnectionProperty.REATTACH_TIMEOUT);
        this._requestPacketSize = connection.getPacketSize();
        this._bufferRefType = connection.getBufferReferenceType();
        this._connectionID = new AtomicInteger();
        this._isFirstReplyVerified = new AtomicBoolean(false);
        this._sessionID = new AtomicLong(0L);
        this._messageID = new AtomicInteger();
        this._sendTime = new AtomicLong();
        this._receiveTime = new AtomicLong();
        this._totalSendTime = new AtomicLong();
        this._totalReceiveTime = new AtomicLong();
        this._sentPacketCount = new AtomicLong();
        this._receivedPacketCount = new AtomicLong();
        this._sentByteCount = new AtomicLong();
        this._receivedByteCount = new AtomicLong();
        this._uncompressedSentByteCount = new AtomicLong();
        this._uncompressedReceivedByteCount = new AtomicLong();
        this._isConnecting = new AtomicBoolean(true);
        this._isReattaching = new AtomicBoolean();
        this._isHintRouted = new AtomicBoolean();
        this._isDestroyed = new AtomicBoolean();
        this._sessionType = SessionType._getSessionType(this instanceof SecureSession, this._connectionProperties);
        this._currentSessionVariablesAndClientInfoProperties = new Properties();
        this._pingSentCount = new AtomicInteger();
        this._pingReceivedCount = new AtomicInteger();
        this._gcSendBufferCount = new AtomicInteger();
        this._gcReceiveBufferCount = new AtomicInteger();
        this._timeout = new AtomicInteger();
        if (connection.isReconnecting() && (networkTimeout = connection._getNetworkTimeout()) > 0) {
            this._timeout.set(networkTimeout);
        } else {
            this._timeout.set(this._connectionProperties.getIntProperty(ConnectionProperty.CONNECT_TIMEOUT));
        }
        this._cachedReattachException = new AtomicReference();
        this._localAddress = this._connect(connection);
    }

    void destroy() {
        if (this._isReattaching.get()) {
            return;
        }
        this._socketLock.lock();
        try {
            if (this._isDestroyed.getAndSet(true)) {
                return;
            }
            if (this._tracer.on()) {
                this._tracer.printSessionClosing(this);
                this._tracer.printSessionStatistics(this);
            }
            this._closeSocketOrChannelObject();
            INSTANCES.remove(this);
            if (this._tracer.on()) {
                this._tracer.printSessionClosed(this);
            }
        }
        finally {
            this._socketLock.unlock();
        }
    }

    protected abstract void _sendBytes(byte[] var1, int var2, SendType var3) throws RTEException;

    protected abstract int _receiveBytes(byte[] var1, int var2, int var3) throws RTEException;

    protected abstract void _writeBytes(byte[] var1, int var2, SendType var3) throws RTEException;

    protected abstract int _readBytes(byte[] var1, int var2, int var3, boolean var4) throws RTEException;

    @Override
    public String toString() {
        return this.getTraceString(true, false);
    }

    public String getTraceString(boolean isFullString, boolean includeConnection) {
        return this.getTraceString(isFullString, includeConnection, false);
    }

    public String getTraceString(boolean isFullString, boolean includeConnection, boolean forDetach) {
        ConnectionSapDB connection = includeConnection ? (ConnectionSapDB)this._connection.get() : null;
        Object obj = this._getSocketOrChannelObject(forDetach);
        return super.toString() + (includeConnection && connection != null ? " " + connection.getClass().getSimpleName() + "@" + HexUtils.toHexString(connection.hashCode()) : "") + " " + this._address.get().getTraceString(isFullString) + (isFullString ? " ConnectionID:" + this._connectionID.get() + " SessionID:" + this._sessionID.get() + " on " + obj : "");
    }

    public long getInstantiationTime() {
        return this._instantiationTime;
    }

    public Address getAddress() {
        return this._address.get();
    }

    public SiteVolumeID getSiteVolumeID() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).getSiteVolumeID() : SiteVolumeID.DUMMY;
    }

    public SiteType getSiteType() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).getSiteType() : SiteType.NONE;
    }

    public boolean isNoneOrPrimarySite() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).isNoneOrPrimarySite() : true;
    }

    public boolean isPrimarySite() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).isPrimarySite() : false;
    }

    public boolean isSecondarySite() {
        Address address = this._address.get();
        return address instanceof PublicAddress ? ((PublicAddress)address).isSecondarySite() : false;
    }

    public int getConnectionID() {
        return this._connectionID.get();
    }

    public void setConnectionID(int connectionID) {
        this._connectionID.set(connectionID);
    }

    public long getSessionID() {
        return this._sessionID.get();
    }

    public boolean isConnecting() {
        return this._isConnecting.get();
    }

    public void setConnecting(boolean isConnecting) {
        this._isConnecting.set(isConnecting);
    }

    public boolean isReattaching() {
        return this._isReattaching.get();
    }

    public boolean isHintRouted() {
        return this._isHintRouted.get();
    }

    public void setHintRouted(boolean isHintRouted) {
        this._isHintRouted.set(isHintRouted);
    }

    public boolean isConnected() {
        return !this._isDestroyed.get();
    }

    public boolean isWebSocketConnection() {
        return this._webSocket != null;
    }

    public Address getLocalAddress() {
        this._socketLock.lock();
        try {
            Address address = this._localAddress;
            return address;
        }
        finally {
            this._socketLock.unlock();
        }
    }

    public boolean isSendSessionContextFlagSet() {
        return this._isSendSessionContextFlagSet;
    }

    public void setSendSessionContextFlag() {
        this._isSendSessionContextFlagSet = true;
    }

    public void clearSendSessionContextFlag() {
        this._isSendSessionContextFlagSet = false;
    }

    public boolean isSendSessionVariablesFlagSet() {
        return this._isSendSessionVariablesFlagSet;
    }

    public void setSendSessionVariablesFlag() {
        this._isSendSessionVariablesFlagSet = true;
    }

    public boolean isSendClientInfoFlagSet() {
        return this._isSendClientInfoFlagSet;
    }

    public void setSendClientInfoFlag() {
        this._isSendClientInfoFlagSet = true;
    }

    public void clearSendSessionVariablesAndClientInfoFlags(ConnectionSapDB connection) {
        Properties properties = new Properties();
        this._isSendSessionVariablesFlagSet = false;
        this._isSendClientInfoFlagSet = false;
        properties.putAll((Map<?, ?>)connection._getClientInfo());
        properties.putAll((Map<?, ?>)connection._getSessionVariables());
        this._currentSessionVariablesAndClientInfoProperties = properties;
    }

    public Properties getCurrentSessionVariablesAndClientInfoProperties() {
        return this._currentSessionVariablesAndClientInfoProperties;
    }

    public byte[] getReattachToken() {
        return this._reattachToken;
    }

    public void setReattachToken(byte[] reattachToken) {
        this._reattachToken = reattachToken;
    }

    public long getSendTime() {
        return this._sendTime.get();
    }

    public long getReceiveTime() {
        return this._receiveTime.get();
    }

    public long getTotalSendTime() {
        return this._totalSendTime.get();
    }

    public long getTotalReceiveTime() {
        return this._totalReceiveTime.get();
    }

    public long getSentPacketCount() {
        return this._sentPacketCount.get();
    }

    public long getReceivedPacketCount() {
        return this._receivedPacketCount.get();
    }

    public long getSentByteCount() {
        return this._sentByteCount.get();
    }

    public long getReceivedByteCount() {
        return this._receivedByteCount.get();
    }

    public long getUncompressedSentByteCount() {
        return this._uncompressedSentByteCount.get();
    }

    public long getUncompressedReceivedByteCount() {
        return this._uncompressedReceivedByteCount.get();
    }

    public double getSentCompressionRatio() {
        return (double)this._uncompressedSentByteCount.get() / (double)this._sentByteCount.get();
    }

    public double getReceivedCompressionRatio() {
        return (double)this._uncompressedReceivedByteCount.get() / (double)this._receivedByteCount.get();
    }

    protected X509Certificate[] _getPeerCertificateChain() {
        return null;
    }

    protected Certificate[] _getPeerCertificates() {
        return null;
    }

    public void writeProxy(String description, byte[] buffer, int len) throws RTEException {
        this._sendRawPacket(true, description, buffer, len);
    }

    public int readProxy(String description, byte[] buffer, int off, int len, boolean strictLength) throws RTEException {
        return this._receiveRawPacket(true, description, buffer, off, len, strictLength);
    }

    public Session _processDBConnectInfoPart(SessionFactory factory, DBConnectInfo dbConnectInfo) throws RTEException {
        String hostName = dbConnectInfo.getHost();
        int portNumber = dbConnectInfo.getPort();
        ConnectionSapDB connection = (ConnectionSapDB)this._connection.get();
        if (connection != null && connection.getBooleanConnectionProperty(ConnectionProperty._TEST_SIMULATE_DBCONNECTINFO_HOST_UNAVAILABLE)) {
            hostName = "bogus." + hostName;
        }
        if (hostName == null || hostName.isEmpty() || portNumber <= 0) {
            this._throwRTEException(MessageTranslator.translate("error.unknown.host", hostName + ":" + portNumber, "No additional information", RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN);
        }
        if (this._tracer.on()) {
            this._tracer.printSessionMessage(this, "Redirecting to " + hostName + ":" + portNumber, new String[0]);
        }
        this.destroy();
        if (connection == null) {
            this._throwRTEException(MessageTranslator.translate("error.objectisfreed", this.toString()), RteReturnCode.SQLSEND_LINE_DOWN);
        }
        PreferredAddress address = new PreferredAddress(hostName, portNumber);
        Session newSession = Session.newInstance(factory, connection, address, false);
        return newSession;
    }

    public Session _retryPreferredAddress(SessionFactory factory) throws RTEException {
        Address address = this._address.get();
        String hostName = address.getHost();
        int portNumber = address.getPort();
        ConnectionSapDB connection = (ConnectionSapDB)this._connection.get();
        if (this._tracer.on()) {
            this._tracer.printSessionMessage(this, "Redirection failed: Reverting back to " + hostName + ":" + portNumber + " with redirection disabled", new String[0]);
        }
        this.destroy();
        if (connection == null) {
            this._throwRTEException(MessageTranslator.translate("error.objectisfreed", this.toString()), RteReturnCode.SQLSEND_LINE_DOWN);
        }
        Session newSession = Session.newInstance(factory, connection, address, false);
        return newSession;
    }

    SessionType getSessionType() {
        return this._sessionType;
    }

    HRequestPacket newRequestPacket() {
        return HRequestPacket.newInstance(true, this._requestPacketSize);
    }

    HRequestPacket newRequestPacket(int requestPacketSize) {
        return HRequestPacket.newInstance(false, requestPacketSize);
    }

    void send(HRequestPacket requestPacket, EngineFeatures engineFeatures) throws RTEException {
        this._socketLock.lock();
        try {
            this._sendPacket(requestPacket, engineFeatures, SendType.DEFAULT);
            this._isDuringRequest = true;
        }
        finally {
            this._socketLock.unlock();
        }
    }

    HReplyPacket receive(EngineFeatures engineFeatures) throws RTEException {
        this._socketLock.lock();
        try {
            this._isDuringRequest = false;
            HReplyPacket hReplyPacket = this._receivePacket(engineFeatures);
            return hReplyPacket;
        }
        finally {
            this._socketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPing() {
        if (this._isDestroyed.get()) {
            return;
        }
        if (!this._socketLock.tryLock()) {
            return;
        }
        try {
            if (this._isDuringRequest) {
                ConnectionSapDB connection = (ConnectionSapDB)this._connection.get();
                if (connection == null) {
                    return;
                }
                if (!connection.supportIdlePingDuringRequest()) {
                    return;
                }
            }
            if (this._pingPacket == null) {
                this._pingPacket = this.newRequestPacket(56);
            }
            this._pingPacket.initPing();
            this._sendPacket(this._pingPacket, null, SendType.PING);
            this._pingSentCount.incrementAndGet();
        }
        catch (RTEException rTEException) {
        }
        finally {
            this._socketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDisconnect(String cookie) {
        if (!this._sendDisconnect) {
            return;
        }
        if (this._isDestroyed.get()) {
            return;
        }
        if (!this._socketLock.tryLock()) {
            return;
        }
        try {
            HRequestPacket requestPacket = this.newRequestPacket();
            requestPacket.initDisconnect(this, cookie);
            this._sendPacket(requestPacket, null, SendType.DISCONNECT);
        }
        catch (RTEException rTEException) {
        }
        finally {
            this._socketLock.unlock();
        }
    }

    int getTimeout() {
        return this._timeout.get();
    }

    void setTimeout(int milliseconds) {
        this._timeout.set(milliseconds);
        if (!this._sessionType.isChannel()) {
            this._socketLock.lock();
            try {
                this._socket.setSoTimeout(milliseconds);
            }
            catch (SocketException socketException) {
            }
            finally {
                this._socketLock.unlock();
            }
        }
    }

    SQLException getAndClearCachedReattachException() {
        return this._cachedReattachException.getAndSet(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reattach(ConnectionSapDB connection, SessionReattachType reattachType, boolean isDistributedReattach) throws SQLException {
        boolean clientSuccess;
        SessionReattachStatusOption serverReattachStatus;
        block61: {
            if (this._sessionType.isWebSocket()) {
                throw new AssertionError((Object)"Reattachment not supported for web sockets");
            }
            ConnectionInjectionHandler connectionInjectionHandler = connection.getConnectionInjectionHandler();
            int timeout = this._timeout.get();
            if (connectionInjectionHandler != null) {
                connectionInjectionHandler.sessionReattachBegin(this);
            }
            this._socketLock.lock();
            try {
                String reattachFailureReason;
                block60: {
                    if (isDistributedReattach) {
                        serverReattachStatus = SessionReattachStatusOption.Unknown;
                        clientSuccess = false;
                        reattachFailureReason = null;
                        try {
                            if (this._tracer.on()) {
                                this._tracer.printSessionRequestingReattach(this);
                            }
                            serverReattachStatus = connection._sendClientReattach(this, SessionReattachType.DistributedNode, null, null);
                            clientSuccess = true;
                            if (serverReattachStatus == SessionReattachStatusOption.Success) {
                                if (this._tracer.on()) {
                                    this._tracer.printSessionRequestedReattach(this);
                                }
                            } else {
                                reattachFailureReason = "ServerReattachStatus is " + serverReattachStatus.getDisplayName();
                            }
                        }
                        catch (SQLException e) {
                            reattachFailureReason = e.getMessage();
                            if (!(e instanceof InternalSkipReattachException)) {
                                this._setCachedReattachException(e);
                            }
                        }
                        finally {
                            if ((serverReattachStatus != SessionReattachStatusOption.Success || !clientSuccess) && this._tracer.on()) {
                                this._tracer.printSessionMessage(this, "Reattach request failed: " + reattachFailureReason, new String[0]);
                            }
                        }
                        if (serverReattachStatus != SessionReattachStatusOption.Success || !clientSuccess) {
                            boolean e = false;
                            return e;
                        }
                    }
                    this._isReattaching.set(true);
                    serverReattachStatus = SessionReattachStatusOption.Unknown;
                    clientSuccess = false;
                    reattachFailureReason = null;
                    try {
                        this._timeout.set(this._reattachTimeout);
                        this._saveSocketOrChannelObject();
                        serverReattachStatus = connection._attach(this);
                        clientSuccess = true;
                        if (serverReattachStatus == SessionReattachStatusOption.Success) {
                            if (this._tracer.on()) {
                                this._tracer.printSessionDetaching(this);
                            }
                            this._detachSocketOrChannelObject();
                            if (this._tracer.on()) {
                                this._tracer.printSessionDetached(this);
                            }
                        } else {
                            StringBuilder statusText = new StringBuilder(64);
                            statusText.append(serverReattachStatus.getDisplayName());
                            switch (serverReattachStatus) {
                                case Failure_General: {
                                    statusText.append(": General failure");
                                    break;
                                }
                                case Failure_HSR_Secondary_Instance: 
                                case Failure_Auth_Evaluation_Failed: 
                                case Failure_Auth_Evaluation_Method_Unknown: 
                                case Failure_Auth_PostAuthenticate_Failed: 
                                case Failure_Reattach_Session_NotFound: 
                                case Failure_Reattach_Token_Mismatch: 
                                case Failure_Reattach_Window_Closed: 
                                case Failure_Reattach_Toggle_Disabled: {
                                    break;
                                }
                                case Unknown: {
                                    break;
                                }
                                default: {
                                    throw new AssertionError((Object)("Unexpected session reattach status: " + (Object)((Object)serverReattachStatus)));
                                }
                            }
                            reattachFailureReason = "ServerReattachStatus is " + statusText;
                        }
                        if (serverReattachStatus != SessionReattachStatusOption.Success || !clientSuccess) {
                            if (this._tracer.on()) {
                                this._tracer.printSessionMessage(this, "Reattach failed: " + reattachFailureReason, new String[0]);
                            }
                            this._closeSocketOrChannelObject();
                            if (this._tracer.on()) {
                                this._tracer.printSessionRestoring(this);
                            }
                            this._restoreSocketOrChannelObject();
                            if (this._tracer.on()) {
                                this._tracer.printSessionRestored(this, this._timeout.get());
                            }
                        }
                        this._isReattaching.set(false);
                        if (connectionInjectionHandler != null) {
                            connectionInjectionHandler.sessionReattachSendingClientReattachMessage(this);
                        }
                        if (reattachType != SessionReattachType.ReattachDuringRequest || isDistributedReattach) break block60;
                        connection._sendClientReattach(this, reattachType, serverReattachStatus == SessionReattachStatusOption.Success && clientSuccess, reattachFailureReason);
                    }
                    catch (RTEException | SQLException e) {
                        block62: {
                            try {
                                reattachFailureReason = e.getMessage();
                                this._timeout.set(timeout);
                                if (serverReattachStatus != SessionReattachStatusOption.Success || !clientSuccess) {
                                    if (this._tracer.on()) {
                                        this._tracer.printSessionMessage(this, "Reattach failed: " + reattachFailureReason, new String[0]);
                                    }
                                    this._closeSocketOrChannelObject();
                                    if (this._tracer.on()) {
                                        this._tracer.printSessionRestoring(this);
                                    }
                                    this._restoreSocketOrChannelObject();
                                    if (this._tracer.on()) {
                                        this._tracer.printSessionRestored(this, this._timeout.get());
                                    }
                                }
                                this._isReattaching.set(false);
                                if (connectionInjectionHandler != null) {
                                    connectionInjectionHandler.sessionReattachSendingClientReattachMessage(this);
                                }
                                if (reattachType != SessionReattachType.ReattachDuringRequest || isDistributedReattach) break block62;
                                connection._sendClientReattach(this, reattachType, serverReattachStatus == SessionReattachStatusOption.Success && clientSuccess, reattachFailureReason);
                            }
                            catch (Throwable throwable) {
                                if (serverReattachStatus != SessionReattachStatusOption.Success || !clientSuccess) {
                                    if (this._tracer.on()) {
                                        this._tracer.printSessionMessage(this, "Reattach failed: " + reattachFailureReason, new String[0]);
                                    }
                                    this._closeSocketOrChannelObject();
                                    if (this._tracer.on()) {
                                        this._tracer.printSessionRestoring(this);
                                    }
                                    this._restoreSocketOrChannelObject();
                                    if (this._tracer.on()) {
                                        this._tracer.printSessionRestored(this, this._timeout.get());
                                    }
                                }
                                this._isReattaching.set(false);
                                if (connectionInjectionHandler != null) {
                                    connectionInjectionHandler.sessionReattachSendingClientReattachMessage(this);
                                }
                                if (reattachType == SessionReattachType.ReattachDuringRequest && !isDistributedReattach) {
                                    connection._sendClientReattach(this, reattachType, serverReattachStatus == SessionReattachStatusOption.Success && clientSuccess, reattachFailureReason);
                                } else if (!clientSuccess) {
                                    try {
                                        connection._sendClientReattach(this, reattachType, clientSuccess, reattachFailureReason);
                                    }
                                    catch (SQLException e2) {
                                        this._setCachedReattachException(e2);
                                    }
                                }
                                throw throwable;
                            }
                            break block61;
                        }
                        if (!clientSuccess) {
                            try {
                                connection._sendClientReattach(this, reattachType, clientSuccess, reattachFailureReason);
                            }
                            catch (SQLException e3) {
                                this._setCachedReattachException(e3);
                            }
                        }
                        break block61;
                    }
                    break block61;
                }
                if (!clientSuccess) {
                    try {
                        connection._sendClientReattach(this, reattachType, clientSuccess, reattachFailureReason);
                    }
                    catch (SQLException e) {
                        this._setCachedReattachException(e);
                    }
                }
            }
            finally {
                this._socketLock.unlock();
                if (connectionInjectionHandler != null) {
                    connectionInjectionHandler.sessionReattachEnd(this);
                }
            }
        }
        return serverReattachStatus == SessionReattachStatusOption.Success && clientSuccess;
    }

    protected Address _connect(ConnectionSapDB connection) throws RTEException {
        PreferredAddress localAddress;
        int port;
        String host;
        Address address;
        block31: {
            InetSocketAddress socketAddress;
            address = this._address.get();
            host = address.getHost();
            port = address.getPort();
            int timeout = this._timeout.get();
            if (this._sessionType.isProxy()) {
                String proxyHostName = this._connectionProperties.getProperty(ConnectionProperty.PROXY_HOST_NAME);
                int proxyPort = this._connectionProperties.getIntProperty(ConnectionProperty.PROXY_PORT);
                socketAddress = new InetSocketAddress(proxyHostName, proxyPort);
            } else {
                socketAddress = new InetSocketAddress(host, port);
            }
            if (this._tracer.on()) {
                if (this._isReattaching.get()) {
                    this._tracer.printSessionAttaching(this, timeout);
                } else {
                    this._tracer.printSessionOpening(this, timeout);
                }
            }
            if (this._sessionType.isChannel()) {
                try {
                    if (this._sessionType.isSelectable()) {
                        this._selectableChannel = SocketChannel.open();
                        this._selectableChannel.socket().setSoTimeout(timeout);
                        this._setChannelOptions(this._selectableChannel);
                        if (this._bindAddress != null && !this._bindAddress.isEmpty()) {
                            this._selectableChannel.bind(new InetSocketAddress(this._bindAddress, 0));
                        }
                        this._selectableChannel.connect(socketAddress);
                        this._selectableChannel.configureBlocking(false);
                        if (this._usePermanentSelectors) {
                            this._selector = Selector.open();
                            this._selectionKey = this._selectableChannel.register(this._selector, 5);
                        }
                        break block31;
                    }
                    this._asynchChannel = AsynchronousSocketChannel.open();
                    this._setChannelOptions(this._asynchChannel);
                    if (this._bindAddress != null && !this._bindAddress.isEmpty()) {
                        this._asynchChannel.bind(new InetSocketAddress(this._bindAddress, 0));
                    }
                    Future<Void> connectFuture = this._asynchChannel.connect(socketAddress);
                    if (timeout > 0) {
                        connectFuture.get(timeout, TimeUnit.MILLISECONDS);
                        break block31;
                    }
                    connectFuture.get();
                }
                catch (UnresolvedAddressException e) {
                    this._throwRTEException(MessageTranslator.translate("error.unknown.host", socketAddress.toString(), e.getMessage(), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, e);
                }
                catch (TimeoutException e) {
                    this._throwRTETimeoutException(MessageTranslator.translate("error.host.connect.timeout", socketAddress.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, e);
                }
                catch (IOException | InterruptedException | SecurityException | AlreadyConnectedException | ConnectionPendingException | UnsupportedAddressTypeException | CancellationException | ExecutionException e) {
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", socketAddress.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, e);
                }
            } else {
                try {
                    this._socket = new Socket();
                    this._setSocketOptions(this._socket);
                    if (this._bindAddress != null && !this._bindAddress.isEmpty()) {
                        this._socket.bind(new InetSocketAddress(this._bindAddress, 0));
                    }
                    this._socket.connect(socketAddress, timeout);
                    this._inputStream = this._socket.getInputStream();
                    this._outputStream = this._socket.getOutputStream();
                }
                catch (UnknownHostException e) {
                    this._throwRTEException(MessageTranslator.translate("error.unknown.host", socketAddress.toString(), e.getMessage(), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, e);
                }
                catch (SocketTimeoutException e) {
                    this._throwRTETimeoutException(MessageTranslator.translate("error.host.connect.timeout", socketAddress.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, e);
                }
                catch (IOException | IllegalArgumentException | IllegalBlockingModeException e) {
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", socketAddress.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, e);
                }
            }
        }
        if (this._sessionType.isProxy()) {
            String proxyUserName = this._connectionProperties.getProperty(ConnectionProperty.PROXY_USER_NAME);
            String proxyPassword = this._connectionProperties.getProperty(ConnectionProperty.PROXY_PASSWD);
            if (this._sessionType.isHttpProxy()) {
                ProxyUtils.doHttpAuthentication(this._tracer, this, host, port, proxyUserName, proxyPassword);
            } else {
                String proxyScpAccount = this._connectionProperties.getProperty(ConnectionProperty.PROXY_SCP_ACCOUNT);
                ProxyUtils.doSocksAuthentication(this._tracer, this, host, port, proxyUserName, proxyPassword, proxyScpAccount);
            }
        }
        if (this._sessionType.isChannel()) {
            int localPort;
            String localHost;
            try {
                localHost = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                localHost = this._getHostAddressFromNetworkInterfaces();
            }
            try {
                SocketAddress channelLocalAddress = this._sessionType.isSelectable() ? this._selectableChannel.getLocalAddress() : this._asynchChannel.getLocalAddress();
                localPort = channelLocalAddress instanceof InetSocketAddress ? ((InetSocketAddress)channelLocalAddress).getPort() : -1;
            }
            catch (IOException e) {
                localPort = -1;
            }
            localAddress = new PreferredAddress(localHost, localPort);
        } else {
            localAddress = new PreferredAddress(this._socket.getLocalAddress().getHostAddress(), this._socket.getLocalPort());
            if (this._sessionType.isWebSocket()) {
                String webSocketUrl = this._connectionProperties.getProperty(ConnectionProperty.WEB_SOCKET_URL);
                this._webSocket = new HanaWebSocket(this._tracer, this, this._connectionProperties, this._getWebSocketUri(address, webSocketUrl), this._socket);
                this._setWebSocketDefaults(this._connectionProperties);
            }
        }
        this._checkDelayAfterSocketOpen(connection);
        return localAddress;
    }

    protected void _attach(ConnectionSapDB connection) throws RTEException {
        this._localAddress = this._connect(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _writeChannel(byte[] buffer, int len, SendType sendType) throws RTEException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, 0, len);
        boolean isPing = sendType == SendType.PING;
        boolean isDisconnect = sendType == SendType.DISCONNECT;
        int timeout = this._timeout.get();
        int remaining = len;
        Selector selector = null;
        SelectionKey selectionKey = null;
        try {
            if (this._sessionType.isSelectable()) {
                if (this._usePermanentSelectors) {
                    selector = this._selector;
                    selectionKey = this._selectionKey;
                } else {
                    selector = Selector.open();
                    selectionKey = this._selectableChannel.register(selector, 5);
                }
            }
            ByteBuffer sendBuffer = this._getSendBuffer();
            BufferUtils.clear(sendBuffer);
            BufferUtils.limit(sendBuffer, Math.min(remaining, sendBuffer.capacity()));
            while (remaining > 0) {
                int count;
                if (sendBuffer.position() == 0) {
                    BufferUtils.limit(byteBuffer, byteBuffer.position() + Math.min(remaining, sendBuffer.capacity()));
                    sendBuffer.put(byteBuffer);
                    BufferUtils.limit(byteBuffer, len);
                    BufferUtils.flip(sendBuffer);
                }
                if (this._sessionType.isSelectable()) {
                    selector.selectedKeys().clear();
                    selectionKey.interestOps(4);
                    selector.select(isPing ? (long)this._heartbeatPingRequestTimeout : (long)timeout);
                    if (!selectionKey.isWritable()) {
                        String message = "Channel not writable after timeout on selector";
                        throw new TimeoutException(message);
                    }
                    if (!(isPing || isDisconnect || this.isConnecting())) {
                        selector.selectedKeys().clear();
                        selectionKey.interestOps(1);
                        selector.selectNow();
                        if (selectionKey.isReadable()) {
                            String message = "Channel readable when performing write (poll before send check)";
                            count = this._selectableChannel.read(this._getReceiveBuffer());
                            if (count > 0) {
                                message = message + " Assertion error: Channel read returned " + count + " bytes";
                                throw new IOException(message);
                            }
                            throw new IOException(message);
                        }
                    }
                    if ((count = this._selectableChannel.write(sendBuffer)) == 0) {
                        String message = "Channel write returned no bytes";
                        throw new TimeoutException(message);
                    }
                } else {
                    Future<Integer> future = this._asynchChannel.write(sendBuffer);
                    count = isPing ? future.get(this._heartbeatPingRequestTimeout, TimeUnit.MILLISECONDS) : (timeout > 0 ? future.get(timeout, TimeUnit.MILLISECONDS).intValue() : future.get().intValue());
                }
                if (sendBuffer.remaining() == 0) {
                    BufferUtils.flip(sendBuffer);
                }
                remaining -= count;
            }
        }
        catch (TimeoutException e) {
            this._throwRTETimeoutException(MessageTranslator.translate("error.send.write.timeout", e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN, e);
        }
        catch (IOException | InterruptedException | NotYetConnectedException | WritePendingException | ExecutionException e) {
            this._throwRTEException(MessageTranslator.translate("error.send.write", e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN, e);
        }
        finally {
            if (this._sessionType.isSelectable() && !this._usePermanentSelectors && selector != null) {
                try {
                    selector.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final int _readChannel(byte[] buffer, int off, int len, boolean strictLength) throws RTEException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, off, len);
        int remaining = len;
        int timeout = this._timeout.get();
        Selector selector = null;
        SelectionKey selectionKey = null;
        try {
            if (this._sessionType.isSelectable()) {
                if (this._usePermanentSelectors) {
                    selector = this._selector;
                    selectionKey = this._selectionKey;
                } else {
                    selector = Selector.open();
                    selectionKey = this._selectableChannel.register(selector, 5);
                }
            }
            ByteBuffer receiveBuffer = this._getReceiveBuffer();
            while (remaining > 0) {
                int count;
                BufferUtils.clear(receiveBuffer);
                BufferUtils.limit(receiveBuffer, Math.min(remaining, receiveBuffer.capacity()));
                if (this._sessionType.isSelectable()) {
                    selector.selectedKeys().clear();
                    selectionKey.interestOps(1);
                    selector.select(timeout);
                    if (!selectionKey.isReadable()) {
                        String message = "Channel not readable after timeout on selector";
                        throw new TimeoutException(message);
                    }
                    count = this._selectableChannel.read(receiveBuffer);
                    if (count == 0) {
                        String message = "Channel read returned no bytes";
                        throw new TimeoutException(message);
                    }
                } else {
                    Future<Integer> future = this._asynchChannel.read(receiveBuffer);
                    count = timeout > 0 ? future.get(timeout, TimeUnit.MILLISECONDS).intValue() : future.get().intValue();
                }
                if (count == -1) {
                    int n = count;
                    return n;
                }
                if (count > 0) {
                    BufferUtils.flip(receiveBuffer);
                    byteBuffer.put(receiveBuffer);
                }
                if (count > 0 && !strictLength) {
                    int n = count;
                    return n;
                }
                remaining -= count;
            }
            int n = len;
            return n;
        }
        catch (TimeoutException e) {
            this._throwRTETimeoutException(MessageTranslator.translate("error.data.receivefailed.timeout", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN, e);
            throw new AssertionError((Object)"_throwRTEException didn't throw an RTEException");
        }
        catch (IOException | IllegalArgumentException | InterruptedException | NotYetConnectedException | ReadPendingException | ExecutionException e) {
            this._throwRTEException(MessageTranslator.translate("error.data.receivefailed.reason", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN, e);
            throw new AssertionError((Object)"_throwRTEException didn't throw an RTEException");
        }
        finally {
            if (this._sessionType.isSelectable() && !this._usePermanentSelectors && selector != null) {
                try {
                    selector.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected final void _writeSocket(byte[] buffer, int len) throws RTEException {
        try {
            this._outputStream.write(buffer, 0, len);
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.send.write", e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN, e);
        }
    }

    protected final int _readSocket(byte[] buffer, int off, int len) throws RTEException {
        try {
            return this._inputStream.read(buffer, off, len);
        }
        catch (SocketTimeoutException e) {
            this._throwRTETimeoutException(MessageTranslator.translate("error.data.receivefailed.timeout", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN, e);
        }
        catch (IOException e) {
            this._throwRTEException(MessageTranslator.translate("error.data.receivefailed.reason", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN, e);
        }
        throw new AssertionError((Object)"_throwRTEException didn't throw an RTEException");
    }

    protected final void _writeWebSocket(byte[] buffer, int len) throws RTEException {
        try {
            this._webSocket._writeSocket(buffer, len);
        }
        catch (RTEException e) {
            this._throwRTEException(e);
        }
    }

    protected final int _readWebSocket(byte[] buffer, int off, int len) throws RTEException {
        try {
            return this._webSocket._readSocket(buffer, off, len);
        }
        catch (RTEException e) {
            this._throwRTEException(e);
            throw new AssertionError((Object)"_throwRTEException didn't throw an RTEException");
        }
    }

    protected void _setSocketOptions(Socket socket) {
        try {
            socket.setSoTimeout(this._timeout.get());
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            socket.setSoLinger(true, 15);
            SocketUtils.setKeepAliveOptions(socket, this._connectionProperties.getIntProperty(ConnectionProperty.TCP_KEEP_ALIVE_IDLE), this._connectionProperties.getIntProperty(ConnectionProperty.TCP_KEEP_ALIVE_INTERVAL), this._connectionProperties.getIntProperty(ConnectionProperty.TCP_KEEP_ALIVE_COUNT));
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    protected void _setChannelOptions(NetworkChannel channel) {
        try {
            channel.setOption(StandardSocketOptions.TCP_NODELAY, true);
            channel.setOption(StandardSocketOptions.SO_KEEPALIVE, true);
            SocketUtils.setKeepAliveOptions(channel, this._connectionProperties.getIntProperty(ConnectionProperty.TCP_KEEP_ALIVE_IDLE), this._connectionProperties.getIntProperty(ConnectionProperty.TCP_KEEP_ALIVE_INTERVAL), this._connectionProperties.getIntProperty(ConnectionProperty.TCP_KEEP_ALIVE_COUNT));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String _getHostAddressFromNetworkInterfaces() {
        try {
            Enumeration<NetworkInterface> iterNetwork = NetworkInterface.getNetworkInterfaces();
            while (iterNetwork.hasMoreElements()) {
                NetworkInterface network = iterNetwork.nextElement();
                if (!network.isUp() || network.isLoopback()) continue;
                Enumeration<InetAddress> iterAddress = network.getInetAddresses();
                while (iterAddress.hasMoreElements()) {
                    InetAddress address = iterAddress.nextElement();
                    if (address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isMulticastAddress()) continue;
                    return address.getHostAddress();
                }
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    protected void _sendPacket(HRequestPacket requestPacket, EngineFeatures engineFeatures, SendType sendType) throws RTEException {
        long beforeSend = Session._getNanoTime();
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        ConnectionSapDB connection = (ConnectionSapDB)this._connection.get();
        PassportListener pl = connection != null ? connection.getPassportListener() : null;
        byte[] packet = requestPacket.getRawPacketArray();
        int len = requestPacket.getLength();
        int uncompressedHeaderLength = 56;
        byte[] workBuffer = null;
        boolean isCompressed = false;
        MessageType messageType = MessageType.decode(ByteUtils.getByte(packet, 45));
        ByteUtils.putLong(messageType == MessageType.Authenticate ? 0L : this._sessionID.get(), packet, 0);
        ByteUtils.putInt(this._messageID.getAndIncrement(), packet, 8);
        if (engineFeatures != null && engineFeatures.isCompressionEnabled() && len >= 10240) {
            try {
                int uncompressedRemainderLength = len - uncompressedHeaderLength;
                int maximumCompressedRemainderLength = (int)((double)uncompressedRemainderLength * 0.95);
                workBuffer = this._getCompressionWorkBuffer(uncompressedHeaderLength + maximumCompressedRemainderLength);
                int compressedRemainderLength = Session._getCompressor().compress(packet, uncompressedHeaderLength, uncompressedRemainderLength, workBuffer, uncompressedHeaderLength, maximumCompressedRemainderLength);
                isCompressed = true;
                len = uncompressedHeaderLength + compressedRemainderLength;
                int varpartLength = 24 + compressedRemainderLength;
                int compressionVarpartLength = 24 + uncompressedRemainderLength;
                packet[22] = (byte)(packet[22] | (byte)PacketOption.IsCompressed.getValue());
                ByteUtils.putInt(varpartLength, packet, 12);
                ByteUtils.putInt(compressionVarpartLength, packet, 24);
                System.arraycopy(packet, 0, workBuffer, 0, uncompressedHeaderLength);
            }
            catch (LZ4Exception lZ4Exception) {
                // empty catch block
            }
        }
        long beforeTrace = Session._getNanoTime();
        if (on) {
            this._tracer.printPacket(packet, engineFeatures);
        }
        long afterTrace = Session._getNanoTime();
        if (isCompressed) {
            this._sendBytes(workBuffer, len, sendType);
        } else {
            this._sendBytes(packet, len, sendType);
        }
        long afterSend = Session._getNanoTime();
        this._sentByteCount.addAndGet(len);
        this._uncompressedSentByteCount.addAndGet(requestPacket.getLength());
        this._sentPacketCount.incrementAndGet();
        long sendTime = beforeTrace - beforeSend + (afterSend - afterTrace);
        this._sendTime.set(sendTime);
        this._totalSendTime.addAndGet(sendTime);
        if (aon || pl != null) {
            APIMetrics.getInstance().accumulateNetworkTime(sendTime);
        }
        if (on) {
            this._tracer.printPacketElapsedSendTime(sendTime);
        }
    }

    protected HReplyPacket _receivePacket(EngineFeatures engineFeatures) throws RTEException {
        int receivedByteCount;
        int uncompressedRemainderLength;
        boolean isCompressed;
        long beforeTrace;
        long sessionID;
        long beforeReceive = Session._getNanoTime();
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        ConnectionSapDB connection = (ConnectionSapDB)this._connection.get();
        PassportListener pl = connection != null ? connection.getPassportListener() : null;
        int uncompressedHeaderLength = 56;
        byte[] uncompressedHeader = new byte[uncompressedHeaderLength];
        long pingReceivedByteCount = 0L;
        long pingReceivedPacketCount = 0L;
        long pingReceiveTime = 0L;
        while (true) {
            FunctionCode functionCode;
            if (this._receiveBytes(uncompressedHeader, 0, uncompressedHeaderLength) < uncompressedHeaderLength) {
                this._throwRTEException(MessageTranslator.translate("error.data.receivefailed", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            sessionID = ByteUtils.getLong(uncompressedHeader, 0);
            int packetCount = ByteUtils.getInt(uncompressedHeader, 8);
            if (!this._isFirstReplyVerified.get()) {
                if (sessionID != 0L || packetCount != 0) {
                    this._throwRTEException(MessageTranslator.translate("error.data.receivefailed", new Object[0]), RteReturnCode.REQUEST_UNKNOWN);
                }
                this._isFirstReplyVerified.set(true);
            }
            if ((functionCode = FunctionCode.decode(ByteUtils.getShort(uncompressedHeader, 46))) != FunctionCode.Ping) break;
            this._pingReceivedCount.incrementAndGet();
            beforeTrace = Session._getNanoTime();
            if (on) {
                this._tracer.printPacket(uncompressedHeader, engineFeatures);
            }
            pingReceivedByteCount += (long)uncompressedHeaderLength;
            ++pingReceivedPacketCount;
            pingReceiveTime += beforeTrace - beforeReceive;
            beforeReceive = Session._getNanoTime();
        }
        this._sessionID.compareAndSet(0L, sessionID);
        int varpartLength = ByteUtils.getInt(uncompressedHeader, 12);
        if (varpartLength < 0) {
            this._throwRTEInvalidPacketException(MessageTranslator.translate("error.packet.too.large", new Object[0]), RteReturnCode.SQLPACKETLIMIT);
        }
        boolean bl = isCompressed = (ByteUtils.getByte(uncompressedHeader, 22) & PacketOption.IsCompressed.getValue()) != 0;
        if (isCompressed) {
            int compressionVarpartLength = ByteUtils.getInt(uncompressedHeader, 24);
            if (compressionVarpartLength < 0) {
                this._throwRTEInvalidPacketException(MessageTranslator.translate("error.packet.invalid", "Invalid length"), RteReturnCode.REQUEST_UNKNOWN);
            }
            uncompressedRemainderLength = compressionVarpartLength - 24;
        } else {
            uncompressedRemainderLength = varpartLength - 24;
        }
        byte[] packet = new byte[uncompressedHeaderLength + uncompressedRemainderLength];
        System.arraycopy(uncompressedHeader, 0, packet, 0, uncompressedHeaderLength);
        if (isCompressed) {
            int compressedRemainderLength = varpartLength - 24;
            byte[] workBuffer = this._getCompressionWorkBuffer(compressedRemainderLength);
            this._receiveRemainderOfPacket(workBuffer, 0, compressedRemainderLength);
            try {
                int decompressedLength = Session._getDecompressor().decompress(workBuffer, 0, packet, uncompressedHeaderLength, uncompressedRemainderLength);
                if (decompressedLength != compressedRemainderLength) {
                    this._throwRTEDecompressException(MessageTranslator.translate("error.packet.decompress.failed", new Object[0]), RteReturnCode.SQLNOTOK, null);
                }
            }
            catch (LZ4Exception e) {
                this._throwRTEDecompressException(MessageTranslator.translate("error.packet.decompress.failed", new Object[0]), RteReturnCode.SQLNOTOK, e);
            }
            receivedByteCount = uncompressedHeaderLength + compressedRemainderLength;
        } else {
            this._receiveRemainderOfPacket(packet, uncompressedHeaderLength, uncompressedRemainderLength);
            receivedByteCount = packet.length;
        }
        beforeTrace = Session._getNanoTime();
        if (on) {
            this._tracer.printPacket(packet, engineFeatures);
        }
        long afterTrace = Session._getNanoTime();
        HReplyPacket replyPacket = HReplyPacket.newInstance(this._tracer, this, packet);
        long afterReceive = Session._getNanoTime();
        this._receivedByteCount.addAndGet(pingReceivedByteCount + (long)receivedByteCount);
        this._uncompressedReceivedByteCount.addAndGet(pingReceivedByteCount + (long)packet.length);
        this._receivedPacketCount.addAndGet(pingReceivedPacketCount + 1L);
        long receiveTime = pingReceiveTime + (beforeTrace - beforeReceive) + (afterReceive - afterTrace);
        this._receiveTime.set(receiveTime);
        this._totalReceiveTime.addAndGet(receiveTime);
        if (aon || pl != null) {
            APIMetrics.getInstance().accumulateNetworkTime(receiveTime);
        }
        if (on) {
            this._tracer.printPacketElapsedReceiveTime(receiveTime, pingReceivedPacketCount);
        }
        return replyPacket;
    }

    protected void _sendRawPacket(boolean toProxy, String description, byte[] packet, int len) throws RTEException {
        long beforeSend = Session._getNanoTime();
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        ConnectionSapDB connection = (ConnectionSapDB)this._connection.get();
        PassportListener pl = connection != null ? connection.getPassportListener() : null;
        long beforeTrace = Session._getNanoTime();
        if (on) {
            this._tracer.printRawPacket(description, packet, 0, len);
        }
        long afterTrace = Session._getNanoTime();
        if (toProxy) {
            this._writeBytes(packet, len, SendType.DEFAULT);
        } else {
            this._sendBytes(packet, len, SendType.DEFAULT);
        }
        long afterSend = Session._getNanoTime();
        this._sentByteCount.addAndGet(len);
        this._uncompressedSentByteCount.addAndGet(len);
        this._sentPacketCount.incrementAndGet();
        long sendTime = beforeTrace - beforeSend + (afterSend - afterTrace);
        this._sendTime.set(sendTime);
        this._totalSendTime.addAndGet(sendTime);
        if (aon || pl != null) {
            APIMetrics.getInstance().accumulateNetworkTime(sendTime);
        }
        if (on) {
            this._tracer.printPacketElapsedSendTime(sendTime);
        }
    }

    protected int _receiveRawPacket(boolean toProxy, String description, byte[] packet, int off, int len, boolean strictLength) throws RTEException {
        int retLen;
        PassportListener pl;
        long beforeReceive = Session._getNanoTime();
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        ConnectionSapDB connection = (ConnectionSapDB)this._connection.get();
        PassportListener passportListener = pl = connection != null ? connection.getPassportListener() : null;
        if (toProxy ? (retLen = this._readBytes(packet, off, len, strictLength)) == -1 : (retLen = this._receiveBytes(packet, off, len)) == -1) {
            return retLen;
        }
        long afterReceive = Session._getNanoTime();
        if (on) {
            this._tracer.printRawPacket(description, packet, off, retLen);
        }
        this._receivedByteCount.addAndGet(retLen);
        this._uncompressedReceivedByteCount.addAndGet(retLen);
        this._receivedPacketCount.incrementAndGet();
        long receiveTime = afterReceive - beforeReceive;
        this._receiveTime.set(receiveTime);
        this._totalReceiveTime.addAndGet(receiveTime);
        if (aon || pl != null) {
            APIMetrics.getInstance().accumulateNetworkTime(receiveTime);
        }
        if (on) {
            this._tracer.printPacketElapsedReceiveTime(receiveTime, 0L);
        }
        return retLen;
    }

    protected void _doInfoExchange(PassportListener passportListener) throws RTEException {
        byte[] request = new byte[14];
        byte[] reply = new byte[8];
        ByteUtils.putLongBigEndian(-1L, request, 0);
        ByteUtils.putByte(4, request, 4);
        ByteUtils.putShortBigEndian(20, request, 5);
        ByteUtils.putByte(4, request, 7);
        ByteUtils.putShortBigEndian(1, request, 8);
        ByteUtils.putByte(1, request, 11);
        ByteUtils.putByte(1, request, 12);
        ByteUtils.putByte(1, request, 13);
        this._sendRawPacket(false, "InfoRequest", request, 14);
        int len = this._receiveRawPacket(false, "InfoReply", reply, 0, 8, false);
        if (passportListener != null) {
            APIMetrics.getInstance().handleReceivedPacket(passportListener, new PassportListener.PacketInfo(MessageType.Nil, null, null, 0L, 0L, 0L, null, -1));
        }
        if (len < 8) {
            this._throwRTEException(MessageTranslator.translate("error.recv.connect", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
    }

    protected Session _doConnectExchange(SessionFactory factory, ConnectionSapDB connection, PassportListener passportListener, String databaseName, String networkGroup) throws RTEException {
        DBConnectInfo dbConnectInfo;
        if (databaseName == null || databaseName.isEmpty()) {
            return this;
        }
        HRequestPacket requestPacket = this.newRequestPacket();
        requestPacket.initDBConnectInfo(databaseName, networkGroup);
        this.send(requestPacket, null);
        HReplyPacket replyPacket = this.receive(null);
        if (passportListener != null) {
            APIMetrics.getInstance().handleReceivedPacket(passportListener, new PassportListener.PacketInfo(MessageType.DBConnectInfo, null, null, 0L, 0L, 0L, null, -1));
        }
        if ((dbConnectInfo = replyPacket.findDBConnectInfo(0)) == null) {
            SQLException sqlException = replyPacket.findSQLExceptionChain(null, 0);
            if (sqlException == null) {
                sqlException = SQLExceptionSapDB.newInstance("error.internal.unknownError", new String[0]);
            }
            this._throwRTEException(sqlException.getMessage(), RteReturnCode.decode(sqlException.getErrorCode()), -708);
        }
        if (dbConnectInfo.isOnCorrectDatabase()) {
            return this;
        }
        connection.setRedirectedHost(dbConnectInfo.getHost());
        connection.setRedirectedPort(dbConnectInfo.getPort());
        return this._processDBConnectInfoPart(factory, dbConnectInfo);
    }

    protected URI _getWebSocketUri(Address address, String resource) throws RTEException {
        URI webSocketUri = null;
        String uriString = "ws://" + address.toString() + (resource.charAt(0) != '/' ? "/" : "") + resource.trim();
        try {
            webSocketUri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            this._throwRTEException(MessageTranslator.translate("error.invalid.websocket.uri", address.getHost(), address.getPort(), resource, e.getMessage()), RteReturnCode.SQLSTART_REQUIRED, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), e);
        }
        return webSocketUri;
    }

    protected void _setWebSocketDefaults(ConnectionProperties connectionProperties) {
        connectionProperties.setProperty(ConnectionProperty.IGNORE_TOPOLOGY, "true");
        if (!connectionProperties.hasProperty(ConnectionProperty.COMPRESS)) {
            connectionProperties.setProperty(ConnectionProperty.COMPRESS, "true");
        }
        if (!connectionProperties.hasProperty(ConnectionProperty.RECONNECT)) {
            connectionProperties.setProperty(ConnectionProperty.RECONNECT, "false");
        }
    }

    protected void _throwRTETimeoutException(String message, RteReturnCode rteReturnCode, Throwable cause) throws RTEException {
        this.destroy();
        throw RTETimeoutException.newInstance(this._tracer, this, message, rteReturnCode, cause);
    }

    protected void _throwRTEDecompressException(String message, RteReturnCode rteReturnCode, Throwable cause) throws RTEException {
        this.destroy();
        throw RTEDecompressException.newInstance(this._tracer, this, message, rteReturnCode, cause);
    }

    protected void _throwRTEInvalidPacketException(String message, RteReturnCode rteReturnCode) throws RTEException {
        this.destroy();
        throw RTEInvalidPacketException.newInstance(this._tracer, this, message, rteReturnCode);
    }

    protected void _throwRTEException(String message, RteReturnCode rteReturnCode) throws RTEException {
        this.destroy();
        throw RTEException.newInstance(this._tracer, this, message, rteReturnCode);
    }

    protected void _throwRTEException(String message, RteReturnCode rteReturnCode, int detailErrorCode) throws RTEException {
        this.destroy();
        throw RTEException.newInstance(this._tracer, this, message, rteReturnCode, detailErrorCode);
    }

    protected void _throwRTEException(String message, RteReturnCode rteReturnCode, Throwable cause) throws RTEException {
        this.destroy();
        throw RTEException.newInstance(this._tracer, this, message, rteReturnCode, cause);
    }

    protected void _throwRTEException(String message, RteReturnCode rteReturnCode, int detailErrorCode, Throwable cause) throws RTEException {
        this.destroy();
        throw RTEException.newInstance(this._tracer, this, message, rteReturnCode, detailErrorCode, cause);
    }

    protected void _throwRTEException(RTEException e) throws RTEException {
        this.destroy();
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _detachSocketOrChannelObject() {
        this._detachLocalAddress = null;
        if (this._sessionType.isChannel()) {
            if (this._sessionType.isSelectable()) {
                if (this._detachSelectableChannel != null) {
                    try {
                        this._detachSelectableChannel.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        this._detachSelectableChannel = null;
                    }
                }
                if (this._detachSelector != null) {
                    try {
                        this._detachSelector.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        this._detachSelector = null;
                    }
                }
                if (this._detachSelectionKey != null) {
                    this._detachSelectionKey = null;
                }
            } else if (this._detachAsynchChannel != null) {
                try {
                    this._detachAsynchChannel.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this._detachAsynchChannel = null;
                }
            }
        } else if (this._detachSocket != null) {
            try {
                this._detachSocket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this._detachSocket = null;
                this._detachInputStream = null;
                this._detachOutputStream = null;
            }
        }
    }

    protected void _saveSocketOrChannelObject() {
        this._detachLocalAddress = this._localAddress;
        this._localAddress = null;
        if (this._sessionType.isChannel()) {
            if (this._sessionType.isSelectable()) {
                this._detachSelectableChannel = this._selectableChannel;
                this._detachSelector = this._selector;
                this._detachSelectionKey = this._selectionKey;
                this._selectableChannel = null;
                this._selector = null;
                this._selectionKey = null;
            } else {
                this._detachAsynchChannel = this._asynchChannel;
                this._asynchChannel = null;
            }
        } else {
            this._detachSocket = this._socket;
            this._detachInputStream = this._inputStream;
            this._detachOutputStream = this._outputStream;
            this._socket = null;
            this._inputStream = null;
            this._outputStream = null;
        }
    }

    protected void _restoreSocketOrChannelObject() {
        this._localAddress = this._detachLocalAddress;
        this._detachLocalAddress = null;
        if (this._sessionType.isChannel()) {
            if (this._sessionType.isSelectable()) {
                this._selectableChannel = this._detachSelectableChannel;
                this._selector = this._detachSelector;
                this._selectionKey = this._detachSelectionKey;
                this._detachSelectableChannel = null;
                this._detachSelector = null;
                this._detachSelectionKey = null;
            } else {
                this._asynchChannel = this._detachAsynchChannel;
                this._detachAsynchChannel = null;
            }
        } else {
            this._socket = this._detachSocket;
            this._inputStream = this._detachInputStream;
            this._outputStream = this._detachOutputStream;
            this._detachSocket = null;
            this._detachInputStream = null;
            this._detachOutputStream = null;
        }
    }

    private void _checkSocketLock(String name) {
        if (!this._socketLock.isLocked()) {
            // empty if block
        }
    }

    private static long _getNanoTime() {
        return System.nanoTime();
    }

    private static synchronized LZ4Compressor _getCompressor() {
        if (_compressor != null) {
            return _compressor;
        }
        _compressor = LZ4JavaSafeCompressor.INSTANCE;
        return _compressor;
    }

    private static synchronized LZ4FastDecompressor _getDecompressor() {
        if (_decompressor != null) {
            return _decompressor;
        }
        _decompressor = LZ4JavaSafeFastDecompressor.INSTANCE;
        return _decompressor;
    }

    private ByteBuffer _getSendBuffer() throws IOException {
        ByteBuffer sendBuffer;
        if (this._sendBuffer == null) {
            sendBuffer = null;
        } else {
            sendBuffer = this._sendBuffer.get();
            if (sendBuffer == null) {
                this._gcSendBufferCount.incrementAndGet();
                if (this._tracer.on()) {
                    this._tracer.printDebugMessage(this.getTraceString(false, false) + ": _sendBuffer was garbage collected");
                }
            }
        }
        int sendBufferSize = this._sessionType.isSelectable() ? this._selectableChannel.getOption(StandardSocketOptions.SO_SNDBUF).intValue() : this._asynchChannel.getOption(StandardSocketOptions.SO_SNDBUF).intValue();
        if (sendBuffer == null || sendBuffer.capacity() != sendBufferSize) {
            sendBuffer = this._channelAllocate(sendBufferSize);
            this._sendBuffer = this._bufferRefType.newReference(sendBuffer);
        }
        return sendBuffer;
    }

    private ByteBuffer _getReceiveBuffer() throws IOException {
        ByteBuffer receiveBuffer;
        if (this._receiveBuffer == null) {
            receiveBuffer = null;
        } else {
            receiveBuffer = this._receiveBuffer.get();
            if (receiveBuffer == null) {
                this._gcReceiveBufferCount.incrementAndGet();
                if (this._tracer.on()) {
                    this._tracer.printDebugMessage(this.getTraceString(false, false) + ": _receiveBuffer was garbage collected");
                }
            }
        }
        int receiveBufferSize = this._sessionType.isSelectable() ? this._selectableChannel.getOption(StandardSocketOptions.SO_RCVBUF).intValue() : this._asynchChannel.getOption(StandardSocketOptions.SO_RCVBUF).intValue();
        if (receiveBuffer == null || receiveBuffer.capacity() != receiveBufferSize) {
            receiveBuffer = this._channelAllocate(receiveBufferSize);
            this._receiveBuffer = this._bufferRefType.newReference(receiveBuffer);
        }
        return receiveBuffer;
    }

    private ByteBuffer _channelAllocate(int size) {
        if (this._sessionType.isDirectMemory()) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }

    private byte[] _getCompressionWorkBuffer(int requiredSize) {
        byte[] buffer;
        if (this._compressionBuffer != null && (buffer = this._compressionBuffer.get()) != null && buffer.length >= requiredSize) {
            return buffer;
        }
        this._compressionBuffer = null;
        buffer = new byte[requiredSize];
        this._compressionBuffer = new SoftReference<byte[]>(buffer);
        return buffer;
    }

    private void _receiveRemainderOfPacket(byte[] packet, int off, int len) throws RTEException {
        while (len > 0) {
            int n = this._receiveBytes(packet, off, len);
            if (n == -1) {
                this._throwRTEException(MessageTranslator.translate("error.data.receivefailed", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            off += n;
            len -= n;
        }
    }

    private void _closeSocketOrChannelObject() {
        if (this._sessionType.isChannel()) {
            if (this._sessionType.isSelectable()) {
                if (this._selectableChannel != null) {
                    try {
                        this._selectableChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this._selector != null) {
                    try {
                        this._selector.close();
                    }
                    catch (IOException iOException) {}
                }
            } else if (this._asynchChannel != null) {
                try {
                    this._asynchChannel.close();
                }
                catch (IOException iOException) {}
            }
        } else if (this._socket != null) {
            try {
                if (this._webSocket != null) {
                    this._webSocket.close();
                } else {
                    this._socket.close();
                }
            }
            catch (WebsocketNotConnectedException | IOException exception) {
                // empty catch block
            }
        }
    }

    private Object _getSocketOrChannelObject(boolean forDetach) {
        Closeable obj = forDetach ? (this._sessionType.isChannel() ? (this._sessionType.isSelectable() ? this._detachSelectableChannel : this._detachAsynchChannel) : this._detachSocket) : (this._sessionType.isChannel() ? (this._sessionType.isSelectable() ? this._selectableChannel : this._asynchChannel) : this._socket);
        return obj;
    }

    private void _setCachedReattachException(SQLException e) {
        int[] updateCounts;
        RteReturnCode rteReturnCode;
        int errorPos;
        if (e instanceof SQLExceptionSapDBInterface) {
            SQLExceptionSapDBInterface eSapDB = (SQLExceptionSapDBInterface)((Object)e);
            errorPos = eSapDB.getErrorPos();
            rteReturnCode = eSapDB.getRTEReturnCode();
            updateCounts = eSapDB.getUpdateCountsFromLastPacket();
        } else {
            errorPos = 0;
            rteReturnCode = RteReturnCode.SQLOK;
            updateCounts = SQLExceptionSapDB.NO_UPDATE_COUNTS;
        }
        SQLException cached = SQLExceptionSapDB.newInstanceWithMessage(e, "Exception in client reattach: " + e.getMessage(), e.getSQLState(), e.getErrorCode(), errorPos, rteReturnCode, updateCounts);
        this._cachedReattachException.set(cached);
    }

    int getMessageID() {
        return this._messageID.get();
    }

    public void kill() {
        this._socketLock.lock();
        try {
            this._closeSocketOrChannelObject();
        }
        finally {
            this._socketLock.unlock();
        }
    }

    int getPingSentCount() {
        return this._pingSentCount.get();
    }

    void clearPingSentCount() {
        this._pingSentCount.set(0);
    }

    int getPingReceivedCount() {
        return this._pingReceivedCount.get();
    }

    void clearPingReceivedCount() {
        this._pingReceivedCount.set(0);
    }

    public int getGCSendBufferCount() {
        return this._gcSendBufferCount.get();
    }

    public void clearGCSendBufferCount() {
        this._gcSendBufferCount.set(0);
    }

    public int getGCReceiveBufferCount() {
        return this._gcReceiveBufferCount.get();
    }

    public void clearGCReceiveBufferCount() {
        this._gcReceiveBufferCount.set(0);
    }

    private void _checkDelayAfterSocketOpen(ConnectionSapDB connection) {
        int ms = connection.getDelayAfterSocketOpen();
        if (ms > 0) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    SQLException getCachedReattachException() {
        return this._cachedReattachException.get();
    }

    static class SessionType {
        private final Set<SessionFlag> _flags;

        private static SessionType _getSessionType(boolean isSecure, ConnectionProperties connectionProperties) {
            String webSocketUrl = connectionProperties.getProperty(ConnectionProperty.WEB_SOCKET_URL);
            boolean isWebSocket = webSocketUrl != null && !webSocketUrl.isEmpty();
            boolean isChannel = !isWebSocket && connectionProperties.getBooleanProperty(ConnectionProperty.NON_BLOCKING_IO);
            boolean isSelectable = isChannel && connectionProperties.getBooleanProperty(ConnectionProperty.POLL_BEFORE_SEND);
            boolean isDirectMemory = isChannel && connectionProperties.getBooleanProperty(ConnectionProperty.NON_BLOCKING_IO_DIRECT_MEMORY);
            boolean hasPermanentSelector = isSelectable && connectionProperties.getBooleanProperty(ConnectionProperty.USE_PERMANENT_SELECTORS);
            String proxyHostName = connectionProperties.getProperty(ConnectionProperty.PROXY_HOST_NAME);
            boolean hasProxy = proxyHostName != null && !proxyHostName.isEmpty();
            boolean isProxyHttp = hasProxy && (isWebSocket || connectionProperties.getBooleanProperty(ConnectionProperty.PROXY_HTTP));
            EnumSet<SessionFlag> flags = EnumSet.noneOf(SessionFlag.class);
            if (isSecure) {
                flags.add(SessionFlag.SECURE);
            }
            if (isWebSocket) {
                flags.add(SessionFlag.WEBSOCKET);
            }
            if (isChannel) {
                flags.add(SessionFlag.CHANNEL);
            }
            if (isSelectable) {
                flags.add(SessionFlag.SELECTABLE);
            }
            if (isDirectMemory) {
                flags.add(SessionFlag.DIRECT_MEMORY);
            }
            if (hasPermanentSelector) {
                flags.add(SessionFlag.PERMANENT_SELECTOR);
            }
            if (hasProxy) {
                if (isProxyHttp) {
                    flags.add(SessionFlag.HTTPPROXY);
                } else {
                    flags.add(SessionFlag.SOCKSPROXY);
                }
            }
            return new SessionType(flags);
        }

        SessionType(Set<SessionFlag> flags) {
            this._flags = EnumSet.copyOf(flags);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SessionType)) {
                return false;
            }
            SessionType other = (SessionType)object;
            return Objects.equals(this._flags, other._flags);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this._flags.hashCode();
            return result;
        }

        boolean isSecure() {
            return this._flags.contains((Object)SessionFlag.SECURE);
        }

        boolean isWebSocket() {
            return this._flags.contains((Object)SessionFlag.WEBSOCKET);
        }

        boolean isChannel() {
            return this._flags.contains((Object)SessionFlag.CHANNEL);
        }

        boolean isSelectable() {
            return this._flags.contains((Object)SessionFlag.SELECTABLE);
        }

        boolean isDirectMemory() {
            return this._flags.contains((Object)SessionFlag.DIRECT_MEMORY);
        }

        boolean isHttpProxy() {
            return this._flags.contains((Object)SessionFlag.HTTPPROXY);
        }

        boolean isSocksProxy() {
            return this._flags.contains((Object)SessionFlag.SOCKSPROXY);
        }

        boolean isProxy() {
            return this.isHttpProxy() || this.isSocksProxy();
        }
    }

    protected static enum SendType {
        DEFAULT,
        PING,
        DISCONNECT;

    }

    static enum SessionFlag {
        SECURE,
        WEBSOCKET,
        CHANNEL,
        SELECTABLE,
        PERMANENT_SELECTOR,
        DIRECT_MEMORY,
        HTTPPROXY,
        SOCKSPROXY;

    }
}

