/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.security.GSSAuthentication;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.security.auth.Subject;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Immutable
public final class GSSUtils {
    private GSSUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static Subject getSubject() {
        return Subject.getSubject(AccessController.getContext());
    }

    public static byte[] getInitialData(GSSAuthentication gssAuthentication, Subject subject) throws SQLException {
        if (subject == null) {
            return gssAuthentication.getInitData();
        }
        GetInitialDataAction action = new GetInitialDataAction(gssAuthentication);
        Subject.doAs(subject, action);
        if (action._exception != null) {
            throw action._exception;
        }
        return action._result;
    }

    public static byte[] evaluateAuthenticateReply(GSSAuthentication gssAuthentication, Subject subject, Tracer tracer, HAuthenticationPart authenticationPart) throws SQLException {
        if (subject == null) {
            return gssAuthentication.evaluateAuthReply(tracer, authenticationPart);
        }
        EvaluateAuthenticateReplyAction action = new EvaluateAuthenticateReplyAction(gssAuthentication, tracer, authenticationPart);
        Subject.doAs(subject, action);
        if (action._exception != null) {
            throw action._exception;
        }
        return action._result;
    }

    static {
        Driver.checkJavaVersionMaximum17();
    }

    private static class GetInitialDataAction
    implements PrivilegedAction<Object> {
        private final GSSAuthentication _gssAuthentication;
        private byte[] _result;
        private SQLException _exception;

        private GetInitialDataAction(GSSAuthentication gssAuthentication) {
            this._gssAuthentication = gssAuthentication;
        }

        @Override
        public Object run() {
            try {
                this._result = this._gssAuthentication.getInitData();
            }
            catch (SQLException e) {
                this._exception = e;
            }
            return null;
        }
    }

    private static class EvaluateAuthenticateReplyAction
    implements PrivilegedAction<Object> {
        private final GSSAuthentication _gssAuthentication;
        private final Tracer _tracer;
        private final HAuthenticationPart _authenticationPart;
        private byte[] _result;
        private SQLException _exception;

        private EvaluateAuthenticateReplyAction(GSSAuthentication gssAuthentication, Tracer tracer, HAuthenticationPart authenticationPart) {
            this._gssAuthentication = gssAuthentication;
            this._authenticationPart = authenticationPart;
            this._tracer = tracer;
        }

        @Override
        public Object run() {
            try {
                this._result = this._gssAuthentication.evaluateAuthReply(this._tracer, this._authenticationPart);
            }
            catch (SQLException e) {
                this._exception = e;
            }
            return null;
        }
    }
}

