/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.Driver;
import com.sap.db.util.PlatformUtils;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.NetworkChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import jdk.net.ExtendedSocketOptions;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ThreadSafe
public final class SocketUtils {
    private static final AtomicBoolean jdkNetExtendedSocketOptionsNoClassDefFoundError;

    private SocketUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static void setKeepAliveOptions(Socket socket, int n, int n2, int n3) {
        if (!PlatformUtils.isLinux() && !PlatformUtils.isMacOS()) {
            return;
        }
        if (jdkNetExtendedSocketOptionsNoClassDefFoundError.get()) {
            return;
        }
        try {
            socket.setOption(ExtendedSocketOptions.TCP_KEEPIDLE, n);
            socket.setOption(ExtendedSocketOptions.TCP_KEEPINTERVAL, n2);
            socket.setOption(ExtendedSocketOptions.TCP_KEEPCOUNT, n3);
        }
        catch (IOException iOException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            jdkNetExtendedSocketOptionsNoClassDefFoundError.set(true);
        }
    }

    public static void setKeepAliveOptions(NetworkChannel networkChannel, int n, int n2, int n3) {
        if (!PlatformUtils.isLinux() && !PlatformUtils.isMacOS()) {
            return;
        }
        if (jdkNetExtendedSocketOptionsNoClassDefFoundError.get()) {
            return;
        }
        try {
            networkChannel.setOption(ExtendedSocketOptions.TCP_KEEPIDLE, n);
            networkChannel.setOption(ExtendedSocketOptions.TCP_KEEPINTERVAL, n2);
            networkChannel.setOption(ExtendedSocketOptions.TCP_KEEPCOUNT, n3);
        }
        catch (IOException iOException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            jdkNetExtendedSocketOptionsNoClassDefFoundError.set(true);
        }
    }

    static {
        Driver.checkJavaVersionMinimum11();
        jdkNetExtendedSocketOptionsNoClassDefFoundError = new AtomicBoolean();
    }
}

