/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.SMVRRole;
import com.sap.db.jdbc.SiteReplicaVolumeID;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteTypeReplicaRoleVolumeID;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.ServiceType;
import com.sap.db.jdbc.packet.TopologyInformationOption;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.NetworkAddress;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

@Immutable
public final class SystemInfo {
    public static final SystemInfo DUMMY = new SystemInfo(new HashMap<Byte, SiteType>(), new HashMap<Integer, SMVRRole>());
    private final String _sidAndDatabaseName;
    private final Map<SiteTypeReplicaRoleVolumeID, PublicAddress> _addresses;
    private final Map<Byte, SiteType> _siteIDToSiteTypeMap;
    private final Map<Integer, SMVRRole> _siteReplicaVolumeIDToSMVRRoleMap;

    static PublicAddress getOwnAddress(HMultiLineOptionsPart topologyPart) throws SQLException {
        return SystemInfo._processTopologyPart(null, topologyPart);
    }

    static boolean areDifferentSystems(SystemInfo first, SystemInfo second) {
        return !first._sidAndDatabaseName.equals(second._sidAndDatabaseName);
    }

    SystemInfo(String sidAndDatabaseName, HMultiLineOptionsPart topologyPart, PublicAddress[] outOwnAddress) throws SQLException {
        this._sidAndDatabaseName = sidAndDatabaseName;
        this._addresses = new TreeMap<SiteTypeReplicaRoleVolumeID, PublicAddress>();
        this._siteIDToSiteTypeMap = new HashMap<Byte, SiteType>();
        this._siteReplicaVolumeIDToSMVRRoleMap = new HashMap<Integer, SMVRRole>();
        outOwnAddress[0] = SystemInfo._processTopologyPart(this, topologyPart);
    }

    String getSidAndDatabaseName() {
        return this._sidAndDatabaseName;
    }

    Collection<PublicAddress> getAddresses() {
        return Collections.unmodifiableCollection(this._addresses.values());
    }

    PublicAddress getAddress(SiteTypeReplicaRoleVolumeID siteTypeReplicaRoleVolumeID) {
        return this._addresses.get(siteTypeReplicaRoleVolumeID);
    }

    int getAddressCount() {
        return this._addresses.size();
    }

    boolean isSiteIDToSiteTypeMapEmpty() {
        return this._siteIDToSiteTypeMap.isEmpty();
    }

    SiteType getSiteType(byte siteID) {
        return this.getSiteType(siteID, null);
    }

    SiteType getSiteType(byte siteID, boolean[] outIsUnknown) {
        SiteType siteType = this._siteIDToSiteTypeMap.get(siteID);
        if (outIsUnknown != null && siteType == null && !this._siteIDToSiteTypeMap.isEmpty()) {
            outIsUnknown[0] = true;
        }
        return siteType != null ? siteType : SiteType.NONE;
    }

    byte getSiteID(SiteType siteType) {
        for (Map.Entry<Byte, SiteType> entry : this._siteIDToSiteTypeMap.entrySet()) {
            if (!entry.getValue().equals(siteType)) continue;
            return entry.getKey();
        }
        return -1;
    }

    int getSiteCount() {
        return this._siteIDToSiteTypeMap.size();
    }

    int getPerSiteIndexServerCount() {
        int siteCount = this._siteIDToSiteTypeMap.size();
        int indexServerCount = 0;
        for (PublicAddress publicAddress : this._addresses.values()) {
            if (!publicAddress.isIndexServer()) continue;
            ++indexServerCount;
        }
        if (siteCount > 1) {
            indexServerCount /= siteCount;
        }
        return indexServerCount;
    }

    SMVRRole getSMVRRole(Integer siteReplicaVolumeID) {
        return this.getSMVRRole(siteReplicaVolumeID, null);
    }

    SMVRRole getSMVRRole(Integer siteReplicaVolumeID, boolean[] outIsUnknown) {
        SMVRRole smvrRole = this._siteReplicaVolumeIDToSMVRRoleMap.get(siteReplicaVolumeID);
        if (outIsUnknown != null && smvrRole == null && !this._siteReplicaVolumeIDToSMVRRoleMap.isEmpty()) {
            outIsUnknown[0] = true;
        }
        return smvrRole != null ? smvrRole : SMVRRole.NONE;
    }

    boolean isKnownLocation(Integer siteReplicaVolumeID) {
        if (this == DUMMY) {
            return true;
        }
        return this._siteReplicaVolumeIDToSMVRRoleMap.containsKey(siteReplicaVolumeID);
    }

    private static PublicAddress _processTopologyPart(SystemInfo systemInfo, HMultiLineOptionsPart topologyPart) throws SQLException {
        boolean returnOwnAddressOnly = systemInfo == null;
        String[] outHost = new String[1];
        int[] outPort = new int[1];
        PublicAddress ownAddress = null;
        do {
            String host = null;
            int port = -1;
            int siteReplicaVolumeIDInt = -1;
            SiteReplicaVolumeID siteReplicaVolumeID = null;
            byte siteID = -1;
            int replicaID = -1;
            int volumeID = -1;
            String tenantName = null;
            boolean isCoordinator = false;
            boolean isOwn = false;
            ServiceType serviceType = ServiceType.IndexServer;
            boolean isStandby = false;
            SiteType siteType = SiteType.NONE;
            SMVRRole smvrRole = SMVRRole.NONE;
            do {
                switch (TopologyInformationOption.decode(topologyPart.getOptionName())) {
                    case HostName: {
                        host = topologyPart.getOptionStringValue();
                        break;
                    }
                    case HostPortNumber: {
                        port = topologyPart.getOptionIntValue();
                        break;
                    }
                    case TenantName: {
                        tenantName = topologyPart.getOptionStringValue();
                        break;
                    }
                    case VolumeID: {
                        siteReplicaVolumeIDInt = topologyPart.getOptionIntValue();
                        siteReplicaVolumeID = new SiteReplicaVolumeID(siteReplicaVolumeIDInt);
                        siteID = siteReplicaVolumeID.getSiteID();
                        replicaID = siteReplicaVolumeID.getReplicaID();
                        volumeID = siteReplicaVolumeID.getVolumeID();
                        break;
                    }
                    case IsMaster: {
                        isCoordinator = topologyPart.getOptionBooleanValue();
                        break;
                    }
                    case IsCurrentSession: {
                        isOwn = topologyPart.getOptionBooleanValue();
                        break;
                    }
                    case ServiceType: {
                        serviceType = ServiceType.decode(topologyPart.getOptionIntValue());
                        break;
                    }
                    case IsStandby: {
                        isStandby = topologyPart.getOptionBooleanValue();
                        break;
                    }
                    case SiteType: {
                        siteType = SiteType.decode(topologyPart.getOptionIntValue());
                        break;
                    }
                    case SMVRRole: {
                        smvrRole = SMVRRole.decode(topologyPart.getOptionIntValue());
                        break;
                    }
                }
            } while (topologyPart.nextOption());
            if (returnOwnAddressOnly && !isOwn) continue;
            if (host == null) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Host name");
            }
            if (port == -1) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Port number");
            }
            if (siteID == -1) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Site ID");
            }
            if (replicaID == -1) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Replica ID");
            }
            if (volumeID == -1) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Volume ID");
            }
            SystemInfo._updateTopologyHostAndPortFromReportedHost(host, port, outHost, outPort);
            PublicAddress address = new PublicAddress(outHost[0], outPort[0], systemInfo, tenantName, siteReplicaVolumeID, siteType, smvrRole, serviceType, isCoordinator, isStandby);
            if (returnOwnAddressOnly) {
                ownAddress = address;
                break;
            }
            systemInfo._addresses.put(new SiteTypeReplicaRoleVolumeID(siteType, smvrRole, volumeID), address);
            systemInfo._siteIDToSiteTypeMap.put(siteID, siteType);
            systemInfo._siteReplicaVolumeIDToSMVRRoleMap.put(siteReplicaVolumeIDInt, smvrRole);
            if (!isOwn) continue;
            ownAddress = address;
        } while (topologyPart.nextLine());
        topologyPart.rewind();
        return ownAddress;
    }

    private static void _updateTopologyHostAndPortFromReportedHost(String host, int port, String[] outHost, int[] outPort) {
        outHost[0] = host;
        outPort[0] = port;
        try {
            NetworkAddress networkAddress = NetworkAddress.newInstance(Tracer.getDummyTracer(), host);
            Integer networkPort = networkAddress.getPort();
            if (networkPort != null) {
                outHost[0] = networkAddress.getHost();
                outPort[0] = networkPort;
            }
        }
        catch (RTEException rTEException) {
            // empty catch block
        }
    }

    SystemInfo(Map<Byte, SiteType> siteIDToSiteTypeMap, Map<Integer, SMVRRole> siteReplicaVolumeIDToSMVRRoleMap) {
        this._siteIDToSiteTypeMap = siteIDToSiteTypeMap;
        this._siteReplicaVolumeIDToSMVRRoleMap = siteReplicaVolumeIDToSMVRRoleMap;
        this._sidAndDatabaseName = null;
        this._addresses = null;
    }

    Map<SiteTypeReplicaRoleVolumeID, PublicAddress> getAddressesMap() {
        return this._addresses;
    }

    void testClearAllSecondarySiteAddressReferences() {
        TreeMap<SiteTypeReplicaRoleVolumeID, PublicAddress> addresses = new TreeMap<SiteTypeReplicaRoleVolumeID, PublicAddress>();
        HashMap<Byte, SiteType> siteIDToSiteTypeMap = new HashMap<Byte, SiteType>();
        for (Map.Entry<SiteTypeReplicaRoleVolumeID, PublicAddress> entry : this._addresses.entrySet()) {
            if (entry.getKey().isSecondarySite()) continue;
            addresses.put(entry.getKey(), entry.getValue());
        }
        this._addresses.clear();
        this._addresses.putAll(addresses);
        for (Map.Entry<Comparable<SiteTypeReplicaRoleVolumeID>, Object> entry : this._siteIDToSiteTypeMap.entrySet()) {
            if (entry.getValue() == SiteType.SECONDARY) continue;
            siteIDToSiteTypeMap.put((Byte)entry.getKey(), (SiteType)entry.getValue());
        }
        this._siteIDToSiteTypeMap.clear();
        this._siteIDToSiteTypeMap.putAll(siteIDToSiteTypeMap);
    }
}

