/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.Cesu8Utils;
import com.sap.db.util.HexUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
class DecimalConverter
extends AbstractNumericConverter {
    private static final String MAX_VALUE = "1.189731495357231765085759326628007E+4932";
    private static final BigDecimal MIN_VALUE_BIG_DECIMAL = new BigDecimal("-1.189731495357231765085759326628007E+4932");
    private static final BigDecimal MAX_VALUE_BIG_DECIMAL = new BigDecimal("1.189731495357231765085759326628007E+4932");

    protected DecimalConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(16) + 1;
        }
        return 16;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof BigDecimal) && !(data instanceof String)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            if (data instanceof BigDecimal) {
                return this._cipher.getEncryptedLength(16) + 2;
            }
            throw new AssertionError((Object)"String argument not supported for encrypted input parameter");
        }
        if (data instanceof BigDecimal) {
            return 17;
        }
        int dataLen = Cesu8Utils.getByteLength((String)data);
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        return dataLen + dataLengthIndicatorLen + 1;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof BigDecimal) && !(data instanceof String)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            if (data instanceof BigDecimal) {
                byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putBigDecimalAsDecimal((BigDecimal)data, new byte[16], 0));
                return dataPart.putEncryptedBytes(encrypted);
            }
            throw new AssertionError((Object)"String argument not supported for encrypted input parameter");
        }
        if (data instanceof BigDecimal) {
            return dataPart.putBigDecimalAsDecimal((BigDecimal)data);
        }
        return dataPart.putStringAsString((String)data);
    }

    @Override
    protected int _getNullInputArgLength() {
        if (this._isEncrypted && !this._isDeterministic) {
            return this._cipher.getEncryptedLength(16) + 2;
        }
        return 1;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) throws SQLException {
        if (this._isEncrypted && !this._isDeterministic) {
            byte[] bytes = new byte[16];
            ByteUtils.putLong(0L, bytes, 0);
            ByteUtils.putLong(0x7000000000000000L, bytes, 8);
            byte[] encrypted = this._getEncryptedBuffer(bytes);
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putNull(this._dataType);
    }

    @Override
    public int getColumnDisplaySize() {
        return 42;
    }

    @Override
    public int getScale() {
        return this._fraction == Short.MAX_VALUE ? 0 : this._fraction;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBigDecimal(controller, dataPart, true, null, null);
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        BigDecimal value = this._getValueAsBigDecimal(controller, dataPart, true, null, outIsNull);
        return value == null ? false : value.longValue() != 0L;
    }

    @Override
    public BigDecimal setBoolean(boolean value) throws SQLException {
        return this._checkPrecision(value ? BigDecimal.ONE : BigDecimal.ZERO);
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        BigDecimal value = this._getValueAsBigDecimal(controller, dataPart, true, null, outIsNull);
        return value == null ? (byte)0 : value.byteValue();
    }

    @Override
    public BigDecimal setByte(byte value) throws SQLException {
        return this._checkPrecision(BigDecimal.valueOf(value));
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        BigDecimal value = this._getValueAsBigDecimal(controller, dataPart, true, null, outIsNull);
        return value == null ? (short)0 : value.shortValue();
    }

    @Override
    public BigDecimal setShort(short value) throws SQLException {
        return this._checkPrecision(BigDecimal.valueOf(value));
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        BigDecimal value = this._getValueAsBigDecimal(controller, dataPart, true, null, outIsNull);
        return value == null ? 0 : value.intValue();
    }

    @Override
    public BigDecimal setInt(int value) throws SQLException {
        return this._checkPrecision(BigDecimal.valueOf(value));
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        BigDecimal value = this._getValueAsBigDecimal(controller, dataPart, true, null, outIsNull);
        return value == null ? 0L : value.longValue();
    }

    @Override
    public BigDecimal setLong(long value) throws SQLException {
        return this._checkPrecision(BigDecimal.valueOf(value));
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        BigDecimal value = this._getValueAsBigDecimal(controller, dataPart, true, null, outIsNull);
        return value == null ? 0.0f : value.floatValue();
    }

    @Override
    public BigDecimal setFloat(float value) throws SQLException {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw DecimalConverter._newSetNumericValueInvalidException(String.valueOf(value));
        }
        BigDecimal bigDecimal = this._inexactDoubleToDecimalConversion ? BigDecimal.valueOf(value) : new BigDecimal(value);
        return this._checkPrecision(bigDecimal);
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        BigDecimal value = this._getValueAsBigDecimal(controller, dataPart, true, null, outIsNull);
        return value == null ? 0.0 : value.doubleValue();
    }

    @Override
    public BigDecimal setDouble(double value) throws SQLException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw DecimalConverter._newSetNumericValueInvalidException(String.valueOf(value));
        }
        BigDecimal bigDecimal = this._inexactDoubleToDecimalConversion ? BigDecimal.valueOf(value) : new BigDecimal(value);
        return this._checkPrecision(bigDecimal);
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBigDecimal(controller, dataPart, true, null, null);
    }

    @Override
    public BigDecimal setBigDecimal(BigDecimal value) throws SQLException {
        return this._checkPrecision(value);
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : String.valueOf(this._getValueAsBigDecimal(controller, dataPart, false, decrypted, null));
    }

    @Override
    public Object setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (this._isEncrypted) {
            if (this._length > 33) {
                throw SQLExceptionSapDB.newInstance("error.encrypt.failed.precisionloss", new String[0]);
            }
            try {
                return this._checkPrecision(new BigDecimal(value.trim()));
            }
            catch (NumberFormatException e) {
                throw DecimalConverter._newSetConversionException(value, "java.math.BigDecimal");
            }
        }
        return value;
    }

    @Override
    public BigDecimal setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetNumericInvalidByteArrayLengthConversionException(HexUtils.toDisplayHexString(value));
        }
        return this._checkPrecision(BigDecimal.valueOf(value[0] & 0xFF));
    }

    protected BigDecimal _getValueAsBigDecimal(SQLParamController controller, HDataPart dataPart, boolean doNullCheck, byte[] decrypted, boolean[] outIsNull) throws SQLException {
        if (doNullCheck) {
            decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
            boolean isNull = dataPart.isNull(this, controller, decrypted);
            if (outIsNull != null) {
                outIsNull[0] = isNull;
            }
            if (isNull) {
                return null;
            }
        }
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            return ByteUtils.getDecimalAsBigDecimal(decrypted, 0, this._fraction);
        }
        return dataPart.getDecimalAsBigDecimal(this._fraction);
    }

    protected BigDecimal _checkPrecision(BigDecimal value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (this._fraction == Short.MAX_VALUE) {
            if (value.compareTo(MIN_VALUE_BIG_DECIMAL) < 0 || value.compareTo(MAX_VALUE_BIG_DECIMAL) > 0) {
                throw DecimalConverter._newSetNumericValueOutOfRangeException(value.toString(), MIN_VALUE_BIG_DECIMAL.toString(), MAX_VALUE_BIG_DECIMAL.toEngineeringString());
            }
        } else {
            int targetDigits;
            int signum = value.signum();
            int precision = value.precision();
            int scale = value.scale();
            int valueDigits = signum != 0 && precision >= scale ? precision - scale : 0;
            if (valueDigits > (targetDigits = this._length - this._fraction)) {
                throw DecimalConverter._newSetNumericValueInvalidPrecisionException(value.toPlainString(), String.valueOf(targetDigits));
            }
        }
        return value;
    }
}

