/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;

@Immutable
public final class SiteReplicaVolumeID {
    public static final SiteReplicaVolumeID DUMMY = new SiteReplicaVolumeID(0);
    private final byte _siteID;
    private final byte _replicaID;
    private final int _volumeID;
    private final int _intValue;

    public static String getDisplayString(int siteReplicaVolumeID) {
        return SiteReplicaVolumeID.getSiteID(siteReplicaVolumeID) + ":" + SiteReplicaVolumeID.getReplicaID(siteReplicaVolumeID) + ":" + SiteReplicaVolumeID.getVolumeID(siteReplicaVolumeID);
    }

    public static byte getSiteID(int siteReplicaVolumeID) {
        return (byte)(siteReplicaVolumeID >> 24);
    }

    public static byte getReplicaID(int siteReplicaVolumeID) {
        return (byte)((siteReplicaVolumeID & 0xF00000) >> 20);
    }

    public static int getVolumeID(int siteReplicaVolumeID) {
        return siteReplicaVolumeID & 0xFFFFF;
    }

    SiteReplicaVolumeID(int siteReplicaVolumeID) {
        this._siteID = SiteReplicaVolumeID.getSiteID(siteReplicaVolumeID);
        this._replicaID = SiteReplicaVolumeID.getReplicaID(siteReplicaVolumeID);
        this._volumeID = SiteReplicaVolumeID.getVolumeID(siteReplicaVolumeID);
        this._intValue = siteReplicaVolumeID;
    }

    SiteReplicaVolumeID(byte siteID, byte replicaID, int volumeID) {
        this._siteID = siteID;
        this._replicaID = replicaID;
        this._volumeID = volumeID;
        this._intValue = (siteID << 24) + (replicaID << 20) + volumeID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SiteReplicaVolumeID)) {
            return false;
        }
        SiteReplicaVolumeID other = (SiteReplicaVolumeID)object;
        return this._siteID == other._siteID && this._replicaID == other._replicaID && this._volumeID == other._volumeID;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._siteID;
        result = 31 * result + this._replicaID;
        result = 31 * result + this._volumeID;
        return result;
    }

    public String toString() {
        return this._siteID + ":" + this._replicaID + ":" + this._volumeID;
    }

    public byte getSiteID() {
        return this._siteID;
    }

    public byte getReplicaID() {
        return this._replicaID;
    }

    public int getVolumeID() {
        return this._volumeID;
    }

    public int intValue() {
        return this._intValue;
    }

    public boolean isValid() {
        return this._siteID >= 0 && this._replicaID >= 0 && this._volumeID >= 0;
    }
}

