/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.SMVRRole;
import com.sap.db.jdbc.SiteReplicaVolumeID;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SystemInfo;

@Immutable
public final class SiteTypeReplicaRoleVolumeID
implements Comparable<SiteTypeReplicaRoleVolumeID> {
    private final SiteType _siteType;
    private final SMVRRole _smvrRole;
    private final int _volumeID;
    private final boolean _hadUnknownSiteID;
    private final SiteReplicaVolumeID _unknownSiteReplicaVolumeID;

    public static SiteTypeReplicaRoleVolumeID newInstance(int siteReplicaVolumeID, SystemInfo systemInfo) {
        return SiteTypeReplicaRoleVolumeID.newInstance(siteReplicaVolumeID, systemInfo, false);
    }

    public static SiteTypeReplicaRoleVolumeID newInstance(int siteReplicaVolumeID, SystemInfo systemInfo, boolean forPartition) {
        Byte unknownReplicaID;
        boolean isSubpartition = forPartition && siteReplicaVolumeID == 0;
        byte siteID = SiteReplicaVolumeID.getSiteID(siteReplicaVolumeID);
        boolean[] outIsUnknownSiteType = new boolean[1];
        SiteType siteType = systemInfo.getSiteType(siteID, outIsUnknownSiteType);
        Byte unknownSiteID = outIsUnknownSiteType[0] && !isSubpartition ? Byte.valueOf(siteID) : null;
        byte replicaID = SiteReplicaVolumeID.getReplicaID(siteReplicaVolumeID);
        boolean[] outIsUnknownSMVRRole = new boolean[1];
        SMVRRole smvrRole = systemInfo.getSMVRRole(siteReplicaVolumeID, outIsUnknownSMVRRole);
        Byte by = unknownReplicaID = outIsUnknownSMVRRole[0] && !isSubpartition ? Byte.valueOf(replicaID) : null;
        if (forPartition && smvrRole == SMVRRole.REPLICA) {
            smvrRole = SMVRRole.SOURCE;
        }
        int volumeID = SiteReplicaVolumeID.getVolumeID(siteReplicaVolumeID);
        Integer unknownVolumeID = !systemInfo.isKnownLocation(siteReplicaVolumeID) && !isSubpartition ? Integer.valueOf(volumeID) : null;
        return new SiteTypeReplicaRoleVolumeID(siteType, smvrRole, volumeID, unknownSiteID != null, unknownSiteID != null || unknownReplicaID != null || unknownVolumeID != null ? new SiteReplicaVolumeID(siteReplicaVolumeID) : null);
    }

    public SiteTypeReplicaRoleVolumeID(SiteType siteType, SMVRRole smvrRole, int volumeID) {
        this(siteType, smvrRole, volumeID, false, null);
    }

    private SiteTypeReplicaRoleVolumeID(SiteType siteType, SMVRRole smvrRole, int volumeID, boolean hadUnknownSiteID, SiteReplicaVolumeID unknownSiteReplicaVolumeID) {
        this._siteType = siteType;
        this._smvrRole = smvrRole;
        this._volumeID = volumeID == -1 ? -1 : SiteReplicaVolumeID.getVolumeID(volumeID);
        this._hadUnknownSiteID = hadUnknownSiteID;
        this._unknownSiteReplicaVolumeID = unknownSiteReplicaVolumeID;
    }

    @Override
    public int compareTo(SiteTypeReplicaRoleVolumeID other) {
        int siteTypeDiff = this._siteType.compareTo(other._siteType);
        if (siteTypeDiff != 0) {
            return siteTypeDiff;
        }
        int smvrRoleDiff = this._smvrRole.compareTo(other._smvrRole);
        if (smvrRoleDiff != 0) {
            return smvrRoleDiff;
        }
        int volumeIDDiff = this._volumeID - other._volumeID;
        if (volumeIDDiff != 0) {
            return volumeIDDiff;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SiteTypeReplicaRoleVolumeID)) {
            return false;
        }
        SiteTypeReplicaRoleVolumeID other = (SiteTypeReplicaRoleVolumeID)object;
        return this._siteType.equals(other._siteType) && this._smvrRole.equals(other._smvrRole) && this._volumeID == other._volumeID;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._siteType.hashCode();
        result = 31 * result + this._smvrRole.hashCode();
        result = 31 * result + this._volumeID;
        return result;
    }

    public String toString() {
        return this._siteType + ":" + this._smvrRole + ":" + this._volumeID + (this._unknownSiteReplicaVolumeID != null ? "(Unknown siteReplicaVolumeID " + this._unknownSiteReplicaVolumeID + ")" : "");
    }

    public SiteType getSiteType() {
        return this._siteType;
    }

    public boolean isNoneSite() {
        return this._siteType == SiteType.NONE;
    }

    public boolean isNoneOrPrimarySite() {
        return this._siteType == SiteType.NONE || this._siteType == SiteType.PRIMARY;
    }

    public boolean isPrimarySite() {
        return this._siteType == SiteType.PRIMARY;
    }

    public boolean isSecondarySite() {
        return this._siteType == SiteType.SECONDARY;
    }

    public SMVRRole getSMVRRole() {
        return this._smvrRole;
    }

    public boolean isNoneRole() {
        return this._smvrRole == SMVRRole.NONE;
    }

    public boolean isNoneOrSourceRole() {
        return this._smvrRole == SMVRRole.NONE || this._smvrRole == SMVRRole.SOURCE;
    }

    public boolean isSourceRole() {
        return this._smvrRole == SMVRRole.SOURCE;
    }

    public boolean isReplicaRole() {
        return this._smvrRole == SMVRRole.REPLICA;
    }

    public int getVolumeID() {
        return this._volumeID;
    }

    public boolean isValid() {
        return this._volumeID >= 0;
    }

    public boolean isSubpartition() {
        return this._siteType == SiteType.NONE && this._smvrRole == SMVRRole.NONE && this._volumeID == 0;
    }

    public boolean hadUnknownSiteID() {
        return this._hadUnknownSiteID;
    }

    public SiteReplicaVolumeID getUnknownSiteReplicaVolumeID() {
        return this._unknownSiteReplicaVolumeID;
    }
}

