/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.AbstractClientLob;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.trace.TraceRecord;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;

@NotThreadSafe
public class HanaClientClob
extends AbstractClientLob
implements Clob,
NClob {
    private final boolean _isNClob;
    private StringBuilder _data = new StringBuilder();

    public HanaClientClob(ConnectionSapDB connection, boolean isNClob) {
        super(connection);
        this._isNClob = isNClob;
    }

    public boolean isNClob() {
        return this._isNClob;
    }

    public Reader getReaderForTransfer() {
        return new StringReader(this._data.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public long length() throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "length") : null;
        try {
            long result;
            if (on) {
                this._tracer.printCall(this, "length", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._length();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getSubString(long pos, int length) throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "getSubString") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getSubString", pos, length);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getSubString(pos, length);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public Reader getCharacterStream() throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "getCharacterStream") : null;
        try {
            Reader result;
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getCharacterStream(1L, this._data != null ? (long)this._data.length() : 0L);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public InputStream getAsciiStream() throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "getAsciiStream") : null;
        try {
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getAsciiStream", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getAsciiStream();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public long position(String searchstr, long start) throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "position") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "position", searchstr, start);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw HanaClientClob._getUnsupportedMethodException(this._isNClob ? "NClob" : "Clob", "position( String, long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public long position(Clob searchstr, long start) throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "position") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "position", searchstr, start);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw HanaClientClob._getUnsupportedMethodException(this._isNClob ? "NClob" : "Clob", "position( Clob, long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int setString(long pos, String str) throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "setString") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "setString", pos, str);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._setString(pos, str, 0, str != null ? str.length() : 0);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "setString") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "setString", pos, str, offset, len);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._setString(pos, str, offset, len);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public Writer setCharacterStream(long pos) throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "setCharacterStream") : null;
        try {
            Writer result;
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", pos);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._setCharacterStream(pos);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Writer writer = result;
            return writer;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public OutputStream setAsciiStream(long pos) throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "setAsciiStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setAsciiStream", pos);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw HanaClientClob._getUnsupportedMethodException(this._isNClob ? "NClob" : "Clob", "setAsciiStream( long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public void truncate(long len) throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "truncate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "truncate", len);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._truncate(len);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public void free() throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "free") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "free", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._free();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        boolean aon;
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean bl = aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord(this._isNClob ? "NClob" : "Clob", "getCharacterStream") : null;
        try {
            Reader result;
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", pos, length);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getCharacterStream(pos, length);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    private int _length() throws SQLException {
        HanaClientClob._checkFreed(this._data);
        return this._data.length();
    }

    private String _getSubString(long pos, int length) throws SQLException {
        HanaClientClob._checkFreed(this._data);
        HanaClientClob._checkGetPositionAndLength(this._data.length(), pos, length);
        int ipos = (int)pos - 1;
        try {
            return this._data.subSequence(ipos, ipos + length).toString();
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    private Reader _getCharacterStream(long pos, long length) throws SQLException {
        HanaClientClob._checkFreed(this._data);
        HanaClientClob._checkGetPositionAndLength(this._data.length(), pos, length);
        int ipos = (int)pos - 1;
        int ilength = (int)length;
        try {
            return new StringReader(this._data.subSequence(ipos, ipos + ilength).toString());
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    private InputStream _getAsciiStream() throws SQLException {
        HanaClientClob._checkFreed(this._data);
        return new ByteArrayInputStream(this._data.toString().getBytes(StandardCharsets.ISO_8859_1));
    }

    private int _setString(long pos, String str, int offset, int length) throws SQLException {
        int strLen;
        HanaClientClob._checkFreed(this._data);
        HanaClientClob._checkSetPosition(pos);
        HanaClientClob._checkSourceOffsetAndLength(str != null ? str.length() : 0, offset, length);
        int n = strLen = str != null ? str.length() : 0;
        if (strLen == 0 || length == 0) {
            return 0;
        }
        if (!this._isNClob) {
            int n2 = offset + length;
            for (int i = offset; i < n2; ++i) {
                HanaClientClob._checkValidCharacterForClob(str.charAt(i));
            }
        }
        int ipos = (int)pos - 1;
        this._blankPad(ipos);
        this._data.replace(ipos, ipos + length, str.substring(offset, offset + length));
        return length;
    }

    private Writer _setCharacterStream(long pos) throws SQLException {
        HanaClientClob._checkFreed(this._data);
        HanaClientClob._checkSetPosition(pos);
        int ipos = (int)pos - 1;
        this._blankPad(ipos);
        return new ClobWriter(this, pos);
    }

    private void _truncate(long len) throws SQLException {
        HanaClientClob._checkFreed(this._data);
        HanaClientClob._checkLength(this._data.length(), len);
        int ilen = (int)len;
        this._data.setLength(ilen);
    }

    private void _free() throws SQLException {
        this._data = null;
    }

    private void _blankPad(int ipos) {
        for (int p = this._data.length(); p < ipos; ++p) {
            this._data.append(' ');
        }
    }

    private static class ClobWriter
    extends Writer {
        private final HanaClientClob _clob;
        private long _pos;

        public ClobWriter(HanaClientClob clob, long pos) {
            this._clob = clob;
            this._pos = pos;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            try {
                this._pos += (long)this._clob._setString(this._pos, new String(cbuf), off, len);
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

