/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.SMVRRole;
import com.sap.db.jdbc.SiteReplicaVolumeID;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SystemInfo;
import com.sap.db.jdbc.packet.ServiceType;

@Immutable
public final class PublicAddress
extends Address {
    private final SystemInfo _systemInfo;
    private final String _tenantName;
    private final SiteReplicaVolumeID _siteReplicaVolumeID;
    private final SiteType _siteType;
    private final SMVRRole _smvrRole;
    private final ServiceType _serviceType;
    private final boolean _isCoordinator;
    private final boolean _isStandby;

    PublicAddress(String host, int port, SystemInfo systemInfo, String tenantName, SiteReplicaVolumeID siteReplicaVolumeID, SiteType siteType, SMVRRole smvrRole, ServiceType serviceType, boolean isCoordinator, boolean isStandby) {
        super(host, port);
        this._systemInfo = systemInfo;
        this._tenantName = tenantName;
        this._siteReplicaVolumeID = siteReplicaVolumeID;
        this._siteType = siteType;
        this._smvrRole = smvrRole;
        this._serviceType = serviceType;
        this._isCoordinator = isCoordinator;
        this._isStandby = isStandby;
    }

    @Override
    public String getTraceString(boolean isFullString) {
        return this + (isFullString ? " System:" + (this._systemInfo != null ? this._systemInfo.getSidAndDatabaseName() : "(null)") + " TenantName:" + (this._tenantName != null && !this._tenantName.isEmpty() ? this._tenantName : "(none)") + " SiteReplicaVolumeID:" + this._siteReplicaVolumeID + " SiteType:" + this._siteType + " SMVRRole:" + this._smvrRole : "");
    }

    SystemInfo getSystemInfo() {
        return this._systemInfo;
    }

    public String getTenantName() {
        return this._tenantName;
    }

    public SiteReplicaVolumeID getSiteReplicaVolumeID() {
        return this._siteReplicaVolumeID;
    }

    public SiteType getSiteType() {
        return this._siteType;
    }

    public boolean isHSR() {
        return this._siteType != SiteType.NONE;
    }

    public boolean isNoneOrPrimarySite() {
        return this._siteType == SiteType.NONE || this._siteType == SiteType.PRIMARY;
    }

    public boolean isPrimarySite() {
        return this._siteType == SiteType.PRIMARY;
    }

    public boolean isSecondarySite() {
        return this._siteType == SiteType.SECONDARY;
    }

    public SMVRRole getSMVRRole() {
        return this._smvrRole;
    }

    public boolean isNoneOrSourceRole() {
        return this._smvrRole == SMVRRole.NONE || this._smvrRole == SMVRRole.SOURCE;
    }

    public boolean isSourceRole() {
        return this._smvrRole == SMVRRole.SOURCE;
    }

    public boolean isReplicaRole() {
        return this._smvrRole == SMVRRole.REPLICA;
    }

    public int getVolumeID() {
        return this._siteReplicaVolumeID.getVolumeID();
    }

    public ServiceType getServiceType() {
        return this._serviceType;
    }

    public boolean isIndexServer() {
        return this._serviceType == ServiceType.IndexServer;
    }

    public boolean isNameServer() {
        return this._serviceType == ServiceType.NameServer;
    }

    public boolean isStatisticServer() {
        return this._serviceType == ServiceType.StatisticsServer;
    }

    public boolean isCoordinator() {
        return this._isCoordinator;
    }

    public boolean isStandby() {
        return this._isStandby;
    }
}

