/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.SMVRRole;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SystemInfo;

@Immutable
public final class SiteTypeReplicaRoleVolumeID
implements Comparable<SiteTypeReplicaRoleVolumeID> {
    private final SiteType _siteType;
    private final SMVRRole _smvrRole;
    private final int _volumeID;
    private final boolean _hadUnknownSiteID;

    public static SiteTypeReplicaRoleVolumeID newInstance(int siteReplicaVolumeID, SystemInfo systemInfo) {
        byte siteID = (byte)(siteReplicaVolumeID >> 24);
        int volumeID = siteReplicaVolumeID & 0xFFFFF;
        SiteType siteType = systemInfo.getSiteType(siteID);
        SMVRRole smvrRole = systemInfo.getSMVRRole(siteReplicaVolumeID);
        boolean hadUnknownSiteID = false;
        if (siteType == null) {
            siteType = SiteType.NONE;
            if (!systemInfo.isSiteIDToSiteTypeMapEmpty()) {
                hadUnknownSiteID = true;
            }
        }
        return new SiteTypeReplicaRoleVolumeID(siteType, smvrRole, volumeID, hadUnknownSiteID);
    }

    public SiteTypeReplicaRoleVolumeID(SiteType siteType, SMVRRole smvrRole, int volumeID) {
        this(siteType, smvrRole, volumeID, false);
    }

    private SiteTypeReplicaRoleVolumeID(SiteType siteType, SMVRRole smvrRole, int volumeID, boolean hadUnknownSiteID) {
        this._siteType = siteType;
        this._smvrRole = smvrRole;
        this._volumeID = volumeID & 0xFFFFF;
        this._hadUnknownSiteID = hadUnknownSiteID;
    }

    @Override
    public int compareTo(SiteTypeReplicaRoleVolumeID other) {
        int siteTypeDiff = this._siteType.compareTo(other._siteType);
        if (siteTypeDiff != 0) {
            return siteTypeDiff;
        }
        int smvrRoleDiff = this._smvrRole.compareTo(other._smvrRole);
        if (smvrRoleDiff != 0) {
            return smvrRoleDiff;
        }
        int volumeIDDiff = this._volumeID - other._volumeID;
        if (volumeIDDiff != 0) {
            return volumeIDDiff;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SiteTypeReplicaRoleVolumeID)) {
            return false;
        }
        SiteTypeReplicaRoleVolumeID other = (SiteTypeReplicaRoleVolumeID)object;
        return this._siteType.equals(other._siteType) && this._smvrRole.equals(other._smvrRole) && this._volumeID == other._volumeID;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._siteType.hashCode();
        result = 31 * result + this._smvrRole.hashCode();
        result = 31 * result + this._volumeID;
        return result;
    }

    public String toString() {
        return this._siteType + ":" + this._smvrRole + ":" + this._volumeID;
    }

    public SiteType getSiteType() {
        return this._siteType;
    }

    public boolean isNoneSite() {
        return this._siteType == SiteType.NONE;
    }

    public boolean isNoneOrPrimary() {
        return this._siteType == SiteType.NONE || this._siteType == SiteType.PRIMARY;
    }

    public boolean isPrimarySite() {
        return this._siteType == SiteType.PRIMARY;
    }

    public boolean isSecondarySite() {
        return this._siteType == SiteType.SECONDARY;
    }

    public SMVRRole getSMVRRole() {
        return this._smvrRole;
    }

    public boolean isNoneRole() {
        return this._smvrRole == SMVRRole.NONE;
    }

    public boolean isNoneOrSourceRole() {
        return this._smvrRole == SMVRRole.NONE || this._smvrRole == SMVRRole.SOURCE;
    }

    public boolean isSourceRole() {
        return this._smvrRole == SMVRRole.SOURCE;
    }

    public boolean isReplicaRole() {
        return this._smvrRole == SMVRRole.REPLICA;
    }

    public int getVolumeID() {
        return this._volumeID;
    }

    public boolean isValid() {
        return this._volumeID >= 0;
    }

    public boolean isSubpartition() {
        return this.getSiteType() == SiteType.NONE && this.getSMVRRole() == SMVRRole.NONE && this.getVolumeID() == 0;
    }

    public boolean hadUnknownSiteID() {
        return this._hadUnknownSiteID;
    }
}

