/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.Driver;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Immutable
public final class Half {
    public static final float MAX_VALUE = 65504.0f;

    private Half() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static float shortBitsToFloat(short bits) {
        return Half._float16ToFloat(bits);
    }

    public static short floatToRawShortBits(float value) {
        return Half._floatToFloat16(value);
    }

    private static float _float16ToFloat(short h) {
        int s = h >> 15 & 1;
        int e = h >> 10 & 0x1F;
        int f = h & 0x3FF;
        if (e == 0) {
            if (f == 0) {
                return Float.intBitsToFloat(s << 31);
            }
            while ((f & 0x400) == 0) {
                f <<= 1;
                --e;
            }
            ++e;
            f &= 0xFFFFFBFF;
        } else if (e == 31) {
            if (f == 0) {
                return Float.intBitsToFloat(s << 31 | 0x7F800000);
            }
            return Float.intBitsToFloat(s << 31 | 0x7F800000 | f << 13);
        }
        return Float.intBitsToFloat(s << 31 | (e += 112) << 23 | (f <<= 13));
    }

    private static short _floatToFloat16(float f) {
        int i = Float.floatToIntBits(f);
        int s = i >> 16 & 0x8000;
        int e = (i >> 23 & 0xFF) - 112;
        int m = i & 0x7FFFFF;
        if (e <= 0) {
            if (e < -10) {
                return (short)s;
            }
            m = (m | 0x800000) >> 1 - e;
            return (short)(s | m >> 13);
        }
        if (e == 143) {
            if (m == 0) {
                return (short)(s | 0x7C00);
            }
            return (short)(s | 0x7C00 | m | ((m >>= 13) == 0 ? 1 : 0));
        }
        if (e > 30) {
            return (short)(s | 0x7C00);
        }
        return (short)(s | e << 10 | m >> 13);
    }

    static {
        Driver.checkJavaVersionMaximum19();
    }
}

