/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.Host;
import com.sap.db.jdbc.Location;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.ServiceType;
import com.sap.db.jdbc.packet.TopologyInformationOption;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.UniqueID;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ThreadSafe
class HanaSystem {
    private final String _sidAndDatabaseName;
    private final String _sid;
    private final UniqueID _nextlocation;
    @GuardedBy(value="this")
    private final Map<Host, Location> _locations;
    @GuardedBy(value="this")
    private final Map<Host, Host> _alternativeHostnames;
    @GuardedBy(value="this")
    private final Map<Byte, Location.SiteType> _siteIDToSiteTypeMap;

    static HanaSystem newInstance(String sidAndDatabaseName) {
        return new HanaSystem(sidAndDatabaseName);
    }

    private HanaSystem(String sidAndDatabaseName) {
        this._sidAndDatabaseName = sidAndDatabaseName;
        this._sid = sidAndDatabaseName == null || sidAndDatabaseName.length() <= 3 ? sidAndDatabaseName : sidAndDatabaseName.substring(0, 3);
        this._nextlocation = new UniqueID(0L);
        this._locations = new HashMap<Host, Location>();
        this._alternativeHostnames = new HashMap<Host, Host>();
        this._siteIDToSiteTypeMap = new HashMap<Byte, Location.SiteType>();
    }

    String getSidAndDatabaseName() {
        return this._sidAndDatabaseName;
    }

    String getSid() {
        return this._sid;
    }

    synchronized Map<Host, Location> getLocations() {
        return Collections.unmodifiableMap(this._locations);
    }

    synchronized int getNumberOfLocations() {
        return this._locations.size();
    }

    synchronized Location getLocation(SiteVolumeID siteVolumeID) {
        for (Location location : this._locations.values()) {
            if (!location.getSiteVolumeID().equals(siteVolumeID)) continue;
            return location;
        }
        return null;
    }

    synchronized Location getLocation(SiteTypeVolumeID siteTypeVolumeID) {
        for (Location location : this._locations.values()) {
            if (location.getSiteType() != siteTypeVolumeID.getSiteType() || location.getSiteVolumeID().getVolumeID() != siteTypeVolumeID.getVolumeID()) continue;
            return location;
        }
        return null;
    }

    synchronized Location getLocation(Host host, boolean considerAlternativeLocation) {
        Host alternativeHost;
        Location location = this._locations.get(host);
        if (location == null && considerAlternativeLocation && (alternativeHost = this._alternativeHostnames.get(host)) != null) {
            location = this._locations.get(alternativeHost);
        }
        return location;
    }

    synchronized Location getPrimaryLocation() {
        for (Location location : this._locations.values()) {
            if (!location.isPrimarySite()) continue;
            return location;
        }
        return null;
    }

    synchronized Location getSecondaryLocation() {
        for (Location location : this._locations.values()) {
            if (!location.isSecondarySite()) continue;
            return location;
        }
        return null;
    }

    synchronized Location.SiteType getSiteType(byte siteID) {
        Location.SiteType siteType = this._siteIDToSiteTypeMap.get(siteID);
        return siteType != null ? siteType : Location.SiteType.NONE;
    }

    synchronized Map<Byte, Location.SiteType> getSiteIDToSiteTypeMap() {
        return Collections.unmodifiableMap(this._siteIDToSiteTypeMap);
    }

    synchronized int getSiteCount() {
        return this._siteIDToSiteTypeMap.size();
    }

    synchronized Location updateLocations(HMultiLineOptionsPart multiLineOptionsPart) throws SQLException {
        int serviceType = ServiceType.IndexServer.getValue();
        Location ownLocation = null;
        this._locations.clear();
        this._siteIDToSiteTypeMap.clear();
        do {
            String hostName = null;
            int portNumber = 0;
            String tenantName = null;
            double loadFactor = 0.0;
            byte siteID = 0;
            int volumeID = 0;
            boolean isMaster = false;
            boolean isStandby = false;
            boolean isOwn = false;
            int siteType = 0;
            do {
                switch (TopologyInformationOption.decode(multiLineOptionsPart.getOptionName())) {
                    case HostName: {
                        hostName = multiLineOptionsPart.getOptionStringValue();
                        break;
                    }
                    case HostPortNumber: {
                        portNumber = multiLineOptionsPart.getOptionIntValue();
                        break;
                    }
                    case TenantName: {
                        tenantName = multiLineOptionsPart.getOptionStringValue();
                        break;
                    }
                    case LoadFactor: {
                        loadFactor = multiLineOptionsPart.getOptionDoubleValue();
                        break;
                    }
                    case VolumeID: {
                        SiteVolumeID siteVolumeID = new SiteVolumeID(multiLineOptionsPart.getOptionIntValue());
                        siteID = siteVolumeID.getSiteID();
                        volumeID = siteVolumeID.getVolumeID();
                        break;
                    }
                    case IsMaster: {
                        isMaster = multiLineOptionsPart.getOptionBooleanValue();
                        break;
                    }
                    case IsStandby: {
                        isStandby = multiLineOptionsPart.getOptionBooleanValue();
                        break;
                    }
                    case IsCurrentSession: {
                        isOwn = multiLineOptionsPart.getOptionBooleanValue();
                        break;
                    }
                    case ServiceType: {
                        serviceType = multiLineOptionsPart.getOptionIntValue();
                        break;
                    }
                    case SiteType: {
                        siteType = multiLineOptionsPart.getOptionIntValue();
                        break;
                    }
                }
            } while (multiLineOptionsPart.nextOption());
            if (siteType < 0 || siteType > 3) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Site type");
            }
            if (siteID <= -1) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Site ID");
            }
            if (volumeID == -1) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Volume ID");
            }
            if (portNumber == 0) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Port number");
            }
            if (hostName == null) {
                throw SQLExceptionSapDB.newInstance("error.topology.missinginfo", "Host name");
            }
            Host host = new Host(hostName, portNumber);
            Location location = this.addLocation(siteID, volumeID, host, tenantName, Location.SiteType.decode(siteType), isMaster, isStandby, serviceType, loadFactor);
            this._siteIDToSiteTypeMap.put(siteID, Location.SiteType.decode(siteType));
            if (!isOwn) continue;
            ownLocation = location;
        } while (multiLineOptionsPart.nextLine());
        return ownLocation;
    }

    synchronized Location addLocation(byte siteID, int volumeID, Host host, String tenantName, Location.SiteType siteType, boolean isMaster, boolean isStandby, int serviceType, double Loadfactor) {
        Location location = new Location(siteID, volumeID, host, tenantName, siteType, isMaster, isStandby, serviceType, Loadfactor, this);
        this._locations.put(host, location);
        return location;
    }

    synchronized void clearLocations() {
        this._locations.clear();
        this._alternativeHostnames.clear();
    }

    synchronized void getLocationsList(List<Location> locationList, boolean connectionRoutingEnabled, Location.SiteType siteType) throws SQLException {
        ArrayList<Location> tempLocationList;
        if (!connectionRoutingEnabled) {
            return;
        }
        boolean hasPrimary = false;
        boolean hasSecondary = false;
        boolean isStatisticServerConnect = false;
        ArrayList<Location> clearedLocation = new ArrayList<Location>(locationList);
        locationList.clear();
        for (Location loc : this._locations.values()) {
            boolean isInList = false;
            for (int i = 0; i < locationList.size(); ++i) {
                Location location = locationList.get(i);
                if (!loc.getHost().equals(location.getHost()) && !loc.isSameTarget(location)) continue;
                locationList.set(i, loc);
                if (loc.isPrimarySite()) {
                    hasPrimary = true;
                } else if (loc.isSecondarySite()) {
                    hasSecondary = true;
                }
                isInList = true;
                if (!loc.isStatisticServer()) break;
                isStatisticServerConnect = true;
                break;
            }
            if (isInList || !loc.isIndexServer() && !loc.isNameServer() || siteType != Location.SiteType.NONE && siteType != loc.getSiteType()) continue;
            locationList.add(loc);
            if (loc.isPrimarySite()) {
                hasPrimary = true;
                continue;
            }
            if (!loc.isSecondarySite()) continue;
            hasSecondary = true;
        }
        if (siteType != Location.SiteType.NONE) {
            tempLocationList = new ArrayList<Location>(locationList);
            for (Location eachLocation : tempLocationList) {
                if (eachLocation.isInitial() || eachLocation.getSiteType() == siteType) continue;
                locationList.remove(eachLocation);
            }
        } else if (siteType == Location.SiteType.NONE && hasPrimary && hasSecondary) {
            tempLocationList = new ArrayList<Location>(locationList);
            for (Location eachLocation : tempLocationList) {
                if (eachLocation.isInitial() || !eachLocation.isPrimarySite() && !eachLocation.isSecondarySite()) continue;
                locationList.remove(eachLocation);
            }
        }
        if (clearedLocation.size() > 0 && locationList.size() == 0) {
            locationList.addAll(clearedLocation);
        }
        if (!isStatisticServerConnect && locationList.size() > 1) {
            long pos = this._nextlocation.getNextID() % (long)locationList.size();
            int var = 0;
            while ((long)var < pos) {
                locationList.add(locationList.remove(0));
                ++var;
            }
            if (locationList.get(0).isStandby()) {
                locationList.add(locationList.remove(0));
            }
        }
    }

    synchronized void addAlternativeHostPort(Host hostPortFromURL, Host hostPortFromTopologyPart) {
        if (!hostPortFromURL.equals(hostPortFromTopologyPart)) {
            this._alternativeHostnames.put(hostPortFromURL, hostPortFromTopologyPart);
        }
    }

    Session getSession(SiteTypeVolumeID siteTypeVolumeID, ConnectionProperties connectionProperties, Tracer tracer) throws RTEException {
        Location location = this.getLocation(siteTypeVolumeID);
        if (location == null) {
            return null;
        }
        try {
            return Driver.getCommunicationFactory(connectionProperties, tracer).newInstance(tracer, location, connectionProperties, true);
        }
        catch (UnsatisfiedLinkError e) {
            throw new RTEException(tracer, MessageTranslator.translate("error.library.notloaded", "jniAuthentication", e.toString()), RteReturnCode.SQLNOTOK, -10899);
        }
    }

    void incrementNextLocationPointer() {
        this._nextlocation.getNextID();
    }
}

