/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.BufferUtils;
import com.sap.db.util.MessageTranslator;
import java.net.Authenticator;
import java.net.Proxy;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;

@ThreadSafe
class HanaWebSocket
extends WebSocketClient {
    private static final int MAX_RETRY_COUNT = 500;
    private static final int DEFAULT_ALLOCATION = 130000;
    private final Tracer _tracer;
    private final boolean _isEncrypted;
    @GuardedBy(value="this")
    private final SSLEngine _sslEngine;
    @GuardedBy(value="this")
    private final Queue<ByteBuffer> _queue;
    @GuardedBy(value="this")
    private boolean _isOpened;
    @GuardedBy(value="this")
    private boolean _isClosed;
    @GuardedBy(value="this")
    private ByteBuffer _buff;
    @GuardedBy(value="this")
    private Exception _exception;

    HanaWebSocket(Tracer tracer, URI serverUrl, Proxy proxy, Authenticator authenticator, int timeout, boolean isEncrypted, SSLEngine sslEngine, int pingInterval) throws RTEException {
        super(serverUrl, new Draft_6455(), null, timeout);
        this._tracer = tracer;
        this._isEncrypted = isEncrypted;
        this._sslEngine = sslEngine;
        this._queue = new LinkedList<ByteBuffer>();
        this._isOpened = false;
        this._isClosed = true;
        if (proxy != null) {
            super.setProxy(proxy);
            if (authenticator != null) {
                Authenticator.setDefault(authenticator);
            }
        }
        try {
            super.connectBlocking();
        }
        catch (InterruptedException e) {
            throw new RTEException(tracer, MessageTranslator.translate("error.host.connect", serverUrl.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
        if (this._exception != null) {
            throw new RTEException(tracer, MessageTranslator.translate("error.host.connect", serverUrl.toString(), this._exception.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
        this.setConnectionLostTimeout(pingInterval);
    }

    @Override
    public synchronized void onOpen(ServerHandshake handshakedata) {
        this._isOpened = true;
        this._isClosed = false;
        this.notify();
    }

    @Override
    public void onMessage(String message) {
    }

    @Override
    public synchronized void onClose(int code, String reason, boolean remote) {
        this._isClosed = true;
        this.notify();
    }

    @Override
    public synchronized void onError(Exception e) {
        this._exception = e;
        this.close();
    }

    @Override
    public synchronized void onMessage(ByteBuffer buffer) {
        this._queue.add(buffer);
        this.notify();
    }

    @Override
    public void onFragment(Framedata fragment) {
    }

    SSLEngine getSSLEngine() {
        return this._sslEngine;
    }

    synchronized void doHandshake() throws RTEException {
        ByteBuffer applicationBuffer = ByteBuffer.allocate(130000);
        ByteBuffer networkBuffer = ByteBuffer.allocate(130000);
        SSLEngineResult result = null;
        if (this._sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            return;
        }
        try {
            this._sslEngine.beginHandshake();
        }
        catch (SSLException e1) {
            throw new RTEException(this._tracer, MessageTranslator.translate("error.ssl.handshake", e1.getMessage()), RteReturnCode.SQLSTART_REQUIRED);
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this._sslEngine.getHandshakeStatus();
        while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    if (networkBuffer == null || networkBuffer.remaining() == 0) {
                        networkBuffer = this._getServerReply(true, 0);
                        applicationBuffer = ByteBuffer.allocate(networkBuffer.capacity());
                    } else if (result != null && result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        ByteBuffer latest = this._getServerReply(true, 0);
                        ByteBuffer newSrc = ByteBuffer.allocate(networkBuffer.remaining() + latest.capacity());
                        newSrc.put(networkBuffer);
                        newSrc.put(latest);
                        BufferUtils.position(newSrc, 0);
                        networkBuffer = newSrc;
                    } else if (result != null && result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        BufferUtils.flip(applicationBuffer);
                        ByteBuffer newDes = ByteBuffer.allocate(networkBuffer.remaining() + applicationBuffer.capacity());
                        newDes.put(applicationBuffer);
                        applicationBuffer = newDes;
                    }
                    try {
                        result = this._sslEngine.unwrap(networkBuffer, applicationBuffer);
                    }
                    catch (SSLException e) {
                        throw new RTEException(this._tracer, MessageTranslator.translate("error.unwrap.failed", e), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                    }
                    handshakeStatus = this._sslEngine.getHandshakeStatus();
                    if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                    Runnable r = this._sslEngine.getDelegatedTask();
                    r.run();
                    handshakeStatus = this._sslEngine.getHandshakeStatus();
                    if (this._sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                    networkBuffer = null;
                    break;
                }
                case NEED_WRAP: {
                    if (networkBuffer == null) {
                        networkBuffer = ByteBuffer.allocate(130000);
                        applicationBuffer = ByteBuffer.allocate(130000);
                    }
                    try {
                        result = this._sslEngine.wrap(applicationBuffer, networkBuffer);
                    }
                    catch (SSLException e) {
                        throw new RTEException(this._tracer, MessageTranslator.translate("error.wrap.failed", e), RteReturnCode.SQLSEND_LINE_DOWN);
                    }
                    if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                        BufferUtils.flip(networkBuffer);
                        super.send(networkBuffer);
                    }
                    if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        networkBuffer = null;
                    }
                    handshakeStatus = this._sslEngine.getHandshakeStatus();
                }
            }
        }
    }

    synchronized void send(byte[] buffer, int len) throws RTEException, SSLException {
        while (!this._isOpened && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RTEException(this._tracer, MessageTranslator.translate("error.send.write", e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
            }
        }
        if (this._isClosed) {
            throw new RTEException(this._tracer, MessageTranslator.translate("error.send.write", new Object[0]), RteReturnCode.SQLSEND_LINE_DOWN);
        }
        if (this._exception != null) {
            throw new RTEException(this._tracer, MessageTranslator.translate("error.send.write", this._exception.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
        }
        ByteBuffer src = ByteBuffer.wrap(buffer, 0, len);
        if (this._isEncrypted) {
            ByteBuffer dest = ByteBuffer.allocate(260000);
            do {
                for (int count = 0; src.remaining() > 0 && count < 500 && this._sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP && this._sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK; ++count) {
                    this._sslEngine.wrap(src, dest);
                }
                if (src.remaining() <= 0) continue;
                throw new RTEException(this._tracer, MessageTranslator.translate("error.wrap.failed", new Object[0]), RteReturnCode.SQLSEND_LINE_DOWN);
            } while (this._sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP);
            BufferUtils.flip(dest);
            super.send(dest);
        } else {
            super.send(src);
        }
    }

    synchronized void receive(byte[] buffer, int off, int len) throws RTEException, SSLException {
        while (true) {
            int remaining;
            if (this._buff == null || this._buff.remaining() == 0) {
                this._buff = this._getServerReply(false, len);
            }
            if (len <= (remaining = this._buff.remaining())) break;
            this._buff.get(buffer, off, remaining);
            off += remaining;
            len -= remaining;
        }
        this._buff.get(buffer, off, len);
    }

    private ByteBuffer _getServerReply(boolean isRaw, int len) throws RTEException {
        while (this._queue.isEmpty() && !this._isClosed && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RTEException(this._tracer, MessageTranslator.translate("error.data.receivefailed.reason", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
        }
        if (this._isClosed) {
            throw new RTEException(this._tracer, MessageTranslator.translate("error.data.receivefailed.reason", new Object[0]), RteReturnCode.SQLSEND_LINE_DOWN);
        }
        if (this._exception != null) {
            throw new RTEException(this._tracer, MessageTranslator.translate("error.data.receivefailed.reason", this._exception.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
        if (this._queue.peek() == null) {
            throw new RTEException(this._tracer, MessageTranslator.translate("error.data.receivefailed.reason", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        }
        if (isRaw || !this._isEncrypted) {
            return this._queue.poll();
        }
        ByteBuffer src = this._queue.poll();
        len = Math.max(len, src.capacity());
        ByteBuffer dst = ByteBuffer.allocate(len);
        do {
            for (int count = 0; src.remaining() > 0 && count < 500 && this._sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP && this._sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK; ++count) {
                SSLEngineResult.Status result;
                try {
                    result = this._sslEngine.unwrap(src, dst).getStatus();
                }
                catch (SSLException e) {
                    throw new RTEException(this._tracer, MessageTranslator.translate("error.unwrap.failed", e), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                }
                if (result == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    ByteBuffer latest = this._getServerReply(true, 0);
                    ByteBuffer newSrc = ByteBuffer.allocate(src.remaining() + latest.capacity());
                    newSrc.put(src);
                    newSrc.put(latest);
                    BufferUtils.position(newSrc, 0);
                    src = newSrc;
                    continue;
                }
                if (result != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
                BufferUtils.flip(dst);
                ByteBuffer newDes = ByteBuffer.allocate(src.remaining() + dst.capacity());
                newDes.put(dst);
                dst = newDes;
            }
            if (src.remaining() <= 0) continue;
            throw new RTEException(this._tracer, MessageTranslator.translate("error.unwrap.failed", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
        } while (this._sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
        BufferUtils.flip(dst);
        return dst;
    }
}

