/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.HanaSystem;
import com.sap.db.jdbc.Host;
import com.sap.db.jdbc.SiteVolumeID;
import com.sap.db.jdbc.Topology;
import com.sap.db.jdbc.packet.ServiceType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class Location {
    private final boolean _isInitial;
    private final SiteVolumeID _siteVolumeID;
    private final Host _host;
    private final String _tenantName;
    private final SiteType _siteType;
    private final boolean _isMaster;
    private final boolean _isStandby;
    private final ServiceType _serviceType;
    private final double _loadFactor;
    private final AtomicReference<HanaSystem> _system;
    private final AtomicBoolean _isAvailable;

    Location(Host host, String tenantName) {
        this(true, 0, 0, host, tenantName, SiteType.NONE, false, false, ServiceType.IndexServer.getValue(), 0.0, null);
    }

    Location(byte siteID, int volumeID, Host host, String tenantName, SiteType siteType, boolean isMaster, boolean isStandby, int serviceType, double loadFactor, HanaSystem system) {
        this(false, siteID, volumeID, host, tenantName, siteType, isMaster, isStandby, serviceType, loadFactor, system);
    }

    private Location(boolean isInitial, byte siteID, int volumeID, Host host, String tenantName, SiteType siteType, boolean isMaster, boolean isStandby, int serviceType, double loadFactor, HanaSystem system) {
        this._isInitial = isInitial;
        this._siteVolumeID = new SiteVolumeID(siteID, volumeID);
        this._host = host;
        this._tenantName = tenantName;
        this._siteType = siteType;
        this._isMaster = isMaster;
        this._isStandby = isStandby;
        this._serviceType = ServiceType.decode(serviceType);
        this._loadFactor = loadFactor;
        this._system = new AtomicReference<HanaSystem>(system);
        this._isAvailable = new AtomicBoolean(true);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Location)) {
            return false;
        }
        Location other = (Location)object;
        return this._siteVolumeID.equals(other._siteVolumeID) && (this._host == null ? other._host == null : this._host.equals(other._host)) && (this._tenantName == null ? other._tenantName == null : this._tenantName.equals(other._tenantName)) && this._siteType == other._siteType && this._isMaster == other._isMaster;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._siteVolumeID.hashCode();
        result = 31 * result + (this._host == null ? 0 : this._host.hashCode());
        result = 31 * result + (this._tenantName == null ? 0 : this._tenantName.hashCode());
        result = 31 * result + this._siteType.ordinal();
        result = 31 * result + (this._isMaster ? 1 : 0);
        return result;
    }

    public String toString() {
        return "System=" + (this._system.get() == null ? "null" : this._system.get().toString()) + " SiteID=" + this._siteVolumeID.getSiteID() + " VolumeID=" + this._siteVolumeID.getVolumeID() + " HostName=" + this._host.getHost() + " PortNumber=" + this._host.getPort() + " TenantName=" + this._tenantName + " siteType=" + (Object)((Object)this._siteType) + " isMaster=" + this._isMaster + " serviceType=" + (Object)((Object)this._serviceType) + " Loadfactor=" + this._loadFactor + " isAvailable=" + this._isAvailable.get();
    }

    public boolean isInitial() {
        return this._isInitial;
    }

    public SiteVolumeID getSiteVolumeID() {
        return this._siteVolumeID;
    }

    public Host getHost() {
        return this._host;
    }

    public String getHostName() {
        return this._host.getHost();
    }

    public int getPortNumber() {
        return this._host.getPort();
    }

    public String getTenantName() {
        return this._tenantName;
    }

    public SiteType getSiteType() {
        return this._siteType;
    }

    public boolean isHSR() {
        return this._siteType != SiteType.NONE;
    }

    public boolean isPrimarySite() {
        return this._siteType == SiteType.PRIMARY;
    }

    public boolean isSecondarySite() {
        return this._siteType == SiteType.SECONDARY;
    }

    public boolean isPrimaryOrNoneSite() {
        return this._siteType == SiteType.PRIMARY || this._siteType == SiteType.NONE;
    }

    public boolean isMaster() {
        return this._isMaster;
    }

    public boolean isStandby() {
        return this._isStandby;
    }

    public boolean isIndexServer() {
        return this._serviceType == ServiceType.IndexServer;
    }

    public boolean isStatisticServer() {
        return this._serviceType == ServiceType.StatisticsServer;
    }

    public boolean isNameServer() {
        return this._serviceType == ServiceType.NameServer;
    }

    public double getLoadfactor() {
        return this._loadFactor;
    }

    public HanaSystem getSystem() {
        return this._system.get();
    }

    public void setSystem(HanaSystem sys) {
        this._system.set(sys);
    }

    public boolean isAvailable() {
        return this._isAvailable.get();
    }

    public void setAvailable(boolean isAvailable) {
        this._isAvailable.set(isAvailable);
    }

    public boolean isSameTarget(Location host) {
        return this._host.equals(host.getHost());
    }

    public HanaSystem setSystemID(String sidAndDatabase, Host hostPortFromURL) {
        HanaSystem system = this.getSystem();
        if (system == null) {
            system = Topology.addSystem(sidAndDatabase, hostPortFromURL);
        }
        this.setSystem(system);
        return system;
    }

    public String getAsShortString() {
        return this._host.getHost() + ":" + this._host.getPort() + " [Site=" + this._siteVolumeID.getSiteID() + " Volume=" + this._siteVolumeID.getVolumeID() + "]";
    }

    public static enum SiteType {
        NONE(0),
        PRIMARY(1),
        SECONDARY(2),
        TERTIARY(3);

        private static final Map<Integer, SiteType> SITE_TYPE_MAP;
        private final int _value;

        static SiteType decode(int value) {
            SiteType siteType = SITE_TYPE_MAP.get(value);
            return siteType != null ? siteType : NONE;
        }

        private SiteType(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }

        static {
            SITE_TYPE_MAP = new HashMap<Integer, SiteType>();
            for (SiteType siteType : SiteType.values()) {
                SITE_TYPE_MAP.put(siteType._value, siteType);
            }
        }
    }
}

