/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.HashPartitionInfo;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.PartitionParameterInfo;
import com.sap.db.jdbc.RangePartitionInfo;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.util.UniqueID;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

@ThreadSafe
public class ParseInfo
implements DataFormatDescription {
    private final String _sql;
    private final FunctionCode _functionCode;
    private final boolean _isSelect;
    private final boolean _isProcedure;
    private final UniqueID _tableLocationCounter;
    @GuardedBy(value="itself")
    private final Map<Session, ParseID> _parseIDs = new WeakHashMap<Session, ParseID>();
    @GuardedBy(value="this")
    private List<AbstractConverter> _parameterConverters;
    @GuardedBy(value="this")
    private Map<String, AbstractConverter> _parameterConverterMap;
    @GuardedBy(value="this")
    private int _inputParameterCount;
    @GuardedBy(value="this")
    private List<DataType> _outputDataTypes;
    @GuardedBy(value="this")
    private boolean _hasInputLOB;
    @GuardedBy(value="this")
    private boolean _hasOutputLOB;
    @GuardedBy(value="this")
    private boolean _hasResultSetLOB;
    @GuardedBy(value="this")
    private List<AbstractConverter> _resultSetConverters;
    @GuardedBy(value="this")
    private List<SiteTypeVolumeID> _tableLocations;
    @GuardedBy(value="this")
    private HashPartitionInfo _hashPartitionInfo;
    @GuardedBy(value="this")
    private RangePartitionInfo _rangePartitionInfo;
    @GuardedBy(value="this")
    private List<Integer> _partitionParamIndexList;

    public ParseInfo(String sql, FunctionCode functionCode, UniqueID uniqueID) throws SQLException {
        this._sql = sql;
        this._functionCode = functionCode;
        switch (functionCode) {
            case Select: 
            case SelectForUpdate: {
                this._isSelect = true;
                this._isProcedure = false;
                break;
            }
            case DBProcedureCall: {
                this._isSelect = false;
                this._isProcedure = true;
                break;
            }
            case DBProcedureCallWithResultSet: {
                this._isSelect = true;
                this._isProcedure = true;
                break;
            }
            default: {
                this._isSelect = false;
                this._isProcedure = false;
            }
        }
        this._tableLocationCounter = new UniqueID(uniqueID.getNextID());
        this._parameterConverters = Collections.emptyList();
        this._parameterConverterMap = new TreeMap<String, AbstractConverter>(String.CASE_INSENSITIVE_ORDER);
        this._inputParameterCount = 0;
        this._outputDataTypes = new ArrayList<DataType>();
        this._hasInputLOB = false;
        this._hasOutputLOB = false;
        this._hasResultSetLOB = false;
        this._resultSetConverters = new ArrayList<AbstractConverter>();
    }

    @Override
    public synchronized int getOutputFieldCount() {
        return this._outputDataTypes.size();
    }

    @Override
    public synchronized DataType getOutputFieldDataType(int outputFieldPos) {
        return this._outputDataTypes.get(outputFieldPos - 1);
    }

    @Override
    public boolean isOutputFieldEncrypted(int outputFieldPos) {
        return false;
    }

    @Override
    public synchronized int getResultSetColumnCount() {
        return this._resultSetConverters.size();
    }

    @Override
    public synchronized AbstractConverter getResultSetConverter(int index) {
        return this._resultSetConverters.get(index - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<Session, ParseID> map = this._parseIDs;
        synchronized (map) {
            return super.toString() + Arrays.toString(this._parseIDs.values().toArray());
        }
    }

    public String getSQL() {
        return this._sql;
    }

    public FunctionCode getFunctionCode() {
        return this._functionCode;
    }

    public boolean isSelect() {
        return this._isSelect;
    }

    public boolean isProcedure() {
        return this._isProcedure;
    }

    public UniqueID getTableLocationCounter() {
        return this._tableLocationCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Session, ParseID> getParseIDs() {
        Map<Session, ParseID> map = this._parseIDs;
        synchronized (map) {
            return new HashMap<Session, ParseID>(this._parseIDs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParseID getParseID(Session session) {
        Map<Session, ParseID> map = this._parseIDs;
        synchronized (map) {
            return this._parseIDs.get(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParseID(Session session, ParseID parseID) {
        Map<Session, ParseID> map = this._parseIDs;
        synchronized (map) {
            this._parseIDs.put(session, parseID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParseID(Session session) {
        Map<Session, ParseID> map = this._parseIDs;
        synchronized (map) {
            this._parseIDs.remove(session);
        }
    }

    public synchronized List<AbstractConverter> getParameterConverters() {
        return this._parameterConverters;
    }

    public synchronized AbstractConverter getParameterConverter(int index) {
        return this._parameterConverters.get(index - 1);
    }

    public synchronized AbstractConverter getParameterConverter(String parameterName) {
        return this._parameterConverterMap.get(parameterName);
    }

    public synchronized int getParameterCount() {
        return this._parameterConverters.size();
    }

    public synchronized int getInputParameterCount() {
        return this._inputParameterCount;
    }

    public synchronized boolean hasInputLOB() {
        return this._hasInputLOB;
    }

    public synchronized boolean hasOutputLOB() {
        return this._hasOutputLOB;
    }

    public synchronized boolean hasResultSetLOB() {
        return this._hasResultSetLOB;
    }

    public synchronized void setHasResultSetLOB() {
        this._hasResultSetLOB = true;
    }

    public synchronized void setParameterInfo(List<AbstractConverter> parameterConverters, int inputParameterCount, List<DataType> outputDataTypes, boolean hasInputLOB, boolean hasOutputLOB) {
        this._parameterConverters = Collections.unmodifiableList(parameterConverters);
        this._inputParameterCount = inputParameterCount;
        this._outputDataTypes = outputDataTypes;
        this._hasInputLOB |= hasInputLOB;
        this._hasOutputLOB |= hasOutputLOB;
        this._parameterConverterMap.clear();
        for (AbstractConverter converter : parameterConverters) {
            String parameterName = converter.getColumnLabel();
            if (this._parameterConverterMap.containsKey(parameterName)) continue;
            this._parameterConverterMap.put(parameterName, converter);
        }
    }

    public synchronized List<AbstractConverter> getResultSetConverters() {
        return this._resultSetConverters;
    }

    public synchronized void setResultSetConverters(List<AbstractConverter> resultSetConverters) {
        this._resultSetConverters = resultSetConverters;
    }

    public synchronized List<SiteTypeVolumeID> getTableLocations() {
        return this._tableLocations;
    }

    public synchronized void setTableLocations(List<SiteTypeVolumeID> tableLocations) {
        this._tableLocations = Collections.unmodifiableList(tableLocations);
    }

    public synchronized boolean isHashPartitioned() {
        return this._hashPartitionInfo != null;
    }

    public synchronized HashPartitionInfo getHashPartitionInfo() {
        return this._hashPartitionInfo;
    }

    public synchronized void setHashPartitionInfo(HashPartitionInfo hashPartitionInfo) {
        this._hashPartitionInfo = hashPartitionInfo;
        this._setPartitionParamIndexList(hashPartitionInfo.getPartitionParameterInfoList());
    }

    public synchronized boolean isRangePartitioned() {
        return this._rangePartitionInfo != null;
    }

    public synchronized RangePartitionInfo getRangePartitionInfo() {
        return this._rangePartitionInfo;
    }

    public synchronized void setRangePartitionInfo(RangePartitionInfo rangePartitionInfo) {
        this._rangePartitionInfo = rangePartitionInfo;
        this._setPartitionParamIndexList(rangePartitionInfo.getPartitionParameterInfoList());
    }

    public synchronized boolean isPartitionParameter(int parameterIndex) {
        return this._partitionParamIndexList.contains(parameterIndex);
    }

    private void _setPartitionParamIndexList(List<PartitionParameterInfo> partitionParameterInfoList) {
        if (this._partitionParamIndexList == null) {
            this._partitionParamIndexList = new ArrayList<Integer>();
        } else {
            this._partitionParamIndexList.clear();
        }
        if (partitionParameterInfoList == null || partitionParameterInfoList.size() == 0) {
            return;
        }
        for (PartitionParameterInfo partitionParameterInfo : partitionParameterInfoList) {
            this._partitionParamIndexList.add(partitionParameterInfo.getParameterIndex());
        }
    }
}

