/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.Location;
import java.util.Map;

@Immutable
public class SiteTypeVolumeID {
    private final Location.SiteType _siteType;
    private final int _volumeID;

    public static SiteTypeVolumeID newInstance(int siteVolumeID, Map<Byte, Location.SiteType> siteIDToSiteTypeMap) {
        byte siteID = (byte)(siteVolumeID >> 24);
        int volumeID = siteVolumeID & 0xFFFFFF;
        Location.SiteType siteType = siteIDToSiteTypeMap.get(siteID);
        if (siteType == null) {
            siteType = Location.SiteType.NONE;
        }
        return new SiteTypeVolumeID(siteType, volumeID);
    }

    public SiteTypeVolumeID(int volumeID) {
        this._siteType = Location.SiteType.NONE;
        this._volumeID = volumeID & 0xFFFFFF;
    }

    public SiteTypeVolumeID(Location.SiteType siteType, int volumeID) {
        this._siteType = siteType;
        this._volumeID = volumeID & 0xFFFFFF;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SiteTypeVolumeID)) {
            return false;
        }
        SiteTypeVolumeID other = (SiteTypeVolumeID)object;
        return this._siteType == other._siteType && this._volumeID == other._volumeID;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._siteType.hashCode();
        result = 31 * result + this._volumeID;
        return result;
    }

    public String toString() {
        return (Object)((Object)this._siteType) + ":" + this._volumeID;
    }

    public Location.SiteType getSiteType() {
        return this._siteType;
    }

    public boolean isNoneSite() {
        return this._siteType == Location.SiteType.NONE;
    }

    public boolean isPrimarySite() {
        return this._siteType == Location.SiteType.PRIMARY;
    }

    public boolean isSecondarySite() {
        return this._siteType == Location.SiteType.SECONDARY;
    }

    public int getVolumeID() {
        return this._volumeID;
    }

    public boolean isValid() {
        return this._volumeID >= 0;
    }
}

