/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HanaClob;
import com.sap.db.jdbc.converters.AbstractGetval;
import com.sap.db.jdbc.converters.AbstractLobConverter;
import com.sap.db.jdbc.converters.InputStreamFilter;
import com.sap.db.jdbc.converters.PutvalClob;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.CharsetUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Set;

@NotThreadSafe
class ClobConverter
extends AbstractLobConverter {
    private final boolean _isNClob;

    protected ClobConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isNClob) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel);
        this._isNClob = isNClob;
    }

    @Override
    protected AbstractGetval _getLob(SQLParamController controller, HDataPart dataPart) throws SQLException {
        if (dataPart.isNull(this, controller)) {
            return null;
        }
        return new HanaClob(controller, dataPart, this._outputFieldPos, this._length, this._isNClob);
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    public PutvalClob setString(String value) throws SQLException {
        return value != null ? this._convertStringToClob(value, this._isNClob) : null;
    }

    @Override
    public PutvalClob setBytes(byte[] value) throws SQLException {
        return value != null ? this._convertStringToClob(new String(value), this._isNClob) : null;
    }

    @Override
    public PutvalClob setCharacterStream(Reader value, long length) throws SQLException {
        return value != null ? this._convertReaderToClob(value, length, this._isNClob) : null;
    }

    @Override
    public PutvalClob setAsciiStream(InputStream value, long length) throws SQLException {
        return value != null ? this._convertReaderToClob(new InputStreamReader(length >= 0L ? new InputStreamFilter(value, length) : value, CharsetUtils.ISO_8859_1), -1L, this._isNClob) : null;
    }

    @Override
    public PutvalClob setBinaryStream(InputStream value, long length) throws SQLException {
        return value != null ? this._convertReaderToClob(new InputStreamReader(length >= 0L ? new InputStreamFilter(value, length) : value), -1L, this._isNClob) : null;
    }

    @Override
    public Clob getClob(SQLParamController controller, HDataPart dataPart) throws SQLException {
        AbstractGetval getval = this._getLob(controller, dataPart);
        return getval != null ? (Clob)((Object)getval) : null;
    }

    @Override
    public PutvalClob setClob(Clob value) throws SQLException {
        return value != null ? this._convertClobToClob(value, this._isNClob) : null;
    }
}

