/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.Driver;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

@Immutable
public final class Base64Utils {
    private static final String BEGIN_PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----";
    private static final String END_PUBLIC_KEY = "-----END PUBLIC KEY-----";
    private static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    private static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static final String BEGIN_TRUSTED_CERTIFICATE = "-----BEGIN TRUSTED CERTIFICATE-----";
    private static final String END_TRUSTED_CERTIFICATE = "-----END TRUSTED CERTIFICATE-----";
    private static final String REGEX_BASE_64 = "[A-Za-z0-9+/=\\s]+";
    private static final Pattern PATTERN_PRIVATE_KEY = Pattern.compile("(?:" + Pattern.quote("-----BEGIN PRIVATE KEY-----") + ")(" + "[A-Za-z0-9+/=\\s]+" + ")(?:" + Pattern.quote("-----END PRIVATE KEY-----") + ")");
    private static final Pattern PATTERN_CERTIFICATE = Pattern.compile("(?:" + Pattern.quote("-----BEGIN CERTIFICATE-----") + "|" + Pattern.quote("-----BEGIN TRUSTED CERTIFICATE-----") + ")(" + "[A-Za-z0-9+/=\\s]+" + ")(?:" + Pattern.quote("-----END CERTIFICATE-----") + "|" + Pattern.quote("-----END TRUSTED CERTIFICATE-----") + ")");

    private Base64Utils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static String encodeToString(byte[] bytes) {
        return Base64Utils._encode(bytes);
    }

    public static String encodePublicKey(byte[] bytes) {
        return BEGIN_PUBLIC_KEY + Base64Utils._encode(bytes) + END_PUBLIC_KEY;
    }

    public static byte[] decodePublicKey(String text) {
        return Base64Utils._decode(text.replace(BEGIN_PUBLIC_KEY, "").replace(END_PUBLIC_KEY, "").replaceAll("\\s", "").replaceAll("\u0000", ""));
    }

    public static List<byte[]> decodePrivateKeys(String text) {
        ArrayList<byte[]> keysBytes = new ArrayList<byte[]>();
        Matcher matcher = PATTERN_PRIVATE_KEY.matcher(text);
        while (matcher.find()) {
            keysBytes.add(Base64Utils._decode(matcher.group(1)));
        }
        return keysBytes;
    }

    public static List<byte[]> decodeCertificates(String text) {
        ArrayList<byte[]> certsBytes = new ArrayList<byte[]>();
        Matcher matcher = PATTERN_CERTIFICATE.matcher(text);
        while (matcher.find()) {
            certsBytes.add(Base64Utils._decode(matcher.group(1)));
        }
        return certsBytes;
    }

    private static String _encode(byte[] bytes) {
        if (Driver.getJavaVersion() >= 8) {
            return Base64.getEncoder().encodeToString(bytes);
        }
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    private static byte[] _decode(String text) {
        if (Driver.getJavaVersion() >= 8) {
            return Base64.getDecoder().decode(text);
        }
        return DatatypeConverter.parseBase64Binary((String)text);
    }
}

