/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.CharsetUtils;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import com.sap.db.util.security.ScramSHA256;
import java.security.SecureRandom;
import java.sql.SQLException;

@NotThreadSafe
class ScramSHA256Authentication
extends AbstractAuthenticationMethod {
    static final String METHOD_NAME = "SCRAMSHA256";
    protected static final int CLIENT_PROOF_SIZE = 32;
    protected byte[] _salt;
    protected byte[] _clientChallenge;
    protected byte[] _serverChallenge;

    ScramSHA256Authentication() {
    }

    @Override
    String getMethodName() {
        return METHOD_NAME;
    }

    @Override
    byte[] getInitialData(byte[] passwd) throws SQLException {
        return this._getClientChallenge();
    }

    @Override
    byte[] getFinalData(String passwd) throws SQLException {
        if (passwd == null) {
            throw SQLExceptionSapDB.newInstance("error.nopasswd", new String[0]);
        }
        return this._getClientProof(passwd);
    }

    @Override
    byte[] evaluateAuthenticateReply(HAuthenticationPart authenticationPart, Tracer tracer) throws SQLException {
        HAuthenticationPart part = new HAuthenticationPart(authenticationPart);
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
        }
        this._salt = part.getValueAsBytes();
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
        }
        this._serverChallenge = part.getValueAsBytes();
        return null;
    }

    @Override
    boolean supportsReconnect() {
        return true;
    }

    protected byte[] _getClientChallenge() {
        if (this._clientChallenge != null) {
            return this._clientChallenge;
        }
        this._clientChallenge = new byte[64];
        SecureRandom srnd = new SecureRandom();
        srnd.nextBytes(this._clientChallenge);
        return this._clientChallenge;
    }

    protected byte[] _getClientProof(String pass) {
        byte[] passBytes = pass.getBytes(CharsetUtils.UTF_8);
        byte[] data = new byte[35];
        ByteUtils.putShortBigEndian(1, data, 0);
        byte[] clientProof = ScramSHA256.scramSHA256(this._salt, passBytes, this._getClientChallenge(), this._serverChallenge);
        data[2] = 32;
        System.arraycopy(clientProof, 0, data, 3, clientProof.length);
        return data;
    }
}

