/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.CleanableSapDB;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PhantomCleanableSapDB;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
class CleanableSapDBImpl {
    CleanableSapDBImpl() {
    }

    static void cleanAll() {
        PhantomCleanableSapDB ref;
        while ((ref = (PhantomCleanableSapDB)CleanableSapDB.REFERENCE_QUEUE.poll()) != null) {
            CleanableSapDBImpl.clean(ref);
        }
    }

    static void clean(PhantomCleanableSapDB ref) {
        try {
            ref.getRunnable().run();
        }
        finally {
            CleanableSapDB.PHANTOM_SET.remove(ref);
            ref.clear();
        }
    }

    static class ResultSetCleaner
    implements Runnable {
        private final String _instanceClassName;
        private final String _instanceString;
        private final ConnectionSapDB _connection;
        private final Session _session;
        private final CursorID _cursorID;
        private final ParseInfo _metaDataStatementParseInfo;
        private final AtomicBoolean _isClosed;
        private final AtomicBoolean _isClosedOnServer;

        ResultSetCleaner(ResultSetSapDB resultSet) {
            this._instanceClassName = resultSet.getInstanceClassName();
            this._instanceString = resultSet.getInstanceString();
            this._connection = resultSet.getConnectionSapDB();
            this._session = resultSet._getSession();
            this._cursorID = resultSet._getCursorID();
            this._metaDataStatementParseInfo = resultSet._getMetaDataStatementParseInfo();
            this._isClosed = resultSet._isClosed;
            this._isClosedOnServer = resultSet._isClosedOnServer;
        }

        @Override
        public void run() {
            try {
                ResultSetSapDB._clean(this._instanceClassName, this._connection, this._session, this._cursorID, this._metaDataStatementParseInfo, this._isClosed, this._isClosedOnServer);
            }
            catch (SQLException sQLException) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    static class PreparedStatementCleaner
    implements Runnable {
        private final String _instanceClassName;
        private final String _instanceString;
        private final ConnectionSapDB _connection;
        private final ParseInfo _parseInfo;
        private final AtomicBoolean _isPoolable;
        private final AtomicBoolean _isClosed;

        PreparedStatementCleaner(PreparedStatementSapDB statement) {
            this._instanceClassName = statement.getInstanceClassName();
            this._instanceString = statement.getInstanceString();
            this._connection = statement.getConnectionSapDB();
            this._parseInfo = statement.getParseInfo();
            this._isPoolable = statement._isPoolable;
            this._isClosed = statement._isClosed;
        }

        @Override
        public void run() {
            try {
                PreparedStatementSapDB._clean(this._instanceClassName, this._connection, this._parseInfo, this._isPoolable, this._isClosed);
            }
            catch (SQLException sQLException) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    static class ConnectionCleaner
    implements Runnable {
        private final String _instanceClassName;
        private final String _instanceString;
        private final SessionPool _sessionPool;
        private final AtomicBoolean _isClosed;

        ConnectionCleaner(ConnectionSapDB connection) {
            this._instanceClassName = connection.getInstanceClassName();
            this._instanceString = connection.getInstanceString();
            this._sessionPool = connection.getSessionPool();
            this._isClosed = connection._isClosed;
        }

        @Override
        public void run() {
            try {
                ConnectionSapDB._clean(this._instanceClassName, null, this._sessionPool, this._isClosed);
            }
            catch (SQLException sQLException) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }
}

