/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.InternalCallableStatementSapDB;
import com.sap.db.jdbc.InternalPreparedStatementSapDB;
import com.sap.db.jdbc.InternalResultSetSapDB;
import com.sap.db.jdbc.InternalStatementSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.StringUtils;
import com.sap.db.util.VersionInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

@ThreadSafe
abstract class DatabaseMetaDataSapDB
extends WrapperDummy
implements DatabaseMetaData {
    private static final String NUMERIC_FUNCTIONS = "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,EXP,FLOOR,LOG,LOG10,MOD,POWER,ROUND,SIGN,SIN,SQRT,TAN";
    private static final String STRING_FUNCTIONS = "ASCII,CHAR,CONCAT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPLACE,RIGHT,RTRIM,SUBSTRING,UCASE";
    private static final String SYSTEM_FUNCTIONS = "DATABASE,IFNULL,USER";
    private static final String TIME_DATE_FUNCTIONS = "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,SECOND,WEEK,YEAR";
    private static final int MAX_SCHEMA_NAME_LENGTH = 127;
    private static final int MAX_TABLE_NAME_LENGTH = 127;
    private static final int MAX_COLUMN_NAME_LENGTH = 127;
    private static final int MAX_PROCEDURE_NAME_LENGTH = 127;
    protected final Tracer _tracer;
    private final ConnectionSapDB _connection;
    @GuardedBy(value="this")
    private VersionInfo _dbVersionInfo;
    @GuardedBy(value="this")
    private String _userName;
    @GuardedBy(value="this")
    private String[] _tableTypes;

    protected DatabaseMetaDataSapDB(Tracer tracer, ConnectionSapDB connection) {
        this._tracer = tracer;
        this._connection = connection;
        this._getDBInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("allProceduresAreCallable") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "allProceduresAreCallable", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("allTablesAreSelectable") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "allTablesAreSelectable", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getURL() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getURL") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getURL", new Object[0]);
            }
            String result = this._connection.getConnectionProperty(ConnectionProperty.DBURL);
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserName() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getUserName") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getUserName", new Object[0]);
            }
            String result = this._getUserName();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isReadOnly") : null;
        try {
            Session anchor;
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isReadOnly", new Object[0]);
            }
            boolean bl = result = (anchor = this._connection.getSessionPool().getAnchorSession()) != null && anchor.isSecondarySite();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("nullsAreSortedHigh") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "nullsAreSortedHigh", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("nullsAreSortedLow") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "nullsAreSortedLow", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("nullsAreSortedAtStart") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "nullsAreSortedAtStart", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("nullsAreSortedAtEnd") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "nullsAreSortedAtEnd", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDatabaseProductName() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDatabaseProductName") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDatabaseProductName", new Object[0]);
            }
            String result = Driver.getDatabaseName();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getDatabaseProductVersion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDatabaseProductVersion") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDatabaseProductVersion", new Object[0]);
            }
            String result = this._dbVersionInfo.toString();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDriverName() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDriverName") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDriverName", new Object[0]);
            }
            String result = Driver.getDriverName();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDriverVersion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDriverVersion") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDriverVersion", new Object[0]);
            }
            String result = Driver.getVersionInfo().toShortVersionNumberString();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDriverMajorVersion() {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDriverMajorVersion") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDriverMajorVersion", new Object[0]);
            }
            int result = Driver.getVersionInfo().getMajorVersion();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDriverMinorVersion() {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDriverMinorVersion") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDriverMinorVersion", new Object[0]);
            }
            int result = Driver.getVersionInfo().getMinorVersion();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean usesLocalFiles() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("usesLocalFiles") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "usesLocalFiles", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("usesLocalFilePerTable") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "usesLocalFilePerTable", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsMixedCaseIdentifiers") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsMixedCaseIdentifiers", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("storesUpperCaseIdentifiers") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "storesUpperCaseIdentifiers", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("storesLowerCaseIdentifiers") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "storesLowerCaseIdentifiers", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("storesMixedCaseIdentifiers") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "storesMixedCaseIdentifiers", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsMixedCaseQuotedIdentifiers") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsMixedCaseQuotedIdentifiers", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("storesUpperCaseQuotedIdentifiers") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "storesUpperCaseQuotedIdentifiers", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("storesLowerCaseQuotedIdentifiers") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "storesLowerCaseQuotedIdentifiers", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("storesMixedCaseQuotedIdentifiers") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "storesMixedCaseQuotedIdentifiers", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIdentifierQuoteString() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getIdentifierQuoteString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getIdentifierQuoteString", new Object[0]);
            }
            String result = "\"";
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLKeywords() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSQLKeywords") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSQLKeywords", new Object[0]);
            }
            String result = "";
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNumericFunctions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getNumericFunctions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNumericFunctions", new Object[0]);
            }
            String result = NUMERIC_FUNCTIONS;
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStringFunctions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getStringFunctions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getStringFunctions", new Object[0]);
            }
            String result = STRING_FUNCTIONS;
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSystemFunctions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSystemFunctions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSystemFunctions", new Object[0]);
            }
            String result = SYSTEM_FUNCTIONS;
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTimeDateFunctions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTimeDateFunctions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimeDateFunctions", new Object[0]);
            }
            String result = TIME_DATE_FUNCTIONS;
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSearchStringEscape() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSearchStringEscape") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSearchStringEscape", new Object[0]);
            }
            String result = "\\";
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getExtraNameCharacters() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getExtraNameCharacters") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getExtraNameCharacters", new Object[0]);
            }
            String result = "";
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsAlterTableWithAddColumn") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsAlterTableWithAddColumn", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsAlterTableWithDropColumn") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsAlterTableWithDropColumn", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsColumnAliasing") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsColumnAliasing", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("nullPlusNonNullIsNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "nullPlusNonNullIsNull", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsConvert() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsConvert") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsConvert", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsConvert") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsConvert", fromType, toType);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsTableCorrelationNames") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsTableCorrelationNames", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsDifferentTableCorrelationNames") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsDifferentTableCorrelationNames", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsExpressionsInOrderBy") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsExpressionsInOrderBy", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsOrderByUnrelated") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsOrderByUnrelated", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsGroupBy() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsGroupBy") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsGroupBy", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsGroupByUnrelated") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsGroupByUnrelated", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsGroupByBeyondSelect") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsGroupByBeyondSelect", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsLikeEscapeClause") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsLikeEscapeClause", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsMultipleResultSets") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsMultipleResultSets", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsMultipleTransactions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsMultipleTransactions", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsNonNullableColumns") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsNonNullableColumns", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsMinimumSQLGrammar") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsMinimumSQLGrammar", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsCoreSQLGrammar") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsCoreSQLGrammar", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsExtendedSQLGrammar") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsExtendedSQLGrammar", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsANSI92EntryLevelSQL") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsANSI92EntryLevelSQL", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsANSI92IntermediateSQL") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsANSI92IntermediateSQL", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsANSI92FullSQL") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsANSI92FullSQL", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsIntegrityEnhancementFacility") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsIntegrityEnhancementFacility", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsOuterJoins() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsOuterJoins") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsOuterJoins", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsFullOuterJoins") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsFullOuterJoins", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsLimitedOuterJoins") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsLimitedOuterJoins", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchemaTerm() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSchemaTerm") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSchemaTerm", new Object[0]);
            }
            String result = "SCHEMA";
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProcedureTerm() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getProcedureTerm") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getProcedureTerm", new Object[0]);
            }
            String result = "PROCEDURE";
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalogTerm() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getCatalogTerm") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getCatalogTerm", new Object[0]);
            }
            String result = "CATALOG";
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCatalogAtStart() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("isCatalogAtStart") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isCatalogAtStart", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalogSeparator() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getCatalogSeparator") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getCatalogSeparator", new Object[0]);
            }
            String result = ".";
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsSchemasInDataManipulation") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsSchemasInDataManipulation", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsSchemasInProcedureCalls") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsSchemasInProcedureCalls", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsSchemasInTableDefinitions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsSchemasInTableDefinitions", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsSchemasInIndexDefinitions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsSchemasInIndexDefinitions", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsSchemasInPrivilegeDefinitions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsSchemasInPrivilegeDefinitions", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsCatalogsInDataManipulation") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsCatalogsInDataManipulation", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsCatalogsInProcedureCalls") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsCatalogsInProcedureCalls", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsCatalogsInTableDefinitions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsCatalogsInTableDefinitions", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsCatalogsInIndexDefinitions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsCatalogsInIndexDefinitions", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsCatalogsInPrivilegeDefinitions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsCatalogsInPrivilegeDefinitions", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsPositionedDelete") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsPositionedDelete", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsPositionedUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsPositionedUpdate", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsSelectForUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsSelectForUpdate", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsStoredProcedures") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsStoredProcedures", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsSubqueriesInComparisons") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsSubqueriesInComparisons", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsSubqueriesInExists") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsSubqueriesInExists", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsSubqueriesInIns") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsSubqueriesInIns", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsSubqueriesInQuantifieds") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsSubqueriesInQuantifieds", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsCorrelatedSubqueries") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsCorrelatedSubqueries", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsUnion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsUnion") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsUnion", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsUnionAll() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsUnionAll") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsUnionAll", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsOpenCursorsAcrossCommit") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsOpenCursorsAcrossCommit", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsOpenCursorsAcrossRollback") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsOpenCursorsAcrossRollback", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsOpenStatementsAcrossCommit") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsOpenStatementsAcrossCommit", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsOpenStatementsAcrossRollback") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsOpenStatementsAcrossRollback", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxBinaryLiteralLength") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxBinaryLiteralLength", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxCharLiteralLength") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxCharLiteralLength", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxColumnNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxColumnNameLength") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxColumnNameLength", new Object[0]);
            }
            int result = 127;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxColumnsInGroupBy") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxColumnsInGroupBy", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxColumnsInIndex") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxColumnsInIndex", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxColumnsInOrderBy") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxColumnsInOrderBy", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxColumnsInSelect") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxColumnsInSelect", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxColumnsInTable() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxColumnsInTable") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxColumnsInTable", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxConnections() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxConnections") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxConnections", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxCursorNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxCursorNameLength") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxCursorNameLength", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxIndexLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxIndexLength") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxIndexLength", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxSchemaNameLength") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxSchemaNameLength", new Object[0]);
            }
            int result = 127;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxProcedureNameLength") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxProcedureNameLength", new Object[0]);
            }
            int result = 127;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxCatalogNameLength") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxCatalogNameLength", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxRowSize() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxRowSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxRowSize", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("doesMaxRowSizeIncludeBlobs") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "doesMaxRowSizeIncludeBlobs", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxStatementLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxStatementLength") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxStatementLength", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxStatements() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxStatements") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxStatements", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxTableNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxTableNameLength") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxTableNameLength", new Object[0]);
            }
            int result = 127;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxTablesInSelect() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxTablesInSelect") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxTablesInSelect", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxUserNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxUserNameLength") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxUserNameLength", new Object[0]);
            }
            int result = 127;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDefaultTransactionIsolation") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDefaultTransactionIsolation", new Object[0]);
            }
            int result = 2;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsTransactions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsTransactions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsTransactions", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsTransactionIsolationLevel") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsTransactionIsolationLevel", level);
            }
            switch (level) {
                case 2: 
                case 4: 
                case 8: {
                    result = true;
                    break;
                }
                case 0: 
                case 1: {
                    result = false;
                    break;
                }
                default: {
                    throw new SQLException("Unexpected isolation level: " + level);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsDataDefinitionAndDataManipulationTransactions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsDataDefinitionAndDataManipulationTransactions", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsDataManipulationTransactionsOnly") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsDataManipulationTransactionsOnly", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("dataDefinitionCausesTransactionCommit") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "dataDefinitionCausesTransactionCommit", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("dataDefinitionIgnoredInTransactions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "dataDefinitionIgnoredInTransactions", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getProcedures") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getProcedures", catalog, schemaPattern, procedureNamePattern);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_PROCEDURES");
            ics._setString(1, catalog);
            ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
            ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(procedureNamePattern));
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getProcedureColumns") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getProcedureColumns", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_PROCEDURE_COLUMNS");
            ics._setString(1, catalog);
            ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
            ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(procedureNamePattern));
            ics._setString(4, DatabaseMetaDataSapDB._replaceForSystemQuery(columnNamePattern));
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTables") : null;
        try {
            int i;
            if (on) {
                this._tracer.printCall(this, "getTables", catalog, schemaPattern, tableNamePattern, types);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_TABLES");
            ics._setString(1, catalog);
            ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
            ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(tableNamePattern));
            int paramCnt = ics._getParameterMetaData().getParameterCount();
            if (types == null) {
                i = 4;
                if (this._tableTypes == null) {
                    this._initTableTypes();
                }
                if (paramCnt >= this._tableTypes.length) {
                    for (int j = 0; j < this._tableTypes.length; ++j) {
                        ics._setString(j + i, this._tableTypes[j]);
                    }
                    i += this._tableTypes.length;
                } else {
                    ics._setString(4, "VIEW");
                    ics._setString(5, "SYNONYM");
                    ics._setString(6, "TABLE");
                    ics._setString(7, "SYSTEM TABLE");
                    ics._setString(8, "GLOBAL TEMPORARY");
                    ics._setString(9, "SHARED TEMPORARY");
                    i = 10;
                    if (paramCnt >= 11) {
                        ics._setString(10, "USER DEFINED");
                        ics._setString(11, "COLUMN VIEW");
                        i = 12;
                    }
                    if (paramCnt >= 15) {
                        ics._setString(12, "OLAP VIEW");
                        ics._setString(13, "JOIN VIEW");
                        ics._setString(14, "HIERARCHY VIEW");
                        ics._setString(15, "CALC VIEW");
                        i = 16;
                    }
                }
                while (i <= paramCnt) {
                    ics._setNull(i);
                    ++i;
                }
            } else {
                for (i = 0; i < types.length; ++i) {
                    if (types[i] != null) {
                        types[i] = types[i].toUpperCase(Locale.ENGLISH);
                    }
                    ics._setString(i + 4, types[i]);
                }
                for (int j = i + 4; j <= paramCnt; ++j) {
                    ics._setNull(j);
                }
            }
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSchemas") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSchemas", new Object[0]);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_SCHEMAS");
            ics._setString(1, null);
            ics._setString(2, "%");
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getCatalogs") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getCatalogs", new Object[0]);
            }
            this._connection._assertOpen();
            InternalPreparedStatementSapDB ips = this._newPreparedStatement("SELECT CAST( NULL AS NVARCHAR ) AS TABLE_CAT FROM SYS.DUMMY WHERE 1 <> 1");
            ResultSet result = ips._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTableTypes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTableTypes", new Object[0]);
            }
            ResultSet result = this._getTableTypes(false);
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getColumns") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_COLUMNS");
            ics._setString(1, catalog);
            ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
            ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(tableNamePattern));
            ics._setString(4, DatabaseMetaDataSapDB._replaceForSystemQuery(columnNamePattern));
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getColumnPrivileges") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getColumnPrivileges", catalog, schema, table, columnNamePattern);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_COLUMN_PRIVILEGES");
            ics._setString(1, catalog);
            ics._setString(2, schema);
            ics._setString(3, table);
            ics._setString(4, DatabaseMetaDataSapDB._replaceForSystemQuery(columnNamePattern));
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTablePrivileges") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTablePrivileges", catalog, schemaPattern, tableNamePattern);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_TABLE_PRIVILEGES");
            ics._setString(1, catalog);
            ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
            ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(tableNamePattern));
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getBestRowIdentifier") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBestRowIdentifier", catalog, schema, table, scope, nullable);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_BEST_ROW_IDENTIFIER");
            ics._setString(1, catalog);
            ics._setString(2, schema);
            ics._setString(3, table);
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getVersionColumns") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getVersionColumns", catalog, schema, table);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_VERSION_COLUMNS");
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getPrimaryKeys") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getPrimaryKeys", catalog, schema, table);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_PRIMARY_KEYS");
            ics._setString(1, catalog);
            ics._setString(2, schema);
            ics._setString(3, table);
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getImportedKeys") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getImportedKeys", catalog, schema, table);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_IMPORTED_KEYS_NEW");
            ics._setString(1, catalog);
            ics._setString(2, schema);
            ics._setString(3, table);
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getExportedKeys") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getExportedKeys", catalog, schema, table);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_EXPORTED_KEYS_NEW");
            ics._setString(1, catalog);
            ics._setString(2, schema);
            ics._setString(3, table);
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getCrossReference") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getCrossReference", parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_CROSS_REFERENCE_NEW");
            ics._setString(1, parentCatalog);
            ics._setString(2, parentSchema);
            ics._setString(3, parentTable);
            ics._setString(4, foreignCatalog);
            ics._setString(5, foreignSchema);
            ics._setString(6, foreignTable);
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getTypeInfo") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTypeInfo", new Object[0]);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_TYPE_INFO");
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getIndexInfo") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getIndexInfo", catalog, schema, table, unique, approximate);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_INDEX_INFO");
            ics._setString(1, catalog);
            ics._setString(2, schema);
            ics._setString(3, table);
            ics._setBoolean(4, unique);
            ics._setBoolean(5, approximate);
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsResultSetType") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsResultSetType", type);
            }
            switch (type) {
                case 1003: {
                    result = true;
                    break;
                }
                case 1004: 
                case 1005: {
                    result = false;
                    break;
                }
                default: {
                    throw new SQLException("Unexpected result set type: " + type);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsResultSetConcurrency") : null;
        try {
            boolean result;
            block15: {
                block14: {
                    if (on) {
                        this._tracer.printCall(this, "supportsResultSetConcurrency", type, concurrency);
                    }
                    if (type != 1003) break block14;
                    switch (concurrency) {
                        case 1007: {
                            result = true;
                            break block15;
                        }
                        case 1008: {
                            result = false;
                            break block15;
                        }
                        default: {
                            throw new SQLException("Unexpected concurrency type: " + concurrency);
                        }
                    }
                }
                result = false;
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("ownUpdatesAreVisible") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "ownUpdatesAreVisible", type);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("ownDeletesAreVisible") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "ownDeletesAreVisible", type);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("ownInsertsAreVisible") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "ownInsertsAreVisible", type);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("othersUpdatesAreVisible") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "othersUpdatesAreVisible", type);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("othersDeletesAreVisible") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "othersDeletesAreVisible", type);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("othersInsertsAreVisible") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "othersInsertsAreVisible", type);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("updatesAreDetected") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "updatesAreDetected", type);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("deletesAreDetected") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "deletesAreDetected", type);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("insertsAreDetected") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "insertsAreDetected", type);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsBatchUpdates") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsBatchUpdates", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getUDTs") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getUDTs", catalog, schemaPattern, typeNamePattern, types);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_UDTS");
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getConnection") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getConnection", new Object[0]);
            }
            ConnectionSapDB result = this._connection;
            if (on) {
                this._tracer.printResult(result);
            }
            ConnectionSapDB connectionSapDB = result;
            return connectionSapDB;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSavepoints() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsSavepoints") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsSavepoints", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsNamedParameters() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsNamedParameters") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsNamedParameters", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsMultipleOpenResults") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsMultipleOpenResults", new Object[0]);
            }
            boolean result = true;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsGetGeneratedKeys") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsGetGeneratedKeys", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSuperTypes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSuperTypes", catalog, schemaPattern, typeNamePattern);
            }
            this._connection._assertOpen();
            InternalPreparedStatementSapDB ips = this._newPreparedStatement("SELECT CAST( NULL AS NVARCHAR ) AS TYPE_CAT, CAST( NULL AS NVARCHAR ) AS TYPE_SCHEM, CAST( NULL AS NVARCHAR ) AS TYPE_NAME, CAST( NULL AS NVARCHAR ) AS SUPERTYPE_CAT, CAST( NULL AS NVARCHAR ) AS SUPERTYPE_SCHEM, CAST( NULL AS NVARCHAR ) AS SUPERTYPE_NAME FROM SYS.DUMMY WHERE 1 <> 1");
            ResultSet result = ips._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSuperTables") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSuperTables", catalog, schemaPattern, tableNamePattern);
            }
            this._connection._assertOpen();
            InternalPreparedStatementSapDB ips = this._newPreparedStatement("SELECT CAST( NULL AS NVARCHAR ) AS TABLE_CAT, CAST( NULL AS NVARCHAR ) AS TABLE_SCHEM, CAST( NULL AS NVARCHAR ) AS TABLE_NAME, CAST( NULL AS NVARCHAR ) AS SUPERTABLE_NAME FROM SYS.DUMMY WHERE 1 <> 1");
            ResultSet result = ips._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getAttributes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getAttributes", catalog, schemaPattern, typeNamePattern, attributeNamePattern);
            }
            this._connection._assertOpen();
            InternalPreparedStatementSapDB ips = this._newPreparedStatement("SELECT CAST( NULL AS NVARCHAR ) AS TYPE_CAT, CAST( NULL AS NVARCHAR ) AS TYPE_SCHEM, CAST( NULL AS NVARCHAR ) AS TYPE_NAME, CAST( NULL AS NVARCHAR ) AS ATTR_NAME, CAST( NULL AS INTEGER ) AS DATA_TYPE, CAST( NULL AS NVARCHAR ) AS ATTR_TYPE_NAME, CAST( NULL AS INTEGER ) AS ATTR_SIZE, CAST( NULL AS INTEGER ) AS DECIMAL_DIGITS, CAST( NULL AS INTEGER ) AS NUM_PREC_RADIX, CAST( NULL AS INTEGER ) AS NULLABLE, CAST( NULL AS NVARCHAR ) AS REMARKS, CAST( NULL AS NVARCHAR ) AS ATTR_DEF, CAST( NULL AS INTEGER ) AS SQL_DATA_TYPE, CAST( NULL AS INTEGER ) AS SQL_DATETIME_SUB, CAST( NULL AS INTEGER ) AS CHAR_OCTET_LENGTH, CAST( NULL AS INTEGER ) AS ORDINAL_POSITION, CAST( NULL AS VARCHAR ) AS IS_NULLABLE, CAST( NULL AS NVARCHAR ) AS SCOPE_CATALOG, CAST( NULL AS NVARCHAR ) AS SCOPE_SCHEMA, CAST( NULL AS NVARCHAR ) AS SCOPE_TABLE, CAST( NULL AS SMALLINT ) AS SOURCE_DATA_TYPE FROM SYS.DUMMY WHERE 1 <> 1");
            ResultSet result = ips._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsResultSetHoldability") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsResultSetHoldability", holdability);
            }
            switch (holdability) {
                case 1: 
                case 2: {
                    result = true;
                    break;
                }
                default: {
                    throw new SQLException("Unexpected result set holdability: " + holdability);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetHoldability() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getResultSetHoldability") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getResultSetHoldability", new Object[0]);
            }
            int result = 1;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getDatabaseMajorVersion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDatabaseMajorVersion") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDatabaseMajorVersion", new Object[0]);
            }
            int result = this._dbVersionInfo.getMajorVersion();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getDatabaseMinorVersion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getDatabaseMinorVersion") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDatabaseMinorVersion", new Object[0]);
            }
            int result = this._dbVersionInfo.getMinorVersion();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getJDBCMajorVersion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getJDBCMajorVersion") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getJDBCMajorVersion", new Object[0]);
            }
            int result = 4;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getJDBCMinorVersion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getJDBCMinorVersion") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getJDBCMinorVersion", new Object[0]);
            }
            int result = 2;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSQLStateType() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSQLStateType") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSQLStateType", new Object[0]);
            }
            int result = 2;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("locatorsUpdateCopy") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "locatorsUpdateCopy", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsStatementPooling() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsStatementPooling") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsStatementPooling", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getRowIdLifetime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getRowIdLifetime", new Object[0]);
            }
            RowIdLifetime result = RowIdLifetime.ROWID_UNSUPPORTED;
            if (on) {
                this._tracer.printResult((Object)result);
            }
            RowIdLifetime rowIdLifetime = result;
            return rowIdLifetime;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getSchemas") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getSchemas", catalog, schemaPattern);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_SCHEMAS");
            ics._setString(1, catalog);
            ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsStoredFunctionsUsingCallSyntax") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsStoredFunctionsUsingCallSyntax", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("autoCommitFailureClosesAllResultSets") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "autoCommitFailureClosesAllResultSets", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getClientInfoProperties") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getClientInfoProperties", new Object[0]);
            }
            this._connection._assertOpen();
            InternalPreparedStatementSapDB ips = this._newPreparedStatement("SELECT CAST( NULL AS VARCHAR ) AS NAME, CAST( NULL AS INTEGER ) AS MAX_LEN, CAST( NULL AS NVARCHAR ) AS DEFAULT_VALUE, CAST( NULL AS NVARCHAR ) AS DESCRIPTION FROM SYS.DUMMY WHERE 1 <> 1");
            ResultSet result = ips._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getFunctions") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFunctions", catalog, schemaPattern, functionNamePattern);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_FUNCTIONS");
            ics._setString(1, catalog);
            ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
            ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(functionNamePattern));
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getFunctionColumns") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFunctionColumns", catalog, schemaPattern, functionNamePattern, columnNamePattern);
            }
            this._connection._assertOpen();
            InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_FUNCTION_COLUMNS");
            ics._setString(1, catalog);
            ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
            ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(functionNamePattern));
            ics._setString(4, DatabaseMetaDataSapDB._replaceForSystemQuery(columnNamePattern));
            ResultSet result = ics._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getPseudoColumns") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getPseudoColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            this._connection._assertOpen();
            InternalPreparedStatementSapDB ips = this._newPreparedStatement("SELECT CAST( NULL AS NVARCHAR ) AS TABLE_CAT, CAST( NULL AS NVARCHAR ) AS TABLE_SCHEM, CAST( NULL AS NVARCHAR ) AS TABLE_NAME, CAST( NULL AS NVARCHAR ) AS COLUMN_NAME, CAST( NULL AS INTEGER ) AS DATA_TYPE, CAST( NULL AS INTEGER ) AS COLUMN_SIZE, CAST( NULL AS INTEGER ) AS DECIMAL_DIGITS, CAST( NULL AS INTEGER ) AS NUM_PREC_RADIX, CAST( NULL AS VARCHAR ) AS COLUMN_USAGE, CAST( NULL AS NVARCHAR ) AS REMARKS, CAST( NULL AS INTEGER ) AS CHAR_OCTET_LENGTH, CAST( NULL AS VARCHAR ) AS IS_NULLABLE FROM SYS.DUMMY WHERE 1 <> 1");
            ResultSet result = ips._executeQuery();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("generatedKeyAlwaysReturned") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "generatedKeyAlwaysReturned", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("getMaxLogicalLobSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxLogicalLobSize", new Object[0]);
            }
            int result = 0;
            if (on) {
                this._tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsRefCursors() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("supportsRefCursors") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsRefCursors", new Object[0]);
            }
            boolean result = false;
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    protected TraceRecord _newTraceRecord(String methodName) {
        return new TraceRecord(this._connection, null, null, "DatabaseMetaData", methodName);
    }

    protected void _publish(TraceRecord r) {
        r.update(this._connection);
        TraceRecordPublisher.getInstance().publish(r);
    }

    protected synchronized String _getUserName() {
        if (this._userName == null) {
            this._getDBInfo();
        }
        return this._userName != null ? this._userName : StringUtils.stripUserName(this._connection.getConnectionProperty(ConnectionProperty.USER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _getDBInfo() {
        InternalStatementSapDB is = null;
        InternalResultSetSapDB irs = null;
        try {
            is = InternalStatementSapDB.newInstance(this._connection, true, true);
            irs = (InternalResultSetSapDB)is._executeQuery("SELECT VERSION, CURRENT_USER FROM SYS.M_DATABASE");
            if (irs != null && irs._next()) {
                this._dbVersionInfo = new VersionInfo(irs._getString(1));
                this._userName = irs._getString(2);
            }
        }
        catch (SQLException e) {
            this._userName = null;
        }
        finally {
            if (this._dbVersionInfo == null) {
                this._dbVersionInfo = new VersionInfo();
            }
            if (irs != null) {
                try {
                    irs._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
            if (is != null) {
                try {
                    is._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static String _replaceForSystemQuery(String src) {
        return src == null ? "%" : src;
    }

    private InternalPreparedStatementSapDB _newPreparedStatement(String sql) throws SQLException {
        return InternalPreparedStatementSapDB.newInstance(this._connection, sql, true, false);
    }

    private InternalCallableStatementSapDB _newCallableStatement(String sql) throws SQLException {
        return this._newCallableStatement(sql, false);
    }

    private InternalCallableStatementSapDB _newCallableStatement(String sql, boolean createInternalResultSets) throws SQLException {
        return InternalCallableStatementSapDB.newInstance(this._connection, "{CALLQ  " + sql + "}", true, createInternalResultSets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initTableTypes() throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        InternalResultSetSapDB irs = null;
        try {
            irs = (InternalResultSetSapDB)this._getTableTypes(true);
            while (irs._next()) {
                types.add(irs._getString(1));
            }
        }
        finally {
            if (irs != null) {
                try {
                    irs._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
        }
        this._tableTypes = types.toArray(new String[0]);
    }

    private ResultSet _getTableTypes(boolean createInternalResultSets) throws SQLException {
        this._connection._assertOpen();
        InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_TABLE_TYPES", createInternalResultSets);
        return ics._executeQuery();
    }
}

