/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.FetchInfo;
import com.sap.db.jdbc.HanaResultSet;
import com.sap.db.jdbc.HanaResultSetFinalize;
import com.sap.db.jdbc.HanaResultSetPhantom;
import com.sap.db.jdbc.InternalResultSetSapDB;
import com.sap.db.jdbc.InternalStatementSapDB;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.jdbc.packet.HPartInfo;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.HSegmentInfo;
import com.sap.db.jdbc.packet.SQLReplyOptions;
import com.sap.db.jdbc.packet.SQLStatementType;
import com.sap.db.jdbc.packet.StatementContextOption;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbcext.wrapper.CallableStatement;
import com.sap.db.jdbcext.wrapper.PreparedStatement;
import com.sap.db.jdbcext.wrapper.Statement;
import com.sap.db.util.Base64Utils;
import com.sap.db.util.Dbg;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.RsaOaep;
import com.sap.db.util.UUIDUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
public abstract class StatementSapDB
extends WrapperDummy
implements java.sql.Statement {
    public static final int SERVER_PROCESSING_TIME_NOT_AVAILABLE = -1;
    protected final Tracer _tracer;
    protected final ConnectionSapDB _connection;
    protected final int _resultSetType;
    protected final int _resultSetConcurrency;
    protected final int _resultSetHoldability;
    protected final boolean _isMetaDataStatement;
    protected final boolean _createInternalResultSets;
    protected final AtomicBoolean _isPoolable;
    protected final AtomicBoolean _wasCancelled;
    protected final AtomicBoolean _isClosed;
    protected final AtomicBoolean _isClosePending;
    private final Object _lockResultSets = new Object();
    @GuardedBy(value="_lockResultSets")
    private List<ResultSetSapDB> _resultSets;
    @GuardedBy(value="_lockResultSets")
    private ResultSetSapDB _currentResultSet;
    @GuardedBy(value="_lockResultSets")
    private int _currentResultSetIndex;
    @GuardedBy(value="this")
    protected long _serverProcessingTime;
    @GuardedBy(value="this")
    protected int _rowsAffected;
    @GuardedBy(value="this")
    protected boolean _hasRowCount;
    @GuardedBy(value="this")
    protected boolean _hasReturnedRowsAffected;
    @GuardedBy(value="this")
    protected int _queryTimeout;
    @GuardedBy(value="this")
    private int _maxFieldSize;
    @GuardedBy(value="this")
    private int _maxRows;
    @GuardedBy(value="this")
    private int _fetchDirection;
    @GuardedBy(value="this")
    private int _fetchSize;
    @GuardedBy(value="this")
    private String _commandInfoSource;
    @GuardedBy(value="this")
    private int _commandInfoLine;
    @GuardedBy(value="this")
    private List<String> _batchSQL;

    public static StatementSapDB getStatementSapDB(java.sql.Statement statement) {
        java.sql.Statement s = statement;
        while (!(s instanceof StatementSapDB)) {
            if (s instanceof Statement) {
                s = ((Statement)s).getInner();
                continue;
            }
            if (s instanceof PreparedStatement) {
                s = ((PreparedStatement)s).getInner();
                continue;
            }
            if (s instanceof CallableStatement) {
                s = ((CallableStatement)s).getInner();
                continue;
            }
            return null;
        }
        return (StatementSapDB)s;
    }

    protected StatementSapDB(Tracer tracer, ConnectionSapDB connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean isMetaDataStatement, boolean createInternalResultSets, boolean isPoolable) throws SQLException {
        switch (resultSetType) {
            case 1003: {
                break;
            }
            default: {
                throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "resultSetType", "TYPE_FORWARD_ONLY");
            }
        }
        switch (resultSetConcurrency) {
            case 1007: {
                break;
            }
            default: {
                throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "resultSetConcurrency", "CONCUR_READ_ONLY");
            }
        }
        switch (resultSetHoldability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "resultSetHoldability", "CLOSE_CURSORS_AT_COMMIT, HOLD_CURSORS_OVER_COMMIT");
            }
        }
        this._tracer = tracer;
        this._connection = connection;
        this._resultSetType = resultSetType;
        this._resultSetConcurrency = resultSetConcurrency;
        this._resultSetHoldability = resultSetHoldability;
        this._isMetaDataStatement = isMetaDataStatement;
        this._createInternalResultSets = createInternalResultSets;
        this._isPoolable = new AtomicBoolean(isPoolable);
        this._wasCancelled = new AtomicBoolean();
        this._isClosed = new AtomicBoolean();
        this._isClosePending = new AtomicBoolean();
        this._serverProcessingTime = -1L;
        this._rowsAffected = -1;
        this._fetchDirection = 1000;
        this._commandInfoLine = -1;
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeQuery") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeQuery", sql);
            }
            ResultSet result = this._executeQuery(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeUpdate", sql);
            }
            int result = this._executeUpdate(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "close") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "close", new Object[0]);
            }
            this._close(true, this._connection.getBooleanConnectionProperty(ConnectionProperty.TRANSACTIONAL_LOBS));
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getMaxFieldSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxFieldSize", new Object[0]);
            }
            int result = this._maxFieldSize;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setMaxFieldSize(int maxFieldSize) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setMaxFieldSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setMaxFieldSize", maxFieldSize);
            }
            if (maxFieldSize < 0) {
                throw SQLExceptionSapDB.newInstance("error.invalid.maxfieldsize", String.valueOf(maxFieldSize));
            }
            this._maxFieldSize = maxFieldSize;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getMaxRows() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getMaxRows") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMaxRows", new Object[0]);
            }
            int result = this._maxRows;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setMaxRows(int maxRows) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setMaxRows") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setMaxRows", maxRows);
            }
            if (maxRows < 0) {
                throw SQLExceptionSapDB.newInstance("error.invalid.maxrows", String.valueOf(maxRows));
            }
            this._maxRows = maxRows;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setEscapeProcessing") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setEscapeProcessing", enable);
            }
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getQueryTimeout") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getQueryTimeout", new Object[0]);
            }
            int result = this._queryTimeout;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setQueryTimeout(int queryTimeout) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setQueryTimeout") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setQueryTimeout", queryTimeout);
            }
            if (queryTimeout < 0) {
                throw SQLExceptionSapDB.newInstance("error.invalid.querytimeout", String.valueOf(queryTimeout));
            }
            this._queryTimeout = queryTimeout;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public void cancel() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "cancel") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "cancel", new Object[0]);
            }
            this._cancel();
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getWarnings", new Object[0]);
            }
            SQLWarning result = null;
            if (on) {
                this._tracer.printResult(result);
            }
            SQLWarning sQLWarning = result;
            return sQLWarning;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearWarnings() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "clearWarnings") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearWarnings", new Object[0]);
            }
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setCursorName(String cursorName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setCursorName") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCursorName", cursorName);
            }
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "execute") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "execute", sql);
            }
            boolean result = this._execute(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getResultSet") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getResultSet", new Object[0]);
            }
            ResultSetSapDB result = this._getCurrentResultSet();
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSetSapDB resultSetSapDB = result;
            return resultSetSapDB;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getUpdateCount") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getUpdateCount", new Object[0]);
            }
            int result = this._getUpdateCount();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getMoreResults") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMoreResults", new Object[0]);
            }
            boolean result = this._getMoreResults(3);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getFetchDirection() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getFetchDirection") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFetchDirection", new Object[0]);
            }
            int result = this._fetchDirection;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void setFetchDirection(int fetchDirection) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setFetchDirection") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFetchDirection", fetchDirection);
            }
            switch (fetchDirection) {
                case 1000: 
                case 1001: 
                case 1002: {
                    this._fetchDirection = fetchDirection;
                    return;
                }
                default: {
                    throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "direction", "FETCH_FORWARD, FETCH_REVERSE, FETCH_UNKNOWN");
                }
            }
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (!pon) throw e;
            r.setException(e);
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getFetchSize() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getFetchSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFetchSize", new Object[0]);
            }
            int result = this._fetchSize;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setFetchSize(int fetchSize) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setFetchSize") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFetchSize", fetchSize);
            }
            if (fetchSize < 0) {
                throw SQLExceptionSapDB.newInstance("error.invalid.fetchsize", String.valueOf(fetchSize));
            }
            this._fetchSize = fetchSize;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getResultSetConcurrency() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getResultSetConcurrency") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getResultSetConcurrency", new Object[0]);
            }
            int result = this._resultSetConcurrency;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getResultSetType() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getResultSetType") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getResultSetType", new Object[0]);
            }
            int result = this._resultSetType;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "addBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "addBatch", sql);
            }
            if (this._batchSQL == null) {
                this._batchSQL = new ArrayList<String>();
            }
            this._batchSQL.add(sql);
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "clearBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "clearBatch", new Object[0]);
            }
            if (this._batchSQL != null) {
                this._batchSQL.clear();
            }
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeBatch") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeBatch", new Object[0]);
            }
            int[] result = this._executeBatch();
            if (on) {
                this._tracer.printResult(result);
            }
            int[] nArray = result;
            return nArray;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Connection getConnection() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getConnection") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getConnection", new Object[0]);
            }
            ConnectionSapDB result = this._connection;
            if (on) {
                this._tracer.printResult(result);
            }
            ConnectionSapDB connectionSapDB = result;
            return connectionSapDB;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getMoreResults") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getMoreResults", current);
            }
            boolean result = this._getMoreResults(current);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getGeneratedKeys") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getGeneratedKeys", new Object[0]);
                }
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeUpdate", sql, autoGeneratedKeys);
            }
            if (autoGeneratedKeys == 1) {
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            int result = this._executeUpdate(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeUpdate", sql, columnIndexes);
            }
            if (columnIndexes.length > 0) {
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            int result = this._executeUpdate(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeUpdate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "executeUpdate", sql, columnNames);
            }
            if (columnNames.length > 0) {
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            int result = this._executeUpdate(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "execute") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "execute", sql, autoGeneratedKeys);
            }
            if (autoGeneratedKeys == 1) {
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            boolean result = this._execute(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "execute") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "execute", sql, columnIndexes);
            }
            if (columnIndexes.length > 0) {
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            boolean result = this._execute(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "execute") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "execute", sql, columnNames);
            }
            if (columnNames.length > 0) {
                throw StatementSapDB._getAutoGeneratedKeysNotSupportedException();
            }
            boolean result = this._execute(sql);
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getResultSetHoldability") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getResultSetHoldability", new Object[0]);
            }
            int result = this._resultSetHoldability;
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isClosed() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "isClosed") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isClosed", new Object[0]);
            }
            boolean bl = result = this._isClosed() || this._isClosePending();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isPoolable() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "isPoolable") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "isPoolable", new Object[0]);
            }
            boolean result = this._isPoolable.get();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setPoolable(boolean isPoolable) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setPoolable") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setPoolable", isPoolable);
            }
            this._setPoolable(isPoolable);
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean isCloseOnCompletion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "isCloseOnCompletion") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "isCloseOnCompletion", new Object[0]);
                }
                throw StatementSapDB._getUnsupportedMethodException("isCloseOnCompletion()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void closeOnCompletion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "closeOnCompletion") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "closeOnCompletion", new Object[0]);
                }
                throw StatementSapDB._getUnsupportedMethodException("closeOnCompletion()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getLargeUpdateCount") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getLargeUpdateCount", new Object[0]);
                }
                throw StatementSapDB._getUnsupportedMethodException("getLargeUpdateCount()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "getLargeMaxRows") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getLargeMaxRows", new Object[0]);
                }
                throw StatementSapDB._getUnsupportedMethodException("getLargeMaxRows()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setLargeMaxRows(long max) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "setLargeMaxRows") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setLargeMaxRows", max);
                }
                throw StatementSapDB._getUnsupportedMethodException("setLargeMaxRows( long )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeBatch") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeBatch", new Object[0]);
                }
                throw StatementSapDB._getUnsupportedMethodException("executeLargeBatch()");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql);
                }
                throw StatementSapDB._getUnsupportedMethodException("executeLargeUpdate( String )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, autoGeneratedKeys);
                }
                throw StatementSapDB._getUnsupportedMethodException("executeLargeUpdate( String, int )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, columnIndexes);
                }
                throw StatementSapDB._getUnsupportedMethodException("executeLargeUpdate( String, int[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("Statement", "executeLargeUpdate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "executeLargeUpdate", sql, columnNames);
                }
                throw StatementSapDB._getUnsupportedMethodException("executeLargeUpdate( String, String[] )");
            }
            catch (SQLException e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    public String toString() {
        String s = super.toString();
        if (this._isClosePending()) {
            return s + "[close pending]";
        }
        if (this._isClosed()) {
            return s + "[closed]";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getServerProcessingTime() throws SQLException {
        StatementSapDB statementSapDB = this;
        synchronized (statementSapDB) {
            return this._serverProcessingTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommandInfo(String source, int line) throws SQLException {
        StatementSapDB statementSapDB = this;
        synchronized (statementSapDB) {
            this._commandInfoSource = source;
            this._commandInfoLine = line;
        }
    }

    protected static SQLException _getUnsupportedMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, "Statement");
    }

    protected static SQLException _getAutoGeneratedKeysNotSupportedException() {
        return SQLExceptionSapDB.newInstance("error.autogenkeys.retrieval.unsupported", new String[0]);
    }

    protected TraceRecord _newTraceRecord(String className, String methodName) {
        return new TraceRecord(this._connection, this, null, className, methodName);
    }

    protected void _publish(TraceRecord r) {
        r.update(this._connection);
        TraceRecordPublisher.getInstance().publish(r);
    }

    protected void _checkLocks() {
        if (this instanceof InternalStatementSapDB) {
            return;
        }
        if (Thread.holdsLock(this)) {
            return;
        }
        if (Thread.holdsLock(this._connection)) {
            Dbg.println("StatementSapDB: Attempting to lock statement when connection is already locked");
        }
    }

    protected void _assertOpen() throws SQLException {
        if (this._isClosed() || this._isClosePending() || this._connection._isClosed()) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }

    protected int _getResultSetHoldability() {
        return this._resultSetHoldability;
    }

    protected boolean _isMetaDataStatement() {
        return this._isMetaDataStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _getMaxRows() {
        StatementSapDB statementSapDB = this;
        synchronized (statementSapDB) {
            return this._maxRows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _getFetchSize() {
        StatementSapDB statementSapDB = this;
        synchronized (statementSapDB) {
            return this._fetchSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSetSapDB _getCurrentResultSet() {
        Object object = this._lockResultSets;
        synchronized (object) {
            return this._currentResultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet _executeQuery(String sql) throws SQLException {
        this._execute(sql);
        Object object = this._lockResultSets;
        synchronized (object) {
            if (this._currentResultSet == null) {
                throw SQLExceptionSapDB.newInstance("error.sqlstatement.noresultset", new String[0]);
            }
            return this._currentResultSet;
        }
    }

    protected int _executeUpdate(String sql) throws SQLException {
        boolean isQuery = this._execute(sql);
        if (isQuery) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.resultset", new String[0]);
        }
        return this._hasRowCount ? this._rowsAffected : 0;
    }

    protected boolean _execute(String sql) throws SQLException {
        Session session = this._getPrimarySession();
        return this._execute(sql, session);
    }

    protected boolean _execute(String sql, Session session) throws SQLException {
        boolean isQuery;
        this._assertOpen();
        if (sql == null || sql.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.null", new String[0]);
        }
        try {
            this._closeResultSets(true, this._connection.getBooleanConnectionProperty(ConnectionProperty.TRANSACTIONAL_LOBS));
            HReplyPacket replyPacket = this._executeDirect(sql, session);
            isQuery = this._parseResult(session, replyPacket, new ArrayList<AbstractConverter>(), true);
        }
        catch (InternalReconnectException e) {
            session = e.getNewSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
            }
            this._connection.handleTransaction(session, true);
            isQuery = this._execute(sql, session);
        }
        return isQuery;
    }

    protected HReplyPacket _executeDirect(String sql, Session session) throws SQLException {
        HRequestPacket requestPacket = this._connection.initExecuteDirect(session, this._resultSetHoldability, this._queryTimeout, sql, this._commandInfoSource, this._commandInfoLine, false);
        HReplyPacket replyPacket = this._connection.exchange(session, requestPacket, this, ConnectionSapDB.ExchangeFlag.IS_STATEMENT, ConnectionSapDB.ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
        return replyPacket;
    }

    protected int _executeUpdateOnAllSessions(String sql) throws SQLException {
        SessionPool sessionPool = this._connection.getSessionPool();
        Session primarySession = sessionPool.getPrimarySession();
        boolean isQuery = false;
        this._connection.handleTransaction(primarySession, true);
        if (!primarySession.isHintRouted()) {
            isQuery = this._execute(sql, primarySession);
        }
        for (Session session : sessionPool.getSessions().values()) {
            if (session == primarySession || !session.isConnected() || session.isHintRouted()) continue;
            this._connection.handleTransaction(session, true);
            isQuery = this._execute(sql, session);
        }
        if (isQuery) {
            throw SQLExceptionSapDB.newInstance("error.sqlstatement.resultset", new String[0]);
        }
        return this._hasRowCount ? this._rowsAffected : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _parseResult(Session session, HReplyPacket replyPacket, List<AbstractConverter> converters, boolean resetRowCount) throws SQLException {
        FunctionCode functionCode = replyPacket.getFunctionCode(0);
        boolean isQuery = false;
        CursorID cursorID = null;
        boolean rowNotFound = false;
        HDataPart dataPart = null;
        this._serverProcessingTime = -1L;
        if (resetRowCount) {
            this._rowsAffected = -1;
            this._hasRowCount = false;
            this._hasReturnedRowsAffected = false;
        }
        switch (functionCode) {
            case Select: 
            case SelectForUpdate: 
            case DBProcedureCallWithResultSet: {
                isQuery = true;
            }
        }
        for (HPartInfo partInfo : replyPacket.parts(0)) {
            switch (partInfo.getPartKind()) {
                case RowsAffected: {
                    this._rowsAffected = partInfo.getRowsAffected();
                    this._hasRowCount = true;
                    this._hasReturnedRowsAffected = false;
                    break;
                }
                case StatementContext: {
                    HOptionsPart statementContextPart = partInfo.getOptionsPart();
                    do {
                        switch (StatementContextOption.decode(statementContextPart.getOptionName())) {
                            case ServerProcessingTime: {
                                this._serverProcessingTime = statementContextPart.getOptionLongValue();
                            }
                        }
                    } while (statementContextPart.nextOption());
                    break;
                }
                case ResultSet: {
                    dataPart = partInfo.getResultSetPart();
                    if (dataPart.isRowNotFound()) {
                        rowNotFound = true;
                    }
                    if (!isQuery || converters.size() <= 0 || cursorID == null) break;
                    if (dataPart == null) {
                        dataPart = HDataPart.createEmptyPart();
                    }
                    this._createResultSet(session, cursorID, converters, rowNotFound, dataPart);
                    cursorID = null;
                    converters = new ArrayList<AbstractConverter>();
                    dataPart = null;
                    rowNotFound = false;
                    break;
                }
                case ResultSetID: {
                    if (isQuery && converters.size() > 0 && cursorID != null) {
                        if (dataPart == null) {
                            dataPart = HDataPart.createEmptyPart();
                        }
                        this._createResultSet(session, cursorID, converters, rowNotFound, dataPart);
                        converters = new ArrayList<AbstractConverter>();
                        rowNotFound = false;
                        dataPart = null;
                    }
                    cursorID = new CursorID(partInfo.getCursorID());
                    break;
                }
                case ResultSetMetaData: {
                    if (isQuery && converters.size() > 0 && cursorID != null) {
                        if (dataPart == null) {
                            dataPart = HDataPart.createEmptyPart();
                        }
                        this._createResultSet(session, cursorID, converters, rowNotFound, dataPart);
                        cursorID = null;
                        converters = new ArrayList<AbstractConverter>();
                        rowNotFound = false;
                        dataPart = null;
                    }
                    partInfo.getResultSetMetaData(this._connection, converters);
                    break;
                }
                case SQLReplyOptions: {
                    this._handleSqlReplyOptions(partInfo.getMultiLineOptionsPart());
                }
            }
        }
        if (isQuery && converters.size() > 0 && cursorID != null) {
            if (dataPart == null) {
                dataPart = HDataPart.createEmptyPart();
            }
            this._createResultSet(session, cursorID, converters, rowNotFound, dataPart);
        }
        Object object = this._lockResultSets;
        synchronized (object) {
            if (isQuery && this._resultSets != null && !this._resultSets.isEmpty()) {
                this._currentResultSet = this._resultSets.get(0);
            }
        }
        return isQuery;
    }

    protected ParseInfo _getParseInfo() {
        return null;
    }

    protected void _setPoolable(boolean isPoolable) throws SQLException {
        this._isPoolable.set(isPoolable);
    }

    protected boolean _isClosePending() {
        return this._isClosePending.get();
    }

    protected boolean _isClosed() {
        return this._isClosed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _close(boolean sendRequests, boolean allowClosePending) throws SQLException {
        if (this._isClosed()) {
            return;
        }
        this._closeResultSets(sendRequests, allowClosePending);
        if (allowClosePending && this._shouldClosePending()) {
            if (this._isClosePending()) {
                return;
            }
            this._connection._removeStatement(this);
            this._isClosePending.set(true);
            this._connection._addPreparedStatementClosePending((PreparedStatementSapDB)this);
            return;
        }
        boolean wasClosePending = this._isClosePending();
        try {
            ConnectionSapDB connectionSapDB = this._connection;
            synchronized (connectionSapDB) {
                block14: {
                    if (!this._isClosed() && !this._connection._isClosed()) break block14;
                    return;
                }
                if (sendRequests) {
                    this._clean();
                }
                this._isClosed.set(true);
                this._isClosePending.set(false);
            }
        }
        finally {
            if (wasClosePending) {
                this._connection._removePreparedStatementClosePending((PreparedStatementSapDB)this);
            } else {
                this._connection._removeStatement(this);
            }
        }
    }

    protected boolean _shouldClosePending() {
        return false;
    }

    protected void _clean() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addResultSet(ResultSetSapDB resultSet) {
        Object object = this._lockResultSets;
        synchronized (object) {
            if (this._resultSets == null) {
                this._resultSets = new ArrayList<ResultSetSapDB>();
            }
            this._resultSets.add(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeResultSet(ResultSetSapDB resultSet) {
        Object object = this._lockResultSets;
        synchronized (object) {
            if (this._resultSets == null) {
                return;
            }
            this._resultSets.remove(resultSet);
        }
    }

    protected void _closeResultSets(boolean sendRequests, boolean allowClosePending) throws SQLException {
        this._closeResultSets(sendRequests, allowClosePending, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closeResultSets(boolean sendRequests, boolean allowClosePending, int lastIdx) throws SQLException {
        int n;
        ArrayList<ResultSetSapDB> resultSets;
        Object object = this._lockResultSets;
        synchronized (object) {
            if (this._resultSets == null) {
                return;
            }
            resultSets = new ArrayList<ResultSetSapDB>(this._resultSets);
            if (lastIdx == -1) {
                this._resultSets = null;
                this._currentResultSet = null;
                this._currentResultSetIndex = 0;
            }
        }
        for (int i = n = lastIdx == -1 ? resultSets.size() - 1 : lastIdx; i >= 0; --i) {
            ResultSetSapDB resultSet = (ResultSetSapDB)resultSets.get(i);
            resultSet._close(sendRequests, allowClosePending);
        }
    }

    private Session _getPrimarySession() throws SQLException {
        Session session = this._connection.getSessionPool().getPrimarySession();
        this._connection.handleTransaction(session, true);
        return session;
    }

    private void _cancel() throws SQLException {
        this._wasCancelled.set(true);
        this._connection._cancel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _getMoreResults(int current) throws SQLException {
        boolean ret;
        int currentResultSetIndex;
        ResultSetSapDB currentResultSet;
        ArrayList<ResultSetSapDB> resultSets;
        this._assertOpen();
        Object object = this._lockResultSets;
        synchronized (object) {
            if (this._resultSets == null || this._currentResultSet == null) {
                return false;
            }
            resultSets = new ArrayList<ResultSetSapDB>(this._resultSets);
            currentResultSet = this._currentResultSet;
            currentResultSetIndex = this._currentResultSetIndex;
        }
        switch (current) {
            case 1: {
                currentResultSet._close(true, this._connection.getBooleanConnectionProperty(ConnectionProperty.TRANSACTIONAL_LOBS));
                break;
            }
            case 2: {
                if (!resultSets.contains(currentResultSet)) break;
                ++currentResultSetIndex;
                break;
            }
            case 3: {
                if (!resultSets.contains(currentResultSet)) break;
                this._closeResultSets(true, this._connection.getBooleanConnectionProperty(ConnectionProperty.TRANSACTIONAL_LOBS), currentResultSetIndex);
                break;
            }
            default: {
                throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue.wexample", "getMoreResults", "Statement.CLOSE_CURRENT_RESULT, Statement.KEEP_CURRENT_RESULT, or Statement.CLOSE_ALL_RESULTS");
            }
        }
        object = this._lockResultSets;
        synchronized (object) {
            this._currentResultSetIndex = currentResultSetIndex;
            if (this._currentResultSetIndex < this._resultSets.size()) {
                this._currentResultSet = this._resultSets.get(this._currentResultSetIndex);
                ret = true;
            } else {
                this._currentResultSet = null;
                ret = false;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _getUpdateCount() throws SQLException {
        int ret;
        ResultSetSapDB currentResultSet;
        this._assertOpen();
        Object object = this._lockResultSets;
        synchronized (object) {
            currentResultSet = this._currentResultSet;
        }
        if (currentResultSet == null) {
            if (this._hasRowCount && !this._hasReturnedRowsAffected) {
                this._hasReturnedRowsAffected = true;
                ret = this._rowsAffected;
            } else {
                ret = -1;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    private void _createResultSet(Session session, CursorID cursorID, List<AbstractConverter> converters, boolean rowNotFound, HDataPart dataPart) throws SQLException {
        FetchInfo fetchInfo = new FetchInfo(cursorID, converters);
        ParseInfo parseInfo = this._getParseInfo();
        dataPart.setDataFormatDescription(fetchInfo);
        if (parseInfo != null && fetchInfo._hasLOB()) {
            parseInfo.setHasResultSetLOB();
        }
        if (this._createInternalResultSets) {
            InternalResultSetSapDB.newInstance(this._connection, session, this, fetchInfo, rowNotFound, dataPart);
        } else {
            ConnectionProperties connectionProperties = this._connection.getConnectionProperties();
            this._createResultSet(session, fetchInfo, rowNotFound, dataPart, connectionProperties);
        }
    }

    protected void _createResultSet(Session session, FetchInfo fetchInfo, boolean rowNotFound, HDataPart dataPart, ConnectionProperties connectionProperties) throws SQLException {
        if (Driver._createPhantomClass(connectionProperties)) {
            HanaResultSetPhantom.newInstance(this._connection.getTracer(), this._connection, session, this, fetchInfo, rowNotFound, dataPart);
        } else if (Driver._createFinalizerClass(connectionProperties)) {
            HanaResultSetFinalize.newInstance(this._connection.getTracer(), this._connection, session, this, fetchInfo, rowNotFound, dataPart);
        } else {
            HanaResultSet.newInstance(this._connection.getTracer(), this._connection, session, this, fetchInfo, rowNotFound, dataPart);
        }
    }

    private void _handleSqlReplyOptions(HMultiLineOptionsPart sqlReplyOptionsPart) throws SQLException {
        do {
            SQLStatementType stmtType = SQLStatementType.Unknown;
            String cekName = null;
            String cekId = null;
            String algorithmName = null;
            String ckpName = null;
            String ckpId = null;
            String pemEncodedPublicKey = null;
            String preCekId = null;
            String newCekId = null;
            String schemaName = null;
            String tableName = null;
            String columnName = null;
            String hiddenColumnName = null;
            String secondHiddenColumnName = null;
            Boolean isDeterministic = null;
            ArrayList<String> primaryKey = new ArrayList<String>();
            do {
                switch (SQLReplyOptions.decode(sqlReplyOptionsPart.getOptionName())) {
                    case SQLStatementType: {
                        stmtType = SQLStatementType.decode(sqlReplyOptionsPart.getOptionIntValue());
                        break;
                    }
                    case ColumnEncryptionKeyName: {
                        cekName = sqlReplyOptionsPart.getOptionStringValue();
                        cekName = cekName.replaceAll("\"", "\"\"");
                        break;
                    }
                    case ColumnEncryptionKeyID: {
                        cekId = UUIDUtils.newInstance(sqlReplyOptionsPart.getOptionBinaryValue()).toString();
                        break;
                    }
                    case EncryptionAlgorithmName: {
                        algorithmName = sqlReplyOptionsPart.getOptionStringValue();
                        break;
                    }
                    case ClientKeyPairName: {
                        ckpName = sqlReplyOptionsPart.getOptionStringValue();
                        ckpName = ckpName.replaceAll("\"", "\"\"");
                        break;
                    }
                    case ClientKeyPairID: {
                        ckpId = UUIDUtils.newInstance(sqlReplyOptionsPart.getOptionBinaryValue()).toString();
                        break;
                    }
                    case EncodedPublicKeyValue: {
                        pemEncodedPublicKey = sqlReplyOptionsPart.getOptionStringValue();
                        break;
                    }
                    case PreColumnEncryptionKeyID: {
                        preCekId = UUIDUtils.newInstance(sqlReplyOptionsPart.getOptionBinaryValue()).toString();
                        break;
                    }
                    case NewColumnEncryptionKeyID: {
                        newCekId = UUIDUtils.newInstance(sqlReplyOptionsPart.getOptionBinaryValue()).toString();
                        break;
                    }
                    case SchemaName: {
                        schemaName = sqlReplyOptionsPart.getOptionStringValue();
                        schemaName = schemaName.replaceAll("\"", "\"\"");
                        break;
                    }
                    case TableName: {
                        tableName = sqlReplyOptionsPart.getOptionStringValue();
                        tableName = tableName.replaceAll("\"", "\"\"");
                        break;
                    }
                    case ColumnName: {
                        columnName = sqlReplyOptionsPart.getOptionStringValue();
                        columnName = columnName.replaceAll("\"", "\"\"");
                        break;
                    }
                    case HiddenColumnName: {
                        hiddenColumnName = sqlReplyOptionsPart.getOptionStringValue();
                        hiddenColumnName = hiddenColumnName.replaceAll("\"", "\"\"");
                        break;
                    }
                    case SecondHiddenColumnName: {
                        secondHiddenColumnName = sqlReplyOptionsPart.getOptionStringValue();
                        secondHiddenColumnName = secondHiddenColumnName.replaceAll("\"", "\"\"");
                        break;
                    }
                    case EncryptionType: {
                        int encryptionType = sqlReplyOptionsPart.getOptionIntValue();
                        if (encryptionType == 1) {
                            isDeterministic = false;
                            break;
                        }
                        isDeterministic = true;
                        break;
                    }
                    case PrimaryKey: {
                        primaryKey.add(sqlReplyOptionsPart.getOptionStringValue().replaceAll("\"", "\"\""));
                    }
                }
            } while (sqlReplyOptionsPart.nextOption());
            if (stmtType == SQLStatementType.Unknown) {
                throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Statement Type");
            }
            if (stmtType.isForClientSideEncryption() && Driver.getJavaVersion() < 8) {
                throw SQLExceptionSapDB.newInstance("error.jdk8.minimum", new String[0]);
            }
            switch (stmtType) {
                case CEKCreation: {
                    this._checkCkpId(ckpId);
                    this._checkCkpName(ckpName);
                    this._checkCekName(cekName);
                    this._checkSchemaName(schemaName);
                    this._checkAlgorithmName(algorithmName);
                    this._connection._createColumnEncryptionKey(ckpId, ckpName, cekId, cekName, schemaName, algorithmName, false);
                    break;
                }
                case CKPCreation: {
                    this._checkCkpName(ckpName);
                    this._checkAlgorithmName(algorithmName);
                    this._connection._createClientKeyPair(ckpName, algorithmName);
                    break;
                }
                case EmptyCEKPopulating: {
                    this._checkCkpId(ckpId);
                    this._checkCkpName(ckpName);
                    this._checkCekId(cekId);
                    this._checkCekName(cekName);
                    this._checkSchemaName(schemaName);
                    this._checkAlgorithmName(algorithmName);
                    this._connection._createColumnEncryptionKey(ckpId, ckpName, cekId, cekName, schemaName, algorithmName, true);
                    break;
                }
                case AccessCEKGranting: {
                    this._checkCkpName(ckpName);
                    this._checkCekName(cekName);
                    this._checkCekId(cekId);
                    this._checkSchemaName(schemaName);
                    this._checkPemEncodedPublicKey(pemEncodedPublicKey);
                    this._checkAlgorithmName(algorithmName);
                    this._connection._grantAccessColumnEncryptionKey(ckpName, cekId, cekName, schemaName, RsaOaep.generatePublicKeyFromBytes(Base64Utils.decodePublicKey(pemEncodedPublicKey), algorithmName));
                    break;
                }
                case CEKChanging: {
                    this._checkSchemaName(schemaName);
                    this._checkTableName(tableName);
                    this._checkColumnName(columnName);
                    this._checkHiddenColumnName(hiddenColumnName);
                    this._checkHiddenColumnName(secondHiddenColumnName);
                    this._checkPrimaryKey(primaryKey);
                    this._checkCekId(newCekId);
                    this._checkEncryptionType(isDeterministic);
                    ColumnEncryptionKey newCek = this._connection.retrieveColumnEncryptionKey(newCekId);
                    this._connection._transformColumn(schemaName, tableName, columnName, hiddenColumnName, secondHiddenColumnName, primaryKey, newCek, isDeterministic, true, this);
                    break;
                }
                case ColumnEncryption: {
                    this._checkSchemaName(schemaName);
                    this._checkTableName(tableName);
                    this._checkColumnName(columnName);
                    this._checkHiddenColumnName(hiddenColumnName);
                    this._checkHiddenColumnName(secondHiddenColumnName);
                    this._checkPrimaryKey(primaryKey);
                    this._checkCekId(newCekId);
                    this._checkEncryptionType(isDeterministic);
                    ColumnEncryptionKey newCek = this._connection.retrieveColumnEncryptionKey(newCekId);
                    this._connection._transformColumn(schemaName, tableName, columnName, hiddenColumnName, secondHiddenColumnName, primaryKey, newCek, isDeterministic, true, this);
                    break;
                }
                case ColumnUnEncryption: {
                    this._checkSchemaName(schemaName);
                    this._checkTableName(tableName);
                    this._checkColumnName(columnName);
                    this._checkHiddenColumnName(hiddenColumnName);
                    this._checkHiddenColumnName(secondHiddenColumnName);
                    this._checkPrimaryKey(primaryKey);
                    this._checkCekId(preCekId);
                    this._checkEncryptionType(isDeterministic);
                    ColumnEncryptionKey preCek = this._connection.retrieveColumnEncryptionKey(preCekId);
                    this._connection._transformColumn(schemaName, tableName, columnName, hiddenColumnName, secondHiddenColumnName, primaryKey, preCek, isDeterministic, false, this);
                    break;
                }
                case CKPDrop: {
                    this._checkCkpId(ckpId);
                    this._connection._dropClientKeyPair(ckpId);
                    break;
                }
                case CEKDrop: {
                    this._checkCekId(cekId);
                    this._connection._dropColumnEncryptionKey(cekId);
                    break;
                }
                case CEKKeyCopyDrop: {
                    this._checkCekId(cekId);
                    this._connection._dropColumnEncryptionKey(cekId);
                }
            }
        } while (sqlReplyOptionsPart.nextLine());
    }

    private void _checkCkpId(String ckpId) throws SQLException {
        if (ckpId == null || ckpId.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Client key pair ID");
        }
    }

    private void _checkCkpName(String ckpName) throws SQLException {
        if (ckpName == null || ckpName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Client key pair name");
        }
    }

    private void _checkCekId(String cekId) throws SQLException {
        if (cekId == null || cekId.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Column encryption key ID");
        }
    }

    private void _checkCekName(String cekName) throws SQLException {
        if (cekName == null || cekName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Column encryption key name");
        }
    }

    private void _checkAlgorithmName(String algorithmName) throws SQLException {
        if (algorithmName == null || algorithmName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Algorithm name");
        }
    }

    private void _checkPemEncodedPublicKey(String pemEncodedPublicKey) throws SQLException {
        if (pemEncodedPublicKey == null || pemEncodedPublicKey.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "PEM encoded public key");
        }
    }

    private void _checkSchemaName(String schemaName) throws SQLException {
        if (schemaName == null || schemaName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Schema name");
        }
    }

    private void _checkTableName(String tableName) throws SQLException {
        if (tableName == null || tableName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Table name");
        }
    }

    private void _checkColumnName(String columnName) throws SQLException {
        if (columnName == null || columnName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Column name");
        }
    }

    private void _checkHiddenColumnName(String hiddenColumnName) throws SQLException {
        if (hiddenColumnName == null || hiddenColumnName.isEmpty()) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Hidden column name");
        }
    }

    private void _checkPrimaryKey(List<String> primaryKey) throws SQLException {
        if (primaryKey == null || primaryKey.size() == 0) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Primary key");
        }
    }

    private void _checkEncryptionType(Boolean encryptionType) throws SQLException {
        if (encryptionType == null) {
            throw SQLExceptionSapDB.newInstance("error.sqlreply.missinginfo", "Encryption type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] _executeBatch() throws SQLException {
        this._assertOpen();
        this._serverProcessingTime = 0L;
        if (this._batchSQL == null || this._batchSQL.isEmpty()) {
            return new int[0];
        }
        int itemCount = this._batchSQL.size();
        int[] updateCounts = new int[itemCount];
        ArrayList<String> batchSQL = new ArrayList<String>(this._batchSQL);
        Session session = this._getPrimarySession();
        int sendCount = 0;
        int receiveCount = 0;
        try {
            this._batchSQL.clear();
            ConnectionSapDB connectionSapDB = this._connection;
            synchronized (connectionSapDB) {
                while (sendCount < itemCount) {
                    HRequestPacket requestPacket = this._connection.initExecuteDirect(session, this._resultSetHoldability, this._queryTimeout, (String)batchSQL.get(sendCount), null, -1, true);
                    ++sendCount;
                    while (sendCount < itemCount && requestPacket.addExecuteDirectSegment(this._connection, session, this._resultSetHoldability, this._queryTimeout, (String)batchSQL.get(sendCount), null, -1)) {
                        ++sendCount;
                    }
                    requestPacket.close();
                    HReplyPacket replyPacket = this._connection.exchange(session, requestPacket, this, ConnectionSapDB.ExchangeFlag.IGNORE_ERRORS, ConnectionSapDB.ExchangeFlag.ALLOW_RECONNECT_OR_FALLBACK);
                    for (HSegmentInfo segmentInfo : replyPacket.segments()) {
                        SQLException sqlExceptionChain = segmentInfo.findSQLExceptionChain();
                        if (sqlExceptionChain != null) {
                            throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batch.withnumber", String.valueOf(receiveCount + 1), sqlExceptionChain.getMessage()), sqlExceptionChain, Arrays.copyOfRange(updateCounts, 0, receiveCount));
                        }
                        FunctionCode functionCode = segmentInfo.getFunctionCode();
                        if (functionCode == FunctionCode.Select || functionCode == FunctionCode.SelectForUpdate) {
                            updateCounts[receiveCount] = -3;
                            throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset.withnumber", String.valueOf(receiveCount + 1)), "2A000", Arrays.copyOfRange(updateCounts, 0, receiveCount + 1));
                        }
                        int rowsAffected = segmentInfo.findRowsAffected();
                        updateCounts[receiveCount] = rowsAffected != -1 ? rowsAffected : -2;
                        long serverExecutionTime = segmentInfo.findServerExecutionTime();
                        if (serverExecutionTime != -1L) {
                            this._serverProcessingTime += serverExecutionTime;
                        }
                        ++receiveCount;
                    }
                }
            }
            return updateCounts;
        }
        catch (InternalReconnectException e) {
            session = e.getNewSession();
            if (session == null || !session.isConnected()) {
                throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
            }
            this._connection.handleTransaction(session, true);
            this._batchSQL.addAll(batchSQL);
            return this._executeBatch();
        }
    }
}

